package io.qt.xmlpatterns;


/**
 * <p>Callback interface for transforming the output of a QXmlQuery</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html">QAbstractXmlReceiver</a></p>
 */
public abstract class QAbstractXmlReceiver extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QAbstractXmlReceiver {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public void atomicValue(java.lang.Object value){
            atomicValue_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        @io.qt.QtUninvokable
        private native void atomicValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
        
        
        @Override
        @io.qt.QtUninvokable
        public void attribute(io.qt.xmlpatterns.QXmlName name, java.lang.String value){
            attribute_native_cref_QXmlName_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), value);
        }
        @io.qt.QtUninvokable
        private native void attribute_native_cref_QXmlName_cref_QStringRef(long __this__nativeId, long name, java.lang.String value);
        
        
        @Override
        @io.qt.QtUninvokable
        public void characters(java.lang.String value){
            characters_native_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        @io.qt.QtUninvokable
        private native void characters_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
        
        
        @Override
        @io.qt.QtUninvokable
        public void comment(java.lang.String value){
            comment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), value);
        }
        @io.qt.QtUninvokable
        private native void comment_native_cref_QString(long __this__nativeId, java.lang.String value);
        
        
        @Override
        @io.qt.QtUninvokable
        public void endDocument(){
            endDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void endDocument_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void endElement(){
            endElement_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void endElement_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void endOfSequence(){
            endOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void endOfSequence_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void namespaceBinding(io.qt.xmlpatterns.QXmlName name){
            namespaceBinding_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
        }
        @io.qt.QtUninvokable
        private native void namespaceBinding_native_cref_QXmlName(long __this__nativeId, long name);
        
        
        @Override
        @io.qt.QtUninvokable
        public void processingInstruction(io.qt.xmlpatterns.QXmlName target, java.lang.String value){
            processingInstruction_native_cref_QXmlName_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(target), value);
        }
        @io.qt.QtUninvokable
        private native void processingInstruction_native_cref_QXmlName_cref_QString(long __this__nativeId, long target, java.lang.String value);
        
        
        @Override
        @io.qt.QtUninvokable
        public void startDocument(){
            startDocument_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void startDocument_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void startElement(io.qt.xmlpatterns.QXmlName name){
            startElement_native_cref_QXmlName(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
        }
        @io.qt.QtUninvokable
        private native void startElement_native_cref_QXmlName(long __this__nativeId, long name);
        
        
        @Override
        @io.qt.QtUninvokable
        public void startOfSequence(){
            startOfSequence_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void startOfSequence_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#QAbstractXmlReceiver">QAbstractXmlReceiver::QAbstractXmlReceiver()</a></p>
     */
    public QAbstractXmlReceiver(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QAbstractXmlReceiver instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#atomicValue">QAbstractXmlReceiver::atomicValue(QVariant)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void atomicValue(java.lang.Object value);
    
    @io.qt.QtUninvokable
    private native void atomicValue_native_cref_QVariant(long __this__nativeId, java.lang.Object value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#attribute">QAbstractXmlReceiver::attribute(QXmlName,QStringRef)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void attribute(io.qt.xmlpatterns.QXmlName name, java.lang.String value);
    
    @io.qt.QtUninvokable
    private native void attribute_native_cref_QXmlName_cref_QStringRef(long __this__nativeId, long name, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#characters">QAbstractXmlReceiver::characters(QStringRef)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void characters(java.lang.String value);
    
    @io.qt.QtUninvokable
    private native void characters_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#comment">QAbstractXmlReceiver::comment(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void comment(java.lang.String value);
    
    @io.qt.QtUninvokable
    private native void comment_native_cref_QString(long __this__nativeId, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endDocument">QAbstractXmlReceiver::endDocument()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void endDocument();
    
    @io.qt.QtUninvokable
    private native void endDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endElement">QAbstractXmlReceiver::endElement()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void endElement();
    
    @io.qt.QtUninvokable
    private native void endElement_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#endOfSequence">QAbstractXmlReceiver::endOfSequence()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void endOfSequence();
    
    @io.qt.QtUninvokable
    private native void endOfSequence_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#namespaceBinding">QAbstractXmlReceiver::namespaceBinding(QXmlName)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void namespaceBinding(io.qt.xmlpatterns.QXmlName name);
    
    @io.qt.QtUninvokable
    private native void namespaceBinding_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#processingInstruction">QAbstractXmlReceiver::processingInstruction(QXmlName,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void processingInstruction(io.qt.xmlpatterns.QXmlName target, java.lang.String value);
    
    @io.qt.QtUninvokable
    private native void processingInstruction_native_cref_QXmlName_cref_QString(long __this__nativeId, long target, java.lang.String value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startDocument">QAbstractXmlReceiver::startDocument()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void startDocument();
    
    @io.qt.QtUninvokable
    private native void startDocument_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startElement">QAbstractXmlReceiver::startElement(QXmlName)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void startElement(io.qt.xmlpatterns.QXmlName name);
    
    @io.qt.QtUninvokable
    private native void startElement_native_cref_QXmlName(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qabstractxmlreceiver.html#startOfSequence">QAbstractXmlReceiver::startOfSequence()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void startOfSequence();
    
    @io.qt.QtUninvokable
    private native void startOfSequence_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public void whitespaceOnly(java.lang.String value){
        whitespaceOnly_native_cref_QStringRef(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void whitespaceOnly_native_cref_QStringRef(long __this__nativeId, java.lang.String value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractXmlReceiver(QPrivateConstructor p) { super(p); } 
    
}
