package io.qt.xml;

import io.qt.*;


/**
 * <p>Represents an XML document</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdomdocument.html">QDomDocument</a></code></p>
 */
public class QDomDocument extends io.qt.xml.QDomNode
    implements java.lang.Cloneable
{
    @QtPropertyMember(enabled=false)
    private Object __rcContent = null;
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::ParseOption</a></code></p>
     * 
     * @see ParseOptions
     */
    public enum ParseOption implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::<wbr/>ParseOption::<wbr/>Default</a></code></p>
         */
        Default(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::<wbr/>ParseOption::<wbr/>UseNamespaceProcessing</a></code></p>
         */
        UseNamespaceProcessing(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::<wbr/>ParseOption::<wbr/>PreserveSpacingOnlyNodes</a></code></p>
         */
        PreserveSpacingOnlyNodes(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ParseOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ParseOptions asFlags() {
            return new ParseOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ParseOptions combined(@NonNull ParseOption e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ParseOptions cleared(@NonNull ParseOption e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link ParseOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ParseOptions flags(@Nullable ParseOption @NonNull... values) {
            return new ParseOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ParseOption resolve(int value) {
            switch (value) {
            case 0: return Default;
            case 1: return UseNamespaceProcessing;
            case 2: return PreserveSpacingOnlyNodes;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link ParseOption}
     */
    public static final class ParseOptions extends QFlags<ParseOption> implements Comparable<ParseOptions> {
        private static final long serialVersionUID = 0xfb082e55aa9a956dL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ParseOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ParseOptions(@Nullable ParseOption @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ParseOptions with given <code>value</code>.
         * @param value
         */
        public ParseOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ParseOptions
         */
        @Override
        public final @NonNull ParseOptions combined(@StrictNonNull ParseOption e){
            return new ParseOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ParseOptions setFlag(@Nullable ParseOption e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ParseOptions setFlag(@Nullable ParseOption e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ParseOptions.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ParseOption @NonNull[] flags(){
            return super.flags(ParseOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ParseOptions clone(){
            return new ParseOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ParseOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>Struct is used to store the result of QDomDocument::setContent()</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html">QDomDocument::ParseResult</a></code></p>
     */
    public static class ParseResult extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QDomDocument::ParseResult::<wbr/>ParseResult()</code></p>
         */
        public ParseResult(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(ParseResult instance);
        
        /**
         * <p>See <code>QDomDocument::ParseResult::<wbr/>ParseResult(QDomDocument::ParseResult)</code></p>
         */
        public ParseResult(io.qt.xml.QDomDocument.@NonNull ParseResult other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(ParseResult instance, io.qt.xml.QDomDocument.ParseResult other);
        
        /**
         * <p>See <code>QDomDocument::ParseResult::<wbr/>ParseResult{QString,<wbr/>qsizetype,<wbr/>qsizetype}</code></p>
         */
        public ParseResult(java.lang.@NonNull String errorMessage, long errorLine, long errorColumn){
            super((QPrivateConstructor)null);
            initialize_native(this, errorMessage, errorLine, errorColumn);
        }
        
        private native static void initialize_native(ParseResult instance, java.lang.String errorMessage, long errorLine, long errorColumn);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#operator-bool">QDomDocument::ParseResult::<wbr/>operator bool()const</a></code></p>
         */
        @QtUninvokable
        public final boolean success(){
            return success_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean success_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code>operator==(QDomDocument::ParseResult,<wbr/>QDomDocument::ParseResult)</code></p>
         */
        @QtUninvokable
        public final boolean equals(io.qt.xml.QDomDocument.@NonNull ParseResult value2){
            return equals_native_cref_QDomDocument_ParseResult(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value2));
        }
        
        @QtUninvokable
        private native boolean equals_native_cref_QDomDocument_ParseResult(long __this__nativeId, long value2);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorColumn-var">QDomDocument::ParseResult::<wbr/>errorColumn</a></code></p>
         */
        @QtUninvokable
        public final void setErrorColumn(long errorColumn){
            setErrorColumn_native_qsizetype(QtJambi_LibraryUtilities.internal.nativeId(this), errorColumn);
        }
        
        @QtUninvokable
        private native void setErrorColumn_native_qsizetype(long __this__nativeId, long errorColumn);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorColumn-var">QDomDocument::ParseResult::<wbr/>errorColumn</a></code></p>
         */
        @QtUninvokable
        public final long errorColumn(){
            return errorColumn_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native long errorColumn_native(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorLine-var">QDomDocument::ParseResult::<wbr/>errorLine</a></code></p>
         */
        @QtUninvokable
        public final void setErrorLine(long errorLine){
            setErrorLine_native_qsizetype(QtJambi_LibraryUtilities.internal.nativeId(this), errorLine);
        }
        
        @QtUninvokable
        private native void setErrorLine_native_qsizetype(long __this__nativeId, long errorLine);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorLine-var">QDomDocument::ParseResult::<wbr/>errorLine</a></code></p>
         */
        @QtUninvokable
        public final long errorLine(){
            return errorLine_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native long errorLine_native(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorMessage-var">QDomDocument::ParseResult::<wbr/>errorMessage</a></code></p>
         */
        @QtUninvokable
        public final void setErrorMessage(java.lang.@NonNull String errorMessage){
            setErrorMessage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), errorMessage);
        }
        
        @QtUninvokable
        private native void setErrorMessage_native_cref_QString(long __this__nativeId, java.lang.String errorMessage);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorMessage-var">QDomDocument::ParseResult::<wbr/>errorMessage</a></code></p>
         */
        @QtUninvokable
        public final java.lang.@NonNull String errorMessage(){
            return errorMessage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native java.lang.String errorMessage_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected ParseResult(QPrivateConstructor p) { super(p); } 
        

        /**
         * <p>See <code>operator==(QDomDocument::ParseResult,<wbr/>QDomDocument::ParseResult)</code></p>
         */
        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.xml.QDomDocument.ParseResult) {
                return equals((io.qt.xml.QDomDocument.ParseResult) other);
            }

            return false;
        }


        /**
         * Returns the objects's hash code computed by <code>qHash(QDomDocument::ParseResult)</code>.
         */
        @QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QDomDocument::ParseResult::<wbr/>ParseResult(QDomDocument::ParseResult)</code></p>
         */
        @QtUninvokable
        @Override
        public ParseResult clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native ParseResult clone_native(long __this_nativeId);
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #errorColumn()} instead.</p>
         */
        @QtUninvokable
        public final long getErrorColumn() {
            return errorColumn();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #errorLine()} instead.</p>
         */
        @QtUninvokable
        public final long getErrorLine() {
            return errorLine();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #errorMessage()} instead.</p>
         */
        @QtUninvokable
        public final java.lang.@NonNull String getErrorMessage() {
            return errorMessage();
        }
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument">QDomDocument::<wbr/>QDomDocument()</a></code></p>
     */
    public QDomDocument(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomDocument instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-3">QDomDocument::<wbr/>QDomDocument(QDomDocument)</a></code></p>
     */
    public QDomDocument(io.qt.xml.@NonNull QDomDocument x){
        super((QPrivateConstructor)null);
        initialize_native(this, x);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocument x);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-2">QDomDocument::<wbr/>QDomDocument(QDomDocumentType)</a></code></p>
     */
    public QDomDocument(io.qt.xml.@NonNull QDomDocumentType doctype){
        super((QPrivateConstructor)null);
        initialize_native(this, doctype);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocumentType doctype);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-1">QDomDocument::<wbr/>QDomDocument(QString)</a></code></p>
     */
    public QDomDocument(java.lang.@NonNull String name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QDomDocument instance, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createAttribute">QDomDocument::<wbr/>createAttribute(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr createAttribute(java.lang.@NonNull String name){
        return createAttribute_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr createAttribute_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createAttributeNS">QDomDocument::<wbr/>createAttributeNS(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr createAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName){
        return createAttributeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr createAttributeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createCDATASection">QDomDocument::<wbr/>createCDATASection(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomCDATASection createCDATASection(java.lang.@NonNull String data){
        return createCDATASection_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomCDATASection createCDATASection_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createComment">QDomDocument::<wbr/>createComment(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomComment createComment(java.lang.@NonNull String data){
        return createComment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomComment createComment_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createDocumentFragment">QDomDocument::<wbr/>createDocumentFragment()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocumentFragment createDocumentFragment(){
        return createDocumentFragment_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocumentFragment createDocumentFragment_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createElement">QDomDocument::<wbr/>createElement(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement createElement(java.lang.@NonNull String tagName){
        return createElement_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tagName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement createElement_native_cref_QString(long __this__nativeId, java.lang.String tagName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createElementNS">QDomDocument::<wbr/>createElementNS(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement createElementNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName){
        return createElementNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement createElementNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createEntityReference">QDomDocument::<wbr/>createEntityReference(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomEntityReference createEntityReference(java.lang.@NonNull String name){
        return createEntityReference_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomEntityReference createEntityReference_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createProcessingInstruction">QDomDocument::<wbr/>createProcessingInstruction(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomProcessingInstruction createProcessingInstruction(java.lang.@NonNull String target, java.lang.@NonNull String data){
        return createProcessingInstruction_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), target, data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomProcessingInstruction createProcessingInstruction_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String target, java.lang.String data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#createTextNode">QDomDocument::<wbr/>createTextNode(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomText createTextNode(java.lang.@NonNull String data){
        return createTextNode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomText createTextNode_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#doctype">QDomDocument::<wbr/>doctype()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocumentType doctype(){
        return doctype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocumentType doctype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#documentElement">QDomDocument::<wbr/>documentElement()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement documentElement(){
        return documentElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement documentElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#elementById">QDomDocument::<wbr/>elementById(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement elementById(java.lang.@NonNull String elementId){
        return elementById_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), elementId);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement elementById_native_cref_QString(long __this__nativeId, java.lang.String elementId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#elementsByTagName">QDomDocument::<wbr/>elementsByTagName(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagName(java.lang.@NonNull String tagname){
        return elementsByTagName_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagname);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagName_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagname);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#elementsByTagNameNS">QDomDocument::<wbr/>elementsByTagNameNS(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagNameNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return elementsByTagNameNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagNameNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#implementation">QDomDocument::<wbr/>implementation()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomImplementation implementation(){
        return implementation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomImplementation implementation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#importNode">QDomDocument::<wbr/>importNode(QDomNode,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode importNode(io.qt.xml.@NonNull QDomNode importedNode, boolean deep){
        return importNode_native_cref_QDomNode_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(importedNode), deep);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode importNode_native_cref_QDomNode_bool(long __this__nativeId, long importedNode, boolean deep);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#operator-eq">QDomDocument::<wbr/>operator=(QDomDocument)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xml.@NonNull QDomDocument arg__1){
        assign_native_cref_QDomDocument(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDomDocument(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#setContent-8">QDomDocument::<wbr/>setContent(QAnyStringView,<wbr/>QDomDocument::ParseOptions)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(java.lang.@NonNull String data, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        return setContent_native_QAnyStringView_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), data, options.value());
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_QAnyStringView_QDomDocument_ParseOptions(long __this__nativeId, java.lang.String data, int options);
    
    /**
     * <p>See <code>QDomDocument::<wbr/>setContent(QByteArray,<wbr/>bool,<wbr/>QString*,<wbr/>int*,<wbr/>int*)</code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@NonNull QByteArray text, boolean namespaceProcessing){
        return setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text), namespaceProcessing);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long text, boolean namespaceProcessing);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#setContent-9">QDomDocument::<wbr/>setContent(QIODevice*,<wbr/>QDomDocument::ParseOptions)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QIODevice device, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        io.qt.xml.QDomDocument.@NonNull ParseResult __qt_return_value = setContent_native_QIODevice_ptr_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device), options.value());
        __rcContent = device;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_QIODevice_ptr_QDomDocument_ParseOptions(long __this__nativeId, long device, int options);
    
    /**
     * <p>See <code>QDomDocument::<wbr/>setContent(QIODevice*,<wbr/>bool,<wbr/>QString*,<wbr/>int*,<wbr/>int*)</code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@Nullable QIODevice dev, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev), namespaceProcessing);
        __rcContent = dev;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long dev, boolean namespaceProcessing);
    
    /**
     * <p>See <code>QDomDocument::<wbr/>setContent(QString,<wbr/>bool,<wbr/>QString*,<wbr/>int*,<wbr/>int*)</code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(java.lang.@NonNull String text, boolean namespaceProcessing){
        return setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), text, namespaceProcessing);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, java.lang.String text, boolean namespaceProcessing);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#setContent-10">QDomDocument::<wbr/>setContent(QXmlStreamReader*,<wbr/>QDomDocument::ParseOptions)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QXmlStreamReader reader, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        io.qt.xml.QDomDocument.@NonNull ParseResult __qt_return_value = setContent_native_QXmlStreamReader_ptr_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reader), options.value());
        __rcContent = reader;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_QXmlStreamReader_ptr_QDomDocument_ParseOptions(long __this__nativeId, long reader, int options);
    
    /**
     * <p>See <code>QDomDocument::<wbr/>setContent(QXmlStreamReader*,<wbr/>bool,<wbr/>QString*,<wbr/>int*,<wbr/>int*)</code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@Nullable QXmlStreamReader reader, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reader), namespaceProcessing);
        __rcContent = reader;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long reader, boolean namespaceProcessing);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#setContent">QDomDocument::<wbr/>setContent&lt;void&gt;(QByteArray,<wbr/>QDomDocument::ParseOptions)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@NonNull QByteArray data, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        return setContent_native_cref_QByteArray_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), options.value());
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_cref_QByteArray_QDomDocument_ParseOptions(long __this__nativeId, long data, int options);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#toByteArray">QDomDocument::<wbr/>toByteArray(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray toByteArray(int arg__1){
        return toByteArray_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray toByteArray_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#toString">QDomDocument::<wbr/>toString(int)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(int arg__1){
        return toString_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDomDocument(QPrivateConstructor p) { super(p); } 
    
    public static final class Result {
        private Result(boolean success, String errorMessage, int errorLine, int errorColumn) {
            this.success = success;
            this.errorMessage = errorMessage;
            this.errorLine = errorLine;
            this.errorColumn = errorColumn;
        }
    
        public final boolean success;
        public final String errorMessage;
        public final int errorLine;
        public final int errorColumn;
    }
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-3">QDomDocument::<wbr/>QDomDocument(QDomDocument)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QDomDocument clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDomDocument clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #setContent(java.lang.String, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(java.lang.@NonNull String data) {
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(java.lang.String, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(java.lang.@NonNull String data, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options) {
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, boolean)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(byte @NonNull[] text, boolean namespaceProcessing) {
        return setContent(new io.qt.core.QByteArray(text), namespaceProcessing);
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QIODevice, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QIODevice device) {
        return setContent(device, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QIODevice, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QIODevice device, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options) {
        return setContent(device, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QXmlStreamReader, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QXmlStreamReader reader) {
        return setContent(reader, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QXmlStreamReader, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QXmlStreamReader reader, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options) {
        return setContent(reader, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@NonNull QByteArray data) {
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(byte[], io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(byte @NonNull[] data) {
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(byte @NonNull[] data, io.qt.xml.QDomDocument.@NonNull ParseOptions options) {
        return setContent(new io.qt.core.QByteArray(data), options);
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@NonNull QByteArray data, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options) {
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(byte @NonNull[] data, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options) {
        return setContent(new io.qt.core.QByteArray(data), new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #toByteArray(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray toByteArray() {
        return toByteArray((int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #toString(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString() {
        return toString((int)1);
    }
}
