package io.qt.xml;

import io.qt.*;


/**
 * <p>Represents a generic string in the DOM</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html">QDomCharacterData</a></code></p>
 */
public class QDomCharacterData extends io.qt.xml.QDomNode
    implements java.lang.Cloneable
{
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#QDomCharacterData">QDomCharacterData::<wbr/>QDomCharacterData()</a></code></p>
     */
    public QDomCharacterData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomCharacterData instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#QDomCharacterData-1">QDomCharacterData::<wbr/>QDomCharacterData(QDomCharacterData)</a></code></p>
     */
    public QDomCharacterData(io.qt.xml.@NonNull QDomCharacterData x){
        super((QPrivateConstructor)null);
        initialize_native(this, x);
    }
    
    private native static void initialize_native(QDomCharacterData instance, io.qt.xml.QDomCharacterData x);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#appendData">QDomCharacterData::<wbr/>appendData(QString)</a></code></p>
     */
    @QtUninvokable
    public final void appendData(java.lang.@NonNull String arg){
        appendData_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg);
    }
    
    @QtUninvokable
    private native void appendData_native_cref_QString(long __this__nativeId, java.lang.String arg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#data">QDomCharacterData::<wbr/>data()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#deleteData">QDomCharacterData::<wbr/>deleteData(ulong,<wbr/>ulong)</a></code></p>
     */
    @QtUninvokable
    public final void deleteData(int offset, int count){
        deleteData_native_unsigned_long_unsigned_long(QtJambi_LibraryUtilities.internal.nativeId(this), offset, count);
    }
    
    @QtUninvokable
    private native void deleteData_native_unsigned_long_unsigned_long(long __this__nativeId, int offset, int count);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#insertData">QDomCharacterData::<wbr/>insertData(ulong,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void insertData(int offset, java.lang.@NonNull String arg){
        insertData_native_unsigned_long_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), offset, arg);
    }
    
    @QtUninvokable
    private native void insertData_native_unsigned_long_cref_QString(long __this__nativeId, int offset, java.lang.String arg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#length">QDomCharacterData::<wbr/>length()const</a></code></p>
     */
    @QtUninvokable
    public final int length(){
        return length_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int length_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#operator-eq">QDomCharacterData::<wbr/>operator=(QDomCharacterData)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xml.@NonNull QDomCharacterData arg__1){
        assign_native_cref_QDomCharacterData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDomCharacterData(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#replaceData">QDomCharacterData::<wbr/>replaceData(ulong,<wbr/>ulong,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void replaceData(int offset, int count, java.lang.@NonNull String arg){
        replaceData_native_unsigned_long_unsigned_long_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), offset, count, arg);
    }
    
    @QtUninvokable
    private native void replaceData_native_unsigned_long_unsigned_long_cref_QString(long __this__nativeId, int offset, int count, java.lang.String arg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#setData">QDomCharacterData::<wbr/>setData(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setData(java.lang.@NonNull String arg__1){
        setData_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setData_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomcharacterdata.html#substringData">QDomCharacterData::<wbr/>substringData(ulong,<wbr/>ulong)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String substringData(int offset, int count){
        return substringData_native_unsigned_long_unsigned_long(QtJambi_LibraryUtilities.internal.nativeId(this), offset, count);
    }
    
    @QtUninvokable
    private native java.lang.String substringData_native_unsigned_long_unsigned_long(long __this__nativeId, int offset, int count);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDomCharacterData(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDomCharacterData clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDomCharacterData clone_native(long __this_nativeId);
}
