package io.qt.xml;

import io.qt.*;


/**
 * <p>Information about the features of the DOM implementation</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdomimplementation.html">QDomImplementation</a></code></p>
 */
public class QDomImplementation extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qdomimplementation.html#InvalidDataPolicy-enum">QDomImplementation::InvalidDataPolicy</a></code></p>
     */
    public enum InvalidDataPolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdomimplementation.html#InvalidDataPolicy-enum">QDomImplementation::<wbr>AcceptInvalidChars</a></code></p>
         */
        AcceptInvalidChars(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdomimplementation.html#InvalidDataPolicy-enum">QDomImplementation::<wbr>DropInvalidChars</a></code></p>
         */
        DropInvalidChars(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qdomimplementation.html#InvalidDataPolicy-enum">QDomImplementation::<wbr>ReturnNullNode</a></code></p>
         */
        ReturnNullNode(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private InvalidDataPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull InvalidDataPolicy resolve(int value) {
            switch (value) {
            case 0: return AcceptInvalidChars;
            case 1: return DropInvalidChars;
            case 2: return ReturnNullNode;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#QDomImplementation">QDomImplementation::<wbr>QDomImplementation()</a></code></p>
     */
    public QDomImplementation(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomImplementation instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#QDomImplementation-1">QDomImplementation::<wbr>QDomImplementation(QDomImplementation)</a></code></p>
     */
    public QDomImplementation(io.qt.xml.@NonNull QDomImplementation arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QDomImplementation instance, io.qt.xml.QDomImplementation arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#createDocument">QDomImplementation::<wbr>createDocument(QString,<wbr>QString,<wbr>QDomDocumentType)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocument createDocument(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName, io.qt.xml.@NonNull QDomDocumentType doctype){
        return createDocument_native_cref_QString_cref_QString_cref_QDomDocumentType(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, QtJambi_LibraryUtilities.internal.checkedNativeId(doctype));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument createDocument_native_cref_QString_cref_QString_cref_QDomDocumentType(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, long doctype);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#createDocumentType">QDomImplementation::<wbr>createDocumentType(QString,<wbr>QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocumentType createDocumentType(java.lang.@NonNull String qName, java.lang.@NonNull String publicId, java.lang.@NonNull String systemId){
        return createDocumentType_native_cref_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), qName, publicId, systemId);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocumentType createDocumentType_native_cref_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String qName, java.lang.String publicId, java.lang.String systemId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#hasFeature">QDomImplementation::<wbr>hasFeature(QString,<wbr>QString)const</a></code></p>
     */
    @QtUninvokable
    public final boolean hasFeature(java.lang.@NonNull String feature, java.lang.@NonNull String version){
        return hasFeature_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), feature, version);
    }
    
    @QtUninvokable
    private native boolean hasFeature_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String feature, java.lang.String version);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#isNull">QDomImplementation::<wbr>isNull()</a></code></p>
     */
    @QtUninvokable
    public final boolean isNull(){
        return isNull_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isNull_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#operator-eq">QDomImplementation::<wbr>operator=(QDomImplementation)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xml.@NonNull QDomImplementation arg__1){
        assign_native_cref_QDomImplementation(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDomImplementation(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#operator-eq-eq">QDomImplementation::<wbr>operator==(QDomImplementation)const</a></code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.xml.@NonNull QDomImplementation arg__1){
        return operator_equal_native_cref_QDomImplementation_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QDomImplementation_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#invalidDataPolicy">QDomImplementation::<wbr>invalidDataPolicy()</a></code></p>
     */
    public static io.qt.xml.QDomImplementation.@NonNull InvalidDataPolicy invalidDataPolicy(){
        return io.qt.xml.QDomImplementation.InvalidDataPolicy.resolve(invalidDataPolicy_native());
    }
    
    private native static int invalidDataPolicy_native();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#setInvalidDataPolicy">QDomImplementation::<wbr>setInvalidDataPolicy(QDomImplementation::InvalidDataPolicy)</a></code></p>
     */
    public static void setInvalidDataPolicy(io.qt.xml.QDomImplementation.@NonNull InvalidDataPolicy policy){
        setInvalidDataPolicy_native_QDomImplementation_InvalidDataPolicy(policy.value());
    }
    
    private native static void setInvalidDataPolicy_native_QDomImplementation_InvalidDataPolicy(int policy);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDomImplementation(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomimplementation.html#operator-eq-eq">QDomImplementation::<wbr>operator==(QDomImplementation)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xml.QDomImplementation) {
            return operator_equal((io.qt.xml.QDomImplementation) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QDomImplementation)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDomImplementation clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDomImplementation clone_native(long __this_nativeId);
}
