package io.qt.xml;

import io.qt.*;


/**
 * <p>Represents one element in the DOM tree</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qdomelement.html">QDomElement</a></code></p>
 */
public class QDomElement extends io.qt.xml.QDomNode
    implements java.lang.Cloneable
{
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#QDomElement">QDomElement::<wbr>QDomElement()</a></code></p>
     */
    public QDomElement(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomElement instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#QDomElement-1">QDomElement::<wbr>QDomElement(QDomElement)</a></code></p>
     */
    public QDomElement(io.qt.xml.@NonNull QDomElement x){
        super((QPrivateConstructor)null);
        initialize_native(this, x);
    }
    
    private native static void initialize_native(QDomElement instance, io.qt.xml.QDomElement x);
    
    /**
     * <p>Overloaded function for {@link #attribute(java.lang.String, java.lang.String)}
     *  with <code>defValue = (String)null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String attribute(java.lang.@NonNull String name) {
        return attribute(name, (String)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#attribute">QDomElement::<wbr>attribute(QString,<wbr>QString)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String attribute(java.lang.@NonNull String name, java.lang.@NonNull String defValue){
        return attribute_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, defValue);
    }
    
    @QtUninvokable
    private native java.lang.String attribute_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String name, java.lang.String defValue);
    
    /**
     * <p>Overloaded function for {@link #attributeNS(java.lang.String, java.lang.String, java.lang.String)}
     *  with <code>defValue = (String)null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String attributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName) {
        return attributeNS(nsURI, localName, (String)null);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#attributeNS">QDomElement::<wbr>attributeNS(QString,<wbr>QString,<wbr>QString)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String attributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName, java.lang.@NonNull String defValue){
        return attributeNS_native_cref_QString_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName, defValue);
    }
    
    @QtUninvokable
    private native java.lang.String attributeNS_native_cref_QString_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String nsURI, java.lang.String localName, java.lang.String defValue);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#attributeNode">QDomElement::<wbr>attributeNode(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr attributeNode(java.lang.@NonNull String name){
        return attributeNode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr attributeNode_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#attributeNodeNS">QDomElement::<wbr>attributeNodeNS(QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr attributeNodeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return attributeNodeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr attributeNodeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#attributes">QDomElement::<wbr>attributes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNamedNodeMap attributes(){
        return attributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNamedNodeMap attributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#elementsByTagName">QDomElement::<wbr>elementsByTagName(QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagName(java.lang.@NonNull String tagname){
        return elementsByTagName_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagname);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagName_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagname);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#elementsByTagNameNS">QDomElement::<wbr>elementsByTagNameNS(QString,<wbr>QString)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagNameNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return elementsByTagNameNS_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagNameNS_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#hasAttribute">QDomElement::<wbr>hasAttribute(QString)const</a></code></p>
     */
    @QtUninvokable
    public final boolean hasAttribute(java.lang.@NonNull String name){
        return hasAttribute_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean hasAttribute_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#hasAttributeNS">QDomElement::<wbr>hasAttributeNS(QString,<wbr>QString)const</a></code></p>
     */
    @QtUninvokable
    public final boolean hasAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return hasAttributeNS_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native boolean hasAttributeNS_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#operator-eq">QDomElement::<wbr>operator=(QDomElement)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xml.@NonNull QDomElement arg__1){
        assign_native_cref_QDomElement(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDomElement(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#removeAttribute">QDomElement::<wbr>removeAttribute(QString)</a></code></p>
     */
    @QtUninvokable
    public final void removeAttribute(java.lang.@NonNull String name){
        removeAttribute_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void removeAttribute_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#removeAttributeNS">QDomElement::<wbr>removeAttributeNS(QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final void removeAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        removeAttributeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native void removeAttributeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#removeAttributeNode">QDomElement::<wbr>removeAttributeNode(QDomAttr)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr removeAttributeNode(io.qt.xml.@NonNull QDomAttr oldAttr){
        return removeAttributeNode_native_cref_QDomAttr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(oldAttr));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr removeAttributeNode_native_cref_QDomAttr(long __this__nativeId, long oldAttr);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttribute">QDomElement::<wbr>setAttribute(QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final void setAttribute(java.lang.@NonNull String name, java.lang.@NonNull String value){
        setAttribute_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setAttribute_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String name, java.lang.String value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-6">QDomElement::<wbr>setAttribute(QString,<wbr>double)</a></code></p>
     */
    @QtUninvokable
    public final void setAttribute(java.lang.@NonNull String name, double value){
        setAttribute_native_cref_QString_double(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setAttribute_native_cref_QString_double(long __this__nativeId, java.lang.String name, double value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-5">QDomElement::<wbr>setAttribute(QString,<wbr>float)</a></code></p>
     */
    @QtUninvokable
    public final void setAttribute(java.lang.@NonNull String name, float value){
        setAttribute_native_cref_QString_float(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setAttribute_native_cref_QString_float(long __this__nativeId, java.lang.String name, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-3">QDomElement::<wbr>setAttribute(QString,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttribute(java.lang.@NonNull String name, int value){
        setAttribute_native_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setAttribute_native_cref_QString_int(long __this__nativeId, java.lang.String name, int value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-1">QDomElement::<wbr>setAttribute(QString,<wbr>qlonglong)</a></code></p>
     */
    @QtUninvokable
    public final void setAttribute(java.lang.@NonNull String name, long value){
        setAttribute_native_cref_QString_qlonglong(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @QtUninvokable
    private native void setAttribute_native_cref_QString_qlonglong(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS">QDomElement::<wbr>setAttributeNS(QString,<wbr>QString,<wbr>QString)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName, java.lang.@NonNull String value){
        setAttributeNS_native_cref_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, java.lang.String value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS-5">QDomElement::<wbr>setAttributeNS(QString,<wbr>QString,<wbr>double)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName, double value){
        setAttributeNS_native_cref_QString_cref_QString_double(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_double(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, double value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS-1">QDomElement::<wbr>setAttributeNS(QString,<wbr>QString,<wbr>int)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName, int value){
        setAttributeNS_native_cref_QString_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_int(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, int value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS-3">QDomElement::<wbr>setAttributeNS(QString,<wbr>QString,<wbr>qlonglong)</a></code></p>
     */
    @QtUninvokable
    public final void setAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName, long value){
        setAttributeNS_native_cref_QString_cref_QString_qlonglong(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_qlonglong(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNode">QDomElement::<wbr>setAttributeNode(QDomAttr)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr setAttributeNode(io.qt.xml.@NonNull QDomAttr newAttr){
        return setAttributeNode_native_cref_QDomAttr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newAttr));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr setAttributeNode_native_cref_QDomAttr(long __this__nativeId, long newAttr);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNodeNS">QDomElement::<wbr>setAttributeNodeNS(QDomAttr)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr setAttributeNodeNS(io.qt.xml.@NonNull QDomAttr newAttr){
        return setAttributeNodeNS_native_cref_QDomAttr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newAttr));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr setAttributeNodeNS_native_cref_QDomAttr(long __this__nativeId, long newAttr);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#setTagName">QDomElement::<wbr>setTagName(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setTagName(java.lang.@NonNull String name){
        setTagName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void setTagName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#tagName">QDomElement::<wbr>tagName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String tagName(){
        return tagName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String tagName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qdomelement.html#text">QDomElement::<wbr>text()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDomElement(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDomElement clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDomElement clone_native(long __this_nativeId);
}
