package io.qt.xml;

import io.qt.*;


/**
 * <p>Contains a collection of nodes that can be accessed by name</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdomnamednodemap.html">QDomNamedNodeMap</a></p>
 */
public class QDomNamedNodeMap extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#QDomNamedNodeMap">QDomNamedNodeMap::QDomNamedNodeMap()</a></p>
     */
    public QDomNamedNodeMap(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomNamedNodeMap instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#QDomNamedNodeMap-1">QDomNamedNodeMap::QDomNamedNodeMap(QDomNamedNodeMap)</a></p>
     */
    public QDomNamedNodeMap(io.qt.xml.@NonNull QDomNamedNodeMap arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QDomNamedNodeMap instance, io.qt.xml.QDomNamedNodeMap arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#contains">QDomNamedNodeMap::contains(QString)const</a></p>
     */
    @QtUninvokable
    public final boolean contains(java.lang.@NonNull String name){
        return contains_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native boolean contains_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#count">QDomNamedNodeMap::count()const</a></p>
     */
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#isEmpty">QDomNamedNodeMap::isEmpty()const</a></p>
     */
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#item">QDomNamedNodeMap::item(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode item(int index){
        return item_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode item_native_int_constfct(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#length">QDomNamedNodeMap::length()const</a></p>
     */
    @QtUninvokable
    public final int length(){
        return length_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int length_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#namedItem">QDomNamedNodeMap::namedItem(QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode namedItem(java.lang.@NonNull String name){
        return namedItem_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode namedItem_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#namedItemNS">QDomNamedNodeMap::namedItemNS(QString,QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode namedItemNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return namedItemNS_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode namedItemNS_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#operator-eq">QDomNamedNodeMap::operator=(QDomNamedNodeMap)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xml.@NonNull QDomNamedNodeMap arg__1){
        assign_native_cref_QDomNamedNodeMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDomNamedNodeMap(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#operator-eq-eq">QDomNamedNodeMap::operator==(QDomNamedNodeMap)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.xml.@NonNull QDomNamedNodeMap arg__1){
        return operator_equal_native_cref_QDomNamedNodeMap_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QDomNamedNodeMap_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#removeNamedItem">QDomNamedNodeMap::removeNamedItem(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode removeNamedItem(java.lang.@NonNull String name){
        return removeNamedItem_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode removeNamedItem_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#removeNamedItemNS">QDomNamedNodeMap::removeNamedItemNS(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode removeNamedItemNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return removeNamedItemNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode removeNamedItemNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#setNamedItem">QDomNamedNodeMap::setNamedItem(QDomNode)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode setNamedItem(io.qt.xml.@NonNull QDomNode newNode){
        return setNamedItem_native_cref_QDomNode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newNode));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode setNamedItem_native_cref_QDomNode(long __this__nativeId, long newNode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#setNamedItemNS">QDomNamedNodeMap::setNamedItemNS(QDomNode)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode setNamedItemNS(io.qt.xml.@NonNull QDomNode newNode){
        return setNamedItemNS_native_cref_QDomNode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newNode));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode setNamedItemNS_native_cref_QDomNode(long __this__nativeId, long newNode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomnamednodemap.html#size">QDomNamedNodeMap::size()const</a></p>
     */
    @QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDomNamedNodeMap(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xml.QDomNamedNodeMap) {
            return operator_equal((io.qt.xml.QDomNamedNodeMap) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QDomNamedNodeMap clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDomNamedNodeMap clone_native(long __this_nativeId);
}
