package io.qt.xml;

import io.qt.*;


/**
 * <p>Represents an XML document</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdomdocument.html">QDomDocument</a></p>
 */
public class QDomDocument extends io.qt.xml.QDomNode
    implements java.lang.Cloneable
{
    @QtPropertyMember(enabled=false)
    private Object __rcContent = null;
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::ParseOption</a></p>
     * 
     * @see ParseOptions
     */
    public enum ParseOption implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::ParseOption::Default</a></p>
         */
        Default(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::ParseOption::UseNamespaceProcessing</a></p>
         */
        UseNamespaceProcessing(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qdomdocument.html#ParseOption-enum">QDomDocument::ParseOption::PreserveSpacingOnlyNodes</a></p>
         */
        PreserveSpacingOnlyNodes(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ParseOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ParseOptions asFlags() {
            return new ParseOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ParseOptions combined(@NonNull ParseOption e) {
            return new ParseOptions(this, e);
        }

        /**
         * Creates a new {@link ParseOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ParseOptions flags(@Nullable ParseOption @NonNull... values) {
            return new ParseOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ParseOption resolve(int value) {
            switch (value) {
            case 0: return Default;
            case 1: return UseNamespaceProcessing;
            case 2: return PreserveSpacingOnlyNodes;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ParseOption}
     */
    public static final class ParseOptions extends QFlags<ParseOption> implements Comparable<ParseOptions> {
        private static final long serialVersionUID = 0xfb082e55aa9a956dL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ParseOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ParseOptions(@Nullable ParseOption @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ParseOptions with given <code>value</code>.
         * @param value
         */
        public ParseOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ParseOptions
         */
        @Override
        public final @NonNull ParseOptions combined(@StrictNonNull ParseOption e){
            return new ParseOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ParseOptions setFlag(@Nullable ParseOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ParseOptions setFlag(@Nullable ParseOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ParseOptions.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ParseOption @NonNull[] flags(){
            return super.flags(ParseOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ParseOptions clone(){
            return new ParseOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ParseOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>Struct is used to store the result of QDomDocument::setContent()</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html">QDomDocument::ParseResult</a></p>
     */
    public static class ParseResult extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public ParseResult(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(ParseResult instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#operator-bool">QDomDocument::ParseResult::operator bool()const</a></p>
         */
        @QtUninvokable
        public final boolean success(){
            return success_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean success_native_constfct(long __this__nativeId);
        
        @QtUninvokable
        private final boolean operator_equal(io.qt.xml.QDomDocument.@NonNull ParseResult value2){
            return operator_equal_native_cref_QDomDocument_ParseResult(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value2));
        }
        
        @QtUninvokable
        private native boolean operator_equal_native_cref_QDomDocument_ParseResult(long __this__nativeId, long value2);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorColumn-var">QDomDocument::ParseResult::errorColumn</a></p>
         */
        @QtUninvokable
        public final void setErrorColumn(long errorColumn){
            setErrorColumn_native_qsizetype(QtJambi_LibraryUtilities.internal.nativeId(this), errorColumn);
        }
        
        @QtUninvokable
        private native void setErrorColumn_native_qsizetype(long __this__nativeId, long errorColumn);
        
        /**
         * <p>Kotlin property getter. In Java use {@link #errorColumn()} instead.</p>
         */
        @QtUninvokable
        public final long getErrorColumn() {
            return errorColumn();
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorColumn-var">QDomDocument::ParseResult::errorColumn</a></p>
         */
        @QtUninvokable
        public final long errorColumn(){
            return errorColumn_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native long errorColumn_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorLine-var">QDomDocument::ParseResult::errorLine</a></p>
         */
        @QtUninvokable
        public final void setErrorLine(long errorLine){
            setErrorLine_native_qsizetype(QtJambi_LibraryUtilities.internal.nativeId(this), errorLine);
        }
        
        @QtUninvokable
        private native void setErrorLine_native_qsizetype(long __this__nativeId, long errorLine);
        
        /**
         * <p>Kotlin property getter. In Java use {@link #errorLine()} instead.</p>
         */
        @QtUninvokable
        public final long getErrorLine() {
            return errorLine();
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorLine-var">QDomDocument::ParseResult::errorLine</a></p>
         */
        @QtUninvokable
        public final long errorLine(){
            return errorLine_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native long errorLine_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorMessage-var">QDomDocument::ParseResult::errorMessage</a></p>
         */
        @QtUninvokable
        public final void setErrorMessage(java.lang.@NonNull String errorMessage){
            setErrorMessage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), errorMessage);
        }
        
        @QtUninvokable
        private native void setErrorMessage_native_cref_QString(long __this__nativeId, java.lang.String errorMessage);
        
        /**
         * <p>Kotlin property getter. In Java use {@link #errorMessage()} instead.</p>
         */
        @QtUninvokable
        public final java.lang.@NonNull String getErrorMessage() {
            return errorMessage();
        }
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qdomdocument-parseresult.html#errorMessage-var">QDomDocument::ParseResult::errorMessage</a></p>
         */
        @QtUninvokable
        public final java.lang.@NonNull String errorMessage(){
            return errorMessage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native java.lang.String errorMessage_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected ParseResult(QPrivateConstructor p) { super(p); } 
        

        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.xml.QDomDocument.ParseResult) {
                return operator_equal((io.qt.xml.QDomDocument.ParseResult) other);
            }

            return false;
        }


        @QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        @QtUninvokable
        @Override
        public ParseResult clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native ParseResult clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument">QDomDocument::QDomDocument()</a></p>
     */
    public QDomDocument(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomDocument instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-3">QDomDocument::QDomDocument(QDomDocument)</a></p>
     */
    public QDomDocument(io.qt.xml.@NonNull QDomDocument x){
        super((QPrivateConstructor)null);
        initialize_native(this, x);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocument x);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-2">QDomDocument::QDomDocument(QDomDocumentType)</a></p>
     */
    public QDomDocument(io.qt.xml.@NonNull QDomDocumentType doctype){
        super((QPrivateConstructor)null);
        initialize_native(this, doctype);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocumentType doctype);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-1">QDomDocument::QDomDocument(QString)</a></p>
     */
    public QDomDocument(java.lang.@NonNull String name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QDomDocument instance, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createAttribute">QDomDocument::createAttribute(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr createAttribute(java.lang.@NonNull String name){
        return createAttribute_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr createAttribute_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createAttributeNS">QDomDocument::createAttributeNS(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr createAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName){
        return createAttributeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr createAttributeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createCDATASection">QDomDocument::createCDATASection(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomCDATASection createCDATASection(java.lang.@NonNull String data){
        return createCDATASection_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomCDATASection createCDATASection_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createComment">QDomDocument::createComment(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomComment createComment(java.lang.@NonNull String data){
        return createComment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomComment createComment_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createDocumentFragment">QDomDocument::createDocumentFragment()</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocumentFragment createDocumentFragment(){
        return createDocumentFragment_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocumentFragment createDocumentFragment_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createElement">QDomDocument::createElement(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement createElement(java.lang.@NonNull String tagName){
        return createElement_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tagName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement createElement_native_cref_QString(long __this__nativeId, java.lang.String tagName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createElementNS">QDomDocument::createElementNS(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement createElementNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName){
        return createElementNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement createElementNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createEntityReference">QDomDocument::createEntityReference(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomEntityReference createEntityReference(java.lang.@NonNull String name){
        return createEntityReference_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomEntityReference createEntityReference_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createProcessingInstruction">QDomDocument::createProcessingInstruction(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomProcessingInstruction createProcessingInstruction(java.lang.@NonNull String target, java.lang.@NonNull String data){
        return createProcessingInstruction_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), target, data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomProcessingInstruction createProcessingInstruction_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String target, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createTextNode">QDomDocument::createTextNode(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomText createTextNode(java.lang.@NonNull String data){
        return createTextNode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomText createTextNode_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#doctype">QDomDocument::doctype()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocumentType doctype(){
        return doctype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocumentType doctype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#documentElement">QDomDocument::documentElement()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement documentElement(){
        return documentElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement documentElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#elementById">QDomDocument::elementById(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement elementById(java.lang.@NonNull String elementId){
        return elementById_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), elementId);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement elementById_native_cref_QString(long __this__nativeId, java.lang.String elementId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#elementsByTagName">QDomDocument::elementsByTagName(QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagName(java.lang.@NonNull String tagname){
        return elementsByTagName_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagname);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagName_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagname);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#elementsByTagNameNS">QDomDocument::elementsByTagNameNS(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagNameNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return elementsByTagNameNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagNameNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#implementation">QDomDocument::implementation()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomImplementation implementation(){
        return implementation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomImplementation implementation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#importNode">QDomDocument::importNode(QDomNode,bool)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode importNode(io.qt.xml.@NonNull QDomNode importedNode, boolean deep){
        return importNode_native_cref_QDomNode_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(importedNode), deep);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode importNode_native_cref_QDomNode_bool(long __this__nativeId, long importedNode, boolean deep);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#operator-eq">QDomDocument::operator=(QDomDocument)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xml.@NonNull QDomDocument arg__1){
        assign_native_cref_QDomDocument(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDomDocument(long __this__nativeId, long arg__1);
    
    /**
     * <p>Overloaded function for {@link #setContent(java.lang.String, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(java.lang.@NonNull String data, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options){
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(java.lang.String, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(java.lang.@NonNull String data) {
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-8">QDomDocument::setContent(QAnyStringView,QDomDocument::ParseOptions)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(java.lang.@NonNull String data, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        return setContent_native_QAnyStringView_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), data, options.value());
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_QAnyStringView_QDomDocument_ParseOptions(long __this__nativeId, java.lang.String data, int options);
    
    /**
     * @deprecated Use the overload taking ParseOptions instead.
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@Nullable QIODevice dev, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev), namespaceProcessing);
        __rcContent = dev;
        return __qt_return_value;
    }
    
    @Deprecated
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long dev, boolean namespaceProcessing);
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QIODevice, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QIODevice device, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options){
        return setContent(device, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QIODevice, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QIODevice device) {
        return setContent(device, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-9">QDomDocument::setContent(QIODevice*,QDomDocument::ParseOptions)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QIODevice device, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        io.qt.xml.QDomDocument.@NonNull ParseResult __qt_return_value = setContent_native_QIODevice_ptr_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(device), options.value());
        __rcContent = device;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_QIODevice_ptr_QDomDocument_ParseOptions(long __this__nativeId, long device, int options);
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QXmlStreamReader, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QXmlStreamReader reader, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options){
        return setContent(reader, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QXmlStreamReader, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QXmlStreamReader reader) {
        return setContent(reader, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-10">QDomDocument::setContent(QXmlStreamReader*,QDomDocument::ParseOptions)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@Nullable QXmlStreamReader reader, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        io.qt.xml.QDomDocument.@NonNull ParseResult __qt_return_value = setContent_native_QXmlStreamReader_ptr_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reader), options.value());
        __rcContent = reader;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_QXmlStreamReader_ptr_QDomDocument_ParseOptions(long __this__nativeId, long reader, int options);
    
    /**
     * @deprecated Use the overload taking ParseOptions instead.
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@Nullable QXmlStreamReader reader, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reader), namespaceProcessing);
        __rcContent = reader;
        return __qt_return_value;
    }
    
    @Deprecated
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long reader, boolean namespaceProcessing);
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, io.qt.xml.QDomDocument.ParseOptions)}.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@NonNull QByteArray data, io.qt.xml.QDomDocument.@NonNull ParseOption @NonNull... options){
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, io.qt.xml.QDomDocument.ParseOptions)}
     *  with <code>options = new io.qt.xml.QDomDocument.ParseOptions(0)</code>.</p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@NonNull QByteArray data) {
        return setContent(data, new io.qt.xml.QDomDocument.ParseOptions(0));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-7">QDomDocument::setContent(QByteArray,QDomDocument::ParseOptions)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@NonNull ParseResult setContent(io.qt.core.@NonNull QByteArray data, io.qt.xml.QDomDocument.@NonNull ParseOptions options){
        return setContent_native_cref_QByteArray_QDomDocument_ParseOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), options.value());
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.ParseResult setContent_native_cref_QByteArray_QDomDocument_ParseOptions(long __this__nativeId, long data, int options);
    
    /**
     * @deprecated Use the overload taking ParseOptions instead.
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@NonNull QByteArray text, boolean namespaceProcessing){
        return setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text), namespaceProcessing);
    }
    
    @Deprecated
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long text, boolean namespaceProcessing);
    
    /**
     * @deprecated Use the overload taking ParseOptions instead.
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(java.lang.@NonNull String text, boolean namespaceProcessing){
        return setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), text, namespaceProcessing);
    }
    
    @Deprecated
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, java.lang.String text, boolean namespaceProcessing);
    
    /**
     * <p>Overloaded function for {@link #toByteArray(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray toByteArray() {
        return toByteArray((int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#toByteArray">QDomDocument::toByteArray(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray toByteArray(int arg__1){
        return toByteArray_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray toByteArray_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>Overloaded function for {@link #toString(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString() {
        return toString((int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#toString">QDomDocument::toString(int)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(int arg__1){
        return toString_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDomDocument(QPrivateConstructor p) { super(p); } 
    
    public static final class Result {
        private Result(boolean success, String errorMessage, int errorLine, int errorColumn) {
            this.success = success;
            this.errorMessage = errorMessage;
            this.errorLine = errorLine;
            this.errorColumn = errorColumn;
        }
    
        public final boolean success;
        public final String errorMessage;
        public final int errorLine;
        public final int errorColumn;
    }
    
    @QtUninvokable
    @Override
    public QDomDocument clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDomDocument clone_native(long __this_nativeId);
}
