package io.qt.xml;


/**
 * <p>Represents one element in the DOM tree</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdomelement.html">QDomElement</a></p>
 */
public class QDomElement extends io.qt.xml.QDomNode
    implements java.lang.Cloneable
{
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#QDomElement">QDomElement::QDomElement()</a></p>
     */
    public QDomElement(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomElement instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#QDomElement-1">QDomElement::QDomElement(QDomElement)</a></p>
     */
    public QDomElement(io.qt.xml.QDomElement x){
        super((QPrivateConstructor)null);
        initialize_native(this, x);
    }
    
    private native static void initialize_native(QDomElement instance, io.qt.xml.QDomElement x);
    
    /**
     * <p>Overloaded function for {@link #attribute(java.lang.String, java.lang.String)}
     *  with <code>defValue = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String attribute(java.lang.String name) {
        return attribute(name, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#attribute">QDomElement::attribute(QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String attribute(java.lang.String name, java.lang.String defValue){
        return attribute_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name, defValue);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String attribute_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String name, java.lang.String defValue);
    
    /**
     * <p>Overloaded function for {@link #attributeNS(java.lang.String, java.lang.String, java.lang.String)}
     *  with <code>defValue = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String attributeNS(java.lang.String nsURI, java.lang.String localName) {
        return attributeNS(nsURI, localName, (String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#attributeNS">QDomElement::attributeNS(QString,QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String attributeNS(java.lang.String nsURI, java.lang.String localName, java.lang.String defValue){
        return attributeNS_native_cref_QString_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName, defValue);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String attributeNS_native_cref_QString_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String nsURI, java.lang.String localName, java.lang.String defValue);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#attributeNode">QDomElement::attributeNode(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr attributeNode(java.lang.String name){
        return attributeNode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr attributeNode_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#attributeNodeNS">QDomElement::attributeNodeNS(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr attributeNodeNS(java.lang.String nsURI, java.lang.String localName){
        return attributeNodeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr attributeNodeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#attributes">QDomElement::attributes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNamedNodeMap attributes(){
        return attributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNamedNodeMap attributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#elementsByTagName">QDomElement::elementsByTagName(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNodeList elementsByTagName(java.lang.String tagname){
        return elementsByTagName_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagname);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagName_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagname);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#elementsByTagNameNS">QDomElement::elementsByTagNameNS(QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNodeList elementsByTagNameNS(java.lang.String nsURI, java.lang.String localName){
        return elementsByTagNameNS_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagNameNS_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#hasAttribute">QDomElement::hasAttribute(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasAttribute(java.lang.String name){
        return hasAttribute_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasAttribute_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#hasAttributeNS">QDomElement::hasAttributeNS(QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasAttributeNS(java.lang.String nsURI, java.lang.String localName){
        return hasAttributeNS_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @io.qt.QtUninvokable
    private native boolean hasAttributeNS_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#removeAttribute">QDomElement::removeAttribute(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAttribute(java.lang.String name){
        removeAttribute_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void removeAttribute_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#removeAttributeNS">QDomElement::removeAttributeNS(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAttributeNS(java.lang.String nsURI, java.lang.String localName){
        removeAttributeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @io.qt.QtUninvokable
    private native void removeAttributeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#removeAttributeNode">QDomElement::removeAttributeNode(QDomAttr)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr removeAttributeNode(io.qt.xml.QDomAttr oldAttr){
        return removeAttributeNode_native_cref_QDomAttr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(oldAttr));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr removeAttributeNode_native_cref_QDomAttr(long __this__nativeId, long oldAttr);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttribute">QDomElement::setAttribute(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttribute(java.lang.String name, java.lang.String value){
        setAttribute_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttribute_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String name, java.lang.String value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-6">QDomElement::setAttribute(QString,double)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttribute(java.lang.String name, double value){
        setAttribute_native_cref_QString_double(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttribute_native_cref_QString_double(long __this__nativeId, java.lang.String name, double value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-5">QDomElement::setAttribute(QString,float)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttribute(java.lang.String name, float value){
        setAttribute_native_cref_QString_float(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttribute_native_cref_QString_float(long __this__nativeId, java.lang.String name, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-3">QDomElement::setAttribute(QString,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttribute(java.lang.String name, int value){
        setAttribute_native_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttribute_native_cref_QString_int(long __this__nativeId, java.lang.String name, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttribute-1">QDomElement::setAttribute(QString,qlonglong)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttribute(java.lang.String name, long value){
        setAttribute_native_cref_QString_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttribute_native_cref_QString_long_long(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS">QDomElement::setAttributeNS(QString,QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeNS(java.lang.String nsURI, java.lang.String qName, java.lang.String value){
        setAttributeNS_native_cref_QString_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, java.lang.String value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS-5">QDomElement::setAttributeNS(QString,QString,double)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeNS(java.lang.String nsURI, java.lang.String qName, double value){
        setAttributeNS_native_cref_QString_cref_QString_double(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_double(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, double value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS-1">QDomElement::setAttributeNS(QString,QString,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeNS(java.lang.String nsURI, java.lang.String qName, int value){
        setAttributeNS_native_cref_QString_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_int(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNS-3">QDomElement::setAttributeNS(QString,QString,qlonglong)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeNS(java.lang.String nsURI, java.lang.String qName, long value){
        setAttributeNS_native_cref_QString_cref_QString_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeNS_native_cref_QString_cref_QString_long_long(long __this__nativeId, java.lang.String nsURI, java.lang.String qName, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNode">QDomElement::setAttributeNode(QDomAttr)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr setAttributeNode(io.qt.xml.QDomAttr newAttr){
        return setAttributeNode_native_cref_QDomAttr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newAttr));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr setAttributeNode_native_cref_QDomAttr(long __this__nativeId, long newAttr);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setAttributeNodeNS">QDomElement::setAttributeNodeNS(QDomAttr)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr setAttributeNodeNS(io.qt.xml.QDomAttr newAttr){
        return setAttributeNodeNS_native_cref_QDomAttr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newAttr));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr setAttributeNodeNS_native_cref_QDomAttr(long __this__nativeId, long newAttr);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#setTagName">QDomElement::setTagName(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTagName(java.lang.String name){
        setTagName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setTagName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#tagName">QDomElement::tagName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String tagName(){
        return tagName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String tagName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomelement.html#text">QDomElement::text()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDomElement(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QDomElement clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDomElement clone_native(long __this_nativeId);
}
