package io.qt.xml;


/**
 * <p>Represents an XML document</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qdomdocument.html">QDomDocument</a></p>
 */
public class QDomDocument extends io.qt.xml.QDomNode
    implements java.lang.Cloneable
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcContent = null;
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument">QDomDocument::QDomDocument()</a></p>
     */
    public QDomDocument(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomDocument instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-3">QDomDocument::QDomDocument(QDomDocument)</a></p>
     */
    public QDomDocument(io.qt.xml.QDomDocument x){
        super((QPrivateConstructor)null);
        initialize_native(this, x);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocument x);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-2">QDomDocument::QDomDocument(QDomDocumentType)</a></p>
     */
    public QDomDocument(io.qt.xml.QDomDocumentType doctype){
        super((QPrivateConstructor)null);
        initialize_native(this, doctype);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocumentType doctype);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#QDomDocument-1">QDomDocument::QDomDocument(QString)</a></p>
     */
    public QDomDocument(java.lang.String name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QDomDocument instance, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createAttribute">QDomDocument::createAttribute(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr createAttribute(java.lang.String name){
        return createAttribute_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr createAttribute_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createAttributeNS">QDomDocument::createAttributeNS(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr createAttributeNS(java.lang.String nsURI, java.lang.String qName){
        return createAttributeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr createAttributeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createCDATASection">QDomDocument::createCDATASection(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomCDATASection createCDATASection(java.lang.String data){
        return createCDATASection_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomCDATASection createCDATASection_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createComment">QDomDocument::createComment(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomComment createComment(java.lang.String data){
        return createComment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomComment createComment_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createDocumentFragment">QDomDocument::createDocumentFragment()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocumentFragment createDocumentFragment(){
        return createDocumentFragment_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocumentFragment createDocumentFragment_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createElement">QDomDocument::createElement(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement createElement(java.lang.String tagName){
        return createElement_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tagName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement createElement_native_cref_QString(long __this__nativeId, java.lang.String tagName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createElementNS">QDomDocument::createElementNS(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement createElementNS(java.lang.String nsURI, java.lang.String qName){
        return createElementNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement createElementNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createEntityReference">QDomDocument::createEntityReference(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomEntityReference createEntityReference(java.lang.String name){
        return createEntityReference_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomEntityReference createEntityReference_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createProcessingInstruction">QDomDocument::createProcessingInstruction(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomProcessingInstruction createProcessingInstruction(java.lang.String target, java.lang.String data){
        return createProcessingInstruction_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), target, data);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomProcessingInstruction createProcessingInstruction_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String target, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#createTextNode">QDomDocument::createTextNode(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomText createTextNode(java.lang.String data){
        return createTextNode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomText createTextNode_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#doctype">QDomDocument::doctype()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocumentType doctype(){
        return doctype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocumentType doctype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#documentElement">QDomDocument::documentElement()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement documentElement(){
        return documentElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement documentElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#elementById">QDomDocument::elementById(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement elementById(java.lang.String elementId){
        return elementById_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), elementId);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement elementById_native_cref_QString(long __this__nativeId, java.lang.String elementId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#elementsByTagName">QDomDocument::elementsByTagName(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNodeList elementsByTagName(java.lang.String tagname){
        return elementsByTagName_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagname);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagName_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagname);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#elementsByTagNameNS">QDomDocument::elementsByTagNameNS(QString,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNodeList elementsByTagNameNS(java.lang.String nsURI, java.lang.String localName){
        return elementsByTagNameNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagNameNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#implementation">QDomDocument::implementation()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomImplementation implementation(){
        return implementation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomImplementation implementation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#importNode">QDomDocument::importNode(QDomNode,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode importNode(io.qt.xml.QDomNode importedNode, boolean deep){
        return importNode_native_cref_QDomNode_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(importedNode), deep);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode importNode_native_cref_QDomNode_bool(long __this__nativeId, long importedNode, boolean deep);
    
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument.Result setContent(io.qt.core.QIODevice dev){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QIODevice_ptr_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev));
        __rcContent = dev;
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QIODevice_ptr_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long dev);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-2">QDomDocument::setContent(QIODevice*,bool,QString*,int*,int*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument.Result setContent(io.qt.core.QIODevice dev, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev), namespaceProcessing);
        __rcContent = dev;
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long dev, boolean namespaceProcessing);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-6">QDomDocument::setContent(QXmlStreamReader*,bool,QString*,int*,int*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument.Result setContent(io.qt.core.QXmlStreamReader reader, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reader), namespaceProcessing);
        __rcContent = reader;
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long reader, boolean namespaceProcessing);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-3">QDomDocument::setContent(QByteArray,QString*,int*,int*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument.Result setContent(io.qt.core.QByteArray text){
        return setContent_native_cref_QByteArray_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QByteArray_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long text);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent">QDomDocument::setContent(QByteArray,bool,QString*,int*,int*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument.Result setContent(io.qt.core.QByteArray text, boolean namespaceProcessing){
        return setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text), namespaceProcessing);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long text, boolean namespaceProcessing);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-4">QDomDocument::setContent(QString,QString*,int*,int*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument.Result setContent(java.lang.String text){
        return setContent_native_cref_QString_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QString_QString_ptr_int_ptr_int_ptr(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#setContent-1">QDomDocument::setContent(QString,bool,QString*,int*,int*)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument.Result setContent(java.lang.String text, boolean namespaceProcessing){
        return setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), text, namespaceProcessing);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, java.lang.String text, boolean namespaceProcessing);
    
    /**
     * <p>Overloaded function for {@link #toByteArray(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray toByteArray() {
        return toByteArray((int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#toByteArray">QDomDocument::toByteArray(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray toByteArray(int arg__1){
        return toByteArray_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray toByteArray_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>Overloaded function for {@link #toString(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String toString() {
        return toString((int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qdomdocument.html#toString">QDomDocument::toString(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String toString(int arg__1){
        return toString_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String toString_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDomDocument(QPrivateConstructor p) { super(p); } 
    
    public static final class Result {
        private Result(boolean success, String errorMessage, int errorLine, int errorColumn) {
            this.success = success;
            this.errorMessage = errorMessage;
            this.errorLine = errorLine;
            this.errorColumn = errorColumn;
        }
    
        public final boolean success;
        public final String errorMessage;
        public final int errorLine;
        public final int errorColumn;
    }
    
    @Override
    public QDomDocument clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDomDocument clone_native(long __this_nativeId);
}
