package io.qt.xml;

import io.qt.*;


/**
 * <p>Represents an XML document</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdomdocument.html">QDomDocument</a></p>
 */
public class QDomDocument extends io.qt.xml.QDomNode
    implements java.lang.Cloneable
{
    @QtPropertyMember(enabled=false)
    private Object __rcContent = null;
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#QDomDocument">QDomDocument::QDomDocument()</a></p>
     */
    public QDomDocument(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomDocument instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#QDomDocument-3">QDomDocument::QDomDocument(QDomDocument)</a></p>
     */
    public QDomDocument(io.qt.xml.@NonNull QDomDocument x){
        super((QPrivateConstructor)null);
        initialize_native(this, x);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocument x);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#QDomDocument-2">QDomDocument::QDomDocument(QDomDocumentType)</a></p>
     */
    public QDomDocument(io.qt.xml.@NonNull QDomDocumentType doctype){
        super((QPrivateConstructor)null);
        initialize_native(this, doctype);
    }
    
    private native static void initialize_native(QDomDocument instance, io.qt.xml.QDomDocumentType doctype);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#QDomDocument-1">QDomDocument::QDomDocument(QString)</a></p>
     */
    public QDomDocument(java.lang.@NonNull String name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QDomDocument instance, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createAttribute">QDomDocument::createAttribute(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr createAttribute(java.lang.@NonNull String name){
        return createAttribute_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr createAttribute_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createAttributeNS">QDomDocument::createAttributeNS(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomAttr createAttributeNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName){
        return createAttributeNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomAttr createAttributeNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createCDATASection">QDomDocument::createCDATASection(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomCDATASection createCDATASection(java.lang.@NonNull String data){
        return createCDATASection_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomCDATASection createCDATASection_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createComment">QDomDocument::createComment(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomComment createComment(java.lang.@NonNull String data){
        return createComment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomComment createComment_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createDocumentFragment">QDomDocument::createDocumentFragment()</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocumentFragment createDocumentFragment(){
        return createDocumentFragment_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocumentFragment createDocumentFragment_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createElement">QDomDocument::createElement(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement createElement(java.lang.@NonNull String tagName){
        return createElement_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tagName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement createElement_native_cref_QString(long __this__nativeId, java.lang.String tagName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createElementNS">QDomDocument::createElementNS(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement createElementNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String qName){
        return createElementNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, qName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement createElementNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String qName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createEntityReference">QDomDocument::createEntityReference(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomEntityReference createEntityReference(java.lang.@NonNull String name){
        return createEntityReference_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomEntityReference createEntityReference_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createProcessingInstruction">QDomDocument::createProcessingInstruction(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomProcessingInstruction createProcessingInstruction(java.lang.@NonNull String target, java.lang.@NonNull String data){
        return createProcessingInstruction_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), target, data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomProcessingInstruction createProcessingInstruction_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String target, java.lang.String data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#createTextNode">QDomDocument::createTextNode(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomText createTextNode(java.lang.@NonNull String data){
        return createTextNode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), data);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomText createTextNode_native_cref_QString(long __this__nativeId, java.lang.String data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#doctype">QDomDocument::doctype()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomDocumentType doctype(){
        return doctype_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocumentType doctype_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#documentElement">QDomDocument::documentElement()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement documentElement(){
        return documentElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement documentElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#elementById">QDomDocument::elementById(QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomElement elementById(java.lang.@NonNull String elementId){
        return elementById_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), elementId);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomElement elementById_native_cref_QString(long __this__nativeId, java.lang.String elementId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#elementsByTagName">QDomDocument::elementsByTagName(QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagName(java.lang.@NonNull String tagname){
        return elementsByTagName_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagname);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagName_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagname);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#elementsByTagNameNS">QDomDocument::elementsByTagNameNS(QString,QString)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNodeList elementsByTagNameNS(java.lang.@NonNull String nsURI, java.lang.@NonNull String localName){
        return elementsByTagNameNS_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), nsURI, localName);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNodeList elementsByTagNameNS_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String nsURI, java.lang.String localName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#implementation">QDomDocument::implementation()const</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomImplementation implementation(){
        return implementation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomImplementation implementation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#importNode">QDomDocument::importNode(QDomNode,bool)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.@NonNull QDomNode importNode(io.qt.xml.@NonNull QDomNode importedNode, boolean deep){
        return importNode_native_cref_QDomNode_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(importedNode), deep);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomNode importNode_native_cref_QDomNode_bool(long __this__nativeId, long importedNode, boolean deep);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#operator-eq">QDomDocument::operator=(QDomDocument)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.xml.@NonNull QDomDocument arg__1){
        assign_native_cref_QDomDocument(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QDomDocument(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument-obsolete.html#setContent-6">QDomDocument::setContent(QIODevice*,QString*,int*,int*)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@Nullable QIODevice dev){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QIODevice_ptr_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev));
        __rcContent = dev;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QIODevice_ptr_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long dev);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#setContent-2">QDomDocument::setContent(QIODevice*,bool,QString*,int*,int*)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@Nullable QIODevice dev, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dev), namespaceProcessing);
        __rcContent = dev;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QIODevice_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long dev, boolean namespaceProcessing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument-obsolete.html#setContent-7">QDomDocument::setContent(QXmlInputSource*,QXmlReader*,QString*,int*,int*)</a></p>
     * 
     * @deprecated Use other overloads instead
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.xml.@Nullable QXmlInputSource source, io.qt.xml.@Nullable QXmlReader reader){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QXmlInputSource_ptr_QXmlReader_ptr_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source), QtJambi_LibraryUtilities.internal.checkedNativeId(reader));
        __rcContent = source;
        return __qt_return_value;
    }
    
    @Deprecated
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QXmlInputSource_ptr_QXmlReader_ptr_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long source, long reader);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument-obsolete.html#setContent-3">QDomDocument::setContent(QXmlInputSource*,bool,QString*,int*,int*)</a></p>
     * 
     * @deprecated Use other overloads instead
     */
    @Deprecated
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.xml.@Nullable QXmlInputSource source, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QXmlInputSource_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source), namespaceProcessing);
        __rcContent = source;
        return __qt_return_value;
    }
    
    @Deprecated
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QXmlInputSource_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long source, boolean namespaceProcessing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#setContent-8">QDomDocument::setContent(QXmlStreamReader*,bool,QString*,int*,int*)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@Nullable QXmlStreamReader reader, boolean namespaceProcessing){
        io.qt.xml.QDomDocument.Result __qt_return_value = setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reader), namespaceProcessing);
        __rcContent = reader;
        return __qt_return_value;
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_QXmlStreamReader_ptr_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long reader, boolean namespaceProcessing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#setContent-4">QDomDocument::setContent(QByteArray,QString*,int*,int*)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@NonNull QByteArray text){
        return setContent_native_cref_QByteArray_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text));
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QByteArray_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#setContent">QDomDocument::setContent(QByteArray,bool,QString*,int*,int*)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(io.qt.core.@NonNull QByteArray text, boolean namespaceProcessing){
        return setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text), namespaceProcessing);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QByteArray_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, long text, boolean namespaceProcessing);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#setContent-5">QDomDocument::setContent(QString,QString*,int*,int*)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(java.lang.@NonNull String text){
        return setContent_native_cref_QString_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QString_QString_ptr_int_ptr_int_ptr(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#setContent-1">QDomDocument::setContent(QString,bool,QString*,int*,int*)</a></p>
     */
    @QtUninvokable
    public final io.qt.xml.QDomDocument.@StrictNonNull Result setContent(java.lang.@NonNull String text, boolean namespaceProcessing){
        return setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), text, namespaceProcessing);
    }
    
    @QtUninvokable
    private native io.qt.xml.QDomDocument.Result setContent_native_cref_QString_bool_QString_ptr_int_ptr_int_ptr(long __this__nativeId, java.lang.String text, boolean namespaceProcessing);
    
    /**
     * <p>Overloaded function for {@link #toByteArray(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray toByteArray() {
        return toByteArray((int)1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#toByteArray">QDomDocument::toByteArray(int)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray toByteArray(int arg__1){
        return toByteArray_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray toByteArray_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * <p>Overloaded function for {@link #toString(int)}
     *  with <code>arg__1 = 1</code>.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString() {
        return toString((int)1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomdocument.html#toString">QDomDocument::toString(int)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String toString(int arg__1){
        return toString_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native java.lang.String toString_native_int_constfct(long __this__nativeId, int arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QDomDocument(QPrivateConstructor p) { super(p); } 
    
    public static final class Result {
        private Result(boolean success, String errorMessage, int errorLine, int errorColumn) {
            this.success = success;
            this.errorMessage = errorMessage;
            this.errorLine = errorLine;
            this.errorColumn = errorColumn;
        }
    
        public final boolean success;
        public final String errorMessage;
        public final int errorLine;
        public final int errorColumn;
    }
    
    @QtUninvokable
    @Override
    public QDomDocument clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QDomDocument clone_native(long __this_nativeId);
}
