package io.qt.xml;


/**
 * <p>The base class for all the nodes in a DOM tree</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qdomnode.html">QDomNode</a></p>
 */
public class QDomNode extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdomnode.html#EncodingPolicy-enum">QDomNode::EncodingPolicy</a></p>
     */
    public enum EncodingPolicy implements io.qt.QtEnumerator {
        EncodingFromDocument(1),
        EncodingFromTextStream(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EncodingPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static EncodingPolicy resolve(int value) {
            switch (value) {
            case 1: return EncodingFromDocument;
            case 2: return EncodingFromTextStream;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qdomnode.html#NodeType-enum">QDomNode::NodeType</a></p>
     */
    public enum NodeType implements io.qt.QtEnumerator {
        ElementNode(1),
        AttributeNode(2),
        TextNode(3),
        CDATASectionNode(4),
        EntityReferenceNode(5),
        EntityNode(6),
        ProcessingInstructionNode(7),
        CommentNode(8),
        DocumentNode(9),
        DocumentTypeNode(10),
        DocumentFragmentNode(11),
        NotationNode(12),
        BaseNode(21),
        CharacterDataNode(22);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NodeType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static NodeType resolve(int value) {
            switch (value) {
            case 1: return ElementNode;
            case 2: return AttributeNode;
            case 3: return TextNode;
            case 4: return CDATASectionNode;
            case 5: return EntityReferenceNode;
            case 6: return EntityNode;
            case 7: return ProcessingInstructionNode;
            case 8: return CommentNode;
            case 9: return DocumentNode;
            case 10: return DocumentTypeNode;
            case 11: return DocumentFragmentNode;
            case 12: return NotationNode;
            case 21: return BaseNode;
            case 22: return CharacterDataNode;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#QDomNode">QDomNode::QDomNode()</a></p>
     */
    public QDomNode(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QDomNode instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#QDomNode-1">QDomNode::QDomNode(QDomNode)</a></p>
     */
    public QDomNode(io.qt.xml.QDomNode arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QDomNode instance, io.qt.xml.QDomNode arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#appendChild">QDomNode::appendChild(QDomNode)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode appendChild(io.qt.xml.QDomNode newChild){
        return appendChild_native_cref_QDomNode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newChild));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode appendChild_native_cref_QDomNode(long __this__nativeId, long newChild);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#childNodes">QDomNode::childNodes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNodeList childNodes(){
        return childNodes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNodeList childNodes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#clear">QDomNode::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #cloneNode(boolean)}
     *  with <code>deep = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode cloneNode() {
        return cloneNode((boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#cloneNode">QDomNode::cloneNode(bool)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode cloneNode(boolean deep){
        return cloneNode_native_bool_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), deep);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode cloneNode_native_bool_constfct(long __this__nativeId, boolean deep);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#columnNumber">QDomNode::columnNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int columnNumber(){
        return columnNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int columnNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#firstChild">QDomNode::firstChild()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode firstChild(){
        return firstChild_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode firstChild_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #firstChildElement(java.lang.String)}
     *  with <code>tagName = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement firstChildElement() {
        return firstChildElement((String)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#firstChildElement">QDomNode::firstChildElement(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement firstChildElement(java.lang.String tagName){
        return firstChildElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement firstChildElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#hasAttributes">QDomNode::hasAttributes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasAttributes(){
        return hasAttributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasAttributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#hasChildNodes">QDomNode::hasChildNodes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasChildNodes(){
        return hasChildNodes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasChildNodes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#insertAfter">QDomNode::insertAfter(QDomNode,QDomNode)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode insertAfter(io.qt.xml.QDomNode newChild, io.qt.xml.QDomNode refChild){
        return insertAfter_native_cref_QDomNode_cref_QDomNode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newChild), QtJambi_LibraryUtilities.internal.checkedNativeId(refChild));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode insertAfter_native_cref_QDomNode_cref_QDomNode(long __this__nativeId, long newChild, long refChild);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#insertBefore">QDomNode::insertBefore(QDomNode,QDomNode)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode insertBefore(io.qt.xml.QDomNode newChild, io.qt.xml.QDomNode refChild){
        return insertBefore_native_cref_QDomNode_cref_QDomNode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newChild), QtJambi_LibraryUtilities.internal.checkedNativeId(refChild));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode insertBefore_native_cref_QDomNode_cref_QDomNode(long __this__nativeId, long newChild, long refChild);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isAttr">QDomNode::isAttr()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isAttr(){
        return isAttr_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAttr_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isCDATASection">QDomNode::isCDATASection()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCDATASection(){
        return isCDATASection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCDATASection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isCharacterData">QDomNode::isCharacterData()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCharacterData(){
        return isCharacterData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCharacterData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isComment">QDomNode::isComment()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isComment(){
        return isComment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isComment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isDocument">QDomNode::isDocument()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDocument(){
        return isDocument_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDocument_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isDocumentFragment">QDomNode::isDocumentFragment()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDocumentFragment(){
        return isDocumentFragment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDocumentFragment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isDocumentType">QDomNode::isDocumentType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isDocumentType(){
        return isDocumentType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isDocumentType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isElement">QDomNode::isElement()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isElement(){
        return isElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isEntity">QDomNode::isEntity()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isEntity(){
        return isEntity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isEntity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isEntityReference">QDomNode::isEntityReference()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isEntityReference(){
        return isEntityReference_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isEntityReference_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isNotation">QDomNode::isNotation()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNotation(){
        return isNotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isNull">QDomNode::isNull()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isNull(){
        return isNull_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isNull_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isProcessingInstruction">QDomNode::isProcessingInstruction()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isProcessingInstruction(){
        return isProcessingInstruction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isProcessingInstruction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isSupported">QDomNode::isSupported(QString,QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSupported(java.lang.String feature, java.lang.String version){
        return isSupported_native_cref_QString_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), feature, version);
    }
    
    @io.qt.QtUninvokable
    private native boolean isSupported_native_cref_QString_cref_QString_constfct(long __this__nativeId, java.lang.String feature, java.lang.String version);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#isText">QDomNode::isText()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isText(){
        return isText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#lastChild">QDomNode::lastChild()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode lastChild(){
        return lastChild_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode lastChild_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #lastChildElement(java.lang.String)}
     *  with <code>tagName = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement lastChildElement() {
        return lastChildElement((String)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#lastChildElement">QDomNode::lastChildElement(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement lastChildElement(java.lang.String tagName){
        return lastChildElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement lastChildElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#lineNumber">QDomNode::lineNumber()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int lineNumber(){
        return lineNumber_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int lineNumber_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#localName">QDomNode::localName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String localName(){
        return localName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String localName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#namedItem">QDomNode::namedItem(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode namedItem(java.lang.String name){
        return namedItem_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode namedItem_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#namespaceURI">QDomNode::namespaceURI()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String namespaceURI(){
        return namespaceURI_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String namespaceURI_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#nextSibling">QDomNode::nextSibling()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode nextSibling(){
        return nextSibling_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode nextSibling_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #nextSiblingElement(java.lang.String)}
     *  with <code>taName = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement nextSiblingElement() {
        return nextSiblingElement((String)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#nextSiblingElement">QDomNode::nextSiblingElement(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement nextSiblingElement(java.lang.String taName){
        return nextSiblingElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), taName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement nextSiblingElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String taName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#nodeName">QDomNode::nodeName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String nodeName(){
        return nodeName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String nodeName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#nodeType">QDomNode::nodeType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode.NodeType nodeType(){
        return io.qt.xml.QDomNode.NodeType.resolve(nodeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int nodeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#nodeValue">QDomNode::nodeValue()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String nodeValue(){
        return nodeValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String nodeValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#normalize">QDomNode::normalize()</a></p>
     */
    @io.qt.QtUninvokable
    public final void normalize(){
        normalize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void normalize_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#operator-lt-lt">operator&lt;&lt;(QTextStream&amp;,QDomNode)</a></p>
     */
    @io.qt.QtUninvokable
    public void writeTo(io.qt.core.QTextStream arg__1){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        writeTo_native_ref_QTextStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void writeTo_native_ref_QTextStream(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#operator-eq-eq">QDomNode::operator==(QDomNode)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.xml.QDomNode arg__1){
        return operator_equal_native_cref_QDomNode_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QDomNode_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#ownerDocument">QDomNode::ownerDocument()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument ownerDocument(){
        return ownerDocument_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument ownerDocument_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#parentNode">QDomNode::parentNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode parentNode(){
        return parentNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode parentNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#prefix">QDomNode::prefix()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String prefix(){
        return prefix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String prefix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#previousSibling">QDomNode::previousSibling()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode previousSibling(){
        return previousSibling_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode previousSibling_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #previousSiblingElement(java.lang.String)}
     *  with <code>tagName = (String)null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement previousSiblingElement() {
        return previousSiblingElement((String)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#previousSiblingElement">QDomNode::previousSiblingElement(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement previousSiblingElement(java.lang.String tagName){
        return previousSiblingElement_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), tagName);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement previousSiblingElement_native_cref_QString_constfct(long __this__nativeId, java.lang.String tagName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#removeChild">QDomNode::removeChild(QDomNode)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode removeChild(io.qt.xml.QDomNode oldChild){
        return removeChild_native_cref_QDomNode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(oldChild));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode removeChild_native_cref_QDomNode(long __this__nativeId, long oldChild);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#replaceChild">QDomNode::replaceChild(QDomNode,QDomNode)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNode replaceChild(io.qt.xml.QDomNode newChild, io.qt.xml.QDomNode oldChild){
        return replaceChild_native_cref_QDomNode_cref_QDomNode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newChild), QtJambi_LibraryUtilities.internal.checkedNativeId(oldChild));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNode replaceChild_native_cref_QDomNode_cref_QDomNode(long __this__nativeId, long newChild, long oldChild);
    
    /**
     * <p>Overloaded function for {@link #save(io.qt.core.QTextStream, int, io.qt.xml.QDomNode.EncodingPolicy)}
     *  with <code>arg__3 = io.qt.xml.QDomNode.EncodingPolicy.EncodingFromDocument</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void save(io.qt.core.QTextStream arg__1, int arg__2) {
        save(arg__1, arg__2, io.qt.xml.QDomNode.EncodingPolicy.EncodingFromDocument);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#save">QDomNode::save(QTextStream&amp;,int,QDomNode::EncodingPolicy)const</a></p>
     */
    @io.qt.QtUninvokable
    public final void save(io.qt.core.QTextStream arg__1, int arg__2, io.qt.xml.QDomNode.EncodingPolicy arg__3){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        save_native_ref_QTextStream_int_QDomNode_EncodingPolicy_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2, arg__3.value());
    }
    
    @io.qt.QtUninvokable
    private native void save_native_ref_QTextStream_int_QDomNode_EncodingPolicy_constfct(long __this__nativeId, long arg__1, int arg__2, int arg__3);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#setNodeValue">QDomNode::setNodeValue(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setNodeValue(java.lang.String arg__1){
        setNodeValue_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setNodeValue_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#setPrefix">QDomNode::setPrefix(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPrefix(java.lang.String pre){
        setPrefix_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), pre);
    }
    
    @io.qt.QtUninvokable
    private native void setPrefix_native_cref_QString(long __this__nativeId, java.lang.String pre);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toAttr">QDomNode::toAttr()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomAttr toAttr(){
        return toAttr_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomAttr toAttr_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toCDATASection">QDomNode::toCDATASection()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomCDATASection toCDATASection(){
        return toCDATASection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomCDATASection toCDATASection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toCharacterData">QDomNode::toCharacterData()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomCharacterData toCharacterData(){
        return toCharacterData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomCharacterData toCharacterData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toComment">QDomNode::toComment()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomComment toComment(){
        return toComment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomComment toComment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toDocument">QDomNode::toDocument()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocument toDocument(){
        return toDocument_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocument toDocument_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toDocumentFragment">QDomNode::toDocumentFragment()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocumentFragment toDocumentFragment(){
        return toDocumentFragment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocumentFragment toDocumentFragment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toDocumentType">QDomNode::toDocumentType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomDocumentType toDocumentType(){
        return toDocumentType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomDocumentType toDocumentType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toElement">QDomNode::toElement()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomElement toElement(){
        return toElement_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomElement toElement_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toEntity">QDomNode::toEntity()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomEntity toEntity(){
        return toEntity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomEntity toEntity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toEntityReference">QDomNode::toEntityReference()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomEntityReference toEntityReference(){
        return toEntityReference_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomEntityReference toEntityReference_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toNotation">QDomNode::toNotation()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomNotation toNotation(){
        return toNotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomNotation toNotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toProcessingInstruction">QDomNode::toProcessingInstruction()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomProcessingInstruction toProcessingInstruction(){
        return toProcessingInstruction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomProcessingInstruction toProcessingInstruction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qdomnode.html#toText">QDomNode::toText()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.xml.QDomText toText(){
        return toText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.xml.QDomText toText_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDomNode(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.xml.QDomNode) {
            return operator_equal((io.qt.xml.QDomNode) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QDomNode clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QDomNode clone_native(long __this_nativeId);
}
