#include "QXmlReader_shell.h"
#include <QtJambi/Cast>

void deleter_QXmlReader(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QXmlReader")
    QXmlReader *_ptr = reinterpret_cast<QXmlReader *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

QtJambiShell* QXmlReader_shell::__shell() const { return *reinterpret_cast<QtJambiShell**>( quintptr(this) + sizeof(QXmlReader_shell) ); }

jmethodID QXmlReader_shell::__shell_javaMethod(int pos) const { return QXmlReader_shell::__shell()->javaMethod(typeid(QXmlReader), pos); }

// emitting (writeShellConstructor)
QXmlReader_shell::QXmlReader_shell()
    : QXmlReader()
{
    QTJAMBI_IN_CONSTRUCTOR_CALL("QXmlReader::QXmlReader_shell()", QXmlReader_shell::__shell())
    QXmlReader_shell::__shell()->constructed(typeid(QXmlReader));
}

// emitting (writeShellDestructor)
QXmlReader_shell::~QXmlReader_shell()
{
    QTJAMBI_IN_DESTRUCTOR_CALL("QXmlReader::~QXmlReader()", QXmlReader_shell::__shell())
    QXmlReader_shell::__shell()->destructed(typeid(QXmlReader));
}

void QXmlReader_shell::operator delete(void * ptr) noexcept {
    reinterpret_cast<QXmlReader_shell*>(ptr)->QXmlReader_shell::__shell()->tryDeleteShell(typeid(QXmlReader));
}

// emitting Virtual overrides (virtualFunctions)
QXmlDTDHandler* QXmlReader_shell::DTDHandler() const
{
    if(jmethodID method_id = __shell_javaMethod(0)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::DTDHandler()const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QXmlDTDHandler*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QXmlDTDHandler* >(__jni_env, __java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::DTDHandler()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::DTDHandler()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

QXmlContentHandler* QXmlReader_shell::contentHandler() const
{
    if(jmethodID method_id = __shell_javaMethod(1)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::contentHandler()const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QXmlContentHandler*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QXmlContentHandler* >(__jni_env, __java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::contentHandler()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::contentHandler()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

QXmlDeclHandler* QXmlReader_shell::declHandler() const
{
    if(jmethodID method_id = __shell_javaMethod(2)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::declHandler()const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QXmlDeclHandler*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QXmlDeclHandler* >(__jni_env, __java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::declHandler()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::declHandler()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

QXmlEntityResolver* QXmlReader_shell::entityResolver() const
{
    if(jmethodID method_id = __shell_javaMethod(3)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::entityResolver()const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QXmlEntityResolver*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QXmlEntityResolver* >(__jni_env, __java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::entityResolver()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::entityResolver()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

QXmlErrorHandler* QXmlReader_shell::errorHandler() const
{
    if(jmethodID method_id = __shell_javaMethod(4)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::errorHandler()const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QXmlErrorHandler*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QXmlErrorHandler* >(__jni_env, __java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::errorHandler()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::errorHandler()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

bool QXmlReader_shell::feature(const QString& name0, bool* ok1) const
{
    if(jmethodID method_id = __shell_javaMethod(5)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::feature(QString,bool*)const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_name0 = qtjambi_cast<jstring>(__jni_env, name0);
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id, __java_name0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    bool __qt_return_value_tmp = false;
                    if(__java_return_value){
                        if (ok1) *ok1 = true;
                        __qt_return_value_tmp = QtJambiAPI::fromJavaBooleanObject(__jni_env, __java_return_value);
                    }
                    __qt_return_value = __qt_return_value_tmp;
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::feature(QString,bool*)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::feature(QString,bool*)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

bool QXmlReader_shell::hasFeature(const QString& name0) const
{
    if(jmethodID method_id = __shell_javaMethod(6)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::hasFeature(QString)const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_name0 = qtjambi_cast<jstring>(__jni_env, name0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_name0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::hasFeature(QString)const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::hasFeature(QString)const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

bool QXmlReader_shell::hasProperty(const QString& name0) const
{
    Q_UNUSED(name0)
    return false;
}

QXmlLexicalHandler* QXmlReader_shell::lexicalHandler() const
{
    if(jmethodID method_id = __shell_javaMethod(8)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::lexicalHandler()const", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{200}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QXmlLexicalHandler*  __qt_return_value = nullptr;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_return_value = __jni_env->CallObjectMethod(__java_this, method_id);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = qtjambi_cast<QXmlLexicalHandler* >(__jni_env, __java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::lexicalHandler()const");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::lexicalHandler()const");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return nullptr;
        }
    }else{
        return nullptr;
    }
}

bool QXmlReader_shell::parse(const QXmlInputSource& input0)
{
    Q_UNUSED(input0)

    JniEnvironment __jni_env{300};
    jmethodID method_id = __shell_javaMethod(10);
    if(__jni_env && method_id) {
        bool  __qt_return_value = false;
        if(jobject __java_this = __shell()->getJavaObjectLocalRef(__jni_env)){
            jobject __java_input0 = qtjambi_cast<jobject>(__jni_env, &input0);
            QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_input0);
            jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_input0);
            JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
            __qt_return_value = bool(__java_return_value);
        } else {
            __shell()->warnForMethod("QXmlReader::parse(const QXmlInputSource& input)");
        }
        return __qt_return_value;
    }

    return false;
}

bool QXmlReader_shell::parse(const QXmlInputSource* input0)
{
    if(jmethodID method_id = __shell_javaMethod(10)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::parse(const QXmlInputSource*)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            bool  __qt_return_value = false;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_input0 = qtjambi_cast<jobject>(__jni_env, input0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_input0);
                    jboolean __java_return_value = __jni_env->CallBooleanMethod(__java_this, method_id, __java_input0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                    __qt_return_value = static_cast<bool>(__java_return_value);
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::parse(const QXmlInputSource*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::parse(const QXmlInputSource*)");
            } QTJAMBI_TRY_END
            return __qt_return_value;
        }else{
            return false;
        }
    }else{
        return false;
    }
}

void* QXmlReader_shell::property(const QString& name0, bool* ok1) const
{
    Q_UNUSED(name0)
    Q_UNUSED(ok1)
    return nullptr;
}

void QXmlReader_shell::setContentHandler(QXmlContentHandler* handler0)
{
    if(jmethodID method_id = __shell_javaMethod(12)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::setContentHandler(QXmlContentHandler*)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_handler0 = qtjambi_cast<jobject>(__jni_env, handler0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_handler0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_handler0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::setContentHandler(QXmlContentHandler*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::setContentHandler(QXmlContentHandler*)");
            } QTJAMBI_TRY_END
        }
    }
}

void QXmlReader_shell::setDTDHandler(QXmlDTDHandler* handler0)
{
    if(jmethodID method_id = __shell_javaMethod(13)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::setDTDHandler(QXmlDTDHandler*)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_handler0 = qtjambi_cast<jobject>(__jni_env, handler0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_handler0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_handler0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::setDTDHandler(QXmlDTDHandler*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::setDTDHandler(QXmlDTDHandler*)");
            } QTJAMBI_TRY_END
        }
    }
}

void QXmlReader_shell::setDeclHandler(QXmlDeclHandler* handler0)
{
    if(jmethodID method_id = __shell_javaMethod(14)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::setDeclHandler(QXmlDeclHandler*)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_handler0 = qtjambi_cast<jobject>(__jni_env, handler0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_handler0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_handler0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::setDeclHandler(QXmlDeclHandler*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::setDeclHandler(QXmlDeclHandler*)");
            } QTJAMBI_TRY_END
        }
    }
}

void QXmlReader_shell::setEntityResolver(QXmlEntityResolver* handler0)
{
    if(jmethodID method_id = __shell_javaMethod(15)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::setEntityResolver(QXmlEntityResolver*)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_handler0 = qtjambi_cast<jobject>(__jni_env, handler0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_handler0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_handler0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::setEntityResolver(QXmlEntityResolver*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::setEntityResolver(QXmlEntityResolver*)");
            } QTJAMBI_TRY_END
        }
    }
}

void QXmlReader_shell::setErrorHandler(QXmlErrorHandler* handler0)
{
    if(jmethodID method_id = __shell_javaMethod(16)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::setErrorHandler(QXmlErrorHandler*)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_handler0 = qtjambi_cast<jobject>(__jni_env, handler0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_handler0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_handler0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::setErrorHandler(QXmlErrorHandler*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::setErrorHandler(QXmlErrorHandler*)");
            } QTJAMBI_TRY_END
        }
    }
}

void QXmlReader_shell::setFeature(const QString& name0, bool value1)
{
    if(jmethodID method_id = __shell_javaMethod(17)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::setFeature(QString,bool)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{400}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jstring __java_name0 = qtjambi_cast<jstring>(__jni_env, name0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_name0, value1);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::setFeature(QString,bool)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::setFeature(QString,bool)");
            } QTJAMBI_TRY_END
        }
    }
}

void QXmlReader_shell::setLexicalHandler(QXmlLexicalHandler* handler0)
{
    if(jmethodID method_id = __shell_javaMethod(18)){
        QTJAMBI_JAVA_METHOD_CALL("QXmlReader::setLexicalHandler(QXmlLexicalHandler*)", QXmlReader_shell::__shell())
        if(JniEnvironment __jni_env{300}) {
            QtJambiExceptionHandler __qj_exnhandler;
            QTJAMBI_TRY {
                if(jobject __java_this = QXmlReader_shell::__shell()->getJavaObjectLocalRef(__jni_env)){
                    jobject __java_handler0 = qtjambi_cast<jobject>(__jni_env, handler0);
                    QTJAMBI_INVALIDATE_AFTER_USE(__jni_env, __java_handler0);
                    __jni_env->CallVoidMethod(__java_this, method_id, __java_handler0);
                    JavaException::check(__jni_env QTJAMBI_STACKTRACEINFO );
                } else {
                    QXmlReader_shell::__shell()->warnForMethod("QXmlReader::setLexicalHandler(QXmlLexicalHandler*)");
                }
            } QTJAMBI_CATCH(const JavaException& exn){
                __qj_exnhandler.handle(__jni_env, exn, "QXmlReader::setLexicalHandler(QXmlLexicalHandler*)");
            } QTJAMBI_TRY_END
        }
    }
}

void QXmlReader_shell::setProperty(const QString& name0, void* value1)
{
    Q_UNUSED(name0)
    Q_UNUSED(value1)
    return;
}

// emitting Functions in shell class (nonVirtualShellFunctions)
// emitting Public Override Functions (publicOverrideFunctions)
// emitting Virtual Override Functions (virtualOverrideFunctions)
jobject QXmlReader_access::__qt_DTDHandler(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::DTDHandler() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::DTDHandler() const.";
    } else {
        QXmlDTDHandler* __qt_return_value = DTDHandler();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QXmlReader_access::__qt_contentHandler(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::contentHandler() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::contentHandler() const.";
    } else {
        QXmlContentHandler* __qt_return_value = contentHandler();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QXmlReader_access::__qt_declHandler(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::declHandler() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::declHandler() const.";
    } else {
        QXmlDeclHandler* __qt_return_value = declHandler();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QXmlReader_access::__qt_entityResolver(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::entityResolver() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::entityResolver() const.";
    } else {
        QXmlEntityResolver* __qt_return_value = entityResolver();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QXmlReader_access::__qt_errorHandler(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::errorHandler() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::errorHandler() const.";
    } else {
        QXmlErrorHandler* __qt_return_value = errorHandler();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jobject QXmlReader_access::__qt_feature_cref_QString_bool_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring name0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
    bool ok = false;
    bool *__qt_ok1 = &ok;
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::feature(const QString & name, bool * ok) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::feature(const QString & name, bool * ok) const.";
    } else {
        bool __qt_return_value = feature(__qt_name0, __qt_ok1);
        jobject __java_return_value = ok ? QtJambiAPI::toJavaBooleanObject(__jni_env, __qt_return_value) : nullptr;
        return __java_return_value;
    }
}

jboolean QXmlReader_access::__qt_hasFeature_cref_QString_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring name0) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::hasFeature(const QString & name) const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::hasFeature(const QString & name) const.";
    } else {
        bool __qt_return_value = hasFeature(__qt_name0);
        return jboolean(__qt_return_value);
    }
}

jobject QXmlReader_access::__qt_lexicalHandler(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::lexicalHandler() const." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::lexicalHandler() const.";
    } else {
        QXmlLexicalHandler* __qt_return_value = lexicalHandler();
        return qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }
}

jboolean QXmlReader_access::__qt_parse_const_QXmlInputSource_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID input0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    const QXmlInputSource* __qt_input0 = QtJambiAPI::objectFromNativeId<QXmlInputSource>(input0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::parse(const QXmlInputSource * input)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::parse(const QXmlInputSource * input).";
    } else {
        bool __qt_return_value = parse(__qt_input0);
        return jboolean(__qt_return_value);
    }
}

void QXmlReader_access::__qt_setContentHandler_QXmlContentHandler_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID handler0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QXmlContentHandler* __qt_handler0 = QtJambiAPI::interfaceFromNativeId<QXmlContentHandler>(handler0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::setContentHandler(QXmlContentHandler * handler)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::setContentHandler(QXmlContentHandler * handler).";
    } else {
        setContentHandler(__qt_handler0);
    }
}

void QXmlReader_access::__qt_setDTDHandler_QXmlDTDHandler_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID handler0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QXmlDTDHandler* __qt_handler0 = QtJambiAPI::interfaceFromNativeId<QXmlDTDHandler>(handler0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::setDTDHandler(QXmlDTDHandler * handler)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::setDTDHandler(QXmlDTDHandler * handler).";
    } else {
        setDTDHandler(__qt_handler0);
    }
}

void QXmlReader_access::__qt_setDeclHandler_QXmlDeclHandler_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID handler0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QXmlDeclHandler* __qt_handler0 = QtJambiAPI::interfaceFromNativeId<QXmlDeclHandler>(handler0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::setDeclHandler(QXmlDeclHandler * handler)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::setDeclHandler(QXmlDeclHandler * handler).";
    } else {
        setDeclHandler(__qt_handler0);
    }
}

void QXmlReader_access::__qt_setEntityResolver_QXmlEntityResolver_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID handler0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QXmlEntityResolver* __qt_handler0 = QtJambiAPI::interfaceFromNativeId<QXmlEntityResolver>(handler0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::setEntityResolver(QXmlEntityResolver * handler)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::setEntityResolver(QXmlEntityResolver * handler).";
    } else {
        setEntityResolver(__qt_handler0);
    }
}

void QXmlReader_access::__qt_setErrorHandler_QXmlErrorHandler_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID handler0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QXmlErrorHandler* __qt_handler0 = QtJambiAPI::interfaceFromNativeId<QXmlErrorHandler>(handler0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::setErrorHandler(QXmlErrorHandler * handler)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::setErrorHandler(QXmlErrorHandler * handler).";
    } else {
        setErrorHandler(__qt_handler0);
    }
}

void QXmlReader_access::__qt_setFeature_cref_QString_bool(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring name0, jboolean value1)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QString  __qt_name0 = qtjambi_cast<QString >(__jni_env, name0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::setFeature(const QString & name, bool value)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::setFeature(const QString & name, bool value).";
    } else {
        setFeature(__qt_name0, static_cast<bool>(value1));
    }
}

void QXmlReader_access::__qt_setLexicalHandler_QXmlLexicalHandler_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID handler0)
{
    Q_UNUSED(__jni_env)
    Q_ASSERT(!!__this_nativeId);
    QXmlLexicalHandler* __qt_handler0 = QtJambiAPI::interfaceFromNativeId<QXmlLexicalHandler>(handler0);
    if (QtJambiAPI::isShell(__this_nativeId)) {
        JavaException::raiseQNoImplementationException(__jni_env, "Call of pure virtual method QXmlReader::setLexicalHandler(QXmlLexicalHandler * handler)." QTJAMBI_STACKTRACEINFO );
        throw "Call of pure virtual method QXmlReader::setLexicalHandler(QXmlLexicalHandler * handler).";
    } else {
        setLexicalHandler(__qt_handler0);
    }
}

// emitting (writeConstructors)
// new 
void __qt_construct_QXmlReader_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct ")
    Q_UNUSED(__java_arguments)
    QXmlReader *__qt_this = new(__qtjambi_ptr) QXmlReader_shell();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// destruct QXmlReader_shell
void __qt_destruct_QXmlReader(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QXmlReader")
    reinterpret_cast<QXmlReader_shell*>(ptr)->~QXmlReader_shell();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QXmlReader::
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_initialize_1native__Lio_qt_xml_QXmlReader_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QXmlReader::")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QXmlReader_0, sizeof(QXmlReader_shell), typeid(QXmlReader), true, &deleter_QXmlReader, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlReader::DTDHandler()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_DTDHandler_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::DTDHandler()const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_DTDHandler(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::contentHandler()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_contentHandler_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::contentHandler()const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_contentHandler(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::declHandler()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_declHandler_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::declHandler()const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_declHandler(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::entityResolver()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_entityResolver_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::entityResolver()const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_entityResolver(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::errorHandler()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_errorHandler_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::errorHandler()const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_errorHandler(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::feature(QString,bool*)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_feature_1native_1cref_1QString_1bool_1ptr_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::feature(QString,bool*)const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_feature_cref_QString_bool_ptr_constfct(__jni_env, __this_nativeId, name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::hasFeature(QString)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_hasFeature_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::hasFeature(QString)const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_hasFeature_cref_QString_constfct(__jni_env, __this_nativeId, name0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::lexicalHandler()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_lexicalHandler_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::lexicalHandler()const", __qt_this)
        __java_return_value = static_cast<const QXmlReader_access*>(__qt_this)->__qt_lexicalHandler(__jni_env, __this_nativeId);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::parse(const QXmlInputSource*)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_parse_1native_1const_1QXmlInputSource_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID input0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::parse(const QXmlInputSource*)", __qt_this)
        __java_return_value = static_cast<QXmlReader_access*>(__qt_this)->__qt_parse_const_QXmlInputSource_ptr(__jni_env, __this_nativeId, input0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QXmlReader::setContentHandler(QXmlContentHandler*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_setContentHandler_1native_1QXmlContentHandler_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID handler0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::setContentHandler(QXmlContentHandler*)", __qt_this)
        static_cast<QXmlReader_access*>(__qt_this)->__qt_setContentHandler_QXmlContentHandler_ptr(__jni_env, __this_nativeId, handler0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlReader::setDTDHandler(QXmlDTDHandler*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_setDTDHandler_1native_1QXmlDTDHandler_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID handler0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::setDTDHandler(QXmlDTDHandler*)", __qt_this)
        static_cast<QXmlReader_access*>(__qt_this)->__qt_setDTDHandler_QXmlDTDHandler_ptr(__jni_env, __this_nativeId, handler0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlReader::setDeclHandler(QXmlDeclHandler*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_setDeclHandler_1native_1QXmlDeclHandler_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID handler0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::setDeclHandler(QXmlDeclHandler*)", __qt_this)
        static_cast<QXmlReader_access*>(__qt_this)->__qt_setDeclHandler_QXmlDeclHandler_ptr(__jni_env, __this_nativeId, handler0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlReader::setEntityResolver(QXmlEntityResolver*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_setEntityResolver_1native_1QXmlEntityResolver_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID handler0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::setEntityResolver(QXmlEntityResolver*)", __qt_this)
        static_cast<QXmlReader_access*>(__qt_this)->__qt_setEntityResolver_QXmlEntityResolver_ptr(__jni_env, __this_nativeId, handler0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlReader::setErrorHandler(QXmlErrorHandler*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_setErrorHandler_1native_1QXmlErrorHandler_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID handler0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::setErrorHandler(QXmlErrorHandler*)", __qt_this)
        static_cast<QXmlReader_access*>(__qt_this)->__qt_setErrorHandler_QXmlErrorHandler_ptr(__jni_env, __this_nativeId, handler0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlReader::setFeature(QString,bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_setFeature_1native_1cref_1QString_1bool__JLjava_lang_String_2Z)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0,
 jboolean value1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::setFeature(QString,bool)", __qt_this)
        static_cast<QXmlReader_access*>(__qt_this)->__qt_setFeature_cref_QString_bool(__jni_env, __this_nativeId, name0, value1);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QXmlReader::setLexicalHandler(QXmlLexicalHandler*)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QXmlReader_00024ConcreteWrapper_setLexicalHandler_1native_1QXmlLexicalHandler_1ptr__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID handler0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QXmlReader *__qt_this = QtJambiAPI::objectFromNativeId<QXmlReader>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QXmlReader::setLexicalHandler(QXmlLexicalHandler*)", __qt_this)
        static_cast<QXmlReader_access*>(__qt_this)->__qt_setLexicalHandler_QXmlLexicalHandler_ptr(__jni_env, __this_nativeId, handler0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// emitting (writeJavaLangObjectOverrideFunctions)

void initialize_meta_info_QXmlReader(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerObjectTypeInfo<QXmlReader>("QXmlReader", "io/qt/xml/QXmlReader");
// BEGIN: function table
    registerFunctionInfos(typeId, {
        FunctionInfo(/*  0 */ "DTDHandler", "()Lio/qt/xml/QXmlDTDHandler;", FunctionInfo::Abstract),
        FunctionInfo(/*  1 */ "contentHandler", "()Lio/qt/xml/QXmlContentHandler;", FunctionInfo::Abstract),
        FunctionInfo(/*  2 */ "declHandler", "()Lio/qt/xml/QXmlDeclHandler;", FunctionInfo::Abstract),
        FunctionInfo(/*  3 */ "entityResolver", "()Lio/qt/xml/QXmlEntityResolver;", FunctionInfo::Abstract),
        FunctionInfo(/*  4 */ "errorHandler", "()Lio/qt/xml/QXmlErrorHandler;", FunctionInfo::Abstract),
        FunctionInfo(/*  5 */ "feature", "(Ljava/lang/String;)Ljava/lang/Boolean;", FunctionInfo::Abstract),
        FunctionInfo(/*  6 */ "hasFeature", "(Ljava/lang/String;)Z", FunctionInfo::Abstract),
        FunctionInfo(/*  7 */ "lexicalHandler", "()Lio/qt/xml/QXmlLexicalHandler;", FunctionInfo::Abstract),
        FunctionInfo(/*  8 */ "parse", "(Lio/qt/xml/QXmlInputSource;)Z", FunctionInfo::Abstract),
        FunctionInfo(/*  9 */ "setContentHandler", "(Lio/qt/xml/QXmlContentHandler;)V", FunctionInfo::Abstract),
        FunctionInfo(/* 10 */ "setDTDHandler", "(Lio/qt/xml/QXmlDTDHandler;)V", FunctionInfo::Abstract),
        FunctionInfo(/* 11 */ "setDeclHandler", "(Lio/qt/xml/QXmlDeclHandler;)V", FunctionInfo::Abstract),
        FunctionInfo(/* 12 */ "setEntityResolver", "(Lio/qt/xml/QXmlEntityResolver;)V", FunctionInfo::Abstract),
        FunctionInfo(/* 13 */ "setErrorHandler", "(Lio/qt/xml/QXmlErrorHandler;)V", FunctionInfo::Abstract),
        FunctionInfo(/* 14 */ "setFeature", "(Ljava/lang/String;Z)V", FunctionInfo::Abstract),
        FunctionInfo(/* 15 */ "setLexicalHandler", "(Lio/qt/xml/QXmlLexicalHandler;)V", FunctionInfo::Abstract)});
    registerConstructorInfos(typeId, &__qt_destruct_QXmlReader, {
        ConstructorInfo(&__qt_construct_QXmlReader_0, nullptr)
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QXmlReader);
    registerSizeOfShell(typeId, sizeof(QXmlReader_shell));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
