#include <QtCore/QtGlobal>
#include <QtXml/qdom.h>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtCore/qiodevice.h>
#include <QtCore/qstring.h>
#include <QtCore/qtextstream.h>
#include <QtCore/qxmlstream.h>
#include "utils_p.h"

#include <QtJambi/QtJambiAPI>
#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QDomDocument(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QDomDocument")
    QDomDocument *_ptr = reinterpret_cast<QDomDocument *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QDomDocument()
void __qt_construct_QDomDocument(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDomDocument()")
    Q_UNUSED(__java_arguments)
    QDomDocument *__qt_this = new(__qtjambi_ptr) QDomDocument();
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// QDomDocument::QDomDocument()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_initialize_1native__Lio_qt_xml_QDomDocument_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDomDocument::QDomDocument()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDomDocument, sizeof(QDomDocument), typeid(QDomDocument), false, &deleter_QDomDocument, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDomDocument(QDomDocument)
void __qt_construct_QDomDocument_cref_QDomDocument(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDomDocument(QDomDocument)")
    jobject x0 = __java_arguments[0].l;
    const QDomDocument& __qt_x0 = qtjambi_cast<const QDomDocument& >(__jni_env, x0);
    QDomDocument *__qt_this = new(__qtjambi_ptr) QDomDocument(__qt_x0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QDomDocument::QDomDocument(QDomDocument)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_initialize_1native__Lio_qt_xml_QDomDocument_2Lio_qt_xml_QDomDocument_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject x0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDomDocument::QDomDocument(QDomDocument)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = x0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDomDocument_cref_QDomDocument, sizeof(QDomDocument), typeid(QDomDocument), false, &deleter_QDomDocument, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDomDocument(QDomDocumentType)
void __qt_construct_QDomDocument_cref_QDomDocumentType(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDomDocument(QDomDocumentType)")
    jobject doctype0 = __java_arguments[0].l;
    const QDomDocumentType& __qt_doctype0 = qtjambi_cast<const QDomDocumentType& >(__jni_env, doctype0);
    QDomDocument *__qt_this = new(__qtjambi_ptr) QDomDocument(__qt_doctype0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QDomDocument::QDomDocument(QDomDocumentType)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_initialize_1native__Lio_qt_xml_QDomDocument_2Lio_qt_xml_QDomDocumentType_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject doctype0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDomDocument::QDomDocument(QDomDocumentType)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = doctype0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDomDocument_cref_QDomDocumentType, sizeof(QDomDocument), typeid(QDomDocument), false, &deleter_QDomDocument, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QDomDocument(QString)
void __qt_construct_QDomDocument_cref_QString(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QDomDocument(QString)")
    jstring name0 = static_cast<jstring>(__java_arguments[0].l);
    QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
    QDomDocument *__qt_this = new(__qtjambi_ptr) QDomDocument(__qt_name0);
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// QDomDocument::QDomDocument(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_initialize_1native__Lio_qt_xml_QDomDocument_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jstring name0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QDomDocument::QDomDocument(QString)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = name0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QDomDocument_cref_QString, sizeof(QDomDocument), typeid(QDomDocument), false, &deleter_QDomDocument, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QDomDocument
void __qt_destruct_QDomDocument(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QDomDocument")
    reinterpret_cast<QDomDocument*>(ptr)->~QDomDocument();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QDomDocument::createAttribute(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createAttribute_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createAttribute(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QDomAttr __qt_return_value = __qt_this->createAttribute(__qt_name0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createAttributeNS(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createAttributeNS_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring nsURI0,
 jstring qName1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createAttributeNS(QString,QString)", __qt_this)
        QString  __qt_nsURI0 = qtjambi_cast<QString>(__jni_env, nsURI0);
        QString  __qt_qName1 = qtjambi_cast<QString>(__jni_env, qName1);
        QDomAttr __qt_return_value = __qt_this->createAttributeNS(__qt_nsURI0, __qt_qName1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createCDATASection(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createCDATASection_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createCDATASection(QString)", __qt_this)
        QString  __qt_data0 = qtjambi_cast<QString>(__jni_env, data0);
        QDomCDATASection __qt_return_value = __qt_this->createCDATASection(__qt_data0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createComment(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createComment_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createComment(QString)", __qt_this)
        QString  __qt_data0 = qtjambi_cast<QString>(__jni_env, data0);
        QDomComment __qt_return_value = __qt_this->createComment(__qt_data0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createDocumentFragment()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createDocumentFragment_1native__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createDocumentFragment()", __qt_this)
        QDomDocumentFragment __qt_return_value = __qt_this->createDocumentFragment();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createElement(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createElement_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring tagName0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createElement(QString)", __qt_this)
        QString  __qt_tagName0 = qtjambi_cast<QString>(__jni_env, tagName0);
        QDomElement __qt_return_value = __qt_this->createElement(__qt_tagName0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createElementNS(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createElementNS_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring nsURI0,
 jstring qName1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createElementNS(QString,QString)", __qt_this)
        QString  __qt_nsURI0 = qtjambi_cast<QString>(__jni_env, nsURI0);
        QString  __qt_qName1 = qtjambi_cast<QString>(__jni_env, qName1);
        QDomElement __qt_return_value = __qt_this->createElementNS(__qt_nsURI0, __qt_qName1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createEntityReference(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createEntityReference_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring name0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createEntityReference(QString)", __qt_this)
        QString  __qt_name0 = qtjambi_cast<QString>(__jni_env, name0);
        QDomEntityReference __qt_return_value = __qt_this->createEntityReference(__qt_name0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createProcessingInstruction(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createProcessingInstruction_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring target0,
 jstring data1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createProcessingInstruction(QString,QString)", __qt_this)
        QString  __qt_target0 = qtjambi_cast<QString>(__jni_env, target0);
        QString  __qt_data1 = qtjambi_cast<QString>(__jni_env, data1);
        QDomProcessingInstruction __qt_return_value = __qt_this->createProcessingInstruction(__qt_target0, __qt_data1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::createTextNode(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_createTextNode_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::createTextNode(QString)", __qt_this)
        QString  __qt_data0 = qtjambi_cast<QString>(__jni_env, data0);
        QDomText __qt_return_value = __qt_this->createTextNode(__qt_data0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::doctype()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_doctype_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::doctype()const", __qt_this)
        QDomDocumentType __qt_return_value = __qt_this->doctype();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::documentElement()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_documentElement_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::documentElement()const", __qt_this)
        QDomElement __qt_return_value = __qt_this->documentElement();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::elementById(QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_elementById_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring elementId0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::elementById(QString)", __qt_this)
        QString  __qt_elementId0 = qtjambi_cast<QString>(__jni_env, elementId0);
        QDomElement __qt_return_value = __qt_this->elementById(__qt_elementId0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::elementsByTagName(QString)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_elementsByTagName_1native_1cref_1QString_1constfct__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring tagname0)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::elementsByTagName(QString)const", __qt_this)
        QString  __qt_tagname0 = qtjambi_cast<QString>(__jni_env, tagname0);
        QDomNodeList __qt_return_value = __qt_this->elementsByTagName(__qt_tagname0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::elementsByTagNameNS(QString,QString)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_elementsByTagNameNS_1native_1cref_1QString_1cref_1QString__JLjava_lang_String_2Ljava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring nsURI0,
 jstring localName1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::elementsByTagNameNS(QString,QString)", __qt_this)
        QString  __qt_nsURI0 = qtjambi_cast<QString>(__jni_env, nsURI0);
        QString  __qt_localName1 = qtjambi_cast<QString>(__jni_env, localName1);
        QDomNodeList __qt_return_value = __qt_this->elementsByTagNameNS(__qt_nsURI0, __qt_localName1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::implementation()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_implementation_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::implementation()const", __qt_this)
        QDomImplementation __qt_return_value = __qt_this->implementation();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::importNode(QDomNode,bool)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_importNode_1native_1cref_1QDomNode_1bool__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID importedNode0,
 jboolean deep1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::importNode(QDomNode,bool)", __qt_this)
        const QDomNode& __qt_importedNode0 = QtJambiAPI::valueReferenceFromNativeId<QDomNode>(importedNode0);
        QDomNode __qt_return_value = __qt_this->importNode(__qt_importedNode0, static_cast<bool>(deep1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::operator=(QDomDocument)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_assign_1native_1cref_1QDomDocument__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID arg__1)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::operator=(QDomDocument)", __qt_this)
        const QDomDocument& __qt_arg__1 = QtJambiAPI::valueReferenceFromNativeId<QDomDocument>(arg__1);
        (*__qt_this) = __qt_arg__1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QDomDocument::setContent(QAnyStringView,QDomDocument::ParseOptions)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1QAnyStringView_1QDomDocument_1ParseOptions__JLjava_lang_String_2I)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring data0,
 jint options1)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent(QAnyStringView,QDomDocument::ParseOptions)", __qt_this)
        QAnyStringView  __qt_data0 = qtjambi_cast<QAnyStringView>(__jni_env, __qtjambi_scope, data0);
        QDomDocument::ParseOptions __qt_options1 = qtjambi_cast<QDomDocument::ParseOptions>(__jni_env, options1);
        QDomDocument::ParseResult __qt_return_value = __qt_this->setContent(__qt_data0, QDomDocument::ParseOptions(__qt_options1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::setContent(QByteArray,bool,QString*,int*,int*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1cref_1QByteArray_1bool_1QString_1ptr_1int_1ptr_1int_1ptr__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID text0,
 jboolean namespaceProcessing1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent(QByteArray,bool,QString*,int*,int*)", __qt_this)
        const QByteArray& __qt_text0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(text0);
        QString errorMsg;
        QString *__qt_errorMsg2 = &errorMsg;
        jint errorLine = 0;
        int *__qt_errorLine3 = reinterpret_cast<int *>(&errorLine);
        jint errorColumn = 0;
        int *__qt_errorColumn4 = reinterpret_cast<int *>(&errorColumn);
        bool __qt_return_value = __qt_this->setContent(__qt_text0, static_cast<bool>(namespaceProcessing1), __qt_errorMsg2, __qt_errorLine3, __qt_errorColumn4);
        __java_return_value = Java::QtXml::QDomDocument$Result::newInstance(__jni_env, jboolean(__qt_return_value), qtjambi_cast<jstring>(__jni_env, errorMsg), errorLine, errorColumn);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::setContent(QIODevice*,QDomDocument::ParseOptions)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1QIODevice_1ptr_1QDomDocument_1ParseOptions__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID device0,
 jint options1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent(QIODevice*,QDomDocument::ParseOptions)", __qt_this)
        QIODevice* __qt_device0 = QtJambiAPI::objectFromNativeId<QIODevice>(device0);
        QDomDocument::ParseOptions __qt_options1 = qtjambi_cast<QDomDocument::ParseOptions>(__jni_env, options1);
        QDomDocument::ParseResult __qt_return_value = __qt_this->setContent(__qt_device0, QDomDocument::ParseOptions(__qt_options1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::setContent(QIODevice*,bool,QString*,int*,int*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1QIODevice_1ptr_1bool_1QString_1ptr_1int_1ptr_1int_1ptr__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID dev0,
 jboolean namespaceProcessing1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent(QIODevice*,bool,QString*,int*,int*)", __qt_this)
        QIODevice* __qt_dev0 = QtJambiAPI::objectFromNativeId<QIODevice>(dev0);
        QString errorMsg;
        QString *__qt_errorMsg2 = &errorMsg;
        jint errorLine = 0;
        int *__qt_errorLine3 = reinterpret_cast<int *>(&errorLine);
        jint errorColumn = 0;
        int *__qt_errorColumn4 = reinterpret_cast<int *>(&errorColumn);
        bool __qt_return_value = __qt_this->setContent(__qt_dev0, static_cast<bool>(namespaceProcessing1), __qt_errorMsg2, __qt_errorLine3, __qt_errorColumn4);
        __java_return_value = Java::QtXml::QDomDocument$Result::newInstance(__jni_env, jboolean(__qt_return_value), qtjambi_cast<jstring>(__jni_env, errorMsg), errorLine, errorColumn);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::setContent(QString,bool,QString*,int*,int*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1cref_1QString_1bool_1QString_1ptr_1int_1ptr_1int_1ptr__JLjava_lang_String_2Z)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring text0,
 jboolean namespaceProcessing1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent(QString,bool,QString*,int*,int*)", __qt_this)
        QString  __qt_text0 = qtjambi_cast<QString>(__jni_env, text0);
        QString errorMsg;
        QString *__qt_errorMsg2 = &errorMsg;
        jint errorLine = 0;
        int *__qt_errorLine3 = reinterpret_cast<int *>(&errorLine);
        jint errorColumn = 0;
        int *__qt_errorColumn4 = reinterpret_cast<int *>(&errorColumn);
        bool __qt_return_value = __qt_this->setContent(__qt_text0, static_cast<bool>(namespaceProcessing1), __qt_errorMsg2, __qt_errorLine3, __qt_errorColumn4);
        __java_return_value = Java::QtXml::QDomDocument$Result::newInstance(__jni_env, jboolean(__qt_return_value), qtjambi_cast<jstring>(__jni_env, errorMsg), errorLine, errorColumn);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::setContent(QXmlStreamReader*,QDomDocument::ParseOptions)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1QXmlStreamReader_1ptr_1QDomDocument_1ParseOptions__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID reader0,
 jint options1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent(QXmlStreamReader*,QDomDocument::ParseOptions)", __qt_this)
        QXmlStreamReader* __qt_reader0 = QtJambiAPI::objectFromNativeId<QXmlStreamReader>(reader0);
        QDomDocument::ParseOptions __qt_options1 = qtjambi_cast<QDomDocument::ParseOptions>(__jni_env, options1);
        QDomDocument::ParseResult __qt_return_value = __qt_this->setContent(__qt_reader0, QDomDocument::ParseOptions(__qt_options1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::setContent(QXmlStreamReader*,bool,QString*,int*,int*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1QXmlStreamReader_1ptr_1bool_1QString_1ptr_1int_1ptr_1int_1ptr__JJZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID reader0,
 jboolean namespaceProcessing1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent(QXmlStreamReader*,bool,QString*,int*,int*)", __qt_this)
        QXmlStreamReader* __qt_reader0 = QtJambiAPI::objectFromNativeId<QXmlStreamReader>(reader0);
        QString errorMsg;
        QString *__qt_errorMsg2 = &errorMsg;
        jint errorLine = 0;
        int *__qt_errorLine3 = reinterpret_cast<int *>(&errorLine);
        jint errorColumn = 0;
        int *__qt_errorColumn4 = reinterpret_cast<int *>(&errorColumn);
        bool __qt_return_value = __qt_this->setContent(__qt_reader0, static_cast<bool>(namespaceProcessing1), __qt_errorMsg2, __qt_errorLine3, __qt_errorColumn4);
        __java_return_value = Java::QtXml::QDomDocument$Result::newInstance(__jni_env, jboolean(__qt_return_value), qtjambi_cast<jstring>(__jni_env, errorMsg), errorLine, errorColumn);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::setContent<>(QByteArray,QDomDocument::ParseOptions)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_setContent_1native_1cref_1QByteArray_1QDomDocument_1ParseOptions__JJI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID data0,
 jint options1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::setContent<>(QByteArray,QDomDocument::ParseOptions)", __qt_this)
        const QByteArray& __qt_data0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(data0);
        QDomDocument::ParseOptions __qt_options1 = qtjambi_cast<QDomDocument::ParseOptions>(__jni_env, options1);
        QDomDocument::ParseResult __qt_return_value = __qt_this->setContent<>(__qt_data0, QDomDocument::ParseOptions(__qt_options1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::toByteArray(int)const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_toByteArray_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::toByteArray(int)const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toByteArray(static_cast<int>(arg__1));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QDomDocument::toString(int)const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_toString_1native_1int_1constfct__JI)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jint arg__1)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QDomDocument::toString(int)const", __qt_this)
        QString __qt_return_value = __qt_this->toString(static_cast<int>(arg__1));
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_xml_QDomDocument_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QDomDocument *__qt_this = QtJambiAPI::objectFromNativeId<QDomDocument>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QDomDocument(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QDomDocument>("QDomDocument", "io/qt/xml/QDomDocument");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QDomDocument, {
        ConstructorInfo(&__qt_construct_QDomDocument, nullptr)
       ,ConstructorInfo(&__qt_construct_QDomDocument_cref_QDomDocument, "Lio/qt/xml/QDomDocument;")
       ,ConstructorInfo(&__qt_construct_QDomDocument_cref_QDomDocumentType, "Lio/qt/xml/QDomDocumentType;")
       ,ConstructorInfo(&__qt_construct_QDomDocument_cref_QString, "Ljava/lang/String;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QDomDocument);
    registerMetaType<QDomDocument>("QDomDocument");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
    registerEnumTypeInfo<QDomDocument::ParseOption>("QDomDocument::ParseOption", "io/qt/xml/QDomDocument$ParseOption", "QDomDocument::ParseOptions", "QFlags<QDomDocument::ParseOption>", "io/qt/xml/QDomDocument$ParseOptions");
// END: enums and flags
}
