package io.qt.x11extras;


/**
 * <p>Provides information about the X display configuration</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qx11info.html">QX11Info</a></p>
 */
public final class QX11Info extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qx11info.html#PeekOption-enum">QX11Info::PeekOption</a></p>
     * 
     * @see PeekOptions
     */
    public enum PeekOption implements io.qt.QtFlagEnumerator {
        PeekDefault(0),
        PeekFromCachedIndex(1);

        private PeekOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public PeekOptions asFlags() {
            return new PeekOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public PeekOptions combined(PeekOption e) {
            return new PeekOptions(this, e);
        }

        /**
         * Creates a new {@link PeekOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static PeekOptions flags(PeekOption ... values) {
            return new PeekOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PeekOption resolve(int value) {
            switch (value) {
            case 0: return PeekDefault;
            case 1: return PeekFromCachedIndex;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link PeekOption}
     */
    public static final class PeekOptions extends io.qt.QFlags<PeekOption> implements Comparable<PeekOptions> {
        private static final long serialVersionUID = 0x4485eee1cbd1ac70L;

        /**
         * Creates a new PeekOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public PeekOptions(PeekOption ... args){
            super(args);
        }

        /**
         * Creates a new PeekOptions with given <code>value</code>.
         * @param value
         */
        public PeekOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new PeekOptions
         */
        @Override
        public final PeekOptions combined(PeekOption e){
            return new PeekOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final PeekOptions setFlag(PeekOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final PeekOptions setFlag(PeekOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this PeekOptions.
         * @return array of enum entries
         */
        @Override
        public final PeekOption[] flags(){
            return super.flags(PeekOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final PeekOptions clone(){
            return new PeekOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(PeekOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>Overloaded function for {@link #appDpiX(int)}
     *  with <code>screen = -1</code>.</p>
     */
    public static int appDpiX() {
        return appDpiX((int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#appDpiX">QX11Info::appDpiX(int)</a></p>
     */
    public native static int appDpiX(int screen);
    
    /**
     * <p>Overloaded function for {@link #appDpiY(int)}
     *  with <code>screen = -1</code>.</p>
     */
    public static int appDpiY() {
        return appDpiY((int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#appDpiY">QX11Info::appDpiY(int)</a></p>
     */
    public native static int appDpiY(int screen);
    
    /**
     * <p>Overloaded function for {@link #appRootWindow(int)}
     *  with <code>screen = -1</code>.</p>
     */
    public static int appRootWindow() {
        return appRootWindow((int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#appRootWindow">QX11Info::appRootWindow(int)</a></p>
     */
    public native static int appRootWindow(int screen);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#appScreen">QX11Info::appScreen()</a></p>
     */
    public native static int appScreen();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#appTime">QX11Info::appTime()</a></p>
     */
    public native static int appTime();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#appUserTime">QX11Info::appUserTime()</a></p>
     */
    public native static int appUserTime();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#generatePeekerId">QX11Info::generatePeekerId()</a></p>
     */
    public native static int generatePeekerId();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#getTimestamp">QX11Info::getTimestamp()</a></p>
     */
    public native static int getTimestamp();
    
    /**
     * <p>Overloaded function for {@link #isCompositingManagerRunning(int)}
     *  with <code>screen = -1</code>.</p>
     */
    public static boolean isCompositingManagerRunning() {
        return isCompositingManagerRunning((int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#isCompositingManagerRunning">QX11Info::isCompositingManagerRunning(int)</a></p>
     */
    public native static boolean isCompositingManagerRunning(int screen);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#isPlatformX11">QX11Info::isPlatformX11()</a></p>
     */
    public native static boolean isPlatformX11();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#nextStartupId">QX11Info::nextStartupId()</a></p>
     */
    public native static io.qt.core.QByteArray nextStartupId();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#removePeekerId">QX11Info::removePeekerId(qint32)</a></p>
     */
    public native static boolean removePeekerId(int peekerId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#setAppTime">QX11Info::setAppTime(ulong)</a></p>
     */
    public native static void setAppTime(int time);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#setAppUserTime">QX11Info::setAppUserTime(ulong)</a></p>
     */
    public native static void setAppUserTime(int time);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qx11info.html#setNextStartupId">QX11Info::setNextStartupId(QByteArray)</a></p>
     */
    public static void setNextStartupId(io.qt.core.QByteArray id){
        setNextStartupId_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(id));
    }
    
    private native static void setNextStartupId_native_cref_QByteArray(long id);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QX11Info(QPrivateConstructor p) { super(p); } 
    
}
