package io.qt.websockets;

import io.qt.*;


/**
 * <p>Contains constants related to the WebSocket standard</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html">QWebSocketProtocol</a></code></p>
 */
public final class QWebSocketProtocol
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QWebSocketProtocol() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QWebSocketProtocol."); }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCode</a></code></p>
     */
    public enum CloseCode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeNormal</a></code></p>
         */
        CloseCodeNormal(1000),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeGoingAway</a></code></p>
         */
        CloseCodeGoingAway(1001),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeProtocolError</a></code></p>
         */
        CloseCodeProtocolError(1002),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeDatatypeNotSupported</a></code></p>
         */
        CloseCodeDatatypeNotSupported(1003),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeReserved1004</a></code></p>
         */
        CloseCodeReserved1004(1004),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeMissingStatusCode</a></code></p>
         */
        CloseCodeMissingStatusCode(1005),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeAbnormalDisconnection</a></code></p>
         */
        CloseCodeAbnormalDisconnection(1006),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeWrongDatatype</a></code></p>
         */
        CloseCodeWrongDatatype(1007),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodePolicyViolated</a></code></p>
         */
        CloseCodePolicyViolated(1008),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeTooMuchData</a></code></p>
         */
        CloseCodeTooMuchData(1009),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeMissingExtension</a></code></p>
         */
        CloseCodeMissingExtension(1010),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeBadOperation</a></code></p>
         */
        CloseCodeBadOperation(1011),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::<wbr/>CloseCodeTlsHandshakeFailed</a></code></p>
         */
        CloseCodeTlsHandshakeFailed(1015);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CloseCode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CloseCode resolve(int value) {
            switch (value) {
            case 1000: return CloseCodeNormal;
            case 1001: return CloseCodeGoingAway;
            case 1002: return CloseCodeProtocolError;
            case 1003: return CloseCodeDatatypeNotSupported;
            case 1004: return CloseCodeReserved1004;
            case 1005: return CloseCodeMissingStatusCode;
            case 1006: return CloseCodeAbnormalDisconnection;
            case 1007: return CloseCodeWrongDatatype;
            case 1008: return CloseCodePolicyViolated;
            case 1009: return CloseCodeTooMuchData;
            case 1010: return CloseCodeMissingExtension;
            case 1011: return CloseCodeBadOperation;
            case 1015: return CloseCodeTlsHandshakeFailed;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version</a></code></p>
     */
    @QtRejectedEntries({"VersionLatest"})
    public enum Version implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>VersionUnknown</a></code></p>
         */
        VersionUnknown(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>Version0</a></code></p>
         */
        Version0(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>Version4</a></code></p>
         */
        Version4(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>Version5</a></code></p>
         */
        Version5(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>Version6</a></code></p>
         */
        Version6(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>Version7</a></code></p>
         */
        Version7(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>Version8</a></code></p>
         */
        Version8(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>Version13</a></code></p>
         */
        Version13(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::<wbr/>VersionLatest</a></code></p>
         */
        VersionLatest(13);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Version(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Version resolve(int value) {
            switch (value) {
            case -1: return VersionUnknown;
            case 0: return Version0;
            case 4: return Version4;
            case 5: return Version5;
            case 6: return Version6;
            case 7: return Version7;
            case 8: return Version8;
            case 13: return Version13;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
