package io.qt.websockets;

import io.qt.*;


/**
 * <p>Authenticator object for Cross Origin Requests (CORS)</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html">QWebSocketCorsAuthenticator</a></code></p>
 */
public class QWebSocketCorsAuthenticator extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html#QWebSocketCorsAuthenticator">QWebSocketCorsAuthenticator::<wbr>QWebSocketCorsAuthenticator(QString)</a></code></p>
     */
    public QWebSocketCorsAuthenticator(java.lang.@NonNull String origin){
        super((QPrivateConstructor)null);
        initialize_native(this, origin);
    }
    
    private native static void initialize_native(QWebSocketCorsAuthenticator instance, java.lang.String origin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html#QWebSocketCorsAuthenticator-1">QWebSocketCorsAuthenticator::<wbr>QWebSocketCorsAuthenticator(QWebSocketCorsAuthenticator)</a></code></p>
     */
    public QWebSocketCorsAuthenticator(io.qt.websockets.@NonNull QWebSocketCorsAuthenticator other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebSocketCorsAuthenticator instance, io.qt.websockets.QWebSocketCorsAuthenticator other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html#allowed">QWebSocketCorsAuthenticator::<wbr>allowed()const</a></code></p>
     */
    @QtUninvokable
    public final boolean allowed(){
        return allowed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean allowed_native_constfct(long __this__nativeId);
    
    /**
     * @deprecated Use {@link #assign(io.qt.websockets.QWebSocketCorsAuthenticator)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.websockets.@NonNull QWebSocketCorsAuthenticator other) {
        assign(other);
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html#operator-eq-1">QWebSocketCorsAuthenticator::<wbr>operator=(QWebSocketCorsAuthenticator)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.websockets.@NonNull QWebSocketCorsAuthenticator other){
        assign_native_cref_QWebSocketCorsAuthenticator(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebSocketCorsAuthenticator(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html#origin">QWebSocketCorsAuthenticator::<wbr>origin()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html#setAllowed">QWebSocketCorsAuthenticator::<wbr>setAllowed(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setAllowed(boolean allowed){
        setAllowed_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), allowed);
    }
    
    @QtUninvokable
    private native void setAllowed_native_bool(long __this__nativeId, boolean allowed);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocketcorsauthenticator.html#swap">QWebSocketCorsAuthenticator::<wbr>swap(QWebSocketCorsAuthenticator&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.websockets.@StrictNonNull QWebSocketCorsAuthenticator other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebSocketCorsAuthenticator(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QWebSocketCorsAuthenticator(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebSocketCorsAuthenticator(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QWebSocketCorsAuthenticator clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebSocketCorsAuthenticator clone_native(long __this_nativeId);
}
