package io.qt.websockets;

import io.qt.*;


/**
 * <p>Implements a TCP socket that talks the WebSocket protocol</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebsocket.html">QWebSocket</a></code></p>
 */
public class QWebSocket extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcMaskGenerator = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebSocket.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#aboutToClose">QWebSocket::<wbr>aboutToClose()</a></code></p>
     */
    public final @NonNull Signal0 aboutToClose = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#alertReceived">QWebSocket::<wbr>alertReceived(QSsl::AlertLevel,<wbr>QSsl::AlertType,<wbr>QString)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal3<io.qt.network.QSsl.@NonNull AlertLevel, io.qt.network.QSsl.@NonNull AlertType, java.lang.@NonNull String> alertReceived = new Signal3<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#alertSent">QWebSocket::<wbr>alertSent(QSsl::AlertLevel,<wbr>QSsl::AlertType,<wbr>QString)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal3<io.qt.network.QSsl.@NonNull AlertLevel, io.qt.network.QSsl.@NonNull AlertType, java.lang.@NonNull String> alertSent = new Signal3<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#binaryFrameReceived">QWebSocket::<wbr>binaryFrameReceived(QByteArray,<wbr>bool)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.core.@NonNull QByteArray, java.lang.@QtPrimitiveType@NonNull Boolean> binaryFrameReceived = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#binaryMessageReceived">QWebSocket::<wbr>binaryMessageReceived(QByteArray)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> binaryMessageReceived = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#bytesWritten">QWebSocket::<wbr>bytesWritten(qint64)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> bytesWritten = new Signal1<>();

    /**
     * <p>Emitted when a connection is successfully established. A connection is successfully established when the socket is connected and the handshake was successful</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#connected">QWebSocket::<wbr>connected()</a></code></p>
     */
    public final @NonNull Signal0 connected = new Signal0();

    /**
     * <p>Emitted when the socket is disconnected</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#disconnected">QWebSocket::<wbr>disconnected()</a></code></p>
     */
    public final @NonNull Signal0 disconnected = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#error">QWebSocket::<wbr>error(QAbstractSocket::SocketError)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.QAbstractSocket.@NonNull SocketError> error = new Signal1<>();

    /**
     * <p>This signal is emitted after an error occurred</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#errorOccurred">QWebSocket::<wbr>errorOccurred(QAbstractSocket::SocketError)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.QAbstractSocket.@NonNull SocketError> errorOccurred = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#handshakeInterruptedOnError">QWebSocket::<wbr>handshakeInterruptedOnError(QSslError)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QSslError> handshakeInterruptedOnError = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#peerVerifyError">QWebSocket::<wbr>peerVerifyError(QSslError)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QSslError> peerVerifyError = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#pong">QWebSocket::<wbr>pong(quint64,<wbr>QByteArray)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Long, io.qt.core.@NonNull QByteArray> pong = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#preSharedKeyAuthenticationRequired">QWebSocket::<wbr>preSharedKeyAuthenticationRequired(QSslPreSharedKeyAuthenticator*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@Nullable QSslPreSharedKeyAuthenticator> preSharedKeyAuthenticationRequired = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#proxyAuthenticationRequired">QWebSocket::<wbr>proxyAuthenticationRequired(QNetworkProxy,<wbr>QAuthenticator*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal2<io.qt.network.@NonNull QNetworkProxy, io.qt.network.@Nullable QAuthenticator> proxyAuthenticationRequired = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#readChannelFinished">QWebSocket::<wbr>readChannelFinished()</a></code></p>
     */
    public final @NonNull Signal0 readChannelFinished = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#sslErrors">QWebSocket::<wbr>sslErrors(QList&lt;QSslError&gt;)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.network.@NonNull QSslError>> sslErrors = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#stateChanged">QWebSocket::<wbr>stateChanged(QAbstractSocket::SocketState)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.QAbstractSocket.@NonNull SocketState> stateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#textFrameReceived">QWebSocket::<wbr>textFrameReceived(QString,<wbr>bool)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Boolean> textFrameReceived = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#textMessageReceived">QWebSocket::<wbr>textMessageReceived(QString)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> textMessageReceived = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QWebSocket(java.lang.String, io.qt.websockets.QWebSocketProtocol.Version, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebSocket(java.lang.@NonNull String origin, io.qt.websockets.QWebSocketProtocol.@NonNull Version version) {
        this(origin, version, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebSocket(java.lang.String, io.qt.websockets.QWebSocketProtocol.Version, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>version = io.qt.websockets.QWebSocketProtocol.Version.VersionLatest</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QWebSocket(java.lang.@NonNull String origin) {
        this(origin, io.qt.websockets.QWebSocketProtocol.Version.VersionLatest, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebSocket(java.lang.String, io.qt.websockets.QWebSocketProtocol.Version, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>origin = (String)null</code></li>
     * <li><code>version = io.qt.websockets.QWebSocketProtocol.Version.VersionLatest</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QWebSocket() {
        this((String)null, io.qt.websockets.QWebSocketProtocol.Version.VersionLatest, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Creates a new QWebSocket with the given origin, the version of the protocol to use and parent</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#QWebSocket-1">QWebSocket::<wbr>QWebSocket(QString,<wbr>QWebSocketProtocol::Version,<wbr>QObject*)</a></code></p>
     */
    public QWebSocket(java.lang.@NonNull String origin, io.qt.websockets.QWebSocketProtocol.@NonNull Version version, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, origin, version, parent);
    }
    
    private native static void initialize_native(QWebSocket instance, java.lang.String origin, io.qt.websockets.QWebSocketProtocol.Version version, io.qt.core.QObject parent);
    
    /**
     * <p>Aborts the current socket and resets the socket. Unlike close(), this function immediately closes the socket, discarding any pending data in the write buffer</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#abort">QWebSocket::<wbr>abort()</a></code></p>
     */
    @QtUninvokable
    public final void abort(){
        abort_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void abort_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#bytesToWrite">QWebSocket::<wbr>bytesToWrite()const</a></code></p>
     */
    @QtUninvokable
    public final long bytesToWrite(){
        return bytesToWrite_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long bytesToWrite_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #close(io.qt.websockets.QWebSocketProtocol.CloseCode, java.lang.String)}
     *  with <code>reason = (String)null</code>.</p>
     */
    public final void close(io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode closeCode) {
        close(closeCode, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #close(io.qt.websockets.QWebSocketProtocol.CloseCode, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>closeCode = io.qt.websockets.QWebSocketProtocol.CloseCode.CloseCodeNormal</code></li>
     * <li><code>reason = (String)null</code></li>
     * </ul>
     */
    public final void close() {
        close(io.qt.websockets.QWebSocketProtocol.CloseCode.CloseCodeNormal, (String)null);
    }
    
    /**
     * <p>Gracefully closes the socket with the given closeCode and reason</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#close">QWebSocket::<wbr>close(QWebSocketProtocol::CloseCode,<wbr>QString)</a></code></p>
     */
    public final void close(io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode closeCode, java.lang.@NonNull String reason){
        close_native_QWebSocketProtocol_CloseCode_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), closeCode.value(), reason);
    }
    
    private native void close_native_QWebSocketProtocol_CloseCode_cref_QString(long __this__nativeId, int closeCode, java.lang.String reason);
    
    /**
     * <p>Returns the code indicating why the socket was closed</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#closeCode">QWebSocket::<wbr>closeCode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode closeCode(){
        return io.qt.websockets.QWebSocketProtocol.CloseCode.resolve(closeCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int closeCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the reason why the socket was closed</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#closeReason">QWebSocket::<wbr>closeReason()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String closeReason(){
        return closeReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String closeReason_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#continueInterruptedHandshake">QWebSocket::<wbr>continueInterruptedHandshake()</a></code></p>
     */
    @QtUninvokable
    public final void continueInterruptedHandshake(){
        continueInterruptedHandshake_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void continueInterruptedHandshake_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#error">QWebSocket::<wbr>error()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.QAbstractSocket.@NonNull SocketError error(){
        return io.qt.network.QAbstractSocket.SocketError.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#errorString">QWebSocket::<wbr>errorString()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#flush">QWebSocket::<wbr>flush()</a></code></p>
     */
    @QtUninvokable
    public final boolean flush(){
        return flush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean flush_native(long __this__nativeId);
    
    /**
     * <p>Returns the handshake options that were used to open this socket</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#handshakeOptions">QWebSocket::<wbr>handshakeOptions()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.websockets.@NonNull QWebSocketHandshakeOptions handshakeOptions(){
        return handshakeOptions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.websockets.QWebSocketHandshakeOptions handshakeOptions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#ignoreSslErrors">QWebSocket::<wbr>ignoreSslErrors()</a></code></p>
     */
    public final void ignoreSslErrors(){
        ignoreSslErrors_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void ignoreSslErrors_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#ignoreSslErrors-1">QWebSocket::<wbr>ignoreSslErrors(QList&lt;QSslError&gt;)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void ignoreSslErrors(java.util.@NonNull Collection<? extends io.qt.network.@NonNull QSslError> errors){
        ignoreSslErrors_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), errors);
    }
    
    @QtUninvokable
    private native void ignoreSslErrors_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.network.QSslError> errors);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#isValid">QWebSocket::<wbr>isValid()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#localAddress">QWebSocket::<wbr>localAddress()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QHostAddress localAddress(){
        return localAddress_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QHostAddress localAddress_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#localPort">QWebSocket::<wbr>localPort()const</a></code></p>
     */
    @QtUninvokable
    public final short localPort(){
        return localPort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native short localPort_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#maskGenerator">QWebSocket::<wbr>maskGenerator()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.websockets.@Nullable QMaskGenerator maskGenerator(){
        return maskGenerator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.websockets.QMaskGenerator maskGenerator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#maxAllowedIncomingFrameSize">QWebSocket::<wbr>maxAllowedIncomingFrameSize()const</a></code></p>
     */
    @QtUninvokable
    public final long maxAllowedIncomingFrameSize(){
        return maxAllowedIncomingFrameSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long maxAllowedIncomingFrameSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#maxAllowedIncomingMessageSize">QWebSocket::<wbr>maxAllowedIncomingMessageSize()const</a></code></p>
     */
    @QtUninvokable
    public final long maxAllowedIncomingMessageSize(){
        return maxAllowedIncomingMessageSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long maxAllowedIncomingMessageSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Opens a WebSocket connection using the given request</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#open-1">QWebSocket::<wbr>open(QNetworkRequest)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final void open(io.qt.network.@NonNull QNetworkRequest request){
        open_native_cref_QNetworkRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    private native void open_native_cref_QNetworkRequest(long __this__nativeId, long request);
    
    /**
     * <p>Opens a WebSocket connection using the given request and options</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#open-3">QWebSocket::<wbr>open(QNetworkRequest,<wbr>QWebSocketHandshakeOptions)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final void open(io.qt.network.@NonNull QNetworkRequest request, io.qt.websockets.@NonNull QWebSocketHandshakeOptions options){
        open_native_cref_QNetworkRequest_cref_QWebSocketHandshakeOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request), QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    private native void open_native_cref_QNetworkRequest_cref_QWebSocketHandshakeOptions(long __this__nativeId, long request, long options);
    
    /**
     * <p>Opens a WebSocket connection using the given url</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#open">QWebSocket::<wbr>open(QUrl)</a></code></p>
     */
    public final void open(io.qt.core.@NonNull QUrl url){
        open_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native void open_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>Opens a WebSocket connection using the given url and options</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#open-2">QWebSocket::<wbr>open(QUrl,<wbr>QWebSocketHandshakeOptions)</a></code></p>
     */
    public final void open(io.qt.core.@NonNull QUrl url, io.qt.websockets.@NonNull QWebSocketHandshakeOptions options){
        open_native_cref_QUrl_cref_QWebSocketHandshakeOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    private native void open_native_cref_QUrl_cref_QWebSocketHandshakeOptions(long __this__nativeId, long url, long options);
    
    /**
     * <p>Returns the current origin</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#origin">QWebSocket::<wbr>origin()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#outgoingFrameSize">QWebSocket::<wbr>outgoingFrameSize()const</a></code></p>
     */
    @QtUninvokable
    public final long outgoingFrameSize(){
        return outgoingFrameSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long outgoingFrameSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#pauseMode">QWebSocket::<wbr>pauseMode()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.QAbstractSocket.@NonNull PauseModes pauseMode(){
        return new io.qt.network.QAbstractSocket.PauseModes(pauseMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pauseMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#peerAddress">QWebSocket::<wbr>peerAddress()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QHostAddress peerAddress(){
        return peerAddress_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QHostAddress peerAddress_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#peerName">QWebSocket::<wbr>peerName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String peerName(){
        return peerName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String peerName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#peerPort">QWebSocket::<wbr>peerPort()const</a></code></p>
     */
    @QtUninvokable
    public final short peerPort(){
        return peerPort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native short peerPort_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #ping(io.qt.core.QByteArray)}
     *  with <code>payload = new io.qt.core.QByteArray()</code>.</p>
     */
    public final void ping() {
        ping(new io.qt.core.QByteArray());
    }
    
    /**
     * <p>Pings the server to indicate that the connection is still alive. Additional payload can be sent along the ping message</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#ping">QWebSocket::<wbr>ping(QByteArray)</a></code></p>
     */
    public final void ping(io.qt.core.@NonNull QByteArray payload){
        ping_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(payload));
    }
    
    private native void ping_native_cref_QByteArray(long __this__nativeId, long payload);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#proxy">QWebSocket::<wbr>proxy()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QNetworkProxy proxy(){
        return proxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkProxy proxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#readBufferSize">QWebSocket::<wbr>readBufferSize()const</a></code></p>
     */
    @QtUninvokable
    public final long readBufferSize(){
        return readBufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long readBufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the request that was or will be used to open this socket</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#request">QWebSocket::<wbr>request()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QNetworkRequest request(){
        return request_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkRequest request_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the url the socket is connected to or will connect to</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#requestUrl">QWebSocket::<wbr>requestUrl()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the name of the resource currently accessed</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#resourceName">QWebSocket::<wbr>resourceName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String resourceName(){
        return resourceName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String resourceName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#resume">QWebSocket::<wbr>resume()</a></code></p>
     */
    @QtUninvokable
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>Sends the given data over the socket as a binary message and returns the number of bytes actually sent</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#sendBinaryMessage">QWebSocket::<wbr>sendBinaryMessage(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final long sendBinaryMessage(io.qt.core.@NonNull QByteArray data){
        return sendBinaryMessage_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @QtUninvokable
    private native long sendBinaryMessage_native_cref_QByteArray(long __this__nativeId, long data);
    
    /**
     * <p>Sends the given message over the socket as a text message and returns the number of bytes actually sent</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#sendTextMessage">QWebSocket::<wbr>sendTextMessage(QString)</a></code></p>
     */
    @QtUninvokable
    public final long sendTextMessage(java.lang.@NonNull String message){
        return sendTextMessage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), message);
    }
    
    @QtUninvokable
    private native long sendTextMessage_native_cref_QString(long __this__nativeId, java.lang.String message);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setMaskGenerator">QWebSocket::<wbr>setMaskGenerator(const QMaskGenerator*)</a></code></p>
     */
    @QtUninvokable
    public final void setMaskGenerator(io.qt.websockets.@Nullable QMaskGenerator maskGenerator){
        setMaskGenerator_native_const_QMaskGenerator_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(maskGenerator));
        __rcMaskGenerator = maskGenerator;
    }
    
    @QtUninvokable
    private native void setMaskGenerator_native_const_QMaskGenerator_ptr(long __this__nativeId, long maskGenerator);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setMaxAllowedIncomingFrameSize">QWebSocket::<wbr>setMaxAllowedIncomingFrameSize(quint64)</a></code></p>
     */
    @QtUninvokable
    public final void setMaxAllowedIncomingFrameSize(long maxAllowedIncomingFrameSize){
        setMaxAllowedIncomingFrameSize_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), maxAllowedIncomingFrameSize);
    }
    
    @QtUninvokable
    private native void setMaxAllowedIncomingFrameSize_native_quint64(long __this__nativeId, long maxAllowedIncomingFrameSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setMaxAllowedIncomingMessageSize">QWebSocket::<wbr>setMaxAllowedIncomingMessageSize(quint64)</a></code></p>
     */
    @QtUninvokable
    public final void setMaxAllowedIncomingMessageSize(long maxAllowedIncomingMessageSize){
        setMaxAllowedIncomingMessageSize_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), maxAllowedIncomingMessageSize);
    }
    
    @QtUninvokable
    private native void setMaxAllowedIncomingMessageSize_native_quint64(long __this__nativeId, long maxAllowedIncomingMessageSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setOutgoingFrameSize">QWebSocket::<wbr>setOutgoingFrameSize(quint64)</a></code></p>
     */
    @QtUninvokable
    public final void setOutgoingFrameSize(long outgoingFrameSize){
        setOutgoingFrameSize_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), outgoingFrameSize);
    }
    
    @QtUninvokable
    private native void setOutgoingFrameSize_native_quint64(long __this__nativeId, long outgoingFrameSize);
    
    /**
     * <p>Overloaded function for {@link #setPauseMode(io.qt.network.QAbstractSocket.PauseModes)}.</p>
     */
    @QtUninvokable
    public final void setPauseMode(io.qt.network.QAbstractSocket.@NonNull PauseMode @NonNull... pauseMode){
        setPauseMode(new io.qt.network.QAbstractSocket.PauseModes(pauseMode));
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setPauseMode">QWebSocket::<wbr>setPauseMode(QAbstractSocket::PauseModes)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setPauseMode(io.qt.network.QAbstractSocket.@NonNull PauseModes pauseMode){
        setPauseMode_native_QAbstractSocket_PauseModes(QtJambi_LibraryUtilities.internal.nativeId(this), pauseMode.value());
    }
    
    @QtUninvokable
    private native void setPauseMode_native_QAbstractSocket_PauseModes(long __this__nativeId, int pauseMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setProxy">QWebSocket::<wbr>setProxy(QNetworkProxy)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setProxy(io.qt.network.@NonNull QNetworkProxy networkProxy){
        setProxy_native_cref_QNetworkProxy(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkProxy));
    }
    
    @QtUninvokable
    private native void setProxy_native_cref_QNetworkProxy(long __this__nativeId, long networkProxy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setReadBufferSize">QWebSocket::<wbr>setReadBufferSize(qint64)</a></code></p>
     */
    @QtUninvokable
    public final void setReadBufferSize(long size){
        setReadBufferSize_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void setReadBufferSize_native_qint64(long __this__nativeId, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#setSslConfiguration">QWebSocket::<wbr>setSslConfiguration(QSslConfiguration)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setSslConfiguration(io.qt.network.@NonNull QSslConfiguration sslConfiguration){
        setSslConfiguration_native_cref_QSslConfiguration(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sslConfiguration));
    }
    
    @QtUninvokable
    private native void setSslConfiguration_native_cref_QSslConfiguration(long __this__nativeId, long sslConfiguration);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#sslConfiguration">QWebSocket::<wbr>sslConfiguration()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QSslConfiguration sslConfiguration(){
        return sslConfiguration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QSslConfiguration sslConfiguration_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the current state of the socket</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#state">QWebSocket::<wbr>state()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.QAbstractSocket.@NonNull SocketState state(){
        return io.qt.network.QAbstractSocket.SocketState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the used WebSocket protocol</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#subprotocol">QWebSocket::<wbr>subprotocol()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String subprotocol(){
        return subprotocol_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String subprotocol_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the version the socket is currently using</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#version">QWebSocket::<wbr>version()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.websockets.QWebSocketProtocol.@NonNull Version version(){
        return io.qt.websockets.QWebSocketProtocol.Version.resolve(version_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int version_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#maxIncomingFrameSize">QWebSocket::<wbr>maxIncomingFrameSize()</a></code></p>
     */
    public native static long maxIncomingFrameSize();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#maxIncomingMessageSize">QWebSocket::<wbr>maxIncomingMessageSize()</a></code></p>
     */
    public native static long maxIncomingMessageSize();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebsocket.html#maxOutgoingFrameSize">QWebSocket::<wbr>maxOutgoingFrameSize()</a></code></p>
     */
    public native static long maxOutgoingFrameSize();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebSocket(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QWebSocket(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWebSocket instance, QDeclarativeConstructor constructor);
    
}
