package io.qt.websockets;

import io.qt.*;


/**
 * <p>Contains constants related to the WebSocket standard</p>
 * <p>Java wrapper for Qt's namespace <a href="https://doc.qt.io/qt/qwebsocketprotocol.html">QWebSocketProtocol</a></p>
 */
public final class QWebSocketProtocol
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QWebSocketProtocol() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QWebSocketProtocol."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCode</a></p>
     */
    public enum CloseCode implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeNormal</a></p>
         */
        CloseCodeNormal(1000),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeGoingAway</a></p>
         */
        CloseCodeGoingAway(1001),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeProtocolError</a></p>
         */
        CloseCodeProtocolError(1002),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeDatatypeNotSupported</a></p>
         */
        CloseCodeDatatypeNotSupported(1003),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeReserved1004</a></p>
         */
        CloseCodeReserved1004(1004),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeMissingStatusCode</a></p>
         */
        CloseCodeMissingStatusCode(1005),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeAbnormalDisconnection</a></p>
         */
        CloseCodeAbnormalDisconnection(1006),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeWrongDatatype</a></p>
         */
        CloseCodeWrongDatatype(1007),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodePolicyViolated</a></p>
         */
        CloseCodePolicyViolated(1008),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeTooMuchData</a></p>
         */
        CloseCodeTooMuchData(1009),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeMissingExtension</a></p>
         */
        CloseCodeMissingExtension(1010),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeBadOperation</a></p>
         */
        CloseCodeBadOperation(1011),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#CloseCode-enum">QWebSocketProtocol::CloseCodeTlsHandshakeFailed</a></p>
         */
        CloseCodeTlsHandshakeFailed(1015);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CloseCode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CloseCode resolve(int value) {
            switch (value) {
            case 1000: return CloseCodeNormal;
            case 1001: return CloseCodeGoingAway;
            case 1002: return CloseCodeProtocolError;
            case 1003: return CloseCodeDatatypeNotSupported;
            case 1004: return CloseCodeReserved1004;
            case 1005: return CloseCodeMissingStatusCode;
            case 1006: return CloseCodeAbnormalDisconnection;
            case 1007: return CloseCodeWrongDatatype;
            case 1008: return CloseCodePolicyViolated;
            case 1009: return CloseCodeTooMuchData;
            case 1010: return CloseCodeMissingExtension;
            case 1011: return CloseCodeBadOperation;
            case 1015: return CloseCodeTlsHandshakeFailed;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version</a></p>
     */
    @QtRejectedEntries({"VersionLatest"})
    public enum Version implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::VersionUnknown</a></p>
         */
        VersionUnknown(-1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version0</a></p>
         */
        Version0(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version4</a></p>
         */
        Version4(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version5</a></p>
         */
        Version5(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version6</a></p>
         */
        Version6(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version7</a></p>
         */
        Version7(7),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version8</a></p>
         */
        Version8(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::Version13</a></p>
         */
        Version13(13),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebsocketprotocol.html#Version-enum">QWebSocketProtocol::VersionLatest</a></p>
         */
        VersionLatest(13);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Version(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Version resolve(int value) {
            switch (value) {
            case -1: return VersionUnknown;
            case 0: return Version0;
            case 4: return Version4;
            case 5: return Version5;
            case 6: return Version6;
            case 7: return Version7;
            case 8: return Version8;
            case 13: return Version13;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
}
