package io.qt.websockets;

import io.qt.*;


/**
 * <p>Collects options for the WebSocket handshake</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebsockethandshakeoptions.html">QWebSocketHandshakeOptions</a></p>
 */
public class QWebSocketHandshakeOptions extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>Constructs an empty QWebSocketHandshakeOptions object</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsockethandshakeoptions.html#QWebSocketHandshakeOptions">QWebSocketHandshakeOptions::QWebSocketHandshakeOptions()</a></p>
     */
    public QWebSocketHandshakeOptions(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QWebSocketHandshakeOptions instance);
    
    /**
     * <p>Constructs a QWebSocketHandshakeOptions that is a copy of other</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsockethandshakeoptions.html#QWebSocketHandshakeOptions-1">QWebSocketHandshakeOptions::QWebSocketHandshakeOptions(QWebSocketHandshakeOptions)</a></p>
     */
    public QWebSocketHandshakeOptions(io.qt.websockets.@NonNull QWebSocketHandshakeOptions other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebSocketHandshakeOptions instance, io.qt.websockets.QWebSocketHandshakeOptions other);
    
    /**
     * @deprecated Use {@link #assign(io.qt.websockets.QWebSocketHandshakeOptions)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.websockets.@NonNull QWebSocketHandshakeOptions other) {
        assign(other);
    }
    
    /**
     * <p>Assigns other to this object</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsockethandshakeoptions.html#operator-eq-1">QWebSocketHandshakeOptions::operator=(QWebSocketHandshakeOptions)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.websockets.@NonNull QWebSocketHandshakeOptions other){
        assign_native_cref_QWebSocketHandshakeOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebSocketHandshakeOptions(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsockethandshakeoptions.html#operator-eq-eq">operator==(QWebSocketHandshakeOptions,QWebSocketHandshakeOptions)</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.websockets.@NonNull QWebSocketHandshakeOptions rhs){
        return operator_equal_native_cref_QWebSocketHandshakeOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QWebSocketHandshakeOptions(long __this__nativeId, long rhs);
    
    /**
     * <p>Sets the list of WebSocket subprotocols protocols to send along with the websocket handshake</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsockethandshakeoptions.html#setSubprotocols">QWebSocketHandshakeOptions::setSubprotocols(QStringList)</a></p>
     */
    @QtUninvokable
    public final void setSubprotocols(java.util.@NonNull Collection<java.lang.@NonNull String> protocols){
        setSubprotocols_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), protocols);
    }
    
    @QtUninvokable
    private native void setSubprotocols_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> protocols);
    
    /**
     * <p>Returns the list of WebSocket subprotocols to send along with the websocket handshake</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsockethandshakeoptions.html#subprotocols">QWebSocketHandshakeOptions::subprotocols()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList subprotocols(){
        return subprotocols_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList subprotocols_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void swap(io.qt.websockets.@StrictNonNull QWebSocketHandshakeOptions other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebSocketHandshakeOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QWebSocketHandshakeOptions(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebSocketHandshakeOptions(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.websockets.QWebSocketHandshakeOptions) {
            return operator_equal((io.qt.websockets.QWebSocketHandshakeOptions) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QWebSocketHandshakeOptions clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebSocketHandshakeOptions clone_native(long __this_nativeId);
}
