package io.qt.websockets;

import io.qt.*;


/**
 * <p>Implements a TCP socket that talks the WebSocket protocol</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebsocket.html">QWebSocket</a></p>
 */
public class QWebSocket extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcMaskGenerator = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebSocket.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#aboutToClose">QWebSocket::aboutToClose()</a></p>
     */
    public final @NonNull Signal0 aboutToClose = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#alertReceived">QWebSocket::alertReceived(QSsl::AlertLevel,QSsl::AlertType,QString)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal3<io.qt.network.QSsl.@NonNull AlertLevel, io.qt.network.QSsl.@NonNull AlertType, java.lang.@NonNull String> alertReceived = new Signal3<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#alertSent">QWebSocket::alertSent(QSsl::AlertLevel,QSsl::AlertType,QString)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal3<io.qt.network.QSsl.@NonNull AlertLevel, io.qt.network.QSsl.@NonNull AlertType, java.lang.@NonNull String> alertSent = new Signal3<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#binaryFrameReceived">QWebSocket::binaryFrameReceived(QByteArray,bool)</a></p>
     */
    public final @NonNull Signal2<io.qt.core.@NonNull QByteArray, java.lang.@QtPrimitiveType@NonNull Boolean> binaryFrameReceived = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#binaryMessageReceived">QWebSocket::binaryMessageReceived(QByteArray)</a></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> binaryMessageReceived = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#bytesWritten">QWebSocket::bytesWritten(qint64)</a></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> bytesWritten = new Signal1<>();

    /**
     * <p>Emitted when a connection is successfully established. A connection is successfully established when the socket is connected and the handshake was successful</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#connected">QWebSocket::connected()</a></p>
     */
    public final @NonNull Signal0 connected = new Signal0();

    /**
     * <p>Emitted when the socket is disconnected</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#disconnected">QWebSocket::disconnected()</a></p>
     */
    public final @NonNull Signal0 disconnected = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#error">QWebSocket::error(QAbstractSocket::SocketError)</a></p>
     * 
     * @deprecated Use errorOccurred instead
     */
    @Deprecated
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.QAbstractSocket.@NonNull SocketError> error = new Signal1<>();

    /**
     * <p>This signal is emitted after an error occurred</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#errorOccurred">QWebSocket::errorOccurred(QAbstractSocket::SocketError)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.QAbstractSocket.@NonNull SocketError> errorOccurred = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#handshakeInterruptedOnError">QWebSocket::handshakeInterruptedOnError(QSslError)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QSslError> handshakeInterruptedOnError = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#peerVerifyError">QWebSocket::peerVerifyError(QSslError)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QSslError> peerVerifyError = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#pong">QWebSocket::pong(quint64,QByteArray)</a></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Long, io.qt.core.@NonNull QByteArray> pong = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#preSharedKeyAuthenticationRequired">QWebSocket::preSharedKeyAuthenticationRequired(QSslPreSharedKeyAuthenticator*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@Nullable QSslPreSharedKeyAuthenticator> preSharedKeyAuthenticationRequired = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#proxyAuthenticationRequired">QWebSocket::proxyAuthenticationRequired(QNetworkProxy,QAuthenticator*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal2<io.qt.network.@NonNull QNetworkProxy, io.qt.network.@Nullable QAuthenticator> proxyAuthenticationRequired = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#readChannelFinished">QWebSocket::readChannelFinished()</a></p>
     */
    public final @NonNull Signal0 readChannelFinished = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#sslErrors">QWebSocket::sslErrors(QList&lt;QSslError&gt;)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.network.@NonNull QSslError>> sslErrors = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#stateChanged">QWebSocket::stateChanged(QAbstractSocket::SocketState)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.QAbstractSocket.@NonNull SocketState> stateChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#textFrameReceived">QWebSocket::textFrameReceived(QString,bool)</a></p>
     */
    public final @NonNull Signal2<java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Boolean> textFrameReceived = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#textMessageReceived">QWebSocket::textMessageReceived(QString)</a></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> textMessageReceived = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QWebSocket(java.lang.String, io.qt.websockets.QWebSocketProtocol.Version, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebSocket(java.lang.@NonNull String origin, io.qt.websockets.QWebSocketProtocol.@NonNull Version version) {
        this(origin, version, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebSocket(java.lang.String, io.qt.websockets.QWebSocketProtocol.Version, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>version = io.qt.websockets.QWebSocketProtocol.Version.VersionLatest</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QWebSocket(java.lang.@NonNull String origin) {
        this(origin, io.qt.websockets.QWebSocketProtocol.Version.VersionLatest, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebSocket(java.lang.String, io.qt.websockets.QWebSocketProtocol.Version, io.qt.core.QObject)}</p>
     * <p>with: </p><ul>
     * <li><code>origin = (String)null</code></li>
     * <li><code>version = io.qt.websockets.QWebSocketProtocol.Version.VersionLatest</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QWebSocket() {
        this((String)null, io.qt.websockets.QWebSocketProtocol.Version.VersionLatest, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Creates a new QWebSocket with the given origin, the version of the protocol to use and parent</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#QWebSocket-1">QWebSocket::QWebSocket(QString,QWebSocketProtocol::Version,QObject*)</a></p>
     */
    public QWebSocket(java.lang.@NonNull String origin, io.qt.websockets.QWebSocketProtocol.@NonNull Version version, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, origin, version, parent);
    }
    
    private native static void initialize_native(QWebSocket instance, java.lang.String origin, io.qt.websockets.QWebSocketProtocol.Version version, io.qt.core.QObject parent);
    
    /**
     * <p>Aborts the current socket and resets the socket. Unlike close(), this function immediately closes the socket, discarding any pending data in the write buffer</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#abort">QWebSocket::abort()</a></p>
     */
    @QtUninvokable
    public final void abort(){
        abort_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void abort_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#bytesToWrite">QWebSocket::bytesToWrite()const</a></p>
     */
    @QtUninvokable
    public final long bytesToWrite(){
        return bytesToWrite_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long bytesToWrite_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #close(io.qt.websockets.QWebSocketProtocol.CloseCode, java.lang.String)}
     *  with <code>reason = (String)null</code>.</p>
     */
    public final void close(io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode closeCode) {
        close(closeCode, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #close(io.qt.websockets.QWebSocketProtocol.CloseCode, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>closeCode = io.qt.websockets.QWebSocketProtocol.CloseCode.CloseCodeNormal</code></li>
     * <li><code>reason = (String)null</code></li>
     * </ul>
     */
    public final void close() {
        close(io.qt.websockets.QWebSocketProtocol.CloseCode.CloseCodeNormal, (String)null);
    }
    
    /**
     * <p>Gracefully closes the socket with the given closeCode and reason</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#close">QWebSocket::close(QWebSocketProtocol::CloseCode,QString)</a></p>
     */
    public final void close(io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode closeCode, java.lang.@NonNull String reason){
        close_native_QWebSocketProtocol_CloseCode_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), closeCode.value(), reason);
    }
    
    private native void close_native_QWebSocketProtocol_CloseCode_cref_QString(long __this__nativeId, int closeCode, java.lang.String reason);
    
    /**
     * <p>Returns the code indicating why the socket was closed</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#closeCode">QWebSocket::closeCode()const</a></p>
     */
    @QtUninvokable
    public final io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode closeCode(){
        return io.qt.websockets.QWebSocketProtocol.CloseCode.resolve(closeCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int closeCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the reason why the socket was closed</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#closeReason">QWebSocket::closeReason()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String closeReason(){
        return closeReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String closeReason_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#continueInterruptedHandshake">QWebSocket::continueInterruptedHandshake()</a></p>
     */
    @QtUninvokable
    public final void continueInterruptedHandshake(){
        continueInterruptedHandshake_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void continueInterruptedHandshake_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#error">QWebSocket::error()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.QAbstractSocket.@NonNull SocketError error(){
        return io.qt.network.QAbstractSocket.SocketError.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#errorString">QWebSocket::errorString()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#flush">QWebSocket::flush()</a></p>
     */
    @QtUninvokable
    public final boolean flush(){
        return flush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean flush_native(long __this__nativeId);
    
    /**
     * <p>Returns the handshake options that were used to open this socket</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#handshakeOptions">QWebSocket::handshakeOptions()const</a></p>
     */
    @QtUninvokable
    public final io.qt.websockets.@NonNull QWebSocketHandshakeOptions handshakeOptions(){
        return handshakeOptions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.websockets.QWebSocketHandshakeOptions handshakeOptions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#ignoreSslErrors">QWebSocket::ignoreSslErrors()</a></p>
     */
    public final void ignoreSslErrors(){
        ignoreSslErrors_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void ignoreSslErrors_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#ignoreSslErrors-1">QWebSocket::ignoreSslErrors(QList&lt;QSslError&gt;)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void ignoreSslErrors(java.util.@NonNull Collection<? extends io.qt.network.@NonNull QSslError> errors){
        ignoreSslErrors_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), errors);
    }
    
    @QtUninvokable
    private native void ignoreSslErrors_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.network.QSslError> errors);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#isValid">QWebSocket::isValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#localAddress">QWebSocket::localAddress()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QHostAddress localAddress(){
        return localAddress_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QHostAddress localAddress_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#localPort">QWebSocket::localPort()const</a></p>
     */
    @QtUninvokable
    public final short localPort(){
        return localPort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native short localPort_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#maskGenerator">QWebSocket::maskGenerator()const</a></p>
     */
    @QtUninvokable
    public final io.qt.websockets.@Nullable QMaskGenerator maskGenerator(){
        return maskGenerator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.websockets.QMaskGenerator maskGenerator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#maxAllowedIncomingFrameSize">QWebSocket::maxAllowedIncomingFrameSize()const</a></p>
     */
    @QtUninvokable
    public final long maxAllowedIncomingFrameSize(){
        return maxAllowedIncomingFrameSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long maxAllowedIncomingFrameSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#maxAllowedIncomingMessageSize">QWebSocket::maxAllowedIncomingMessageSize()const</a></p>
     */
    @QtUninvokable
    public final long maxAllowedIncomingMessageSize(){
        return maxAllowedIncomingMessageSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long maxAllowedIncomingMessageSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Opens a WebSocket connection using the given request</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#open-1">QWebSocket::open(QNetworkRequest)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final void open(io.qt.network.@NonNull QNetworkRequest request){
        open_native_cref_QNetworkRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    private native void open_native_cref_QNetworkRequest(long __this__nativeId, long request);
    
    /**
     * <p>Opens a WebSocket connection using the given request and options</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#open-3">QWebSocket::open(QNetworkRequest,QWebSocketHandshakeOptions)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final void open(io.qt.network.@NonNull QNetworkRequest request, io.qt.websockets.@NonNull QWebSocketHandshakeOptions options){
        open_native_cref_QNetworkRequest_cref_QWebSocketHandshakeOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request), QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    private native void open_native_cref_QNetworkRequest_cref_QWebSocketHandshakeOptions(long __this__nativeId, long request, long options);
    
    /**
     * <p>Opens a WebSocket connection using the given url</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#open">QWebSocket::open(QUrl)</a></p>
     */
    public final void open(io.qt.core.@NonNull QUrl url){
        open_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native void open_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>Opens a WebSocket connection using the given url and options</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#open-2">QWebSocket::open(QUrl,QWebSocketHandshakeOptions)</a></p>
     */
    public final void open(io.qt.core.@NonNull QUrl url, io.qt.websockets.@NonNull QWebSocketHandshakeOptions options){
        open_native_cref_QUrl_cref_QWebSocketHandshakeOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(options));
    }
    
    private native void open_native_cref_QUrl_cref_QWebSocketHandshakeOptions(long __this__nativeId, long url, long options);
    
    /**
     * <p>Returns the current origin</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#origin">QWebSocket::origin()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#outgoingFrameSize">QWebSocket::outgoingFrameSize()const</a></p>
     */
    @QtUninvokable
    public final long outgoingFrameSize(){
        return outgoingFrameSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long outgoingFrameSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#pauseMode">QWebSocket::pauseMode()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.QAbstractSocket.@NonNull PauseModes pauseMode(){
        return new io.qt.network.QAbstractSocket.PauseModes(pauseMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pauseMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#peerAddress">QWebSocket::peerAddress()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QHostAddress peerAddress(){
        return peerAddress_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QHostAddress peerAddress_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#peerName">QWebSocket::peerName()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String peerName(){
        return peerName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String peerName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#peerPort">QWebSocket::peerPort()const</a></p>
     */
    @QtUninvokable
    public final short peerPort(){
        return peerPort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native short peerPort_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #ping(io.qt.core.QByteArray)}
     *  with <code>payload = new io.qt.core.QByteArray()</code>.</p>
     */
    public final void ping() {
        ping(new io.qt.core.QByteArray());
    }
    
    /**
     * <p>Pings the server to indicate that the connection is still alive. Additional payload can be sent along the ping message</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#ping">QWebSocket::ping(QByteArray)</a></p>
     */
    public final void ping(io.qt.core.@NonNull QByteArray payload){
        ping_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(payload));
    }
    
    private native void ping_native_cref_QByteArray(long __this__nativeId, long payload);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#proxy">QWebSocket::proxy()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QNetworkProxy proxy(){
        return proxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkProxy proxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#readBufferSize">QWebSocket::readBufferSize()const</a></p>
     */
    @QtUninvokable
    public final long readBufferSize(){
        return readBufferSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long readBufferSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the request that was or will be used to open this socket</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#request">QWebSocket::request()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QNetworkRequest request(){
        return request_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkRequest request_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the url the socket is connected to or will connect to</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#requestUrl">QWebSocket::requestUrl()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the name of the resource currently accessed</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#resourceName">QWebSocket::resourceName()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String resourceName(){
        return resourceName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String resourceName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#resume">QWebSocket::resume()</a></p>
     */
    @QtUninvokable
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>Sends the given data over the socket as a binary message and returns the number of bytes actually sent</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#sendBinaryMessage">QWebSocket::sendBinaryMessage(QByteArray)</a></p>
     */
    @QtUninvokable
    public final long sendBinaryMessage(io.qt.core.@NonNull QByteArray data){
        return sendBinaryMessage_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @QtUninvokable
    private native long sendBinaryMessage_native_cref_QByteArray(long __this__nativeId, long data);
    
    /**
     * <p>Sends the given message over the socket as a text message and returns the number of bytes actually sent</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#sendTextMessage">QWebSocket::sendTextMessage(QString)</a></p>
     */
    @QtUninvokable
    public final long sendTextMessage(java.lang.@NonNull String message){
        return sendTextMessage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), message);
    }
    
    @QtUninvokable
    private native long sendTextMessage_native_cref_QString(long __this__nativeId, java.lang.String message);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setMaskGenerator">QWebSocket::setMaskGenerator(const QMaskGenerator*)</a></p>
     */
    @QtUninvokable
    public final void setMaskGenerator(io.qt.websockets.@Nullable QMaskGenerator maskGenerator){
        setMaskGenerator_native_const_QMaskGenerator_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(maskGenerator));
        __rcMaskGenerator = maskGenerator;
    }
    
    @QtUninvokable
    private native void setMaskGenerator_native_const_QMaskGenerator_ptr(long __this__nativeId, long maskGenerator);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setMaxAllowedIncomingFrameSize">QWebSocket::setMaxAllowedIncomingFrameSize(quint64)</a></p>
     */
    @QtUninvokable
    public final void setMaxAllowedIncomingFrameSize(long maxAllowedIncomingFrameSize){
        setMaxAllowedIncomingFrameSize_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), maxAllowedIncomingFrameSize);
    }
    
    @QtUninvokable
    private native void setMaxAllowedIncomingFrameSize_native_quint64(long __this__nativeId, long maxAllowedIncomingFrameSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setMaxAllowedIncomingMessageSize">QWebSocket::setMaxAllowedIncomingMessageSize(quint64)</a></p>
     */
    @QtUninvokable
    public final void setMaxAllowedIncomingMessageSize(long maxAllowedIncomingMessageSize){
        setMaxAllowedIncomingMessageSize_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), maxAllowedIncomingMessageSize);
    }
    
    @QtUninvokable
    private native void setMaxAllowedIncomingMessageSize_native_quint64(long __this__nativeId, long maxAllowedIncomingMessageSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setOutgoingFrameSize">QWebSocket::setOutgoingFrameSize(quint64)</a></p>
     */
    @QtUninvokable
    public final void setOutgoingFrameSize(long outgoingFrameSize){
        setOutgoingFrameSize_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), outgoingFrameSize);
    }
    
    @QtUninvokable
    private native void setOutgoingFrameSize_native_quint64(long __this__nativeId, long outgoingFrameSize);
    
    /**
     * <p>Overloaded function for {@link #setPauseMode(io.qt.network.QAbstractSocket.PauseModes)}.</p>
     */
    @QtUninvokable
    public final void setPauseMode(io.qt.network.QAbstractSocket.@NonNull PauseMode @NonNull... pauseMode){
        setPauseMode(new io.qt.network.QAbstractSocket.PauseModes(pauseMode));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setPauseMode">QWebSocket::setPauseMode(QAbstractSocket::PauseModes)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setPauseMode(io.qt.network.QAbstractSocket.@NonNull PauseModes pauseMode){
        setPauseMode_native_QAbstractSocket_PauseModes(QtJambi_LibraryUtilities.internal.nativeId(this), pauseMode.value());
    }
    
    @QtUninvokable
    private native void setPauseMode_native_QAbstractSocket_PauseModes(long __this__nativeId, int pauseMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setProxy">QWebSocket::setProxy(QNetworkProxy)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setProxy(io.qt.network.@NonNull QNetworkProxy networkProxy){
        setProxy_native_cref_QNetworkProxy(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkProxy));
    }
    
    @QtUninvokable
    private native void setProxy_native_cref_QNetworkProxy(long __this__nativeId, long networkProxy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setReadBufferSize">QWebSocket::setReadBufferSize(qint64)</a></p>
     */
    @QtUninvokable
    public final void setReadBufferSize(long size){
        setReadBufferSize_native_qint64(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void setReadBufferSize_native_qint64(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#setSslConfiguration">QWebSocket::setSslConfiguration(QSslConfiguration)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setSslConfiguration(io.qt.network.@NonNull QSslConfiguration sslConfiguration){
        setSslConfiguration_native_cref_QSslConfiguration(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sslConfiguration));
    }
    
    @QtUninvokable
    private native void setSslConfiguration_native_cref_QSslConfiguration(long __this__nativeId, long sslConfiguration);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#sslConfiguration">QWebSocket::sslConfiguration()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QSslConfiguration sslConfiguration(){
        return sslConfiguration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QSslConfiguration sslConfiguration_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the current state of the socket</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#state">QWebSocket::state()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.QAbstractSocket.@NonNull SocketState state(){
        return io.qt.network.QAbstractSocket.SocketState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the used WebSocket protocol</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#subprotocol">QWebSocket::subprotocol()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String subprotocol(){
        return subprotocol_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String subprotocol_native_constfct(long __this__nativeId);
    
    /**
     * <p>Returns the version the socket is currently using</p>
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#version">QWebSocket::version()const</a></p>
     */
    @QtUninvokable
    public final io.qt.websockets.QWebSocketProtocol.@NonNull Version version(){
        return io.qt.websockets.QWebSocketProtocol.Version.resolve(version_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int version_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#maxIncomingFrameSize">QWebSocket::maxIncomingFrameSize()</a></p>
     */
    public native static long maxIncomingFrameSize();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#maxIncomingMessageSize">QWebSocket::maxIncomingMessageSize()</a></p>
     */
    public native static long maxIncomingMessageSize();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebsocket.html#maxOutgoingFrameSize">QWebSocket::maxOutgoingFrameSize()</a></p>
     */
    public native static long maxOutgoingFrameSize();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebSocket(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QWebSocket(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWebSocket instance, QDeclarativeConstructor constructor);
    
}
