package io.qt.websockets;


/**
 * <p>Abstract base for custom 32-bit mask generators</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qmaskgenerator.html">QMaskGenerator</a></p>
 */
public abstract class QMaskGenerator extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QMaskGenerator {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public int nextMask(){
            return nextMask_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int nextMask_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean seed(){
            return seed_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native boolean seed_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QMaskGenerator(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMaskGenerator() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmaskgenerator.html#QMaskGenerator-1">QMaskGenerator::QMaskGenerator(QObject*)</a></p>
     */
    public QMaskGenerator(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMaskGenerator instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmaskgenerator.html#nextMask">QMaskGenerator::nextMask()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract int nextMask();
    
    @io.qt.QtUninvokable
    private native int nextMask_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qmaskgenerator.html#seed">QMaskGenerator::seed()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean seed();
    
    @io.qt.QtUninvokable
    private native boolean seed_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMaskGenerator(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QMaskGenerator(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QMaskGenerator instance, QDeclarativeConstructor constructor);
    
}
