package io.qt.websockets;

import io.qt.*;


/**
 * <p>Implements a WebSocket-based server</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qwebsocketserver.html">QWebSocketServer</a></p>
 */
public class QWebSocketServer extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebSocketServer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#SslMode-enum">QWebSocketServer::SslMode</a></p>
     */
    public enum SslMode implements QtEnumerator {
        SecureMode(0),
        NonSecureMode(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SslMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SslMode resolve(int value) {
            switch (value) {
            case 0: return SecureMode;
            case 1: return NonSecureMode;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#acceptError">QWebSocketServer::acceptError(QAbstractSocket::SocketError)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.QAbstractSocket.@NonNull SocketError> acceptError = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#closed">QWebSocketServer::closed()</a></p>
     */
    public final @NonNull Signal0 closed = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#newConnection">QWebSocketServer::newConnection()</a></p>
     */
    public final @NonNull Signal0 newConnection = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#originAuthenticationRequired">QWebSocketServer::originAuthenticationRequired(QWebSocketCorsAuthenticator*)</a></p>
     */
    public final @NonNull Signal1<io.qt.websockets.@Nullable QWebSocketCorsAuthenticator> originAuthenticationRequired = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#peerVerifyError">QWebSocketServer::peerVerifyError(QSslError)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QSslError> peerVerifyError = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#preSharedKeyAuthenticationRequired">QWebSocketServer::preSharedKeyAuthenticationRequired(QSslPreSharedKeyAuthenticator*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@Nullable QSslPreSharedKeyAuthenticator> preSharedKeyAuthenticationRequired = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#serverError">QWebSocketServer::serverError(QWebSocketProtocol::CloseCode)</a></p>
     */
    public final @NonNull Signal1<io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode> serverError = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#sslErrors">QWebSocketServer::sslErrors(QList&lt;QSslError&gt;)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.network.@NonNull QSslError>> sslErrors = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(java.lang.String, io.qt.websockets.QWebSocketServer.SslMode, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebSocketServer(java.lang.@NonNull String serverName, io.qt.websockets.QWebSocketServer.@NonNull SslMode secureMode) {
        this(serverName, secureMode, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#QWebSocketServer-1">QWebSocketServer::QWebSocketServer(QString,QWebSocketServer::SslMode,QObject*)</a></p>
     */
    public QWebSocketServer(java.lang.@NonNull String serverName, io.qt.websockets.QWebSocketServer.@NonNull SslMode secureMode, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, serverName, secureMode, parent);
    }
    
    private native static void initialize_native(QWebSocketServer instance, java.lang.String serverName, io.qt.websockets.QWebSocketServer.SslMode secureMode, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#close">QWebSocketServer::close()</a></p>
     */
    @QtUninvokable
    public final void close(){
        close_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void close_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#error">QWebSocketServer::error()const</a></p>
     */
    @QtUninvokable
    public final io.qt.websockets.QWebSocketProtocol.@NonNull CloseCode error(){
        return io.qt.websockets.QWebSocketProtocol.CloseCode.resolve(error_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#errorString">QWebSocketServer::errorString()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#handleConnection">QWebSocketServer::handleConnection(QTcpSocket*)const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void handleConnection(io.qt.network.@Nullable QTcpSocket socket){
        handleConnection_native_QTcpSocket_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(socket));
    }
    
    @QtUninvokable
    private native void handleConnection_native_QTcpSocket_ptr_constfct(long __this__nativeId, long socket);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#handshakeTimeoutMS">QWebSocketServer::handshakeTimeoutMS()const</a></p>
     */
    @QtUninvokable
    public final int handshakeTimeoutMS(){
        return handshakeTimeoutMS_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int handshakeTimeoutMS_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#hasPendingConnections">QWebSocketServer::hasPendingConnections()const</a></p>
     */
    @QtUninvokable
    public final boolean hasPendingConnections(){
        return hasPendingConnections_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasPendingConnections_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#isListening">QWebSocketServer::isListening()const</a></p>
     */
    @QtUninvokable
    public final boolean isListening(){
        return isListening_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isListening_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #listen(io.qt.network.QHostAddress, short)}
     *  with <code>port = 0</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final boolean listen(io.qt.network.@NonNull QHostAddress address) {
        return listen(address, (short)0);
    }
    
    /**
     * <p>Overloaded function for {@link #listen(io.qt.network.QHostAddress, short)}</p>
     * <p>with: </p><ul>
     * <li><code>address = new io.qt.network.QHostAddress(io.qt.network.QHostAddress.SpecialAddress.Any)</code></li>
     * <li><code>port = 0</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean listen() {
        return listen(new io.qt.network.QHostAddress(io.qt.network.QHostAddress.SpecialAddress.Any), (short)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#listen">QWebSocketServer::listen(QHostAddress,quint16)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final boolean listen(io.qt.network.@NonNull QHostAddress address, short port){
        return listen_native_cref_QHostAddress_quint16(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(address), port);
    }
    
    @QtUninvokable
    private native boolean listen_native_cref_QHostAddress_quint16(long __this__nativeId, long address, short port);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#maxPendingConnections">QWebSocketServer::maxPendingConnections()const</a></p>
     */
    @QtUninvokable
    public final int maxPendingConnections(){
        return maxPendingConnections_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxPendingConnections_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#nativeDescriptor">QWebSocketServer::nativeDescriptor()const</a></p>
     */
    @QtUninvokable
    public final long nativeDescriptor(){
        return nativeDescriptor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long nativeDescriptor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#pauseAccepting">QWebSocketServer::pauseAccepting()</a></p>
     */
    @QtUninvokable
    public final void pauseAccepting(){
        pauseAccepting_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void pauseAccepting_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#proxy">QWebSocketServer::proxy()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QNetworkProxy proxy(){
        return proxy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkProxy proxy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#resumeAccepting">QWebSocketServer::resumeAccepting()</a></p>
     */
    @QtUninvokable
    public final void resumeAccepting(){
        resumeAccepting_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resumeAccepting_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#secureMode">QWebSocketServer::secureMode()const</a></p>
     */
    @QtUninvokable
    public final io.qt.websockets.QWebSocketServer.@NonNull SslMode secureMode(){
        return io.qt.websockets.QWebSocketServer.SslMode.resolve(secureMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int secureMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#serverAddress">QWebSocketServer::serverAddress()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QHostAddress serverAddress(){
        return serverAddress_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QHostAddress serverAddress_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#serverName">QWebSocketServer::serverName()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String serverName(){
        return serverName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String serverName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#serverPort">QWebSocketServer::serverPort()const</a></p>
     */
    @QtUninvokable
    public final short serverPort(){
        return serverPort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native short serverPort_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#serverUrl">QWebSocketServer::serverUrl()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl serverUrl(){
        return serverUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl serverUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#setHandshakeTimeout-1">QWebSocketServer::setHandshakeTimeout(int)</a></p>
     */
    @QtUninvokable
    public final void setHandshakeTimeout(int msec){
        setHandshakeTimeout_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), msec);
    }
    
    @QtUninvokable
    private native void setHandshakeTimeout_native_int(long __this__nativeId, int msec);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#setMaxPendingConnections">QWebSocketServer::setMaxPendingConnections(int)</a></p>
     */
    @QtUninvokable
    public final void setMaxPendingConnections(int numConnections){
        setMaxPendingConnections_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), numConnections);
    }
    
    @QtUninvokable
    private native void setMaxPendingConnections_native_int(long __this__nativeId, int numConnections);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#setNativeDescriptor">QWebSocketServer::setNativeDescriptor(qintptr)</a></p>
     */
    @QtUninvokable
    public final boolean setNativeDescriptor(long descriptor){
        return setNativeDescriptor_native_qintptr(QtJambi_LibraryUtilities.internal.nativeId(this), descriptor);
    }
    
    @QtUninvokable
    private native boolean setNativeDescriptor_native_qintptr(long __this__nativeId, long descriptor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#setProxy">QWebSocketServer::setProxy(QNetworkProxy)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setProxy(io.qt.network.@NonNull QNetworkProxy networkProxy){
        setProxy_native_cref_QNetworkProxy(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkProxy));
    }
    
    @QtUninvokable
    private native void setProxy_native_cref_QNetworkProxy(long __this__nativeId, long networkProxy);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#setServerName">QWebSocketServer::setServerName(QString)</a></p>
     */
    @QtUninvokable
    public final void setServerName(java.lang.@NonNull String serverName){
        setServerName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), serverName);
    }
    
    @QtUninvokable
    private native void setServerName_native_cref_QString(long __this__nativeId, java.lang.String serverName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver-obsolete.html#setSocketDescriptor">QWebSocketServer::setSocketDescriptor(int)</a></p>
     * 
     * @deprecated Use {@link io.qt.websockets.QWebSocketServer#setNativeDescriptor(long)} instead
     */
    @Deprecated
    @QtUninvokable
    public final boolean setSocketDescriptor(int socketDescriptor){
        return setSocketDescriptor_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), socketDescriptor);
    }
    
    @Deprecated
    @QtUninvokable
    private native boolean setSocketDescriptor_native_int(long __this__nativeId, int socketDescriptor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#setSslConfiguration">QWebSocketServer::setSslConfiguration(QSslConfiguration)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setSslConfiguration(io.qt.network.@NonNull QSslConfiguration sslConfiguration){
        setSslConfiguration_native_cref_QSslConfiguration(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sslConfiguration));
    }
    
    @QtUninvokable
    private native void setSslConfiguration_native_cref_QSslConfiguration(long __this__nativeId, long sslConfiguration);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver-obsolete.html#socketDescriptor">QWebSocketServer::socketDescriptor()const</a></p>
     * 
     * @deprecated Use {@link io.qt.websockets.QWebSocketServer#nativeDescriptor()} instead
     */
    @Deprecated
    @QtUninvokable
    public final int socketDescriptor(){
        return socketDescriptor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @QtUninvokable
    private native int socketDescriptor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#sslConfiguration">QWebSocketServer::sslConfiguration()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QSslConfiguration sslConfiguration(){
        return sslConfiguration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QSslConfiguration sslConfiguration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#supportedVersions">QWebSocketServer::supportedVersions()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.websockets.QWebSocketProtocol.@NonNull Version> supportedVersions(){
        return supportedVersions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.websockets.QWebSocketProtocol.Version> supportedVersions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebsocketserver.html#nextPendingConnection">QWebSocketServer::nextPendingConnection()</a></p>
     */
    @QtUninvokable
    public io.qt.websockets.@Nullable QWebSocket nextPendingConnection(){
        return nextPendingConnection_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.websockets.QWebSocket nextPendingConnection_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebSocketServer(QPrivateConstructor p) { super(p); } 
    
}
