package io.qt.websockets;

import io.qt.*;


/**
 * <p>Abstract base for custom 32-bit mask generators</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qmaskgenerator.html">QMaskGenerator</a></p>
 */
public abstract class QMaskGenerator extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @NativeAccess
    private static final class ConcreteWrapper extends QMaskGenerator {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public int nextMask(){
            return nextMask_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native int nextMask_native(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public boolean seed(){
            return seed_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native boolean seed_native(long __this__nativeId);
        
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QMaskGenerator() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmaskgenerator.html#QMaskGenerator-1">QMaskGenerator::QMaskGenerator(QObject*)</a></p>
     */
    public QMaskGenerator(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMaskGenerator instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmaskgenerator.html#nextMask">QMaskGenerator::nextMask()</a></p>
     */
    @QtUninvokable
    public abstract int nextMask();
    
    @QtUninvokable
    private native int nextMask_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qmaskgenerator.html#seed">QMaskGenerator::seed()</a></p>
     */
    @QtUninvokable
    public abstract boolean seed();
    
    @QtUninvokable
    private native boolean seed_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QMaskGenerator(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QMaskGenerator(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMaskGenerator instance, QDeclarativeConstructor constructor);
    
}
