package io.qt.webengine.widgets;

import io.qt.*;


/**
 * <p>Widget that is used to view and edit web documents</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebengineview.html">QWebEngineView</a></p>
 */
public class QWebEngineView extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineView.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#iconChanged">QWebEngineView::iconChanged(QIcon)</a></p>
     */
    @QtPropertyNotify(name="icon")
    public final @NonNull Signal1<io.qt.gui.@NonNull QIcon> iconChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#iconUrlChanged">QWebEngineView::iconUrlChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="iconUrl")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> iconUrlChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#loadFinished">QWebEngineView::loadFinished(bool)</a></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> loadFinished = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#loadProgress">QWebEngineView::loadProgress(int)</a></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> loadProgress = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#loadStarted">QWebEngineView::loadStarted()</a></p>
     */
    public final @NonNull Signal0 loadStarted = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#pdfPrintingFinished">QWebEngineView::pdfPrintingFinished(QString,bool)</a></p>
     */
    public final @NonNull Signal2<java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Boolean> pdfPrintingFinished = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#printFinished">QWebEngineView::printFinished(bool)</a></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> printFinished = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#printRequested">QWebEngineView::printRequested()</a></p>
     */
    public final @NonNull Signal0 printRequested = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#renderProcessTerminated">QWebEngineView::renderProcessTerminated(QWebEnginePage::RenderProcessTerminationStatus,int)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal2<io.qt.webengine.core.QWebEnginePage.@NonNull RenderProcessTerminationStatus, java.lang.@QtPrimitiveType@NonNull Integer> renderProcessTerminated = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#selectionChanged">QWebEngineView::selectionChanged()</a></p>
     */
    public final @NonNull Signal0 selectionChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#titleChanged">QWebEngineView::titleChanged(QString)</a></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> titleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#urlChanged">QWebEngineView::urlChanged(QUrl)</a></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> urlChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.webengine.core.QWebEnginePage, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QWebEngineView(io.qt.webengine.core.@Nullable QWebEnginePage page) {
        this(page, (io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#QWebEngineView-2">QWebEngineView::QWebEngineView(QWebEnginePage*,QWidget*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QWebEngineView(io.qt.webengine.core.@Nullable QWebEnginePage page, io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, page, parent);
    }
    
    private native static void initialize_native(QWebEngineView instance, io.qt.webengine.core.QWebEnginePage page, io.qt.widgets.QWidget parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.webengine.core.QWebEngineProfile, io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QWebEngineView(io.qt.webengine.core.@Nullable QWebEngineProfile profile) {
        this(profile, (io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#QWebEngineView-1">QWebEngineView::QWebEngineView(QWebEngineProfile*,QWidget*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QWebEngineView(io.qt.webengine.core.@Nullable QWebEngineProfile profile, io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, profile, parent);
    }
    
    private native static void initialize_native(QWebEngineView instance, io.qt.webengine.core.QWebEngineProfile profile, io.qt.widgets.QWidget parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEngineView() {
        this((io.qt.widgets.QWidget)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#QWebEngineView">QWebEngineView::QWebEngineView(QWidget*)</a></p>
     */
    public QWebEngineView(io.qt.widgets.@Nullable QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWebEngineView instance, io.qt.widgets.QWidget parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#back">QWebEngineView::back()</a></p>
     */
    public final void back(){
        back_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void back_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#createStandardContextMenu">QWebEngineView::createStandardContextMenu()</a></p>
     */
    @QtUninvokable
    public final io.qt.widgets.@Nullable QMenu createStandardContextMenu(){
        return createStandardContextMenu_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.widgets.QMenu createStandardContextMenu_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.core.QWebEnginePage.FindFlags, java.util.function.@Nullable Consumer)}
     *  with <code>resultCallback = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString, io.qt.webengine.core.QWebEnginePage.@NonNull FindFlags options) {
        findText(subString, options, (java.util.function.@Nullable Consumer<io.qt.webengine.core.@NonNull QWebEngineFindTextResult>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.core.QWebEnginePage.FindFlags, java.util.function.@Nullable Consumer)}</p>
     * <p>with: </p><ul>
     * <li><code>options = new io.qt.webengine.core.QWebEnginePage.FindFlags(0)</code></li>
     * <li><code>resultCallback = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString) {
        findText(subString, new io.qt.webengine.core.QWebEnginePage.FindFlags(0), (java.util.function.@Nullable Consumer<io.qt.webengine.core.@NonNull QWebEngineFindTextResult>)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#findText">QWebEngineView::findText(const QString&amp;,QWebEnginePage::FindFlags,const std::function&lt;void(const QWebEngineFindTextResult&amp;)&gt;&amp;)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString, io.qt.webengine.core.QWebEnginePage.@NonNull FindFlags options, java.util.function.@Nullable Consumer<io.qt.webengine.core.@NonNull QWebEngineFindTextResult> resultCallback){
        findText_native_cref_QString_QWebEnginePage_FindFlags_cref_QWebEngineView_ResultConsumer(QtJambi_LibraryUtilities.internal.nativeId(this), subString, options.value(), resultCallback);
    }
    
    @QtUninvokable
    private native void findText_native_cref_QString_QWebEnginePage_FindFlags_cref_QWebEngineView_ResultConsumer(long __this__nativeId, java.lang.String subString, int options, java.util.function.@Nullable Consumer<io.qt.webengine.core.@NonNull QWebEngineFindTextResult> resultCallback);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#forward">QWebEngineView::forward()</a></p>
     */
    public final void forward(){
        forward_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void forward_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #hasSelection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getHasSelection() {
        return hasSelection();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#hasSelection-prop">QWebEngineView::hasSelection()const</a></p>
     */
    @QtPropertyReader(name="hasSelection")
    @QtUninvokable
    public final boolean hasSelection(){
        return hasSelection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasSelection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#history">QWebEngineView::history()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistory history(){
        return history_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistory history_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #icon()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon getIcon() {
        return icon();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#icon-prop">QWebEngineView::icon()const</a></p>
     */
    @QtPropertyReader(name="icon")
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon icon(){
        return icon_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #iconUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getIconUrl() {
        return iconUrl();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#iconUrl-prop">QWebEngineView::iconUrl()const</a></p>
     */
    @QtPropertyReader(name="iconUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl iconUrl(){
        return iconUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl iconUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#lastContextMenuRequest">QWebEngineView::lastContextMenuRequest()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineContextMenuRequest lastContextMenuRequest(){
        return lastContextMenuRequest_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineContextMenuRequest lastContextMenuRequest_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#load">QWebEngineView::load(QUrl)</a></p>
     */
    @QtUninvokable
    public final void load(io.qt.core.@NonNull QUrl url){
        load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void load_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#load-1">QWebEngineView::load(QWebEngineHttpRequest)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void load(io.qt.webengine.core.@NonNull QWebEngineHttpRequest request){
        load_native_cref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    @QtUninvokable
    private native void load_native_cref_QWebEngineHttpRequest(long __this__nativeId, long request);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#page">QWebEngineView::page()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEnginePage page(){
        return page_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEnginePage page_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#pageAction">QWebEngineView::pageAction(QWebEnginePage::WebAction)const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.gui.@Nullable QAction pageAction(io.qt.webengine.core.QWebEnginePage.@NonNull WebAction action){
        return pageAction_native_QWebEnginePage_WebAction_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), action.value());
    }
    
    @QtUninvokable
    private native io.qt.gui.QAction pageAction_native_QWebEnginePage_WebAction_constfct(long __this__nativeId, int action);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#print">QWebEngineView::print(QPrinter*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void print(io.qt.printsupport.@Nullable QPrinter printer){
        print_native_QPrinter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(printer));
    }
    
    @QtUninvokable
    private native void print_native_QPrinter_ptr(long __this__nativeId, long printer);
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.lang.String, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}
     *  with <code>ranges = new io.qt.gui.QPageRanges()</code>.</p>
     */
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath, io.qt.gui.@NonNull QPageLayout layout) {
        printToPdf(filePath, layout, new io.qt.gui.QPageRanges());
    }
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.lang.String, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}</p>
     * <p>with: </p><ul>
     * <li><code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code></li>
     * <li><code>ranges = new io.qt.gui.QPageRanges()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath) {
        printToPdf(filePath, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()), new io.qt.gui.QPageRanges());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#printToPdf">QWebEngineView::printToPdf(QString,QPageLayout,QPageRanges)</a></p>
     */
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath, io.qt.gui.@NonNull QPageLayout layout, io.qt.gui.@NonNull QPageRanges ranges){
        printToPdf_native_cref_QString_cref_QPageLayout_cref_QPageRanges(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, QtJambi_LibraryUtilities.internal.checkedNativeId(layout), QtJambi_LibraryUtilities.internal.checkedNativeId(ranges));
    }
    
    @QtUninvokable
    private native void printToPdf_native_cref_QString_cref_QPageLayout_cref_QPageRanges(long __this__nativeId, java.lang.String filePath, long layout, long ranges);
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.util.function.@Nullable Consumer, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}
     *  with <code>ranges = new io.qt.gui.QPageRanges()</code>.</p>
     */
    @QtUninvokable
    public final void printToPdf(java.util.function.@Nullable Consumer<io.qt.core.@NonNull QByteArray> resultCallback, io.qt.gui.@NonNull QPageLayout layout) {
        printToPdf(resultCallback, layout, new io.qt.gui.QPageRanges());
    }
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.util.function.@Nullable Consumer, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}</p>
     * <p>with: </p><ul>
     * <li><code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code></li>
     * <li><code>ranges = new io.qt.gui.QPageRanges()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void printToPdf(java.util.function.@Nullable Consumer<io.qt.core.@NonNull QByteArray> resultCallback) {
        printToPdf(resultCallback, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()), new io.qt.gui.QPageRanges());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#printToPdf-1">QWebEngineView::printToPdf(const std::function&lt;void(const QByteArray&amp;)&gt;&amp;,const QPageLayout&amp;,const QPageRanges&amp;)</a></p>
     */
    @QtUninvokable
    public final void printToPdf(java.util.function.@Nullable Consumer<io.qt.core.@NonNull QByteArray> resultCallback, io.qt.gui.@NonNull QPageLayout layout, io.qt.gui.@NonNull QPageRanges ranges){
        printToPdf_native_cref_QWebEngineView_DataConsumer_cref_QPageLayout_cref_QPageRanges(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback, QtJambi_LibraryUtilities.internal.checkedNativeId(layout), QtJambi_LibraryUtilities.internal.checkedNativeId(ranges));
    }
    
    @QtUninvokable
    private native void printToPdf_native_cref_QWebEngineView_DataConsumer_cref_QPageLayout_cref_QPageRanges(long __this__nativeId, java.util.function.@Nullable Consumer<io.qt.core.@NonNull QByteArray> resultCallback, long layout, long ranges);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#reload">QWebEngineView::reload()</a></p>
     */
    public final void reload(){
        reload_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reload_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSelectedText() {
        return selectedText();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#selectedText-prop">QWebEngineView::selectedText()const</a></p>
     */
    @QtPropertyReader(name="selectedText")
    @QtUninvokable
    public final java.lang.@NonNull String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String mimeType) {
        setContent(data, mimeType, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}</p>
     * <p>with: </p><ul>
     * <li><code>mimeType = (String)null</code></li>
     * <li><code>baseUrl = new io.qt.core.QUrl()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data) {
        setContent(data, (String)null, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#setContent">QWebEngineView::setContent(QByteArray,QString,QUrl)</a></p>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String mimeType, io.qt.core.@NonNull QUrl baseUrl){
        setContent_native_cref_QByteArray_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), mimeType, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @QtUninvokable
    private native void setContent_native_cref_QByteArray_cref_QString_cref_QUrl(long __this__nativeId, long data, java.lang.String mimeType, long baseUrl);
    
    /**
     * <p>Overloaded function for {@link #setHtml(java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setHtml(java.lang.@NonNull String html) {
        setHtml(html, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#setHtml">QWebEngineView::setHtml(QString,QUrl)</a></p>
     */
    @QtUninvokable
    public final void setHtml(java.lang.@NonNull String html, io.qt.core.@NonNull QUrl baseUrl){
        setHtml_native_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), html, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @QtUninvokable
    private native void setHtml_native_cref_QString_cref_QUrl(long __this__nativeId, java.lang.String html, long baseUrl);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#setPage">QWebEngineView::setPage(QWebEnginePage*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setPage(io.qt.webengine.core.@Nullable QWebEnginePage page){
        setPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
    }
    
    @QtUninvokable
    private native void setPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#url-prop">QWebEngineView::setUrl(QUrl)</a></p>
     */
    @QtPropertyWriter(name="url")
    @QtUninvokable
    public final void setUrl(io.qt.core.@NonNull QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#zoomFactor-prop">QWebEngineView::setZoomFactor(qreal)</a></p>
     */
    @QtPropertyWriter(name="zoomFactor")
    @QtUninvokable
    public final void setZoomFactor(double factor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setZoomFactor_native_qreal(long __this__nativeId, double factor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#settings">QWebEngineView::settings()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineSettings settings(){
        return settings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineSettings settings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#stop">QWebEngineView::stop()</a></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #title()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTitle() {
        return title();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#title-prop">QWebEngineView::title()const</a></p>
     */
    @QtPropertyReader(name="title")
    @QtUninvokable
    public final java.lang.@NonNull String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #triggerPageAction(io.qt.webengine.core.QWebEnginePage.WebAction, boolean)}
     *  with <code>checked = false</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void triggerPageAction(io.qt.webengine.core.QWebEnginePage.@NonNull WebAction action) {
        triggerPageAction(action, (boolean)false);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#triggerPageAction">QWebEngineView::triggerPageAction(QWebEnginePage::WebAction,bool)</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void triggerPageAction(io.qt.webengine.core.QWebEnginePage.@NonNull WebAction action, boolean checked){
        triggerPageAction_native_QWebEnginePage_WebAction_bool(QtJambi_LibraryUtilities.internal.nativeId(this), action.value(), checked);
    }
    
    @QtUninvokable
    private native void triggerPageAction_native_QWebEnginePage_WebAction_bool(long __this__nativeId, int action, boolean checked);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#url-prop">QWebEngineView::url()const</a></p>
     */
    @QtPropertyReader(name="url")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zoomFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZoomFactor() {
        return zoomFactor();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#zoomFactor-prop">QWebEngineView::zoomFactor()const</a></p>
     */
    @QtPropertyReader(name="zoomFactor")
    @QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#closeEvent">QWidget::closeEvent(QCloseEvent*)</a></p>
     */
    @QtUninvokable
    protected void closeEvent(io.qt.gui.@Nullable QCloseEvent arg__1){
        closeEvent_native_QCloseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void closeEvent_native_QCloseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#contextMenuEvent">QWidget::contextMenuEvent(QContextMenuEvent*)</a></p>
     */
    @QtUninvokable
    protected void contextMenuEvent(io.qt.gui.@Nullable QContextMenuEvent arg__1){
        contextMenuEvent_native_QContextMenuEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void contextMenuEvent_native_QContextMenuEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#createWindow">QWebEngineView::createWindow(QWebEnginePage::WebWindowType)</a></p>
     */
    @QtUninvokable
    protected io.qt.webengine.widgets.@Nullable QWebEngineView createWindow(io.qt.webengine.core.QWebEnginePage.@NonNull WebWindowType type){
        return createWindow_native_QWebEnginePage_WebWindowType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineView createWindow_native_QWebEnginePage_WebWindowType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#dragEnterEvent">QWidget::dragEnterEvent(QDragEnterEvent*)</a></p>
     */
    @QtUninvokable
    protected void dragEnterEvent(io.qt.gui.@Nullable QDragEnterEvent e){
        dragEnterEvent_native_QDragEnterEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void dragEnterEvent_native_QDragEnterEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#dragLeaveEvent">QWidget::dragLeaveEvent(QDragLeaveEvent*)</a></p>
     */
    @QtUninvokable
    protected void dragLeaveEvent(io.qt.gui.@Nullable QDragLeaveEvent e){
        dragLeaveEvent_native_QDragLeaveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void dragLeaveEvent_native_QDragLeaveEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#dragMoveEvent">QWidget::dragMoveEvent(QDragMoveEvent*)</a></p>
     */
    @QtUninvokable
    protected void dragMoveEvent(io.qt.gui.@Nullable QDragMoveEvent e){
        dragMoveEvent_native_QDragMoveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void dragMoveEvent_native_QDragMoveEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#dropEvent">QWidget::dropEvent(QDropEvent*)</a></p>
     */
    @QtUninvokable
    protected void dropEvent(io.qt.gui.@Nullable QDropEvent e){
        dropEvent_native_QDropEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @QtUninvokable
    private native void dropEvent_native_QDropEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#hideEvent">QWidget::hideEvent(QHideEvent*)</a></p>
     */
    @QtUninvokable
    protected void hideEvent(io.qt.gui.@Nullable QHideEvent arg__1){
        hideEvent_native_QHideEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void hideEvent_native_QHideEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#showEvent">QWidget::showEvent(QShowEvent*)</a></p>
     */
    @QtUninvokable
    protected void showEvent(io.qt.gui.@Nullable QShowEvent arg__1){
        showEvent_native_QShowEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void showEvent_native_QShowEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwidget.html#sizeHint-prop">QWidget::sizeHint()const</a></p>
     */
    @QtUninvokable
    public io.qt.core.@NonNull QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineview.html#forPage">QWebEngineView::forPage(const QWebEnginePage*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public static io.qt.webengine.widgets.@Nullable QWebEngineView forPage(io.qt.webengine.core.@Nullable QWebEnginePage page){
        return forPage_native_const_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(page));
    }
    
    private native static io.qt.webengine.widgets.QWebEngineView forPage_native_const_QWebEnginePage_ptr(long page);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineView(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QWebEngineView(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWebEngineView instance, QDeclarativeConstructor constructor);
    
}
