package io.qt.webengine.widgets;


/**
 * <p>Object to view and edit web documents</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qwebenginepage.html">QWebEnginePage</a></p>
 */
public class QWebEnginePage extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcInspectedPage = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcUrlRequestInterceptor = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcDevToolsPage = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcView = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcWebChannel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEnginePage.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::Feature</a></p>
     */
    public enum Feature implements io.qt.QtEnumerator {
        Notifications(0),
        Geolocation(1),
        MediaAudioCapture(2),
        MediaVideoCapture(3),
        MediaAudioVideoCapture(4),
        MouseLock(5),
        DesktopVideoCapture(6),
        DesktopAudioVideoCapture(7);

        private Feature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Feature resolve(int value) {
            switch (value) {
            case 0: return Notifications;
            case 1: return Geolocation;
            case 2: return MediaAudioCapture;
            case 3: return MediaVideoCapture;
            case 4: return MediaAudioVideoCapture;
            case 5: return MouseLock;
            case 6: return DesktopVideoCapture;
            case 7: return DesktopAudioVideoCapture;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::FileSelectionMode</a></p>
     */
    public enum FileSelectionMode implements io.qt.QtEnumerator {
        FileSelectOpen(0),
        FileSelectOpenMultiple(1);

        private FileSelectionMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FileSelectionMode resolve(int value) {
            switch (value) {
            case 0: return FileSelectOpen;
            case 1: return FileSelectOpenMultiple;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FindFlag-enum">QWebEnginePage::FindFlag</a></p>
     * 
     * @see FindFlags
     */
    public enum FindFlag implements io.qt.QtFlagEnumerator {
        FindBackward(1),
        FindCaseSensitively(2);

        private FindFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public FindFlags asFlags() {
            return new FindFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public FindFlags combined(FindFlag e) {
            return new FindFlags(this, e);
        }

        /**
         * Creates a new {@link FindFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static FindFlags flags(FindFlag ... values) {
            return new FindFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FindFlag resolve(int value) {
            switch (value) {
            case 1: return FindBackward;
            case 2: return FindCaseSensitively;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link FindFlag}
     */
    public static final class FindFlags extends io.qt.QFlags<FindFlag> implements Comparable<FindFlags> {
        private static final long serialVersionUID = 0xd99302055005fdf3L;

        /**
         * Creates a new FindFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public FindFlags(FindFlag ... args){
            super(args);
        }

        /**
         * Creates a new FindFlags with given <code>value</code>.
         * @param value
         */
        public FindFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new FindFlags
         */
        @Override
        public final FindFlags combined(FindFlag e){
            return new FindFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final FindFlags setFlag(FindFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final FindFlags setFlag(FindFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this FindFlags.
         * @return array of enum entries
         */
        @Override
        public final FindFlag[] flags(){
            return super.flags(FindFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final FindFlags clone(){
            return new FindFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(FindFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::JavaScriptConsoleMessageLevel</a></p>
     */
    public enum JavaScriptConsoleMessageLevel implements io.qt.QtEnumerator {
        InfoMessageLevel(0),
        WarningMessageLevel(1),
        ErrorMessageLevel(2);

        private JavaScriptConsoleMessageLevel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static JavaScriptConsoleMessageLevel resolve(int value) {
            switch (value) {
            case 0: return InfoMessageLevel;
            case 1: return WarningMessageLevel;
            case 2: return ErrorMessageLevel;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEnginePage::LifecycleState</p>
     */
    public enum LifecycleState implements io.qt.QtEnumerator {
        Active(0),
        Frozen(1),
        Discarded(2);

        private LifecycleState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static LifecycleState resolve(int value) {
            switch (value) {
            case 0: return Active;
            case 1: return Frozen;
            case 2: return Discarded;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationType</a></p>
     */
    public enum NavigationType implements io.qt.QtEnumerator {
        NavigationTypeLinkClicked(0),
        NavigationTypeTyped(1),
        NavigationTypeFormSubmitted(2),
        NavigationTypeBackForward(3),
        NavigationTypeReload(4),
        NavigationTypeOther(5),
        NavigationTypeRedirect(6);

        private NavigationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static NavigationType resolve(int value) {
            switch (value) {
            case 0: return NavigationTypeLinkClicked;
            case 1: return NavigationTypeTyped;
            case 2: return NavigationTypeFormSubmitted;
            case 3: return NavigationTypeBackForward;
            case 4: return NavigationTypeReload;
            case 5: return NavigationTypeOther;
            case 6: return NavigationTypeRedirect;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::PermissionPolicy</a></p>
     */
    public enum PermissionPolicy implements io.qt.QtEnumerator {
        PermissionUnknown(0),
        PermissionGrantedByUser(1),
        PermissionDeniedByUser(2);

        private PermissionPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PermissionPolicy resolve(int value) {
            switch (value) {
            case 0: return PermissionUnknown;
            case 1: return PermissionGrantedByUser;
            case 2: return PermissionDeniedByUser;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEnginePage::RenderProcessTerminationStatus</p>
     */
    public enum RenderProcessTerminationStatus implements io.qt.QtEnumerator {
        NormalTerminationStatus(0),
        AbnormalTerminationStatus(1),
        CrashedTerminationStatus(2),
        KilledTerminationStatus(3);

        private RenderProcessTerminationStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RenderProcessTerminationStatus resolve(int value) {
            switch (value) {
            case 0: return NormalTerminationStatus;
            case 1: return AbnormalTerminationStatus;
            case 2: return CrashedTerminationStatus;
            case 3: return KilledTerminationStatus;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::WebAction</a></p>
     */
    public enum WebAction implements io.qt.QtEnumerator {
        NoWebAction(-1),
        Back(0),
        Forward(1),
        Stop(2),
        Reload(3),
        Cut(4),
        Copy(5),
        Paste(6),
        Undo(7),
        Redo(8),
        SelectAll(9),
        ReloadAndBypassCache(10),
        PasteAndMatchStyle(11),
        OpenLinkInThisWindow(12),
        OpenLinkInNewWindow(13),
        OpenLinkInNewTab(14),
        CopyLinkToClipboard(15),
        DownloadLinkToDisk(16),
        CopyImageToClipboard(17),
        CopyImageUrlToClipboard(18),
        DownloadImageToDisk(19),
        CopyMediaUrlToClipboard(20),
        ToggleMediaControls(21),
        ToggleMediaLoop(22),
        ToggleMediaPlayPause(23),
        ToggleMediaMute(24),
        DownloadMediaToDisk(25),
        InspectElement(26),
        ExitFullScreen(27),
        RequestClose(28),
        Unselect(29),
        SavePage(30),
        OpenLinkInNewBackgroundTab(31),
        ViewSource(32),
        ToggleBold(33),
        ToggleItalic(34),
        ToggleUnderline(35),
        ToggleStrikethrough(36),
        AlignLeft(37),
        AlignCenter(38),
        AlignRight(39),
        AlignJustified(40),
        Indent(41),
        Outdent(42),
        InsertOrderedList(43),
        InsertUnorderedList(44),
        WebActionCount(45);

        private WebAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static WebAction resolve(int value) {
            switch (value) {
            case -1: return NoWebAction;
            case 0: return Back;
            case 1: return Forward;
            case 2: return Stop;
            case 3: return Reload;
            case 4: return Cut;
            case 5: return Copy;
            case 6: return Paste;
            case 7: return Undo;
            case 8: return Redo;
            case 9: return SelectAll;
            case 10: return ReloadAndBypassCache;
            case 11: return PasteAndMatchStyle;
            case 12: return OpenLinkInThisWindow;
            case 13: return OpenLinkInNewWindow;
            case 14: return OpenLinkInNewTab;
            case 15: return CopyLinkToClipboard;
            case 16: return DownloadLinkToDisk;
            case 17: return CopyImageToClipboard;
            case 18: return CopyImageUrlToClipboard;
            case 19: return DownloadImageToDisk;
            case 20: return CopyMediaUrlToClipboard;
            case 21: return ToggleMediaControls;
            case 22: return ToggleMediaLoop;
            case 23: return ToggleMediaPlayPause;
            case 24: return ToggleMediaMute;
            case 25: return DownloadMediaToDisk;
            case 26: return InspectElement;
            case 27: return ExitFullScreen;
            case 28: return RequestClose;
            case 29: return Unselect;
            case 30: return SavePage;
            case 31: return OpenLinkInNewBackgroundTab;
            case 32: return ViewSource;
            case 33: return ToggleBold;
            case 34: return ToggleItalic;
            case 35: return ToggleUnderline;
            case 36: return ToggleStrikethrough;
            case 37: return AlignLeft;
            case 38: return AlignCenter;
            case 39: return AlignRight;
            case 40: return AlignJustified;
            case 41: return Indent;
            case 42: return Outdent;
            case 43: return InsertOrderedList;
            case 44: return InsertUnorderedList;
            case 45: return WebActionCount;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::WebWindowType</a></p>
     */
    public enum WebWindowType implements io.qt.QtEnumerator {
        WebBrowserWindow(0),
        WebBrowserTab(1),
        WebDialog(2),
        WebBrowserBackgroundTab(3);

        private WebWindowType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static WebWindowType resolve(int value) {
            switch (value) {
            case 0: return WebBrowserWindow;
            case 1: return WebBrowserTab;
            case 2: return WebDialog;
            case 3: return WebBrowserBackgroundTab;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#audioMuted-prop">QWebEnginePage::audioMutedChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="audioMuted")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> audioMutedChanged = new Signal1<>();

    @SuppressWarnings({"exports"})
    public final Signal2<io.qt.core.QUrl, io.qt.network.QAuthenticator> authenticationRequired = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#contentsSize-prop">QWebEnginePage::contentsSizeChanged(QSizeF)</a></p>
     */
    @io.qt.QtPropertyNotify(name="contentsSize")
    public final Signal1<io.qt.core.QSizeF> contentsSizeChanged = new Signal1<>();

    public final Signal2<io.qt.core.QUrl, io.qt.webengine.widgets.QWebEnginePage.Feature> featurePermissionRequestCanceled = new Signal2<>();

    public final Signal2<io.qt.core.QUrl, io.qt.webengine.widgets.QWebEnginePage.Feature> featurePermissionRequested = new Signal2<>();

    @SuppressWarnings({"exports"})
    public final Signal1<io.qt.webengine.core.QWebEngineFindTextResult> findTextFinished = new Signal1<>();

    public final Signal1<QWebEngineFullScreenRequest> fullScreenRequested = new Signal1<>();

    public final Signal1<io.qt.core.QRect> geometryChangeRequested = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#icon-prop">QWebEnginePage::iconChanged(QIcon)</a></p>
     */
    @io.qt.QtPropertyNotify(name="icon")
    public final Signal1<io.qt.gui.QIcon> iconChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#iconUrl-prop">QWebEnginePage::iconUrlChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="iconUrl")
    public final Signal1<io.qt.core.QUrl> iconUrlChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::lifecycleStateChanged(QWebEnginePage::LifecycleState)</a></p>
     */
    @io.qt.QtPropertyNotify(name="lifecycleState")
    public final Signal1<io.qt.webengine.widgets.QWebEnginePage.LifecycleState> lifecycleStateChanged = new Signal1<>();

    public final Signal1<java.lang.String> linkHovered = new Signal1<>();

    public final Signal1<@io.qt.QtPrimitiveType Boolean> loadFinished = new Signal1<>();

    public final Signal1<@io.qt.QtPrimitiveType Integer> loadProgress = new Signal1<>();

    public final Signal0 loadStarted = new Signal0();

    public final Signal2<java.lang.String, @io.qt.QtPrimitiveType Boolean> pdfPrintingFinished = new Signal2<>();

    public final Signal0 printRequested = new Signal0();

    @SuppressWarnings({"exports"})
    public final Signal3<io.qt.core.QUrl, io.qt.network.QAuthenticator, java.lang.String> proxyAuthenticationRequired = new Signal3<>();

    @SuppressWarnings({"exports"})
    public final Signal1<io.qt.webengine.core.QWebEngineQuotaRequest> quotaRequested = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recentlyAudible-prop">QWebEnginePage::recentlyAudibleChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="recentlyAudible")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> recentlyAudibleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recommendedState-prop">QWebEnginePage::recommendedStateChanged(QWebEnginePage::LifecycleState)</a></p>
     */
    @io.qt.QtPropertyNotify(name="recommendedState")
    public final Signal1<io.qt.webengine.widgets.QWebEnginePage.LifecycleState> recommendedStateChanged = new Signal1<>();

    @SuppressWarnings({"exports"})
    public final Signal1<io.qt.webengine.core.QWebEngineRegisterProtocolHandlerRequest> registerProtocolHandlerRequested = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#renderProcessPid-prop">QWebEnginePage::renderProcessPidChanged(qint64)</a></p>
     */
    @io.qt.QtPropertyNotify(name="renderProcessPid")
    public final Signal1<@io.qt.QtPrimitiveType Long> renderProcessPidChanged = new Signal1<>();

    public final Signal2<io.qt.webengine.widgets.QWebEnginePage.RenderProcessTerminationStatus, @io.qt.QtPrimitiveType Integer> renderProcessTerminated = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#scrollPosition-prop">QWebEnginePage::scrollPositionChanged(QPointF)</a></p>
     */
    @io.qt.QtPropertyNotify(name="scrollPosition")
    public final Signal1<io.qt.core.QPointF> scrollPositionChanged = new Signal1<>();

    public final Signal1<io.qt.webengine.widgets.QWebEngineClientCertificateSelection> selectClientCertificate = new Signal1<>();

    public final Signal0 selectionChanged = new Signal0();

    public final Signal1<java.lang.String> titleChanged = new Signal1<>();

    public final Signal1<io.qt.core.QUrl> urlChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#visible-prop">QWebEnginePage::visibleChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="visible")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> visibleChanged = new Signal1<>();

    public final Signal0 windowCloseRequested = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QWebEnginePage(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEnginePage() {
        this((io.qt.core.QObject)null);
    }
    
    public QWebEnginePage(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWebEnginePage instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QWebEnginePage(io.qt.webengine.widgets.QWebEngineProfile, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEnginePage(io.qt.webengine.widgets.QWebEngineProfile profile) {
        this(profile, (io.qt.core.QObject)null);
    }
    
    public QWebEnginePage(io.qt.webengine.widgets.QWebEngineProfile profile, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, profile, parent);
    }
    
    private native static void initialize_native(QWebEnginePage instance, io.qt.webengine.widgets.QWebEngineProfile profile, io.qt.core.QObject parent);
    
    @io.qt.QtUninvokable
    public final io.qt.widgets.QAction action(io.qt.webengine.widgets.QWebEnginePage.WebAction action){
        return action_native_QWebEnginePage_WebAction_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), action.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QAction action_native_QWebEnginePage_WebAction_constfct(long __this__nativeId, int action);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#backgroundColor-prop">QWebEnginePage::backgroundColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="backgroundColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor backgroundColor(){
        return backgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor backgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#contentsSize-prop">QWebEnginePage::contentsSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="contentsSize")
    @io.qt.QtUninvokable
    public final io.qt.core.QSizeF contentsSize(){
        return contentsSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSizeF contentsSize_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineContextMenuData contextMenuData(){
        return contextMenuData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineContextMenuData contextMenuData_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.widgets.QMenu createStandardContextMenu(){
        return createStandardContextMenu_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QMenu createStandardContextMenu_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage devToolsPage(){
        return devToolsPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage devToolsPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #download(io.qt.core.QUrl, java.lang.String)}
     *  with <code>filename = ""</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void download(io.qt.core.QUrl url) {
        download(url, "");
    }
    
    @io.qt.QtUninvokable
    public final void download(io.qt.core.QUrl url, java.lang.String filename){
        download_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), filename);
    }
    
    @io.qt.QtUninvokable
    private native void download_native_cref_QUrl_cref_QString(long __this__nativeId, long url, java.lang.String filename);
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.widgets.QWebEnginePage.FindFlags, java.util.function.Consumer)}
     *  with <code>resultCallback = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void findText(java.lang.String subString, io.qt.webengine.widgets.QWebEnginePage.FindFlags options) {
        findText(subString, options, (java.util.function.Consumer<Boolean>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.widgets.QWebEnginePage.FindFlags, java.util.function.Consumer)}</p>
     * <p>with: </p><ul>
     * <li><code>options = new io.qt.webengine.widgets.QWebEnginePage.FindFlags(0)</code></li>
     * <li><code>resultCallback = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void findText(java.lang.String subString) {
        findText(subString, new io.qt.webengine.widgets.QWebEnginePage.FindFlags(0), (java.util.function.Consumer<Boolean>)null);
    }
    
    @io.qt.QtUninvokable
    public final void findText(java.lang.String subString, io.qt.webengine.widgets.QWebEnginePage.FindFlags options, java.util.function.Consumer<Boolean> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        findText_native_cref_QString_QFlags_QWebEnginePage_FindFlag__cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), subString, options.value(), resultCallback);
    }
    
    @io.qt.QtUninvokable
    private native void findText_native_cref_QString_QFlags_QWebEnginePage_FindFlag__cref_QWebEngineCallback(long __this__nativeId, java.lang.String subString, int options, java.util.function.Consumer<Boolean> resultCallback);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#hasSelection-prop">QWebEnginePage::hasSelection()const</a></p>
     */
    @io.qt.QtPropertyReader(name="hasSelection")
    @io.qt.QtUninvokable
    public final boolean hasSelection(){
        return hasSelection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasSelection_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineHistory history(){
        return history_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineHistory history_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#icon-prop">QWebEnginePage::icon()const</a></p>
     */
    @io.qt.QtPropertyReader(name="icon")
    @io.qt.QtUninvokable
    public final io.qt.gui.QIcon icon(){
        return icon_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#iconUrl-prop">QWebEnginePage::iconUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="iconUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl iconUrl(){
        return iconUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl iconUrl_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage inspectedPage(){
        return inspectedPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage inspectedPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#audioMuted-prop">QWebEnginePage::isAudioMuted()const</a></p>
     */
    @io.qt.QtPropertyReader(name="audioMuted")
    @io.qt.QtUninvokable
    public final boolean isAudioMuted(){
        return isAudioMuted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAudioMuted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#visible-prop">QWebEnginePage::isVisible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="visible")
    @io.qt.QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::lifecycleState()const</a></p>
     */
    @io.qt.QtPropertyReader(name="lifecycleState")
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage.LifecycleState lifecycleState(){
        return io.qt.webengine.widgets.QWebEnginePage.LifecycleState.resolve(lifecycleState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int lifecycleState_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void load(io.qt.core.QUrl url){
        load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void load_native_cref_QUrl(long __this__nativeId, long url);
    
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void load(io.qt.webengine.core.QWebEngineHttpRequest request){
        load_native_cref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    @io.qt.QtUninvokable
    private native void load_native_cref_QWebEngineHttpRequest(long __this__nativeId, long request);
    
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void print(io.qt.printsupport.QPrinter printer, java.util.function.Consumer<Boolean> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        print_native_QPrinter_ptr_cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(printer), resultCallback);
    }
    
    @io.qt.QtUninvokable
    private native void print_native_QPrinter_ptr_cref_QWebEngineCallback(long __this__nativeId, long printer, java.util.function.Consumer<Boolean> resultCallback);
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.lang.String, io.qt.gui.QPageLayout)}
     *  with <code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void printToPdf(java.lang.String filePath) {
        printToPdf(filePath, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()));
    }
    
    @io.qt.QtUninvokable
    public final void printToPdf(java.lang.String filePath, io.qt.gui.QPageLayout layout){
        printToPdf_native_cref_QString_cref_QPageLayout(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, QtJambi_LibraryUtilities.internal.checkedNativeId(layout));
    }
    
    @io.qt.QtUninvokable
    private native void printToPdf_native_cref_QString_cref_QPageLayout(long __this__nativeId, java.lang.String filePath, long layout);
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.util.function.Consumer, io.qt.gui.QPageLayout)}
     *  with <code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void printToPdf(java.util.function.Consumer<io.qt.core.QByteArray> resultCallback) {
        printToPdf(resultCallback, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()));
    }
    
    @io.qt.QtUninvokable
    public final void printToPdf(java.util.function.Consumer<io.qt.core.QByteArray> resultCallback, io.qt.gui.QPageLayout layout){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        printToPdf_native_cref_QWebEngineCallback_cref_QPageLayout(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback, QtJambi_LibraryUtilities.internal.checkedNativeId(layout));
    }
    
    @io.qt.QtUninvokable
    private native void printToPdf_native_cref_QWebEngineCallback_cref_QPageLayout(long __this__nativeId, java.util.function.Consumer<io.qt.core.QByteArray> resultCallback, long layout);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineProfile profile(){
        return profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineProfile profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recentlyAudible-prop">QWebEnginePage::recentlyAudible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="recentlyAudible")
    @io.qt.QtUninvokable
    public final boolean recentlyAudible(){
        return recentlyAudible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean recentlyAudible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recommendedState-prop">QWebEnginePage::recommendedState()const</a></p>
     */
    @io.qt.QtPropertyReader(name="recommendedState")
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage.LifecycleState recommendedState(){
        return io.qt.webengine.widgets.QWebEnginePage.LifecycleState.resolve(recommendedState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int recommendedState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#renderProcessPid-prop">QWebEnginePage::renderProcessPid()const</a></p>
     */
    @io.qt.QtPropertyReader(name="renderProcessPid")
    @io.qt.QtUninvokable
    public final long renderProcessPid(){
        return renderProcessPid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long renderProcessPid_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void replaceMisspelledWord(java.lang.String replacement){
        replaceMisspelledWord_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replacement);
    }
    
    @io.qt.QtUninvokable
    private native void replaceMisspelledWord_native_cref_QString(long __this__nativeId, java.lang.String replacement);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#requestedUrl-prop">QWebEnginePage::requestedUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="requestedUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl requestedUrl(){
        return requestedUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl requestedUrl_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void runJavaScript(java.lang.String scriptSource){
        runJavaScript_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource);
    }
    
    @io.qt.QtUninvokable
    private native void runJavaScript_native_cref_QString(long __this__nativeId, java.lang.String scriptSource);
    
    @io.qt.QtUninvokable
    public final void runJavaScript(java.lang.String scriptSource, java.util.function.Consumer<Object> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        runJavaScript_native_cref_QString_cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, resultCallback);
    }
    
    @io.qt.QtUninvokable
    private native void runJavaScript_native_cref_QString_cref_QWebEngineCallback(long __this__nativeId, java.lang.String scriptSource, java.util.function.Consumer<Object> resultCallback);
    
    @io.qt.QtUninvokable
    public final void runJavaScript(java.lang.String scriptSource, int worldId){
        runJavaScript_native_cref_QString_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, worldId);
    }
    
    @io.qt.QtUninvokable
    private native void runJavaScript_native_cref_QString_unsigned_int(long __this__nativeId, java.lang.String scriptSource, int worldId);
    
    @io.qt.QtUninvokable
    public final void runJavaScript(java.lang.String scriptSource, int worldId, java.util.function.Consumer<Object> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        runJavaScript_native_cref_QString_unsigned_int_cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, worldId, resultCallback);
    }
    
    @io.qt.QtUninvokable
    private native void runJavaScript_native_cref_QString_unsigned_int_cref_QWebEngineCallback(long __this__nativeId, java.lang.String scriptSource, int worldId, java.util.function.Consumer<Object> resultCallback);
    
    /**
     * <p>Overloaded function for {@link #save(java.lang.String, io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat)}
     *  with <code>format = io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat.MimeHtmlSaveFormat</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void save(java.lang.String filePath) {
        save(filePath, io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat.MimeHtmlSaveFormat);
    }
    
    @io.qt.QtUninvokable
    public final void save(java.lang.String filePath, io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat format){
        save_native_cref_QString_QWebEngineDownloadItem_SavePageFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, format.value());
    }
    
    @io.qt.QtUninvokable
    private native void save_native_cref_QString_QWebEngineDownloadItem_SavePageFormat_constfct(long __this__nativeId, java.lang.String filePath, int format);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineScriptCollection scripts(){
        return scripts_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineScriptCollection scripts_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#scrollPosition-prop">QWebEnginePage::scrollPosition()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scrollPosition")
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF scrollPosition(){
        return scrollPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF scrollPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#selectedText-prop">QWebEnginePage::selectedText()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedText")
    @io.qt.QtUninvokable
    public final java.lang.String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#audioMuted-prop">QWebEnginePage::setAudioMuted(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="audioMuted")
    @io.qt.QtUninvokable
    public final void setAudioMuted(boolean muted){
        setAudioMuted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), muted);
    }
    
    @io.qt.QtUninvokable
    private native void setAudioMuted_native_bool(long __this__nativeId, boolean muted);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#backgroundColor-prop">QWebEnginePage::setBackgroundColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="backgroundColor")
    @io.qt.QtUninvokable
    public final void setBackgroundColor(io.qt.gui.QColor color){
        setBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setContent(io.qt.core.QByteArray data, java.lang.String mimeType) {
        setContent(data, mimeType, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}</p>
     * <p>with: </p><ul>
     * <li><code>mimeType = ""</code></li>
     * <li><code>baseUrl = new io.qt.core.QUrl()</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void setContent(io.qt.core.QByteArray data) {
        setContent(data, "", new io.qt.core.QUrl());
    }
    
    @io.qt.QtUninvokable
    public final void setContent(io.qt.core.QByteArray data, java.lang.String mimeType, io.qt.core.QUrl baseUrl){
        setContent_native_cref_QByteArray_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), mimeType, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @io.qt.QtUninvokable
    private native void setContent_native_cref_QByteArray_cref_QString_cref_QUrl(long __this__nativeId, long data, java.lang.String mimeType, long baseUrl);
    
    @io.qt.QtUninvokable
    public final void setDevToolsPage(io.qt.webengine.widgets.QWebEnginePage page){
        setDevToolsPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
        __rcDevToolsPage = page;
    }
    
    @io.qt.QtUninvokable
    private native void setDevToolsPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    @io.qt.QtUninvokable
    public final void setFeaturePermission(io.qt.core.QUrl securityOrigin, io.qt.webengine.widgets.QWebEnginePage.Feature feature, io.qt.webengine.widgets.QWebEnginePage.PermissionPolicy policy){
        setFeaturePermission_native_cref_QUrl_QWebEnginePage_Feature_QWebEnginePage_PermissionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), feature.value(), policy.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFeaturePermission_native_cref_QUrl_QWebEnginePage_Feature_QWebEnginePage_PermissionPolicy(long __this__nativeId, long securityOrigin, int feature, int policy);
    
    /**
     * <p>Overloaded function for {@link #setHtml(java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setHtml(java.lang.String html) {
        setHtml(html, new io.qt.core.QUrl());
    }
    
    @io.qt.QtUninvokable
    public final void setHtml(java.lang.String html, io.qt.core.QUrl baseUrl){
        setHtml_native_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), html, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @io.qt.QtUninvokable
    private native void setHtml_native_cref_QString_cref_QUrl(long __this__nativeId, java.lang.String html, long baseUrl);
    
    @io.qt.QtUninvokable
    public final void setInspectedPage(io.qt.webengine.widgets.QWebEnginePage page){
        setInspectedPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
        __rcInspectedPage = page;
    }
    
    @io.qt.QtUninvokable
    private native void setInspectedPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::setLifecycleState(QWebEnginePage::LifecycleState)</a></p>
     */
    @io.qt.QtPropertyWriter(name="lifecycleState")
    @io.qt.QtUninvokable
    public final void setLifecycleState(io.qt.webengine.widgets.QWebEnginePage.LifecycleState state){
        setLifecycleState_native_QWebEnginePage_LifecycleState(QtJambi_LibraryUtilities.internal.nativeId(this), state.value());
    }
    
    @io.qt.QtUninvokable
    private native void setLifecycleState_native_QWebEnginePage_LifecycleState(long __this__nativeId, int state);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#url-prop">QWebEnginePage::setUrl(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="url")
    @io.qt.QtUninvokable
    public final void setUrl(io.qt.core.QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setUrlRequestInterceptor(io.qt.webengine.core.QWebEngineUrlRequestInterceptor interceptor){
        setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @io.qt.QtUninvokable
    private native void setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    @io.qt.QtUninvokable
    public final void setView(io.qt.widgets.QWidget view){
        setView_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(view));
        __rcView = view;
    }
    
    @io.qt.QtUninvokable
    private native void setView_native_QWidget_ptr(long __this__nativeId, long view);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#visible-prop">QWebEnginePage::setVisible(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="visible")
    @io.qt.QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @io.qt.QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setWebChannel(io.qt.webchannel.QWebChannel arg__1){
        setWebChannel_native_QWebChannel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        __rcWebChannel = arg__1;
    }
    
    @io.qt.QtUninvokable
    private native void setWebChannel_native_QWebChannel_ptr(long __this__nativeId, long arg__1);
    
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setWebChannel(io.qt.webchannel.QWebChannel arg__1, int worldId){
        setWebChannel_native_QWebChannel_ptr_uint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), worldId);
        __rcWebChannel = arg__1;
    }
    
    @io.qt.QtUninvokable
    private native void setWebChannel_native_QWebChannel_ptr_uint(long __this__nativeId, long arg__1, int worldId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#zoomFactor-prop">QWebEnginePage::setZoomFactor(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zoomFactor")
    @io.qt.QtUninvokable
    public final void setZoomFactor(double factor){
        setZoomFactor_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @io.qt.QtUninvokable
    private native void setZoomFactor_native_qtjambireal(long __this__nativeId, double factor);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineSettings settings(){
        return settings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineSettings settings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#title-prop">QWebEnginePage::title()const</a></p>
     */
    @io.qt.QtPropertyReader(name="title")
    @io.qt.QtUninvokable
    public final java.lang.String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void toHtml(java.util.function.Consumer<String> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        toHtml_native_cref_QWebEngineCallback_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback);
    }
    
    @io.qt.QtUninvokable
    private native void toHtml_native_cref_QWebEngineCallback_constfct(long __this__nativeId, java.util.function.Consumer<String> resultCallback);
    
    @io.qt.QtUninvokable
    public final void toPlainText(java.util.function.Consumer<String> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        toPlainText_native_cref_QWebEngineCallback_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback);
    }
    
    @io.qt.QtUninvokable
    private native void toPlainText_native_cref_QWebEngineCallback_constfct(long __this__nativeId, java.util.function.Consumer<String> resultCallback);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#url-prop">QWebEnginePage::url()const</a></p>
     */
    @io.qt.QtPropertyReader(name="url")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.widgets.QWidget view(){
        return view_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QWidget view_native_constfct(long __this__nativeId);
    
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.webchannel.QWebChannel webChannel(){
        return webChannel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webchannel.QWebChannel webChannel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#zoomFactor-prop">QWebEnginePage::zoomFactor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zoomFactor")
    @io.qt.QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected boolean acceptNavigationRequest(io.qt.core.QUrl url, io.qt.webengine.widgets.QWebEnginePage.NavigationType type, boolean isMainFrame){
        return acceptNavigationRequest_native_cref_QUrl_QWebEnginePage_NavigationType_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), type.value(), isMainFrame);
    }
    
    @io.qt.QtUninvokable
    private native boolean acceptNavigationRequest_native_cref_QUrl_QWebEnginePage_NavigationType_bool(long __this__nativeId, long url, int type, boolean isMainFrame);
    
    @io.qt.QtUninvokable
    protected boolean certificateError(io.qt.webengine.widgets.QWebEngineCertificateError certificateError){
        return certificateError_native_cref_QWebEngineCertificateError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(certificateError));
    }
    
    @io.qt.QtUninvokable
    private native boolean certificateError_native_cref_QWebEngineCertificateError(long __this__nativeId, long certificateError);
    
    @io.qt.QtUninvokable
    protected java.util.List<java.lang.String> chooseFiles(io.qt.webengine.widgets.QWebEnginePage.FileSelectionMode mode, java.util.Collection<java.lang.String> oldFiles, java.util.Collection<java.lang.String> acceptedMimeTypes){
        return chooseFiles_native_QWebEnginePage_FileSelectionMode_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value(), oldFiles, acceptedMimeTypes);
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<java.lang.String> chooseFiles_native_QWebEnginePage_FileSelectionMode_cref_QStringList_cref_QStringList(long __this__nativeId, int mode, java.util.Collection<java.lang.String> oldFiles, java.util.Collection<java.lang.String> acceptedMimeTypes);
    
    @io.qt.QtUninvokable
    protected io.qt.webengine.widgets.QWebEnginePage createWindow(io.qt.webengine.widgets.QWebEnginePage.WebWindowType type){
        return createWindow_native_QWebEnginePage_WebWindowType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage createWindow_native_QWebEnginePage_WebWindowType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    @io.qt.QtUninvokable
    protected void javaScriptAlert(io.qt.core.QUrl securityOrigin, java.lang.String msg){
        javaScriptAlert_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg);
    }
    
    @io.qt.QtUninvokable
    private native void javaScriptAlert_native_cref_QUrl_cref_QString(long __this__nativeId, long securityOrigin, java.lang.String msg);
    
    @io.qt.QtUninvokable
    protected boolean javaScriptConfirm(io.qt.core.QUrl securityOrigin, java.lang.String msg){
        return javaScriptConfirm_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg);
    }
    
    @io.qt.QtUninvokable
    private native boolean javaScriptConfirm_native_cref_QUrl_cref_QString(long __this__nativeId, long securityOrigin, java.lang.String msg);
    
    @io.qt.QtUninvokable
    protected void javaScriptConsoleMessage(io.qt.webengine.widgets.QWebEnginePage.JavaScriptConsoleMessageLevel level, java.lang.String message, int lineNumber, java.lang.String sourceID){
        javaScriptConsoleMessage_native_QWebEnginePage_JavaScriptConsoleMessageLevel_cref_QString_int_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), level.value(), message, lineNumber, sourceID);
    }
    
    @io.qt.QtUninvokable
    private native void javaScriptConsoleMessage_native_QWebEnginePage_JavaScriptConsoleMessageLevel_cref_QString_int_cref_QString(long __this__nativeId, int level, java.lang.String message, int lineNumber, java.lang.String sourceID);
    
    @io.qt.QtUninvokable
    protected java.lang.String javaScriptPrompt(io.qt.core.QUrl securityOrigin, java.lang.String msg, java.lang.String defaultValue){
        return javaScriptPrompt_native_cref_QUrl_cref_QString_cref_QString_QString_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg, defaultValue);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String javaScriptPrompt_native_cref_QUrl_cref_QString_cref_QString_QString_ptr(long __this__nativeId, long securityOrigin, java.lang.String msg, java.lang.String defaultValue);
    
    /**
     * <p>Overloaded function for {@link #triggerAction(io.qt.webengine.widgets.QWebEnginePage.WebAction, boolean)}
     *  with <code>checked = false</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void triggerAction(io.qt.webengine.widgets.QWebEnginePage.WebAction action) {
        triggerAction(action, (boolean)false);
    }
    
    @io.qt.QtUninvokable
    public void triggerAction(io.qt.webengine.widgets.QWebEnginePage.WebAction action, boolean checked){
        triggerAction_native_QWebEnginePage_WebAction_bool(QtJambi_LibraryUtilities.internal.nativeId(this), action.value(), checked);
    }
    
    @io.qt.QtUninvokable
    private native void triggerAction_native_QWebEnginePage_WebAction_bool(long __this__nativeId, int action, boolean checked);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEnginePage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QWebEnginePage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QWebEnginePage instance, QDeclarativeConstructor constructor);
    
}
