package io.qt.webengine.widgets;

import io.qt.*;


/**
 * <p>Represents a collection of user scripts</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qwebenginescriptcollection.html">QWebEngineScriptCollection</a></code></p>
 */
public final class QWebEngineScriptCollection extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>clear()</code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>contains(QWebEngineScript)const</code></p>
     */
    @QtUninvokable
    public final boolean contains(io.qt.webengine.widgets.@NonNull QWebEngineScript value){
        return contains_native_cref_QWebEngineScript_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native boolean contains_native_cref_QWebEngineScript_constfct(long __this__nativeId, long value);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>count()const</code></p>
     */
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>findScript(QString)const</code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.widgets.@NonNull QWebEngineScript findScript(java.lang.@NonNull String name){
        return findScript_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineScript findScript_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>findScripts(QString)const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.webengine.widgets.@NonNull QWebEngineScript> findScripts(java.lang.@NonNull String name){
        return findScripts_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.webengine.widgets.QWebEngineScript> findScripts_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>insert(QList&lt;QWebEngineScript&gt;)</code></p>
     */
    @QtUninvokable
    public final void insert(java.util.@NonNull Collection<? extends io.qt.webengine.widgets.@NonNull QWebEngineScript> list){
        insert_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native void insert_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.webengine.widgets.QWebEngineScript> list);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>insert(QWebEngineScript)</code></p>
     */
    @QtUninvokable
    public final void insert(io.qt.webengine.widgets.@NonNull QWebEngineScript arg__1){
        insert_native_cref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void insert_native_cref_QWebEngineScript(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>isEmpty()const</code></p>
     */
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>remove(QWebEngineScript)</code></p>
     */
    @QtUninvokable
    public final boolean remove(io.qt.webengine.widgets.@NonNull QWebEngineScript arg__1){
        return remove_native_cref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean remove_native_cref_QWebEngineScript(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>size()const</code></p>
     */
    @QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineScriptCollection::<wbr>toList()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.webengine.widgets.@NonNull QWebEngineScript> toList(){
        return toList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.webengine.widgets.QWebEngineScript> toList_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineScriptCollection(QPrivateConstructor p) { super(p); } 
    
}
