package io.qt.webengine.widgets;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class <code>QWebEngineDownloadItem</code></p>
 */
public final class QWebEngineDownloadItem extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineDownloadItem.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>QWebEngineDownloadItem::DownloadInterruptReason</code></p>
     */
    public enum DownloadInterruptReason implements QtEnumerator {
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>NoReason</code></p>
         */
        NoReason(0),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileFailed</code></p>
         */
        FileFailed(1),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileAccessDenied</code></p>
         */
        FileAccessDenied(2),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileNoSpace</code></p>
         */
        FileNoSpace(3),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileNameTooLong</code></p>
         */
        FileNameTooLong(5),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileTooLarge</code></p>
         */
        FileTooLarge(6),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileVirusInfected</code></p>
         */
        FileVirusInfected(7),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileTransientError</code></p>
         */
        FileTransientError(10),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileBlocked</code></p>
         */
        FileBlocked(11),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileSecurityCheckFailed</code></p>
         */
        FileSecurityCheckFailed(12),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileTooShort</code></p>
         */
        FileTooShort(13),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>FileHashMismatch</code></p>
         */
        FileHashMismatch(14),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>NetworkFailed</code></p>
         */
        NetworkFailed(20),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>NetworkTimeout</code></p>
         */
        NetworkTimeout(21),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>NetworkDisconnected</code></p>
         */
        NetworkDisconnected(22),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>NetworkServerDown</code></p>
         */
        NetworkServerDown(23),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>NetworkInvalidRequest</code></p>
         */
        NetworkInvalidRequest(24),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>ServerFailed</code></p>
         */
        ServerFailed(30),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>ServerBadContent</code></p>
         */
        ServerBadContent(33),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>ServerUnauthorized</code></p>
         */
        ServerUnauthorized(34),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>ServerCertProblem</code></p>
         */
        ServerCertProblem(35),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>ServerForbidden</code></p>
         */
        ServerForbidden(36),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>ServerUnreachable</code></p>
         */
        ServerUnreachable(37),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>UserCanceled</code></p>
         */
        UserCanceled(40);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadInterruptReason(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadInterruptReason resolve(int value) {
            switch (value) {
            case 0: return NoReason;
            case 1: return FileFailed;
            case 2: return FileAccessDenied;
            case 3: return FileNoSpace;
            case 5: return FileNameTooLong;
            case 6: return FileTooLarge;
            case 7: return FileVirusInfected;
            case 10: return FileTransientError;
            case 11: return FileBlocked;
            case 12: return FileSecurityCheckFailed;
            case 13: return FileTooShort;
            case 14: return FileHashMismatch;
            case 20: return NetworkFailed;
            case 21: return NetworkTimeout;
            case 22: return NetworkDisconnected;
            case 23: return NetworkServerDown;
            case 24: return NetworkInvalidRequest;
            case 30: return ServerFailed;
            case 33: return ServerBadContent;
            case 34: return ServerUnauthorized;
            case 35: return ServerCertProblem;
            case 36: return ServerForbidden;
            case 37: return ServerUnreachable;
            case 40: return UserCanceled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QWebEngineDownloadItem::DownloadState</code></p>
     */
    public enum DownloadState implements QtEnumerator {
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>DownloadRequested</code></p>
         */
        DownloadRequested(0),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>DownloadInProgress</code></p>
         */
        DownloadInProgress(1),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>DownloadCompleted</code></p>
         */
        DownloadCompleted(2),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>DownloadCancelled</code></p>
         */
        DownloadCancelled(3),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>DownloadInterrupted</code></p>
         */
        DownloadInterrupted(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadState resolve(int value) {
            switch (value) {
            case 0: return DownloadRequested;
            case 1: return DownloadInProgress;
            case 2: return DownloadCompleted;
            case 3: return DownloadCancelled;
            case 4: return DownloadInterrupted;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QWebEngineDownloadItem::DownloadType</code></p>
     */
    public enum DownloadType implements QtEnumerator {
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>Attachment</code></p>
         */
        Attachment(0),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>DownloadAttribute</code></p>
         */
        DownloadAttribute(1),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>UserRequested</code></p>
         */
        UserRequested(2),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>SavePage</code></p>
         */
        SavePage(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadType resolve(int value) {
            switch (value) {
            case 0: return Attachment;
            case 1: return DownloadAttribute;
            case 2: return UserRequested;
            case 3: return SavePage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QWebEngineDownloadItem::SavePageFormat</code></p>
     */
    public enum SavePageFormat implements QtEnumerator {
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>UnknownSaveFormat</code></p>
         */
        UnknownSaveFormat(-1),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>SingleHtmlSaveFormat</code></p>
         */
        SingleHtmlSaveFormat(0),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>CompleteHtmlSaveFormat</code></p>
         */
        CompleteHtmlSaveFormat(1),
        /**
         * <p>Representing <code>QWebEngineDownloadItem::<wbr>MimeHtmlSaveFormat</code></p>
         */
        MimeHtmlSaveFormat(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SavePageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SavePageFormat resolve(int value) {
            switch (value) {
            case -1: return UnknownSaveFormat;
            case 0: return SingleHtmlSaveFormat;
            case 1: return CompleteHtmlSaveFormat;
            case 2: return MimeHtmlSaveFormat;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>downloadProgress(qint64,<wbr>qint64)</code></p>
     */
    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Long, java.lang.@QtPrimitiveType@NonNull Long> downloadProgress = new Signal2<>();

    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>finished()</code></p>
     */
    public final @NonNull Signal0 finished = new Signal0();

    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>isPausedChanged(bool)</code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> isPausedChanged = new Signal1<>();

    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>stateChanged(QWebEngineDownloadItem::DownloadState)</code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadState> stateChanged = new Signal1<>();
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>accept()</code></p>
     */
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>cancel()</code></p>
     */
    public final void cancel(){
        cancel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancel_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>downloadDirectory()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String downloadDirectory(){
        return downloadDirectory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadDirectory_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>downloadFileName()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String downloadFileName(){
        return downloadFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>id()const</code></p>
     */
    @QtUninvokable
    public final int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>interruptReason()const</code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadInterruptReason interruptReason(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadInterruptReason.resolve(interruptReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int interruptReason_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>interruptReasonString()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String interruptReasonString(){
        return interruptReasonString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String interruptReasonString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>isFinished()const</code></p>
     */
    @QtUninvokable
    public final boolean isFinished(){
        return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFinished_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>isPaused()const</code></p>
     */
    @QtUninvokable
    public final boolean isPaused(){
        return isPaused_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPaused_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>isSavePageDownload()const</code></p>
     */
    @QtUninvokable
    public final boolean isSavePageDownload(){
        return isSavePageDownload_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSavePageDownload_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>mimeType()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String mimeType(){
        return mimeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String mimeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>page()const</code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.widgets.@Nullable QWebEnginePage page(){
        return page_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage page_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>path()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>pause()</code></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>receivedBytes()const</code></p>
     */
    @QtUninvokable
    public final long receivedBytes(){
        return receivedBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long receivedBytes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>resume()</code></p>
     */
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>savePageFormat()const</code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull SavePageFormat savePageFormat(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat.resolve(savePageFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int savePageFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>setDownloadDirectory(QString)</code></p>
     */
    @QtUninvokable
    public final void setDownloadDirectory(java.lang.@NonNull String directory){
        setDownloadDirectory_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), directory);
    }
    
    @QtUninvokable
    private native void setDownloadDirectory_native_cref_QString(long __this__nativeId, java.lang.String directory);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>setDownloadFileName(QString)</code></p>
     */
    @QtUninvokable
    public final void setDownloadFileName(java.lang.@NonNull String fileName){
        setDownloadFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setDownloadFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>setPath(QString)</code></p>
     */
    @QtUninvokable
    public final void setPath(java.lang.@NonNull String path){
        setPath_native_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setPath_native_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>setSavePageFormat(QWebEngineDownloadItem::SavePageFormat)</code></p>
     */
    @QtUninvokable
    public final void setSavePageFormat(io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull SavePageFormat format){
        setSavePageFormat_native_QWebEngineDownloadItem_SavePageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setSavePageFormat_native_QWebEngineDownloadItem_SavePageFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>state()const</code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadState state(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>suggestedFileName()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String suggestedFileName(){
        return suggestedFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String suggestedFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>totalBytes()const</code></p>
     */
    @QtUninvokable
    public final long totalBytes(){
        return totalBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long totalBytes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>type()const</code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadType type(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDownloadItem::<wbr>url()const</code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineDownloadItem(QPrivateConstructor p) { super(p); } 
    
}
