package io.qt.webengine.widgets;

import io.qt.*;


/**
 * <p>Object to view and edit web documents</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qwebenginepage.html">QWebEnginePage</a></p>
 */
public class QWebEnginePage extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcDevToolsPage = null;
    @QtPropertyMember(enabled=false)
    private Object __rcInspectedPage = null;
    @QtPropertyMember(enabled=false)
    private Object __rcUrlRequestInterceptor = null;
    @QtPropertyMember(enabled=false)
    private Object __rcView = null;
    @QtPropertyMember(enabled=false)
    private Object __rcWebChannel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEnginePage.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::Feature</a></p>
     */
    public enum Feature implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::Notifications</a></p>
         */
        Notifications(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::Geolocation</a></p>
         */
        Geolocation(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::MediaAudioCapture</a></p>
         */
        MediaAudioCapture(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::MediaVideoCapture</a></p>
         */
        MediaVideoCapture(3),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::MediaAudioVideoCapture</a></p>
         */
        MediaAudioVideoCapture(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::MouseLock</a></p>
         */
        MouseLock(5),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::DesktopVideoCapture</a></p>
         */
        DesktopVideoCapture(6),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#Feature-enum">QWebEnginePage::DesktopAudioVideoCapture</a></p>
         */
        DesktopAudioVideoCapture(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Feature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Feature resolve(int value) {
            switch (value) {
            case 0: return Notifications;
            case 1: return Geolocation;
            case 2: return MediaAudioCapture;
            case 3: return MediaVideoCapture;
            case 4: return MediaAudioVideoCapture;
            case 5: return MouseLock;
            case 6: return DesktopVideoCapture;
            case 7: return DesktopAudioVideoCapture;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::FileSelectionMode</a></p>
     */
    public enum FileSelectionMode implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::FileSelectOpen</a></p>
         */
        FileSelectOpen(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::FileSelectOpenMultiple</a></p>
         */
        FileSelectOpenMultiple(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FileSelectionMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FileSelectionMode resolve(int value) {
            switch (value) {
            case 0: return FileSelectOpen;
            case 1: return FileSelectOpenMultiple;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FindFlag-enum">QWebEnginePage::FindFlag</a></p>
     * 
     * @see FindFlags
     */
    public enum FindFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FindFlag-enum">QWebEnginePage::FindBackward</a></p>
         */
        FindBackward(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#FindFlag-enum">QWebEnginePage::FindCaseSensitively</a></p>
         */
        FindCaseSensitively(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FindFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull FindFlags asFlags() {
            return new FindFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull FindFlags combined(@NonNull FindFlag e) {
            return new FindFlags(this, e);
        }

        /**
         * Creates a new {@link FindFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull FindFlags flags(@Nullable FindFlag @NonNull... values) {
            return new FindFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FindFlag resolve(int value) {
            switch (value) {
            case 1: return FindBackward;
            case 2: return FindCaseSensitively;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link FindFlag}
     */
    public static final class FindFlags extends QFlags<FindFlag> implements Comparable<FindFlags> {
        private static final long serialVersionUID = 0xd99302055005fdf3L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new FindFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public FindFlags(@Nullable FindFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new FindFlags with given <code>value</code>.
         * @param value
         */
        public FindFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new FindFlags
         */
        @Override
        public final @NonNull FindFlags combined(@StrictNonNull FindFlag e){
            return new FindFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull FindFlags setFlag(@Nullable FindFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull FindFlags setFlag(@Nullable FindFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this FindFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull FindFlag @NonNull[] flags(){
            return super.flags(FindFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull FindFlags clone(){
            return new FindFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull FindFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::JavaScriptConsoleMessageLevel</a></p>
     */
    public enum JavaScriptConsoleMessageLevel implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::InfoMessageLevel</a></p>
         */
        InfoMessageLevel(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::WarningMessageLevel</a></p>
         */
        WarningMessageLevel(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::ErrorMessageLevel</a></p>
         */
        ErrorMessageLevel(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private JavaScriptConsoleMessageLevel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull JavaScriptConsoleMessageLevel resolve(int value) {
            switch (value) {
            case 0: return InfoMessageLevel;
            case 1: return WarningMessageLevel;
            case 2: return ErrorMessageLevel;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEnginePage::LifecycleState</p>
     */
    public enum LifecycleState implements QtEnumerator {
        /**
         * <p>Representing QWebEnginePage::LifecycleState::Active</p>
         */
        Active(0),
        /**
         * <p>Representing QWebEnginePage::LifecycleState::Frozen</p>
         */
        Frozen(1),
        /**
         * <p>Representing QWebEnginePage::LifecycleState::Discarded</p>
         */
        Discarded(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private LifecycleState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull LifecycleState resolve(int value) {
            switch (value) {
            case 0: return Active;
            case 1: return Frozen;
            case 2: return Discarded;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationType</a></p>
     */
    public enum NavigationType implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationTypeLinkClicked</a></p>
         */
        NavigationTypeLinkClicked(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationTypeTyped</a></p>
         */
        NavigationTypeTyped(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationTypeFormSubmitted</a></p>
         */
        NavigationTypeFormSubmitted(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationTypeBackForward</a></p>
         */
        NavigationTypeBackForward(3),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationTypeReload</a></p>
         */
        NavigationTypeReload(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationTypeOther</a></p>
         */
        NavigationTypeOther(5),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationTypeRedirect</a></p>
         */
        NavigationTypeRedirect(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NavigationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NavigationType resolve(int value) {
            switch (value) {
            case 0: return NavigationTypeLinkClicked;
            case 1: return NavigationTypeTyped;
            case 2: return NavigationTypeFormSubmitted;
            case 3: return NavigationTypeBackForward;
            case 4: return NavigationTypeReload;
            case 5: return NavigationTypeOther;
            case 6: return NavigationTypeRedirect;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::PermissionPolicy</a></p>
     */
    public enum PermissionPolicy implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::PermissionUnknown</a></p>
         */
        PermissionUnknown(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::PermissionGrantedByUser</a></p>
         */
        PermissionGrantedByUser(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::PermissionDeniedByUser</a></p>
         */
        PermissionDeniedByUser(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PermissionPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PermissionPolicy resolve(int value) {
            switch (value) {
            case 0: return PermissionUnknown;
            case 1: return PermissionGrantedByUser;
            case 2: return PermissionDeniedByUser;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEnginePage::RenderProcessTerminationStatus</p>
     */
    public enum RenderProcessTerminationStatus implements QtEnumerator {
        /**
         * <p>Representing QWebEnginePage::NormalTerminationStatus</p>
         */
        NormalTerminationStatus(0),
        /**
         * <p>Representing QWebEnginePage::AbnormalTerminationStatus</p>
         */
        AbnormalTerminationStatus(1),
        /**
         * <p>Representing QWebEnginePage::CrashedTerminationStatus</p>
         */
        CrashedTerminationStatus(2),
        /**
         * <p>Representing QWebEnginePage::KilledTerminationStatus</p>
         */
        KilledTerminationStatus(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderProcessTerminationStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RenderProcessTerminationStatus resolve(int value) {
            switch (value) {
            case 0: return NormalTerminationStatus;
            case 1: return AbnormalTerminationStatus;
            case 2: return CrashedTerminationStatus;
            case 3: return KilledTerminationStatus;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::WebAction</a></p>
     */
    public enum WebAction implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::NoWebAction</a></p>
         */
        NoWebAction(-1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Back</a></p>
         */
        Back(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Forward</a></p>
         */
        Forward(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Stop</a></p>
         */
        Stop(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Reload</a></p>
         */
        Reload(3),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Cut</a></p>
         */
        Cut(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Copy</a></p>
         */
        Copy(5),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Paste</a></p>
         */
        Paste(6),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Undo</a></p>
         */
        Undo(7),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Redo</a></p>
         */
        Redo(8),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::SelectAll</a></p>
         */
        SelectAll(9),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ReloadAndBypassCache</a></p>
         */
        ReloadAndBypassCache(10),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::PasteAndMatchStyle</a></p>
         */
        PasteAndMatchStyle(11),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::OpenLinkInThisWindow</a></p>
         */
        OpenLinkInThisWindow(12),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::OpenLinkInNewWindow</a></p>
         */
        OpenLinkInNewWindow(13),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::OpenLinkInNewTab</a></p>
         */
        OpenLinkInNewTab(14),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::CopyLinkToClipboard</a></p>
         */
        CopyLinkToClipboard(15),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::DownloadLinkToDisk</a></p>
         */
        DownloadLinkToDisk(16),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::CopyImageToClipboard</a></p>
         */
        CopyImageToClipboard(17),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::CopyImageUrlToClipboard</a></p>
         */
        CopyImageUrlToClipboard(18),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::DownloadImageToDisk</a></p>
         */
        DownloadImageToDisk(19),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::CopyMediaUrlToClipboard</a></p>
         */
        CopyMediaUrlToClipboard(20),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleMediaControls</a></p>
         */
        ToggleMediaControls(21),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleMediaLoop</a></p>
         */
        ToggleMediaLoop(22),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleMediaPlayPause</a></p>
         */
        ToggleMediaPlayPause(23),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleMediaMute</a></p>
         */
        ToggleMediaMute(24),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::DownloadMediaToDisk</a></p>
         */
        DownloadMediaToDisk(25),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::InspectElement</a></p>
         */
        InspectElement(26),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ExitFullScreen</a></p>
         */
        ExitFullScreen(27),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::RequestClose</a></p>
         */
        RequestClose(28),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Unselect</a></p>
         */
        Unselect(29),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::SavePage</a></p>
         */
        SavePage(30),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::OpenLinkInNewBackgroundTab</a></p>
         */
        OpenLinkInNewBackgroundTab(31),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ViewSource</a></p>
         */
        ViewSource(32),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleBold</a></p>
         */
        ToggleBold(33),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleItalic</a></p>
         */
        ToggleItalic(34),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleUnderline</a></p>
         */
        ToggleUnderline(35),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::ToggleStrikethrough</a></p>
         */
        ToggleStrikethrough(36),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::AlignLeft</a></p>
         */
        AlignLeft(37),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::AlignCenter</a></p>
         */
        AlignCenter(38),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::AlignRight</a></p>
         */
        AlignRight(39),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::AlignJustified</a></p>
         */
        AlignJustified(40),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Indent</a></p>
         */
        Indent(41),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::Outdent</a></p>
         */
        Outdent(42),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::InsertOrderedList</a></p>
         */
        InsertOrderedList(43),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::InsertUnorderedList</a></p>
         */
        InsertUnorderedList(44),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebAction-enum">QWebEnginePage::WebActionCount</a></p>
         */
        WebActionCount(45);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WebAction resolve(int value) {
            switch (value) {
            case -1: return NoWebAction;
            case 0: return Back;
            case 1: return Forward;
            case 2: return Stop;
            case 3: return Reload;
            case 4: return Cut;
            case 5: return Copy;
            case 6: return Paste;
            case 7: return Undo;
            case 8: return Redo;
            case 9: return SelectAll;
            case 10: return ReloadAndBypassCache;
            case 11: return PasteAndMatchStyle;
            case 12: return OpenLinkInThisWindow;
            case 13: return OpenLinkInNewWindow;
            case 14: return OpenLinkInNewTab;
            case 15: return CopyLinkToClipboard;
            case 16: return DownloadLinkToDisk;
            case 17: return CopyImageToClipboard;
            case 18: return CopyImageUrlToClipboard;
            case 19: return DownloadImageToDisk;
            case 20: return CopyMediaUrlToClipboard;
            case 21: return ToggleMediaControls;
            case 22: return ToggleMediaLoop;
            case 23: return ToggleMediaPlayPause;
            case 24: return ToggleMediaMute;
            case 25: return DownloadMediaToDisk;
            case 26: return InspectElement;
            case 27: return ExitFullScreen;
            case 28: return RequestClose;
            case 29: return Unselect;
            case 30: return SavePage;
            case 31: return OpenLinkInNewBackgroundTab;
            case 32: return ViewSource;
            case 33: return ToggleBold;
            case 34: return ToggleItalic;
            case 35: return ToggleUnderline;
            case 36: return ToggleStrikethrough;
            case 37: return AlignLeft;
            case 38: return AlignCenter;
            case 39: return AlignRight;
            case 40: return AlignJustified;
            case 41: return Indent;
            case 42: return Outdent;
            case 43: return InsertOrderedList;
            case 44: return InsertUnorderedList;
            case 45: return WebActionCount;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::WebWindowType</a></p>
     */
    public enum WebWindowType implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::WebBrowserWindow</a></p>
         */
        WebBrowserWindow(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::WebBrowserTab</a></p>
         */
        WebBrowserTab(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::WebDialog</a></p>
         */
        WebDialog(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::WebBrowserBackgroundTab</a></p>
         */
        WebBrowserBackgroundTab(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebWindowType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WebWindowType resolve(int value) {
            switch (value) {
            case 0: return WebBrowserWindow;
            case 1: return WebBrowserTab;
            case 2: return WebDialog;
            case 3: return WebBrowserBackgroundTab;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#audioMuted-prop">QWebEnginePage::audioMutedChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="audioMuted")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> audioMutedChanged = new Signal1<>();

    @SuppressWarnings({"exports"})
    public final @NonNull Signal2<io.qt.core.@NonNull QUrl, io.qt.network.@Nullable QAuthenticator> authenticationRequired = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#contentsSize-prop">QWebEnginePage::contentsSizeChanged(QSizeF)</a></p>
     */
    @QtPropertyNotify(name="contentsSize")
    public final @NonNull Signal1<io.qt.core.@NonNull QSizeF> contentsSizeChanged = new Signal1<>();

    public final @NonNull Signal2<io.qt.core.@NonNull QUrl, io.qt.webengine.widgets.QWebEnginePage.@NonNull Feature> featurePermissionRequestCanceled = new Signal2<>();

    public final @NonNull Signal2<io.qt.core.@NonNull QUrl, io.qt.webengine.widgets.QWebEnginePage.@NonNull Feature> featurePermissionRequested = new Signal2<>();

    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineFindTextResult> findTextFinished = new Signal1<>();

    public final @NonNull Signal1<io.qt.webengine.widgets.QWebEngineFullScreenRequest> fullScreenRequested = new Signal1<>();

    public final @NonNull Signal1<io.qt.core.@NonNull QRect> geometryChangeRequested = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#icon-prop">QWebEnginePage::iconChanged(QIcon)</a></p>
     */
    @QtPropertyNotify(name="icon")
    public final @NonNull Signal1<io.qt.gui.@NonNull QIcon> iconChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#iconUrl-prop">QWebEnginePage::iconUrlChanged(QUrl)</a></p>
     */
    @QtPropertyNotify(name="iconUrl")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> iconUrlChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::lifecycleStateChanged(QWebEnginePage::LifecycleState)</a></p>
     */
    @QtPropertyNotify(name="lifecycleState")
    public final @NonNull Signal1<io.qt.webengine.widgets.QWebEnginePage.@NonNull LifecycleState> lifecycleStateChanged = new Signal1<>();

    public final @NonNull Signal1<java.lang.@NonNull String> linkHovered = new Signal1<>();

    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> loadFinished = new Signal1<>();

    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> loadProgress = new Signal1<>();

    public final @NonNull Signal0 loadStarted = new Signal0();

    public final @NonNull Signal2<java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Boolean> pdfPrintingFinished = new Signal2<>();

    public final @NonNull Signal0 printRequested = new Signal0();

    @SuppressWarnings({"exports"})
    public final @NonNull Signal3<io.qt.core.@NonNull QUrl, io.qt.network.@Nullable QAuthenticator, java.lang.@NonNull String> proxyAuthenticationRequired = new Signal3<>();

    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineQuotaRequest> quotaRequested = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recentlyAudible-prop">QWebEnginePage::recentlyAudibleChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="recentlyAudible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> recentlyAudibleChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recommendedState-prop">QWebEnginePage::recommendedStateChanged(QWebEnginePage::LifecycleState)</a></p>
     */
    @QtPropertyNotify(name="recommendedState")
    public final @NonNull Signal1<io.qt.webengine.widgets.QWebEnginePage.@NonNull LifecycleState> recommendedStateChanged = new Signal1<>();

    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineRegisterProtocolHandlerRequest> registerProtocolHandlerRequested = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#renderProcessPid-prop">QWebEnginePage::renderProcessPidChanged(qint64)</a></p>
     */
    @QtPropertyNotify(name="renderProcessPid")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> renderProcessPidChanged = new Signal1<>();

    public final @NonNull Signal2<io.qt.webengine.widgets.QWebEnginePage.@NonNull RenderProcessTerminationStatus, java.lang.@QtPrimitiveType@NonNull Integer> renderProcessTerminated = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#scrollPosition-prop">QWebEnginePage::scrollPositionChanged(QPointF)</a></p>
     */
    @QtPropertyNotify(name="scrollPosition")
    public final @NonNull Signal1<io.qt.core.@NonNull QPointF> scrollPositionChanged = new Signal1<>();

    public final @NonNull Signal1<io.qt.webengine.widgets.@NonNull QWebEngineClientCertificateSelection> selectClientCertificate = new Signal1<>();

    public final @NonNull Signal0 selectionChanged = new Signal0();

    public final @NonNull Signal1<java.lang.@NonNull String> titleChanged = new Signal1<>();

    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> urlChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#visible-prop">QWebEnginePage::visibleChanged(bool)</a></p>
     */
    @QtPropertyNotify(name="visible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> visibleChanged = new Signal1<>();

    public final @NonNull Signal0 windowCloseRequested = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QWebEnginePage(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEnginePage() {
        this((io.qt.core.QObject)null);
    }
    
    public QWebEnginePage(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWebEnginePage instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QWebEnginePage(io.qt.webengine.widgets.QWebEngineProfile, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEnginePage(io.qt.webengine.widgets.@Nullable QWebEngineProfile profile) {
        this(profile, (io.qt.core.QObject)null);
    }
    
    public QWebEnginePage(io.qt.webengine.widgets.@Nullable QWebEngineProfile profile, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, profile, parent);
    }
    
    private native static void initialize_native(QWebEnginePage instance, io.qt.webengine.widgets.QWebEngineProfile profile, io.qt.core.QObject parent);
    
    @QtUninvokable
    public final io.qt.widgets.@Nullable QAction action(io.qt.webengine.widgets.QWebEnginePage.@NonNull WebAction action){
        return action_native_QWebEnginePage_WebAction_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), action.value());
    }
    
    @QtUninvokable
    private native io.qt.widgets.QAction action_native_QWebEnginePage_WebAction_constfct(long __this__nativeId, int action);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #backgroundColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getBackgroundColor() {
        return backgroundColor();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#backgroundColor-prop">QWebEnginePage::backgroundColor()const</a></p>
     */
    @QtPropertyReader(name="backgroundColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor backgroundColor(){
        return backgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor backgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #contentsSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF getContentsSize() {
        return contentsSize();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#contentsSize-prop">QWebEnginePage::contentsSize()const</a></p>
     */
    @QtPropertyReader(name="contentsSize")
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF contentsSize(){
        return contentsSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSizeF contentsSize_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@NonNull QWebEngineContextMenuData contextMenuData(){
        return contextMenuData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineContextMenuData contextMenuData_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.widgets.@Nullable QMenu createStandardContextMenu(){
        return createStandardContextMenu_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.widgets.QMenu createStandardContextMenu_native(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@Nullable QWebEnginePage devToolsPage(){
        return devToolsPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage devToolsPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #download(io.qt.core.QUrl, java.lang.String)}
     *  with <code>filename = (String)null</code>.</p>
     */
    @QtUninvokable
    public final void download(io.qt.core.@NonNull QUrl url) {
        download(url, (String)null);
    }
    
    @QtUninvokable
    public final void download(io.qt.core.@NonNull QUrl url, java.lang.@NonNull String filename){
        download_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), filename);
    }
    
    @QtUninvokable
    private native void download_native_cref_QUrl_cref_QString(long __this__nativeId, long url, java.lang.String filename);
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.widgets.QWebEnginePage.FindFlags, java.util.function.Consumer)}
     *  with <code>resultCallback = null</code>.</p>
     */
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString, io.qt.webengine.widgets.QWebEnginePage.@NonNull FindFlags options) {
        findText(subString, options, (java.util.function.Consumer<Boolean>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.widgets.QWebEnginePage.FindFlags, java.util.function.Consumer)}</p>
     * <p>with: </p><ul>
     * <li><code>options = new io.qt.webengine.widgets.QWebEnginePage.FindFlags(0)</code></li>
     * <li><code>resultCallback = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString) {
        findText(subString, new io.qt.webengine.widgets.QWebEnginePage.FindFlags(0), (java.util.function.Consumer<Boolean>)null);
    }
    
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString, io.qt.webengine.widgets.QWebEnginePage.@NonNull FindFlags options, java.util.function.Consumer<Boolean> resultCallback){
        findText_native_cref_QString_QWebEnginePage_FindFlags_cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), subString, options.value(), resultCallback);
    }
    
    @QtUninvokable
    private native void findText_native_cref_QString_QWebEnginePage_FindFlags_cref_QWebEngineCallback(long __this__nativeId, java.lang.String subString, int options, java.util.function.Consumer<Boolean> resultCallback);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #hasSelection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getHasSelection() {
        return hasSelection();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#hasSelection-prop">QWebEnginePage::hasSelection()const</a></p>
     */
    @QtPropertyReader(name="hasSelection")
    @QtUninvokable
    public final boolean hasSelection(){
        return hasSelection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasSelection_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@Nullable QWebEngineHistory history(){
        return history_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineHistory history_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #icon()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon getIcon() {
        return icon();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#icon-prop">QWebEnginePage::icon()const</a></p>
     */
    @QtPropertyReader(name="icon")
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon icon(){
        return icon_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #iconUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getIconUrl() {
        return iconUrl();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#iconUrl-prop">QWebEnginePage::iconUrl()const</a></p>
     */
    @QtPropertyReader(name="iconUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl iconUrl(){
        return iconUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl iconUrl_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@Nullable QWebEnginePage inspectedPage(){
        return inspectedPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage inspectedPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAudioMuted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAudioMuted() {
        return isAudioMuted();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#audioMuted-prop">QWebEnginePage::isAudioMuted()const</a></p>
     */
    @QtPropertyReader(name="audioMuted")
    @QtUninvokable
    public final boolean isAudioMuted(){
        return isAudioMuted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAudioMuted_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getVisible() {
        return isVisible();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#visible-prop">QWebEnginePage::isVisible()const</a></p>
     */
    @QtPropertyReader(name="visible")
    @QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #lifecycleState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage.@NonNull LifecycleState getLifecycleState() {
        return lifecycleState();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::lifecycleState()const</a></p>
     */
    @QtPropertyReader(name="lifecycleState")
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage.@NonNull LifecycleState lifecycleState(){
        return io.qt.webengine.widgets.QWebEnginePage.LifecycleState.resolve(lifecycleState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int lifecycleState_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void load(io.qt.core.@NonNull QUrl url){
        load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void load_native_cref_QUrl(long __this__nativeId, long url);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void load(io.qt.webengine.core.@NonNull QWebEngineHttpRequest request){
        load_native_cref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    @QtUninvokable
    private native void load_native_cref_QWebEngineHttpRequest(long __this__nativeId, long request);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void print(io.qt.printsupport.@Nullable QPrinter printer, java.util.function.Consumer<Boolean> resultCallback){
        print_native_QPrinter_ptr_cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(printer), resultCallback);
    }
    
    @QtUninvokable
    private native void print_native_QPrinter_ptr_cref_QWebEngineCallback(long __this__nativeId, long printer, java.util.function.Consumer<Boolean> resultCallback);
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.lang.String, io.qt.gui.QPageLayout)}
     *  with <code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code>.</p>
     */
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath) {
        printToPdf(filePath, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()));
    }
    
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath, io.qt.gui.@NonNull QPageLayout layout){
        printToPdf_native_cref_QString_cref_QPageLayout(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, QtJambi_LibraryUtilities.internal.checkedNativeId(layout));
    }
    
    @QtUninvokable
    private native void printToPdf_native_cref_QString_cref_QPageLayout(long __this__nativeId, java.lang.String filePath, long layout);
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.util.function.Consumer, io.qt.gui.QPageLayout)}
     *  with <code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code>.</p>
     */
    @QtUninvokable
    public final void printToPdf(java.util.function.@StrictNonNull Consumer<io.qt.core.QByteArray> resultCallback) {
        printToPdf(resultCallback, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()));
    }
    
    @QtUninvokable
    public final void printToPdf(java.util.function.@StrictNonNull Consumer<io.qt.core.QByteArray> resultCallback, io.qt.gui.@NonNull QPageLayout layout){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        printToPdf_native_cref_QWebEngineCallback_cref_QPageLayout(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback, QtJambi_LibraryUtilities.internal.checkedNativeId(layout));
    }
    
    @QtUninvokable
    private native void printToPdf_native_cref_QWebEngineCallback_cref_QPageLayout(long __this__nativeId, java.util.function.Consumer<io.qt.core.QByteArray> resultCallback, long layout);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@Nullable QWebEngineProfile profile(){
        return profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineProfile profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #recentlyAudible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRecentlyAudible() {
        return recentlyAudible();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recentlyAudible-prop">QWebEnginePage::recentlyAudible()const</a></p>
     */
    @QtPropertyReader(name="recentlyAudible")
    @QtUninvokable
    public final boolean recentlyAudible(){
        return recentlyAudible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean recentlyAudible_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #recommendedState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage.@NonNull LifecycleState getRecommendedState() {
        return recommendedState();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#recommendedState-prop">QWebEnginePage::recommendedState()const</a></p>
     */
    @QtPropertyReader(name="recommendedState")
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage.@NonNull LifecycleState recommendedState(){
        return io.qt.webengine.widgets.QWebEnginePage.LifecycleState.resolve(recommendedState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int recommendedState_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #renderProcessPid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getRenderProcessPid() {
        return renderProcessPid();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#renderProcessPid-prop">QWebEnginePage::renderProcessPid()const</a></p>
     */
    @QtPropertyReader(name="renderProcessPid")
    @QtUninvokable
    public final long renderProcessPid(){
        return renderProcessPid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long renderProcessPid_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void replaceMisspelledWord(java.lang.@NonNull String replacement){
        replaceMisspelledWord_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replacement);
    }
    
    @QtUninvokable
    private native void replaceMisspelledWord_native_cref_QString(long __this__nativeId, java.lang.String replacement);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #requestedUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getRequestedUrl() {
        return requestedUrl();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#requestedUrl-prop">QWebEnginePage::requestedUrl()const</a></p>
     */
    @QtPropertyReader(name="requestedUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestedUrl(){
        return requestedUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestedUrl_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource){
        runJavaScript_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource);
    }
    
    @QtUninvokable
    private native void runJavaScript_native_cref_QString(long __this__nativeId, java.lang.String scriptSource);
    
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource, java.util.function.@StrictNonNull Consumer<Object> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        runJavaScript_native_cref_QString_cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, resultCallback);
    }
    
    @QtUninvokable
    private native void runJavaScript_native_cref_QString_cref_QWebEngineCallback(long __this__nativeId, java.lang.String scriptSource, java.util.function.Consumer<Object> resultCallback);
    
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource, int worldId){
        runJavaScript_native_cref_QString_quint32(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, worldId);
    }
    
    @QtUninvokable
    private native void runJavaScript_native_cref_QString_quint32(long __this__nativeId, java.lang.String scriptSource, int worldId);
    
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource, int worldId, java.util.function.@StrictNonNull Consumer<Object> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        runJavaScript_native_cref_QString_quint32_cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, worldId, resultCallback);
    }
    
    @QtUninvokable
    private native void runJavaScript_native_cref_QString_quint32_cref_QWebEngineCallback(long __this__nativeId, java.lang.String scriptSource, int worldId, java.util.function.Consumer<Object> resultCallback);
    
    /**
     * <p>Overloaded function for {@link #save(java.lang.String, io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat)}
     *  with <code>format = io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat.MimeHtmlSaveFormat</code>.</p>
     */
    @QtUninvokable
    public final void save(java.lang.@NonNull String filePath) {
        save(filePath, io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat.MimeHtmlSaveFormat);
    }
    
    @QtUninvokable
    public final void save(java.lang.@NonNull String filePath, io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull SavePageFormat format){
        save_native_cref_QString_QWebEngineDownloadItem_SavePageFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, format.value());
    }
    
    @QtUninvokable
    private native void save_native_cref_QString_QWebEngineDownloadItem_SavePageFormat_constfct(long __this__nativeId, java.lang.String filePath, int format);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@NonNull QWebEngineScriptCollection scripts(){
        return scripts_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineScriptCollection scripts_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #scrollPosition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF getScrollPosition() {
        return scrollPosition();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#scrollPosition-prop">QWebEnginePage::scrollPosition()const</a></p>
     */
    @QtPropertyReader(name="scrollPosition")
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF scrollPosition(){
        return scrollPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPointF scrollPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSelectedText() {
        return selectedText();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#selectedText-prop">QWebEnginePage::selectedText()const</a></p>
     */
    @QtPropertyReader(name="selectedText")
    @QtUninvokable
    public final java.lang.@NonNull String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#audioMuted-prop">QWebEnginePage::setAudioMuted(bool)</a></p>
     */
    @QtPropertyWriter(name="audioMuted")
    @QtUninvokable
    public final void setAudioMuted(boolean muted){
        setAudioMuted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), muted);
    }
    
    @QtUninvokable
    private native void setAudioMuted_native_bool(long __this__nativeId, boolean muted);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#backgroundColor-prop">QWebEnginePage::setBackgroundColor(QColor)</a></p>
     */
    @QtPropertyWriter(name="backgroundColor")
    @QtUninvokable
    public final void setBackgroundColor(io.qt.gui.@NonNull QColor color){
        setBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String mimeType) {
        setContent(data, mimeType, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}</p>
     * <p>with: </p><ul>
     * <li><code>mimeType = (String)null</code></li>
     * <li><code>baseUrl = new io.qt.core.QUrl()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data) {
        setContent(data, (String)null, new io.qt.core.QUrl());
    }
    
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String mimeType, io.qt.core.@NonNull QUrl baseUrl){
        setContent_native_cref_QByteArray_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), mimeType, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @QtUninvokable
    private native void setContent_native_cref_QByteArray_cref_QString_cref_QUrl(long __this__nativeId, long data, java.lang.String mimeType, long baseUrl);
    
    @QtUninvokable
    public final void setDevToolsPage(io.qt.webengine.widgets.@Nullable QWebEnginePage page){
        setDevToolsPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
        __rcDevToolsPage = page;
    }
    
    @QtUninvokable
    private native void setDevToolsPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    @QtUninvokable
    public final void setFeaturePermission(io.qt.core.@NonNull QUrl securityOrigin, io.qt.webengine.widgets.QWebEnginePage.@NonNull Feature feature, io.qt.webengine.widgets.QWebEnginePage.@NonNull PermissionPolicy policy){
        setFeaturePermission_native_cref_QUrl_QWebEnginePage_Feature_QWebEnginePage_PermissionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), feature.value(), policy.value());
    }
    
    @QtUninvokable
    private native void setFeaturePermission_native_cref_QUrl_QWebEnginePage_Feature_QWebEnginePage_PermissionPolicy(long __this__nativeId, long securityOrigin, int feature, int policy);
    
    /**
     * <p>Overloaded function for {@link #setHtml(java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setHtml(java.lang.@NonNull String html) {
        setHtml(html, new io.qt.core.QUrl());
    }
    
    @QtUninvokable
    public final void setHtml(java.lang.@NonNull String html, io.qt.core.@NonNull QUrl baseUrl){
        setHtml_native_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), html, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @QtUninvokable
    private native void setHtml_native_cref_QString_cref_QUrl(long __this__nativeId, java.lang.String html, long baseUrl);
    
    @QtUninvokable
    public final void setInspectedPage(io.qt.webengine.widgets.@Nullable QWebEnginePage page){
        setInspectedPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
        __rcInspectedPage = page;
    }
    
    @QtUninvokable
    private native void setInspectedPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::setLifecycleState(QWebEnginePage::LifecycleState)</a></p>
     */
    @QtPropertyWriter(name="lifecycleState")
    @QtUninvokable
    public final void setLifecycleState(io.qt.webengine.widgets.QWebEnginePage.@NonNull LifecycleState state){
        setLifecycleState_native_QWebEnginePage_LifecycleState(QtJambi_LibraryUtilities.internal.nativeId(this), state.value());
    }
    
    @QtUninvokable
    private native void setLifecycleState_native_QWebEnginePage_LifecycleState(long __this__nativeId, int state);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#url-prop">QWebEnginePage::setUrl(QUrl)</a></p>
     */
    @QtPropertyWriter(name="url")
    @QtUninvokable
    public final void setUrl(io.qt.core.@NonNull QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setUrlRequestInterceptor(io.qt.webengine.core.@Nullable QWebEngineUrlRequestInterceptor interceptor){
        setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @QtUninvokable
    private native void setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    @QtUninvokable
    public final void setView(io.qt.widgets.@Nullable QWidget view){
        setView_native_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(view));
        __rcView = view;
    }
    
    @QtUninvokable
    private native void setView_native_QWidget_ptr(long __this__nativeId, long view);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#visible-prop">QWebEnginePage::setVisible(bool)</a></p>
     */
    @QtPropertyWriter(name="visible")
    @QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setWebChannel(io.qt.webchannel.@Nullable QWebChannel arg__1){
        setWebChannel_native_QWebChannel_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        __rcWebChannel = arg__1;
    }
    
    @QtUninvokable
    private native void setWebChannel_native_QWebChannel_ptr(long __this__nativeId, long arg__1);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setWebChannel(io.qt.webchannel.@Nullable QWebChannel arg__1, int worldId){
        setWebChannel_native_QWebChannel_ptr_uint(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), worldId);
        __rcWebChannel = arg__1;
    }
    
    @QtUninvokable
    private native void setWebChannel_native_QWebChannel_ptr_uint(long __this__nativeId, long arg__1, int worldId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#zoomFactor-prop">QWebEnginePage::setZoomFactor(qreal)</a></p>
     */
    @QtPropertyWriter(name="zoomFactor")
    @QtUninvokable
    public final void setZoomFactor(double factor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setZoomFactor_native_qreal(long __this__nativeId, double factor);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@Nullable QWebEngineSettings settings(){
        return settings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineSettings settings_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #title()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTitle() {
        return title();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#title-prop">QWebEnginePage::title()const</a></p>
     */
    @QtPropertyReader(name="title")
    @QtUninvokable
    public final java.lang.@NonNull String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void toHtml(java.util.function.@StrictNonNull Consumer<String> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        toHtml_native_cref_QWebEngineCallback_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback);
    }
    
    @QtUninvokable
    private native void toHtml_native_cref_QWebEngineCallback_constfct(long __this__nativeId, java.util.function.Consumer<String> resultCallback);
    
    @QtUninvokable
    public final void toPlainText(java.util.function.@StrictNonNull Consumer<String> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        toPlainText_native_cref_QWebEngineCallback_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback);
    }
    
    @QtUninvokable
    private native void toPlainText_native_cref_QWebEngineCallback_constfct(long __this__nativeId, java.util.function.Consumer<String> resultCallback);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#url-prop">QWebEnginePage::url()const</a></p>
     */
    @QtPropertyReader(name="url")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.widgets.@Nullable QWidget view(){
        return view_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.widgets.QWidget view_native_constfct(long __this__nativeId);
    
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webchannel.@Nullable QWebChannel webChannel(){
        return webChannel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webchannel.QWebChannel webChannel_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #zoomFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZoomFactor() {
        return zoomFactor();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginepage.html#zoomFactor-prop">QWebEnginePage::zoomFactor()const</a></p>
     */
    @QtPropertyReader(name="zoomFactor")
    @QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected boolean acceptNavigationRequest(io.qt.core.@NonNull QUrl url, io.qt.webengine.widgets.QWebEnginePage.@NonNull NavigationType type, boolean isMainFrame){
        return acceptNavigationRequest_native_cref_QUrl_QWebEnginePage_NavigationType_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), type.value(), isMainFrame);
    }
    
    @QtUninvokable
    private native boolean acceptNavigationRequest_native_cref_QUrl_QWebEnginePage_NavigationType_bool(long __this__nativeId, long url, int type, boolean isMainFrame);
    
    @QtUninvokable
    protected boolean certificateError(io.qt.webengine.widgets.@NonNull QWebEngineCertificateError certificateError){
        return certificateError_native_cref_QWebEngineCertificateError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(certificateError));
    }
    
    @QtUninvokable
    private native boolean certificateError_native_cref_QWebEngineCertificateError(long __this__nativeId, long certificateError);
    
    @QtUninvokable
    protected java.util.@NonNull List<java.lang.@NonNull String> chooseFiles(io.qt.webengine.widgets.QWebEnginePage.@NonNull FileSelectionMode mode, java.util.@NonNull Collection<java.lang.@NonNull String> oldFiles, java.util.@NonNull Collection<java.lang.@NonNull String> acceptedMimeTypes){
        return chooseFiles_native_QWebEnginePage_FileSelectionMode_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value(), oldFiles, acceptedMimeTypes);
    }
    
    @QtUninvokable
    private native java.util.List<java.lang.String> chooseFiles_native_QWebEnginePage_FileSelectionMode_cref_QStringList_cref_QStringList(long __this__nativeId, int mode, java.util.Collection<java.lang.String> oldFiles, java.util.Collection<java.lang.String> acceptedMimeTypes);
    
    @QtUninvokable
    protected io.qt.webengine.widgets.@Nullable QWebEnginePage createWindow(io.qt.webengine.widgets.QWebEnginePage.@NonNull WebWindowType type){
        return createWindow_native_QWebEnginePage_WebWindowType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage createWindow_native_QWebEnginePage_WebWindowType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @QtUninvokable
    public boolean event(io.qt.core.@Nullable QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    @QtUninvokable
    protected void javaScriptAlert(io.qt.core.@NonNull QUrl securityOrigin, java.lang.@NonNull String msg){
        javaScriptAlert_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg);
    }
    
    @QtUninvokable
    private native void javaScriptAlert_native_cref_QUrl_cref_QString(long __this__nativeId, long securityOrigin, java.lang.String msg);
    
    @QtUninvokable
    protected boolean javaScriptConfirm(io.qt.core.@NonNull QUrl securityOrigin, java.lang.@NonNull String msg){
        return javaScriptConfirm_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg);
    }
    
    @QtUninvokable
    private native boolean javaScriptConfirm_native_cref_QUrl_cref_QString(long __this__nativeId, long securityOrigin, java.lang.String msg);
    
    @QtUninvokable
    protected void javaScriptConsoleMessage(io.qt.webengine.widgets.QWebEnginePage.@NonNull JavaScriptConsoleMessageLevel level, java.lang.@NonNull String message, int lineNumber, java.lang.@NonNull String sourceID){
        javaScriptConsoleMessage_native_QWebEnginePage_JavaScriptConsoleMessageLevel_cref_QString_int_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), level.value(), message, lineNumber, sourceID);
    }
    
    @QtUninvokable
    private native void javaScriptConsoleMessage_native_QWebEnginePage_JavaScriptConsoleMessageLevel_cref_QString_int_cref_QString(long __this__nativeId, int level, java.lang.String message, int lineNumber, java.lang.String sourceID);
    
    @QtUninvokable
    protected java.lang.@Nullable String javaScriptPrompt(io.qt.core.@NonNull QUrl securityOrigin, java.lang.@NonNull String msg, java.lang.@NonNull String defaultValue){
        return javaScriptPrompt_native_cref_QUrl_cref_QString_cref_QString_QString_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg, defaultValue);
    }
    
    @QtUninvokable
    private native java.lang.@Nullable String javaScriptPrompt_native_cref_QUrl_cref_QString_cref_QString_QString_ptr(long __this__nativeId, long securityOrigin, java.lang.String msg, java.lang.String defaultValue);
    
    /**
     * <p>Overloaded function for {@link #triggerAction(io.qt.webengine.widgets.QWebEnginePage.WebAction, boolean)}
     *  with <code>checked = false</code>.</p>
     */
    @QtUninvokable
    public final void triggerAction(io.qt.webengine.widgets.QWebEnginePage.@NonNull WebAction action) {
        triggerAction(action, (boolean)false);
    }
    
    @QtUninvokable
    public void triggerAction(io.qt.webengine.widgets.QWebEnginePage.@NonNull WebAction action, boolean checked){
        triggerAction_native_QWebEnginePage_WebAction_bool(QtJambi_LibraryUtilities.internal.nativeId(this), action.value(), checked);
    }
    
    @QtUninvokable
    private native void triggerAction_native_QWebEnginePage_WebAction_bool(long __this__nativeId, int action, boolean checked);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEnginePage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QWebEnginePage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWebEnginePage instance, QDeclarativeConstructor constructor);
    
}
