package io.qt.webengine.widgets;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class QWebEngineDownloadItem</p>
 */
public final class QWebEngineDownloadItem extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineDownloadItem.class);
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::DownloadInterruptReason</p>
     */
    public enum DownloadInterruptReason implements QtEnumerator {
        /**
         * <p>Representing QWebEngineDownloadItem::NoReason</p>
         */
        NoReason(0),
        /**
         * <p>Representing QWebEngineDownloadItem::FileFailed</p>
         */
        FileFailed(1),
        /**
         * <p>Representing QWebEngineDownloadItem::FileAccessDenied</p>
         */
        FileAccessDenied(2),
        /**
         * <p>Representing QWebEngineDownloadItem::FileNoSpace</p>
         */
        FileNoSpace(3),
        /**
         * <p>Representing QWebEngineDownloadItem::FileNameTooLong</p>
         */
        FileNameTooLong(5),
        /**
         * <p>Representing QWebEngineDownloadItem::FileTooLarge</p>
         */
        FileTooLarge(6),
        /**
         * <p>Representing QWebEngineDownloadItem::FileVirusInfected</p>
         */
        FileVirusInfected(7),
        /**
         * <p>Representing QWebEngineDownloadItem::FileTransientError</p>
         */
        FileTransientError(10),
        /**
         * <p>Representing QWebEngineDownloadItem::FileBlocked</p>
         */
        FileBlocked(11),
        /**
         * <p>Representing QWebEngineDownloadItem::FileSecurityCheckFailed</p>
         */
        FileSecurityCheckFailed(12),
        /**
         * <p>Representing QWebEngineDownloadItem::FileTooShort</p>
         */
        FileTooShort(13),
        /**
         * <p>Representing QWebEngineDownloadItem::FileHashMismatch</p>
         */
        FileHashMismatch(14),
        /**
         * <p>Representing QWebEngineDownloadItem::NetworkFailed</p>
         */
        NetworkFailed(20),
        /**
         * <p>Representing QWebEngineDownloadItem::NetworkTimeout</p>
         */
        NetworkTimeout(21),
        /**
         * <p>Representing QWebEngineDownloadItem::NetworkDisconnected</p>
         */
        NetworkDisconnected(22),
        /**
         * <p>Representing QWebEngineDownloadItem::NetworkServerDown</p>
         */
        NetworkServerDown(23),
        /**
         * <p>Representing QWebEngineDownloadItem::NetworkInvalidRequest</p>
         */
        NetworkInvalidRequest(24),
        /**
         * <p>Representing QWebEngineDownloadItem::ServerFailed</p>
         */
        ServerFailed(30),
        /**
         * <p>Representing QWebEngineDownloadItem::ServerBadContent</p>
         */
        ServerBadContent(33),
        /**
         * <p>Representing QWebEngineDownloadItem::ServerUnauthorized</p>
         */
        ServerUnauthorized(34),
        /**
         * <p>Representing QWebEngineDownloadItem::ServerCertProblem</p>
         */
        ServerCertProblem(35),
        /**
         * <p>Representing QWebEngineDownloadItem::ServerForbidden</p>
         */
        ServerForbidden(36),
        /**
         * <p>Representing QWebEngineDownloadItem::ServerUnreachable</p>
         */
        ServerUnreachable(37),
        /**
         * <p>Representing QWebEngineDownloadItem::UserCanceled</p>
         */
        UserCanceled(40);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadInterruptReason(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadInterruptReason resolve(int value) {
            switch (value) {
            case 0: return NoReason;
            case 1: return FileFailed;
            case 2: return FileAccessDenied;
            case 3: return FileNoSpace;
            case 5: return FileNameTooLong;
            case 6: return FileTooLarge;
            case 7: return FileVirusInfected;
            case 10: return FileTransientError;
            case 11: return FileBlocked;
            case 12: return FileSecurityCheckFailed;
            case 13: return FileTooShort;
            case 14: return FileHashMismatch;
            case 20: return NetworkFailed;
            case 21: return NetworkTimeout;
            case 22: return NetworkDisconnected;
            case 23: return NetworkServerDown;
            case 24: return NetworkInvalidRequest;
            case 30: return ServerFailed;
            case 33: return ServerBadContent;
            case 34: return ServerUnauthorized;
            case 35: return ServerCertProblem;
            case 36: return ServerForbidden;
            case 37: return ServerUnreachable;
            case 40: return UserCanceled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::DownloadState</p>
     */
    public enum DownloadState implements QtEnumerator {
        /**
         * <p>Representing QWebEngineDownloadItem::DownloadRequested</p>
         */
        DownloadRequested(0),
        /**
         * <p>Representing QWebEngineDownloadItem::DownloadInProgress</p>
         */
        DownloadInProgress(1),
        /**
         * <p>Representing QWebEngineDownloadItem::DownloadCompleted</p>
         */
        DownloadCompleted(2),
        /**
         * <p>Representing QWebEngineDownloadItem::DownloadCancelled</p>
         */
        DownloadCancelled(3),
        /**
         * <p>Representing QWebEngineDownloadItem::DownloadInterrupted</p>
         */
        DownloadInterrupted(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadState resolve(int value) {
            switch (value) {
            case 0: return DownloadRequested;
            case 1: return DownloadInProgress;
            case 2: return DownloadCompleted;
            case 3: return DownloadCancelled;
            case 4: return DownloadInterrupted;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::DownloadType</p>
     */
    public enum DownloadType implements QtEnumerator {
        /**
         * <p>Representing QWebEngineDownloadItem::Attachment</p>
         */
        Attachment(0),
        /**
         * <p>Representing QWebEngineDownloadItem::DownloadAttribute</p>
         */
        DownloadAttribute(1),
        /**
         * <p>Representing QWebEngineDownloadItem::UserRequested</p>
         */
        UserRequested(2),
        /**
         * <p>Representing QWebEngineDownloadItem::SavePage</p>
         */
        SavePage(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadType resolve(int value) {
            switch (value) {
            case 0: return Attachment;
            case 1: return DownloadAttribute;
            case 2: return UserRequested;
            case 3: return SavePage;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::SavePageFormat</p>
     */
    public enum SavePageFormat implements QtEnumerator {
        /**
         * <p>Representing QWebEngineDownloadItem::UnknownSaveFormat</p>
         */
        UnknownSaveFormat(-1),
        /**
         * <p>Representing QWebEngineDownloadItem::SingleHtmlSaveFormat</p>
         */
        SingleHtmlSaveFormat(0),
        /**
         * <p>Representing QWebEngineDownloadItem::CompleteHtmlSaveFormat</p>
         */
        CompleteHtmlSaveFormat(1),
        /**
         * <p>Representing QWebEngineDownloadItem::MimeHtmlSaveFormat</p>
         */
        MimeHtmlSaveFormat(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SavePageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SavePageFormat resolve(int value) {
            switch (value) {
            case -1: return UnknownSaveFormat;
            case 0: return SingleHtmlSaveFormat;
            case 1: return CompleteHtmlSaveFormat;
            case 2: return MimeHtmlSaveFormat;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    public final @NonNull Signal2<java.lang.@QtPrimitiveType@NonNull Long, java.lang.@QtPrimitiveType@NonNull Long> downloadProgress = new Signal2<>();

    public final @NonNull Signal0 finished = new Signal0();

    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> isPausedChanged = new Signal1<>();

    public final @NonNull Signal1<io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadState> stateChanged = new Signal1<>();
    
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    public final void cancel(){
        cancel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancel_native(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String downloadDirectory(){
        return downloadDirectory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadDirectory_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String downloadFileName(){
        return downloadFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadFileName_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadInterruptReason interruptReason(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadInterruptReason.resolve(interruptReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int interruptReason_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String interruptReasonString(){
        return interruptReasonString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String interruptReasonString_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final boolean isFinished(){
        return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFinished_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final boolean isPaused(){
        return isPaused_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPaused_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final boolean isSavePageDownload(){
        return isSavePageDownload_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSavePageDownload_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String mimeType(){
        return mimeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String mimeType_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.@Nullable QWebEnginePage page(){
        return page_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage page_native_constfct(long __this__nativeId);
    
    /**
     * @deprecated Use downloadDirectory() and downloadFileName() instead
     */
    @Deprecated
    @QtUninvokable
    public final java.lang.@NonNull String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    @QtUninvokable
    public final long receivedBytes(){
        return receivedBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long receivedBytes_native_constfct(long __this__nativeId);
    
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void resume_native(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull SavePageFormat savePageFormat(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat.resolve(savePageFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int savePageFormat_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void setDownloadDirectory(java.lang.@NonNull String directory){
        setDownloadDirectory_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), directory);
    }
    
    @QtUninvokable
    private native void setDownloadDirectory_native_cref_QString(long __this__nativeId, java.lang.String directory);
    
    @QtUninvokable
    public final void setDownloadFileName(java.lang.@NonNull String fileName){
        setDownloadFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setDownloadFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * @deprecated Use setDownloadDirectory() and setDownloadFileName() instead
     */
    @Deprecated
    @QtUninvokable
    public final void setPath(java.lang.@NonNull String path){
        setPath_native_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @Deprecated
    @QtUninvokable
    private native void setPath_native_QString(long __this__nativeId, java.lang.String path);
    
    @QtUninvokable
    public final void setSavePageFormat(io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull SavePageFormat format){
        setSavePageFormat_native_QWebEngineDownloadItem_SavePageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setSavePageFormat_native_QWebEngineDownloadItem_SavePageFormat(long __this__nativeId, int format);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadState state(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String suggestedFileName(){
        return suggestedFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String suggestedFileName_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final long totalBytes(){
        return totalBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long totalBytes_native_constfct(long __this__nativeId);
    
    @Deprecated
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.@NonNull DownloadType type(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineDownloadItem(QPrivateConstructor p) { super(p); } 
    
}
