package io.qt.webengine.widgets;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class QWebEngineContextMenuData</p>
 */
public class QWebEngineContextMenuData extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineContextMenuData.class);
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineContextMenuData::EditFlag</p>
     * 
     * @see EditFlags
     */
    public enum EditFlag implements QtFlagEnumerator {
        /**
         * <p>Representing QWebEngineContextMenuData::CanUndo</p>
         */
        CanUndo(1),
        /**
         * <p>Representing QWebEngineContextMenuData::CanRedo</p>
         */
        CanRedo(2),
        /**
         * <p>Representing QWebEngineContextMenuData::CanCut</p>
         */
        CanCut(4),
        /**
         * <p>Representing QWebEngineContextMenuData::CanCopy</p>
         */
        CanCopy(8),
        /**
         * <p>Representing QWebEngineContextMenuData::CanPaste</p>
         */
        CanPaste(16),
        /**
         * <p>Representing QWebEngineContextMenuData::CanDelete</p>
         */
        CanDelete(32),
        /**
         * <p>Representing QWebEngineContextMenuData::CanSelectAll</p>
         */
        CanSelectAll(64),
        /**
         * <p>Representing QWebEngineContextMenuData::CanTranslate</p>
         */
        CanTranslate(128),
        /**
         * <p>Representing QWebEngineContextMenuData::CanEditRichly</p>
         */
        CanEditRichly(256);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EditFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull EditFlags asFlags() {
            return new EditFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull EditFlags combined(@NonNull EditFlag e) {
            return new EditFlags(this, e);
        }

        /**
         * Creates a new {@link EditFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull EditFlags flags(@Nullable EditFlag @NonNull... values) {
            return new EditFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull EditFlag resolve(int value) {
            switch (value) {
            case 1: return CanUndo;
            case 2: return CanRedo;
            case 4: return CanCut;
            case 8: return CanCopy;
            case 16: return CanPaste;
            case 32: return CanDelete;
            case 64: return CanSelectAll;
            case 128: return CanTranslate;
            case 256: return CanEditRichly;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link EditFlag}
     */
    public static final class EditFlags extends QFlags<EditFlag> implements Comparable<EditFlags> {
        private static final long serialVersionUID = 0x6471c7474d16e451L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new EditFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public EditFlags(@Nullable EditFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new EditFlags with given <code>value</code>.
         * @param value
         */
        public EditFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new EditFlags
         */
        @Override
        public final @NonNull EditFlags combined(@StrictNonNull EditFlag e){
            return new EditFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull EditFlags setFlag(@Nullable EditFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull EditFlags setFlag(@Nullable EditFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this EditFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull EditFlag @NonNull[] flags(){
            return super.flags(EditFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull EditFlags clone(){
            return new EditFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull EditFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineContextMenuData::MediaFlag</p>
     * 
     * @see MediaFlags
     */
    public enum MediaFlag implements QtFlagEnumerator {
        /**
         * <p>Representing QWebEngineContextMenuData::MediaInError</p>
         */
        MediaInError(1),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaPaused</p>
         */
        MediaPaused(2),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaMuted</p>
         */
        MediaMuted(4),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaLoop</p>
         */
        MediaLoop(8),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaCanSave</p>
         */
        MediaCanSave(16),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaHasAudio</p>
         */
        MediaHasAudio(32),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaCanToggleControls</p>
         */
        MediaCanToggleControls(64),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaControls</p>
         */
        MediaControls(128),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaCanPrint</p>
         */
        MediaCanPrint(256),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaCanRotate</p>
         */
        MediaCanRotate(512);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MediaFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull MediaFlags asFlags() {
            return new MediaFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull MediaFlags combined(@NonNull MediaFlag e) {
            return new MediaFlags(this, e);
        }

        /**
         * Creates a new {@link MediaFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull MediaFlags flags(@Nullable MediaFlag @NonNull... values) {
            return new MediaFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MediaFlag resolve(int value) {
            switch (value) {
            case 1: return MediaInError;
            case 2: return MediaPaused;
            case 4: return MediaMuted;
            case 8: return MediaLoop;
            case 16: return MediaCanSave;
            case 32: return MediaHasAudio;
            case 64: return MediaCanToggleControls;
            case 128: return MediaControls;
            case 256: return MediaCanPrint;
            case 512: return MediaCanRotate;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link MediaFlag}
     */
    public static final class MediaFlags extends QFlags<MediaFlag> implements Comparable<MediaFlags> {
        private static final long serialVersionUID = 0xa5bae86f204e2f26L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new MediaFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public MediaFlags(@Nullable MediaFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new MediaFlags with given <code>value</code>.
         * @param value
         */
        public MediaFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new MediaFlags
         */
        @Override
        public final @NonNull MediaFlags combined(@StrictNonNull MediaFlag e){
            return new MediaFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull MediaFlags setFlag(@Nullable MediaFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull MediaFlags setFlag(@Nullable MediaFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this MediaFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull MediaFlag @NonNull[] flags(){
            return super.flags(MediaFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull MediaFlags clone(){
            return new MediaFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull MediaFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineContextMenuData::MediaType</p>
     */
    public enum MediaType implements QtEnumerator {
        /**
         * <p>Representing QWebEngineContextMenuData::MediaTypeNone</p>
         */
        MediaTypeNone(0),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaTypeImage</p>
         */
        MediaTypeImage(1),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaTypeVideo</p>
         */
        MediaTypeVideo(2),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaTypeAudio</p>
         */
        MediaTypeAudio(3),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaTypeCanvas</p>
         */
        MediaTypeCanvas(4),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaTypeFile</p>
         */
        MediaTypeFile(5),
        /**
         * <p>Representing QWebEngineContextMenuData::MediaTypePlugin</p>
         */
        MediaTypePlugin(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MediaType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MediaType resolve(int value) {
            switch (value) {
            case 0: return MediaTypeNone;
            case 1: return MediaTypeImage;
            case 2: return MediaTypeVideo;
            case 3: return MediaTypeAudio;
            case 4: return MediaTypeCanvas;
            case 5: return MediaTypeFile;
            case 6: return MediaTypePlugin;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QWebEngineContextMenuData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QWebEngineContextMenuData instance);
    
    public QWebEngineContextMenuData(io.qt.webengine.widgets.@NonNull QWebEngineContextMenuData other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineContextMenuData instance, io.qt.webengine.widgets.QWebEngineContextMenuData other);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineContextMenuData.@NonNull EditFlags editFlags(){
        return new io.qt.webengine.widgets.QWebEngineContextMenuData.EditFlags(editFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int editFlags_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final boolean isContentEditable(){
        return isContentEditable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isContentEditable_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String linkText(){
        return linkText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String linkText_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl linkUrl(){
        return linkUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl linkUrl_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineContextMenuData.@NonNull MediaFlags mediaFlags(){
        return new io.qt.webengine.widgets.QWebEngineContextMenuData.MediaFlags(mediaFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mediaFlags_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineContextMenuData.@NonNull MediaType mediaType(){
        return io.qt.webengine.widgets.QWebEngineContextMenuData.MediaType.resolve(mediaType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mediaType_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl mediaUrl(){
        return mediaUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl mediaUrl_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String misspelledWord(){
        return misspelledWord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String misspelledWord_native_constfct(long __this__nativeId);
    
    /**
     * @deprecated Use {@link #assign(io.qt.webengine.widgets.QWebEngineContextMenuData)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.webengine.widgets.@NonNull QWebEngineContextMenuData other) {
        assign(other);
    }
    
    @QtUninvokable
    public final void assign(io.qt.webengine.widgets.@NonNull QWebEngineContextMenuData other){
        assign_native_cref_QWebEngineContextMenuData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineContextMenuData(long __this__nativeId, long other);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.webengine.widgets.@NonNull QWebEngineContextMenuData arg2){
        return operator_equal_native_cref_QWebEngineContextMenuData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg2));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineContextMenuData(long __this__nativeId, long arg2);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint position_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final java.lang.@NonNull String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList spellCheckerSuggestions(){
        return spellCheckerSuggestions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList spellCheckerSuggestions_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineContextMenuData(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.widgets.QWebEngineContextMenuData) {
            return operator_equal((io.qt.webengine.widgets.QWebEngineContextMenuData) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QWebEngineContextMenuData clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineContextMenuData clone_native(long __this_nativeId);
}
