package io.qt.webengine.widgets;


/**
 * <p>Widget that is used to view and edit web documents</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qwebengineview.html">QWebEngineView</a></p>
 */
public class QWebEngineView extends io.qt.widgets.QWidget
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineView.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#icon-prop">QWebEngineView::iconChanged(QIcon)</a></p>
     */
    @io.qt.QtPropertyNotify(name="icon")
    public final Signal1<io.qt.gui.QIcon> iconChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#iconUrl-prop">QWebEngineView::iconUrlChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="iconUrl")
    public final Signal1<io.qt.core.QUrl> iconUrlChanged = new Signal1<>();

    public final Signal1<@io.qt.QtPrimitiveType Boolean> loadFinished = new Signal1<>();

    public final Signal1<@io.qt.QtPrimitiveType Integer> loadProgress = new Signal1<>();

    public final Signal0 loadStarted = new Signal0();

    public final Signal2<io.qt.webengine.widgets.QWebEnginePage.RenderProcessTerminationStatus, @io.qt.QtPrimitiveType Integer> renderProcessTerminated = new Signal2<>();

    public final Signal0 selectionChanged = new Signal0();

    public final Signal1<java.lang.String> titleChanged = new Signal1<>();

    public final Signal1<io.qt.core.QUrl> urlChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineView(io.qt.widgets.QWidget)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEngineView() {
        this((io.qt.widgets.QWidget)null);
    }
    
    public QWebEngineView(io.qt.widgets.QWidget parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWebEngineView instance, io.qt.widgets.QWidget parent);
    
    public final void back(){
        back_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void back_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.widgets.QWebEnginePage.FindFlags, java.util.function.Consumer)}
     *  with <code>resultCallback = null</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void findText(java.lang.String subString, io.qt.webengine.widgets.QWebEnginePage.FindFlags options) {
        findText(subString, options, (java.util.function.Consumer<Boolean>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.widgets.QWebEnginePage.FindFlags, java.util.function.Consumer)}</p>
     * <p>with: </p><ul>
     * <li><code>options = new io.qt.webengine.widgets.QWebEnginePage.FindFlags(0)</code></li>
     * <li><code>resultCallback = null</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void findText(java.lang.String subString) {
        findText(subString, new io.qt.webengine.widgets.QWebEnginePage.FindFlags(0), (java.util.function.Consumer<Boolean>)null);
    }
    
    @io.qt.QtUninvokable
    public final void findText(java.lang.String subString, io.qt.webengine.widgets.QWebEnginePage.FindFlags options, java.util.function.Consumer<Boolean> resultCallback){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        findText_native_cref_QString_QFlags_QWebEnginePage_FindFlag__cref_QWebEngineCallback(QtJambi_LibraryUtilities.internal.nativeId(this), subString, options.value(), resultCallback);
    }
    
    @io.qt.QtUninvokable
    private native void findText_native_cref_QString_QFlags_QWebEnginePage_FindFlag__cref_QWebEngineCallback(long __this__nativeId, java.lang.String subString, int options, java.util.function.Consumer<Boolean> resultCallback);
    
    public final void forward(){
        forward_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void forward_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#hasSelection-prop">QWebEngineView::hasSelection()const</a></p>
     */
    @io.qt.QtPropertyReader(name="hasSelection")
    @io.qt.QtUninvokable
    public final boolean hasSelection(){
        return hasSelection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasSelection_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineHistory history(){
        return history_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineHistory history_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#icon-prop">QWebEngineView::icon()const</a></p>
     */
    @io.qt.QtPropertyReader(name="icon")
    @io.qt.QtUninvokable
    public final io.qt.gui.QIcon icon(){
        return icon_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#iconUrl-prop">QWebEngineView::iconUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="iconUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl iconUrl(){
        return iconUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl iconUrl_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void load(io.qt.core.QUrl url){
        load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void load_native_cref_QUrl(long __this__nativeId, long url);
    
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void load(io.qt.webengine.core.QWebEngineHttpRequest request){
        load_native_cref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    @io.qt.QtUninvokable
    private native void load_native_cref_QWebEngineHttpRequest(long __this__nativeId, long request);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage page(){
        return page_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage page_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.widgets.QAction pageAction(io.qt.webengine.widgets.QWebEnginePage.WebAction action){
        return pageAction_native_QWebEnginePage_WebAction_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), action.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.widgets.QAction pageAction_native_QWebEnginePage_WebAction_constfct(long __this__nativeId, int action);
    
    public final void reload(){
        reload_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reload_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#selectedText-prop">QWebEngineView::selectedText()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedText")
    @io.qt.QtUninvokable
    public final java.lang.String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setContent(io.qt.core.QByteArray data, java.lang.String mimeType) {
        setContent(data, mimeType, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}</p>
     * <p>with: </p><ul>
     * <li><code>mimeType = (String)null</code></li>
     * <li><code>baseUrl = new io.qt.core.QUrl()</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void setContent(io.qt.core.QByteArray data) {
        setContent(data, (String)null, new io.qt.core.QUrl());
    }
    
    @io.qt.QtUninvokable
    public final void setContent(io.qt.core.QByteArray data, java.lang.String mimeType, io.qt.core.QUrl baseUrl){
        setContent_native_cref_QByteArray_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), mimeType, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @io.qt.QtUninvokable
    private native void setContent_native_cref_QByteArray_cref_QString_cref_QUrl(long __this__nativeId, long data, java.lang.String mimeType, long baseUrl);
    
    /**
     * <p>Overloaded function for {@link #setHtml(java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setHtml(java.lang.String html) {
        setHtml(html, new io.qt.core.QUrl());
    }
    
    @io.qt.QtUninvokable
    public final void setHtml(java.lang.String html, io.qt.core.QUrl baseUrl){
        setHtml_native_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), html, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @io.qt.QtUninvokable
    private native void setHtml_native_cref_QString_cref_QUrl(long __this__nativeId, java.lang.String html, long baseUrl);
    
    @io.qt.QtUninvokable
    public final void setPage(io.qt.webengine.widgets.QWebEnginePage page){
        setPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
    }
    
    @io.qt.QtUninvokable
    private native void setPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#url-prop">QWebEngineView::setUrl(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="url")
    @io.qt.QtUninvokable
    public final void setUrl(io.qt.core.QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#zoomFactor-prop">QWebEngineView::setZoomFactor(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="zoomFactor")
    @io.qt.QtUninvokable
    public final void setZoomFactor(double factor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @io.qt.QtUninvokable
    private native void setZoomFactor_native_qreal(long __this__nativeId, double factor);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineSettings settings(){
        return settings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineSettings settings_native_constfct(long __this__nativeId);
    
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#title-prop">QWebEngineView::title()const</a></p>
     */
    @io.qt.QtPropertyReader(name="title")
    @io.qt.QtUninvokable
    public final java.lang.String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #triggerPageAction(io.qt.webengine.widgets.QWebEnginePage.WebAction, boolean)}
     *  with <code>checked = false</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void triggerPageAction(io.qt.webengine.widgets.QWebEnginePage.WebAction action) {
        triggerPageAction(action, (boolean)false);
    }
    
    @io.qt.QtUninvokable
    public final void triggerPageAction(io.qt.webengine.widgets.QWebEnginePage.WebAction action, boolean checked){
        triggerPageAction_native_QWebEnginePage_WebAction_bool(QtJambi_LibraryUtilities.internal.nativeId(this), action.value(), checked);
    }
    
    @io.qt.QtUninvokable
    private native void triggerPageAction_native_QWebEnginePage_WebAction_bool(long __this__nativeId, int action, boolean checked);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#url-prop">QWebEngineView::url()const</a></p>
     */
    @io.qt.QtPropertyReader(name="url")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineview.html#zoomFactor-prop">QWebEngineView::zoomFactor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="zoomFactor")
    @io.qt.QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#closeEvent">QWidget::closeEvent(QCloseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void closeEvent(io.qt.gui.QCloseEvent arg__1){
        closeEvent_native_QCloseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void closeEvent_native_QCloseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#contextMenuEvent">QWidget::contextMenuEvent(QContextMenuEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void contextMenuEvent(io.qt.gui.QContextMenuEvent arg__1){
        contextMenuEvent_native_QContextMenuEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void contextMenuEvent_native_QContextMenuEvent_ptr(long __this__nativeId, long arg__1);
    
    @io.qt.QtUninvokable
    protected io.qt.webengine.widgets.QWebEngineView createWindow(io.qt.webengine.widgets.QWebEnginePage.WebWindowType type){
        return createWindow_native_QWebEnginePage_WebWindowType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEngineView createWindow_native_QWebEnginePage_WebWindowType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#dragEnterEvent">QWidget::dragEnterEvent(QDragEnterEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dragEnterEvent(io.qt.gui.QDragEnterEvent e){
        dragEnterEvent_native_QDragEnterEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void dragEnterEvent_native_QDragEnterEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#dragLeaveEvent">QWidget::dragLeaveEvent(QDragLeaveEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dragLeaveEvent(io.qt.gui.QDragLeaveEvent e){
        dragLeaveEvent_native_QDragLeaveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void dragLeaveEvent_native_QDragLeaveEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#dragMoveEvent">QWidget::dragMoveEvent(QDragMoveEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dragMoveEvent(io.qt.gui.QDragMoveEvent e){
        dragMoveEvent_native_QDragMoveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void dragMoveEvent_native_QDragMoveEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#dropEvent">QWidget::dropEvent(QDropEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dropEvent(io.qt.gui.QDropEvent e){
        dropEvent_native_QDropEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void dropEvent_native_QDropEvent_ptr(long __this__nativeId, long e);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#hideEvent">QWidget::hideEvent(QHideEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void hideEvent(io.qt.gui.QHideEvent arg__1){
        hideEvent_native_QHideEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void hideEvent_native_QHideEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#showEvent">QWidget::showEvent(QShowEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void showEvent(io.qt.gui.QShowEvent arg__1){
        showEvent_native_QShowEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void showEvent_native_QShowEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwidget.html#sizeHint-prop">QWidget::sizeHint()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineView(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QWebEngineView(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QWebEngineView instance, QDeclarativeConstructor constructor);
    
}
