package io.qt.webengine.widgets;


/**
 * <p>Java wrapper for Qt class QWebEngineDownloadItem</p>
 */
public final class QWebEngineDownloadItem extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineDownloadItem.class);
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::DownloadInterruptReason</p>
     */
    public enum DownloadInterruptReason implements io.qt.QtEnumerator {
        NoReason(0),
        FileFailed(1),
        FileAccessDenied(2),
        FileNoSpace(3),
        FileNameTooLong(5),
        FileTooLarge(6),
        FileVirusInfected(7),
        FileTransientError(10),
        FileBlocked(11),
        FileSecurityCheckFailed(12),
        FileTooShort(13),
        FileHashMismatch(14),
        NetworkFailed(20),
        NetworkTimeout(21),
        NetworkDisconnected(22),
        NetworkServerDown(23),
        NetworkInvalidRequest(24),
        ServerFailed(30),
        ServerBadContent(33),
        ServerUnauthorized(34),
        ServerCertProblem(35),
        ServerForbidden(36),
        ServerUnreachable(37),
        UserCanceled(40);

        private DownloadInterruptReason(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DownloadInterruptReason resolve(int value) {
            switch (value) {
            case 0: return NoReason;
            case 1: return FileFailed;
            case 2: return FileAccessDenied;
            case 3: return FileNoSpace;
            case 5: return FileNameTooLong;
            case 6: return FileTooLarge;
            case 7: return FileVirusInfected;
            case 10: return FileTransientError;
            case 11: return FileBlocked;
            case 12: return FileSecurityCheckFailed;
            case 13: return FileTooShort;
            case 14: return FileHashMismatch;
            case 20: return NetworkFailed;
            case 21: return NetworkTimeout;
            case 22: return NetworkDisconnected;
            case 23: return NetworkServerDown;
            case 24: return NetworkInvalidRequest;
            case 30: return ServerFailed;
            case 33: return ServerBadContent;
            case 34: return ServerUnauthorized;
            case 35: return ServerCertProblem;
            case 36: return ServerForbidden;
            case 37: return ServerUnreachable;
            case 40: return UserCanceled;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::DownloadState</p>
     */
    public enum DownloadState implements io.qt.QtEnumerator {
        DownloadRequested(0),
        DownloadInProgress(1),
        DownloadCompleted(2),
        DownloadCancelled(3),
        DownloadInterrupted(4);

        private DownloadState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DownloadState resolve(int value) {
            switch (value) {
            case 0: return DownloadRequested;
            case 1: return DownloadInProgress;
            case 2: return DownloadCompleted;
            case 3: return DownloadCancelled;
            case 4: return DownloadInterrupted;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::DownloadType</p>
     */
    public enum DownloadType implements io.qt.QtEnumerator {
        Attachment(0),
        DownloadAttribute(1),
        UserRequested(2),
        SavePage(3);

        private DownloadType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DownloadType resolve(int value) {
            switch (value) {
            case 0: return Attachment;
            case 1: return DownloadAttribute;
            case 2: return UserRequested;
            case 3: return SavePage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineDownloadItem::SavePageFormat</p>
     */
    public enum SavePageFormat implements io.qt.QtEnumerator {
        UnknownSaveFormat(-1),
        SingleHtmlSaveFormat(0),
        CompleteHtmlSaveFormat(1),
        MimeHtmlSaveFormat(2);

        private SavePageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SavePageFormat resolve(int value) {
            switch (value) {
            case -1: return UnknownSaveFormat;
            case 0: return SingleHtmlSaveFormat;
            case 1: return CompleteHtmlSaveFormat;
            case 2: return MimeHtmlSaveFormat;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    public final Signal2<@io.qt.QtPrimitiveType Long, @io.qt.QtPrimitiveType Long> downloadProgress = new Signal2<>();

    public final Signal0 finished = new Signal0();

    public final Signal1<@io.qt.QtPrimitiveType Boolean> isPausedChanged = new Signal1<>();

    public final Signal1<io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadState> stateChanged = new Signal1<>();
    
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    public final void cancel(){
        cancel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancel_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String downloadDirectory(){
        return downloadDirectory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String downloadDirectory_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String downloadFileName(){
        return downloadFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String downloadFileName_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadInterruptReason interruptReason(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadInterruptReason.resolve(interruptReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int interruptReason_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String interruptReasonString(){
        return interruptReasonString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String interruptReasonString_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isFinished(){
        return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFinished_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isPaused(){
        return isPaused_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPaused_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isSavePageDownload(){
        return isSavePageDownload_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSavePageDownload_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String mimeType(){
        return mimeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String mimeType_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEnginePage page(){
        return page_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.widgets.QWebEnginePage page_native_constfct(long __this__nativeId);
    
    /**
     * @deprecated Use downloadDirectory() and downloadFileName() instead
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final java.lang.String path(){
        return path_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native java.lang.String path_native_constfct(long __this__nativeId);
    
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final long receivedBytes(){
        return receivedBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long receivedBytes_native_constfct(long __this__nativeId);
    
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void resume_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat savePageFormat(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat.resolve(savePageFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int savePageFormat_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void setDownloadDirectory(java.lang.String directory){
        setDownloadDirectory_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), directory);
    }
    
    @io.qt.QtUninvokable
    private native void setDownloadDirectory_native_cref_QString(long __this__nativeId, java.lang.String directory);
    
    @io.qt.QtUninvokable
    public final void setDownloadFileName(java.lang.String fileName){
        setDownloadFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native void setDownloadFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * @deprecated Use setDownloadDirectory() and setDownloadFileName() instead
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setPath(java.lang.String path){
        setPath_native_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setPath_native_QString(long __this__nativeId, java.lang.String path);
    
    @io.qt.QtUninvokable
    public final void setSavePageFormat(io.qt.webengine.widgets.QWebEngineDownloadItem.SavePageFormat format){
        setSavePageFormat_native_QWebEngineDownloadItem_SavePageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @io.qt.QtUninvokable
    private native void setSavePageFormat_native_QWebEngineDownloadItem_SavePageFormat(long __this__nativeId, int format);
    
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadState state(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final java.lang.String suggestedFileName(){
        return suggestedFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String suggestedFileName_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final long totalBytes(){
        return totalBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long totalBytes_native_constfct(long __this__nativeId);
    
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadType type(){
        return io.qt.webengine.widgets.QWebEngineDownloadItem.DownloadType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineDownloadItem(QPrivateConstructor p) { super(p); } 
    
}
