package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Encapsulates the data of a WebAuth UX request</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html">QWebEngineWebAuthUxRequest</a></code></p>
 * <p>This class was introduced in Qt 6.7.</p>
 */
public final class QWebEngineWebAuthUxRequest extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineWebAuthUxRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryError-enum">QWebEngineWebAuthUxRequest::PinEntryError</a></code></p>
     */
    public enum PinEntryError implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryError-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryError::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryError-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryError::<wbr/>InternalUvLocked</a></code></p>
         */
        InternalUvLocked(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryError-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryError::<wbr/>WrongPin</a></code></p>
         */
        WrongPin(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryError-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryError::<wbr/>TooShort</a></code></p>
         */
        TooShort(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryError-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryError::<wbr/>InvalidCharacters</a></code></p>
         */
        InvalidCharacters(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryError-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryError::<wbr/>SameAsCurrentPin</a></code></p>
         */
        SameAsCurrentPin(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PinEntryError(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PinEntryError resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return InternalUvLocked;
            case 2: return WrongPin;
            case 3: return TooShort;
            case 4: return InvalidCharacters;
            case 5: return SameAsCurrentPin;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryReason-enum">QWebEngineWebAuthUxRequest::PinEntryReason</a></code></p>
     */
    public enum PinEntryReason implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryReason-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryReason::<wbr/>Set</a></code></p>
         */
        Set(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryReason-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryReason::<wbr/>Change</a></code></p>
         */
        Change(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#PinEntryReason-enum">QWebEngineWebAuthUxRequest::<wbr/>PinEntryReason::<wbr/>Challenge</a></code></p>
         */
        Challenge(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PinEntryReason(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PinEntryReason resolve(int value) {
            switch (value) {
            case 0: return Set;
            case 1: return Change;
            case 2: return Challenge;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::RequestFailureReason</a></code></p>
     */
    public enum RequestFailureReason implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>Timeout</a></code></p>
         */
        Timeout(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>KeyNotRegistered</a></code></p>
         */
        KeyNotRegistered(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>KeyAlreadyRegistered</a></code></p>
         */
        KeyAlreadyRegistered(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>SoftPinBlock</a></code></p>
         */
        SoftPinBlock(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>HardPinBlock</a></code></p>
         */
        HardPinBlock(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>AuthenticatorRemovedDuringPinEntry</a></code></p>
         */
        AuthenticatorRemovedDuringPinEntry(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>AuthenticatorMissingResidentKeys</a></code></p>
         */
        AuthenticatorMissingResidentKeys(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>AuthenticatorMissingUserVerification</a></code></p>
         */
        AuthenticatorMissingUserVerification(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>AuthenticatorMissingLargeBlob</a></code></p>
         */
        AuthenticatorMissingLargeBlob(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>NoCommonAlgorithms</a></code></p>
         */
        NoCommonAlgorithms(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>StorageFull</a></code></p>
         */
        StorageFull(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>UserConsentDenied</a></code></p>
         */
        UserConsentDenied(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#RequestFailureReason-enum">QWebEngineWebAuthUxRequest::<wbr/>RequestFailureReason::<wbr/>WinUserCancelled</a></code></p>
         */
        WinUserCancelled(12);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RequestFailureReason(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RequestFailureReason resolve(int value) {
            switch (value) {
            case 0: return Timeout;
            case 1: return KeyNotRegistered;
            case 2: return KeyAlreadyRegistered;
            case 3: return SoftPinBlock;
            case 4: return HardPinBlock;
            case 5: return AuthenticatorRemovedDuringPinEntry;
            case 6: return AuthenticatorMissingResidentKeys;
            case 7: return AuthenticatorMissingUserVerification;
            case 8: return AuthenticatorMissingLargeBlob;
            case 9: return NoCommonAlgorithms;
            case 10: return StorageFull;
            case 11: return UserConsentDenied;
            case 12: return WinUserCancelled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::WebAuthUxState</a></code></p>
     */
    public enum WebAuthUxState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::<wbr/>WebAuthUxState::<wbr/>NotStarted</a></code></p>
         */
        NotStarted(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::<wbr/>WebAuthUxState::<wbr/>SelectAccount</a></code></p>
         */
        SelectAccount(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::<wbr/>WebAuthUxState::<wbr/>CollectPin</a></code></p>
         */
        CollectPin(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::<wbr/>WebAuthUxState::<wbr/>FinishTokenCollection</a></code></p>
         */
        FinishTokenCollection(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::<wbr/>WebAuthUxState::<wbr/>RequestFailed</a></code></p>
         */
        RequestFailed(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::<wbr/>WebAuthUxState::<wbr/>Cancelled</a></code></p>
         */
        Cancelled(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#WebAuthUxState-enum">QWebEngineWebAuthUxRequest::<wbr/>WebAuthUxState::<wbr/>Completed</a></code></p>
         */
        Completed(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebAuthUxState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WebAuthUxState resolve(int value) {
            switch (value) {
            case 0: return NotStarted;
            case 1: return SelectAccount;
            case 2: return CollectPin;
            case 3: return FinishTokenCollection;
            case 4: return RequestFailed;
            case 5: return Cancelled;
            case 6: return Completed;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#stateChanged">QWebEngineWebAuthUxRequest::<wbr/>stateChanged(QWebEngineWebAuthUxRequest::WebAuthUxState)</a></code></p>
     */
    @QtPropertyNotify(name="state")
    public final @NonNull Signal1<io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull WebAuthUxState> stateChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#cancel">QWebEngineWebAuthUxRequest::<wbr/>cancel()</a></code></p>
     */
    public final void cancel(){
        cancel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancel_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#pinRequest-prop">QWebEngineWebAuthUxRequest::<wbr/>pinRequest()const</a></code></p>
     */
    @QtPropertyReader(name="pinRequest")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.@NonNull QWebEngineWebAuthPinRequest pinRequest(){
        return pinRequest_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineWebAuthPinRequest pinRequest_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#relyingPartyId-prop">QWebEngineWebAuthUxRequest::<wbr/>relyingPartyId()const</a></code></p>
     */
    @QtPropertyReader(name="relyingPartyId")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String relyingPartyId(){
        return relyingPartyId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String relyingPartyId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#requestFailureReason-prop">QWebEngineWebAuthUxRequest::<wbr/>requestFailureReason()const</a></code></p>
     */
    @QtPropertyReader(name="requestFailureReason")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull RequestFailureReason requestFailureReason(){
        return io.qt.webengine.core.QWebEngineWebAuthUxRequest.RequestFailureReason.resolve(requestFailureReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int requestFailureReason_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#retry">QWebEngineWebAuthUxRequest::<wbr/>retry()</a></code></p>
     */
    public final void retry(){
        retry_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void retry_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#setPin">QWebEngineWebAuthUxRequest::<wbr/>setPin(QString)</a></code></p>
     */
    public final void setPin(java.lang.@NonNull String pin){
        setPin_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), pin);
    }
    
    private native void setPin_native_cref_QString(long __this__nativeId, java.lang.String pin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#setSelectedAccount">QWebEngineWebAuthUxRequest::<wbr/>setSelectedAccount(QString)</a></code></p>
     */
    public final void setSelectedAccount(java.lang.@NonNull String selectedAccount){
        setSelectedAccount_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), selectedAccount);
    }
    
    private native void setSelectedAccount_native_cref_QString(long __this__nativeId, java.lang.String selectedAccount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#state-prop">QWebEngineWebAuthUxRequest::<wbr/>state()const</a></code></p>
     */
    @QtPropertyReader(name="state")
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull WebAuthUxState state(){
        return io.qt.webengine.core.QWebEngineWebAuthUxRequest.WebAuthUxState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginewebauthuxrequest.html#userNames-prop">QWebEngineWebAuthUxRequest::<wbr/>userNames()const</a></code></p>
     */
    @QtPropertyReader(name="userNames")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList userNames(){
        return userNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList userNames_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    private QWebEngineWebAuthUxRequest(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #pinRequest()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.@NonNull QWebEngineWebAuthPinRequest getPinRequest() {
        return pinRequest();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #relyingPartyId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRelyingPartyId() {
        return relyingPartyId();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #requestFailureReason()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull RequestFailureReason getRequestFailureReason() {
        return requestFailureReason();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #state()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull WebAuthUxState getState() {
        return state();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #userNames()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getUserNames() {
        return userNames();
    }
}
