package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Encapsulates the data of a PIN WebAuth UX request</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginewebauthpinrequest.html">QWebEngineWebAuthPinRequest</a></code></p>
 * <p>This class was introduced in Qt 6.7.</p>
 */
public class QWebEngineWebAuthPinRequest extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineWebAuthPinRequest.class);
    
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>QWebEngineWebAuthPinRequest()</code></p>
     */
    public QWebEngineWebAuthPinRequest(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QWebEngineWebAuthPinRequest instance);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>QWebEngineWebAuthPinRequest(QWebEngineWebAuthPinRequest)</code></p>
     */
    public QWebEngineWebAuthPinRequest(io.qt.webengine.core.@StrictNonNull QWebEngineWebAuthPinRequest other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineWebAuthPinRequest instance, io.qt.webengine.core.QWebEngineWebAuthPinRequest other);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>QWebEngineWebAuthPinRequest{QWebEngineWebAuthUxRequest::PinEntryReason,<wbr/>QWebEngineWebAuthUxRequest::PinEntryError,<wbr/>qint32,<wbr/>int}</code></p>
     */
    public QWebEngineWebAuthPinRequest(io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryReason reason, io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryError error, int minPinLength, int remainingAttempts){
        super((QPrivateConstructor)null);
        initialize_native(this, reason, error, minPinLength, remainingAttempts);
    }
    
    private native static void initialize_native(QWebEngineWebAuthPinRequest instance, io.qt.webengine.core.QWebEngineWebAuthUxRequest.PinEntryReason reason, io.qt.webengine.core.QWebEngineWebAuthUxRequest.PinEntryError error, int minPinLength, int remainingAttempts);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>error</code></p>
     */
    @QtPropertyWriter(name="error")
    @QtUninvokable
    public final void setError(io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryError error){
        setError_native_cref_QWebEngineWebAuthUxRequest_PinEntryError(QtJambi_LibraryUtilities.internal.nativeId(this), error.value());
    }
    
    @QtUninvokable
    private native void setError_native_cref_QWebEngineWebAuthUxRequest_PinEntryError(long __this__nativeId, int error);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>error</code></p>
     */
    @QtPropertyReader(name="error")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryError error(){
        return io.qt.webengine.core.QWebEngineWebAuthUxRequest.PinEntryError.resolve(error_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int error_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>minPinLength</code></p>
     */
    @QtPropertyWriter(name="minPinLength")
    @QtUninvokable
    public final void setMinPinLength(int minPinLength){
        setMinPinLength_native_qint32(QtJambi_LibraryUtilities.internal.nativeId(this), minPinLength);
    }
    
    @QtUninvokable
    private native void setMinPinLength_native_qint32(long __this__nativeId, int minPinLength);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>minPinLength</code></p>
     */
    @QtPropertyReader(name="minPinLength")
    @QtPropertyConstant
    @QtUninvokable
    public final int minPinLength(){
        return minPinLength_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minPinLength_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>reason</code></p>
     */
    @QtPropertyWriter(name="reason")
    @QtUninvokable
    public final void setReason(io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryReason reason){
        setReason_native_cref_QWebEngineWebAuthUxRequest_PinEntryReason(QtJambi_LibraryUtilities.internal.nativeId(this), reason.value());
    }
    
    @QtUninvokable
    private native void setReason_native_cref_QWebEngineWebAuthUxRequest_PinEntryReason(long __this__nativeId, int reason);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>reason</code></p>
     */
    @QtPropertyReader(name="reason")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryReason reason(){
        return io.qt.webengine.core.QWebEngineWebAuthUxRequest.PinEntryReason.resolve(reason_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int reason_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>remainingAttempts</code></p>
     */
    @QtPropertyWriter(name="remainingAttempts")
    @QtUninvokable
    public final void setRemainingAttempts(int remainingAttempts){
        setRemainingAttempts_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), remainingAttempts);
    }
    
    @QtUninvokable
    private native void setRemainingAttempts_native_int(long __this__nativeId, int remainingAttempts);
    
    /**
     * <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>remainingAttempts</code></p>
     */
    @QtPropertyReader(name="remainingAttempts")
    @QtPropertyConstant
    @QtUninvokable
    public final int remainingAttempts(){
        return remainingAttempts_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int remainingAttempts_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineWebAuthPinRequest(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QWebEngineWebAuthPinRequest::<wbr/>QWebEngineWebAuthPinRequest(QWebEngineWebAuthPinRequest)</code></p>
     */
    @QtUninvokable
    @Override
    public QWebEngineWebAuthPinRequest clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineWebAuthPinRequest clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #error()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryError getError() {
        return error();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #minPinLength()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMinPinLength() {
        return minPinLength();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #reason()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineWebAuthUxRequest.@NonNull PinEntryReason getReason() {
        return reason();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #remainingAttempts()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getRemainingAttempts() {
        return remainingAttempts();
    }
}
