package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Information about URL requests</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html">QWebEngineUrlRequestInfo</a></code></p>
 */
public final class QWebEngineUrlRequestInfo extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationType</a></code></p>
     */
    public enum NavigationType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::<wbr/>NavigationTypeLink</a></code></p>
         */
        NavigationTypeLink(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::<wbr/>NavigationTypeTyped</a></code></p>
         */
        NavigationTypeTyped(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::<wbr/>NavigationTypeFormSubmitted</a></code></p>
         */
        NavigationTypeFormSubmitted(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::<wbr/>NavigationTypeBackForward</a></code></p>
         */
        NavigationTypeBackForward(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::<wbr/>NavigationTypeReload</a></code></p>
         */
        NavigationTypeReload(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::<wbr/>NavigationTypeOther</a></code></p>
         */
        NavigationTypeOther(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::<wbr/>NavigationTypeRedirect</a></code></p>
         */
        NavigationTypeRedirect(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NavigationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NavigationType resolve(int value) {
            switch (value) {
            case 0: return NavigationTypeLink;
            case 1: return NavigationTypeTyped;
            case 2: return NavigationTypeFormSubmitted;
            case 3: return NavigationTypeBackForward;
            case 4: return NavigationTypeReload;
            case 5: return NavigationTypeOther;
            case 6: return NavigationTypeRedirect;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceType</a></code></p>
     */
    @QtRejectedEntries({"ResourceTypeLast"})
    public enum ResourceType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeMainFrame</a></code></p>
         */
        ResourceTypeMainFrame(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeSubFrame</a></code></p>
         */
        ResourceTypeSubFrame(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeStylesheet</a></code></p>
         */
        ResourceTypeStylesheet(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeScript</a></code></p>
         */
        ResourceTypeScript(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeImage</a></code></p>
         */
        ResourceTypeImage(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeFontResource</a></code></p>
         */
        ResourceTypeFontResource(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeSubResource</a></code></p>
         */
        ResourceTypeSubResource(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeObject</a></code></p>
         */
        ResourceTypeObject(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeMedia</a></code></p>
         */
        ResourceTypeMedia(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeWorker</a></code></p>
         */
        ResourceTypeWorker(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeSharedWorker</a></code></p>
         */
        ResourceTypeSharedWorker(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypePrefetch</a></code></p>
         */
        ResourceTypePrefetch(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeFavicon</a></code></p>
         */
        ResourceTypeFavicon(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeXhr</a></code></p>
         */
        ResourceTypeXhr(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypePing</a></code></p>
         */
        ResourceTypePing(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeServiceWorker</a></code></p>
         */
        ResourceTypeServiceWorker(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeCspReport</a></code></p>
         */
        ResourceTypeCspReport(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypePluginResource</a></code></p>
         */
        ResourceTypePluginResource(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeNavigationPreloadMainFrame</a></code></p>
         */
        ResourceTypeNavigationPreloadMainFrame(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeNavigationPreloadSubFrame</a></code></p>
         */
        ResourceTypeNavigationPreloadSubFrame(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeLast</a></code></p>
         */
        ResourceTypeLast(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeWebSocket</a></code></p>
         */
        ResourceTypeWebSocket(254),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::<wbr/>ResourceTypeUnknown</a></code></p>
         */
        ResourceTypeUnknown(255);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ResourceType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ResourceType resolve(int value) {
            switch (value) {
            case 0: return ResourceTypeMainFrame;
            case 1: return ResourceTypeSubFrame;
            case 2: return ResourceTypeStylesheet;
            case 3: return ResourceTypeScript;
            case 4: return ResourceTypeImage;
            case 5: return ResourceTypeFontResource;
            case 6: return ResourceTypeSubResource;
            case 7: return ResourceTypeObject;
            case 8: return ResourceTypeMedia;
            case 9: return ResourceTypeWorker;
            case 10: return ResourceTypeSharedWorker;
            case 11: return ResourceTypePrefetch;
            case 12: return ResourceTypeFavicon;
            case 13: return ResourceTypeXhr;
            case 14: return ResourceTypePing;
            case 15: return ResourceTypeServiceWorker;
            case 16: return ResourceTypeCspReport;
            case 17: return ResourceTypePluginResource;
            case 19: return ResourceTypeNavigationPreloadMainFrame;
            case 20: return ResourceTypeNavigationPreloadSubFrame;
            case 254: return ResourceTypeWebSocket;
            case 255: return ResourceTypeUnknown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#block">QWebEngineUrlRequestInfo::<wbr/>block(bool)</a></code></p>
     */
    @QtUninvokable
    public final void block(boolean shouldBlock){
        block_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), shouldBlock);
    }
    
    @QtUninvokable
    private native void block_native_bool(long __this__nativeId, boolean shouldBlock);
    
    /**
     * <p>See <code>QWebEngineUrlRequestInfo::<wbr/>changed()const</code></p>
     */
    @QtUninvokable
    public final boolean changed(){
        return changed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean changed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#firstPartyUrl">QWebEngineUrlRequestInfo::<wbr/>firstPartyUrl()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl firstPartyUrl(){
        return firstPartyUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl firstPartyUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#httpHeaders">QWebEngineUrlRequestInfo::<wbr/>httpHeaders()const</a></code></p>
     * <p>This function was introduced in Qt 6.5.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QHash<io.qt.core.@NonNull QByteArray, io.qt.core.@NonNull QByteArray> httpHeaders(){
        return httpHeaders_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QHash<io.qt.core.QByteArray, io.qt.core.QByteArray> httpHeaders_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#initiator">QWebEngineUrlRequestInfo::<wbr/>initiator()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl initiator(){
        return initiator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl initiator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#navigationType">QWebEngineUrlRequestInfo::<wbr/>navigationType()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlRequestInfo.@NonNull NavigationType navigationType(){
        return io.qt.webengine.core.QWebEngineUrlRequestInfo.NavigationType.resolve(navigationType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int navigationType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#redirect">QWebEngineUrlRequestInfo::<wbr/>redirect(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void redirect(io.qt.core.@NonNull QUrl url){
        redirect_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void redirect_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#requestBody">QWebEngineUrlRequestInfo::<wbr/>requestBody()const</a></code></p>
     * <p>This function was introduced in Qt 6.7.</p>
     */
    @QtUninvokable
    public final io.qt.core.@Nullable QIODevice requestBody(){
        return requestBody_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QIODevice requestBody_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#requestMethod">QWebEngineUrlRequestInfo::<wbr/>requestMethod()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray requestMethod(){
        return requestMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray requestMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#requestUrl">QWebEngineUrlRequestInfo::<wbr/>requestUrl()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#resourceType">QWebEngineUrlRequestInfo::<wbr/>resourceType()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlRequestInfo.@NonNull ResourceType resourceType(){
        return io.qt.webengine.core.QWebEngineUrlRequestInfo.ResourceType.resolve(resourceType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int resourceType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#setHttpHeader">QWebEngineUrlRequestInfo::<wbr/>setHttpHeader(QByteArray,<wbr/>QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setHttpHeader(io.qt.core.@NonNull QByteArray name, io.qt.core.@NonNull QByteArray value){
        setHttpHeader_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setHttpHeader_native_cref_QByteArray_cref_QByteArray(long __this__nativeId, long name, long value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    private QWebEngineUrlRequestInfo(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #redirect(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void redirect(java.lang.@NonNull String url) {
        redirect(new io.qt.core.QUrl(url));
    }
    
    /**
     * <p>Overloaded function for {@link #setHttpHeader(io.qt.core.QByteArray, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void setHttpHeader(byte @NonNull[] name, io.qt.core.@NonNull QByteArray value) {
        setHttpHeader(new io.qt.core.QByteArray(name), value);
    }
    
    /**
     * <p>Overloaded function for {@link #setHttpHeader(io.qt.core.QByteArray, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void setHttpHeader(io.qt.core.@NonNull QByteArray name, byte @NonNull[] value) {
        setHttpHeader(name, new io.qt.core.QByteArray(value));
    }
    
    /**
     * <p>Overloaded function for {@link #setHttpHeader(io.qt.core.QByteArray, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void setHttpHeader(byte @NonNull[] name, byte @NonNull[] value) {
        setHttpHeader(new io.qt.core.QByteArray(name), new io.qt.core.QByteArray(value));
    }
}
