package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>A request for populating a dialog with available sources for screen capturing</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginedesktopmediarequest.html">QWebEngineDesktopMediaRequest</a></code></p>
 * <p>This class was introduced in Qt 6.7.</p>
 */
public class QWebEngineDesktopMediaRequest extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineDesktopMediaRequest.class);
    
    
    /**
     * <p>See <code>QWebEngineDesktopMediaRequest::<wbr/>QWebEngineDesktopMediaRequest(QWebEngineDesktopMediaRequest)</code></p>
     */
    public QWebEngineDesktopMediaRequest(io.qt.webengine.core.@StrictNonNull QWebEngineDesktopMediaRequest other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineDesktopMediaRequest instance, io.qt.webengine.core.QWebEngineDesktopMediaRequest other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedesktopmediarequest.html#cancel">QWebEngineDesktopMediaRequest::<wbr/>cancel()const</a></code></p>
     */
    public final void cancel(){
        cancel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineDesktopMediaRequest::<wbr/>operator=(QWebEngineDesktopMediaRequest)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@StrictNonNull QWebEngineDesktopMediaRequest other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        assign_native_cref_QWebEngineDesktopMediaRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineDesktopMediaRequest(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedesktopmediarequest.html#screensModel">QWebEngineDesktopMediaRequest::<wbr/>screensModel()const</a></code></p>
     */
    @QtPropertyReader(name="screensModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractListModel screensModel(){
        return screensModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractListModel screensModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedesktopmediarequest.html#selectScreen">QWebEngineDesktopMediaRequest::<wbr/>selectScreen(QModelIndex)const</a></code></p>
     */
    public final void selectScreen(io.qt.core.@NonNull QModelIndex index){
        selectScreen_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    private native void selectScreen_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedesktopmediarequest.html#selectWindow">QWebEngineDesktopMediaRequest::<wbr/>selectWindow(QModelIndex)const</a></code></p>
     */
    public final void selectWindow(io.qt.core.@NonNull QModelIndex index){
        selectWindow_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index));
    }
    
    private native void selectWindow_native_cref_QModelIndex_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <code>QWebEngineDesktopMediaRequest::<wbr/>swap(QWebEngineDesktopMediaRequest&amp;)</code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.webengine.core.@StrictNonNull QWebEngineDesktopMediaRequest other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebEngineDesktopMediaRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QWebEngineDesktopMediaRequest(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedesktopmediarequest.html#windowsModel">QWebEngineDesktopMediaRequest::<wbr/>windowsModel()const</a></code></p>
     */
    @QtPropertyReader(name="windowsModel")
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractListModel windowsModel(){
        return windowsModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QAbstractListModel windowsModel_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineDesktopMediaRequest(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QWebEngineDesktopMediaRequest::<wbr/>QWebEngineDesktopMediaRequest(QWebEngineDesktopMediaRequest)</code></p>
     */
    @QtUninvokable
    @Override
    public QWebEngineDesktopMediaRequest clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineDesktopMediaRequest clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #screensModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractListModel getScreensModel() {
        return screensModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #windowsModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@Nullable QAbstractListModel getWindowsModel() {
        return windowsModel();
    }
}
