package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Java wrapper for Qt header file <code>QtWebEngineCore</code></p>
 */
public final class QtWebEngineCore
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtWebEngineCore() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtWebEngineCore."); }
    
    /**
     * <p>Java wrapper for Qt enum <code>QtWebEngineCore::ReferrerPolicy</code></p>
     */
    @QtRejectedEntries({"Last"})
    public enum ReferrerPolicy implements QtEnumerator {
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>Always</code></p>
         */
        Always(0),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>Default</code></p>
         */
        Default(1),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>NoReferrerWhenDowngrade</code></p>
         */
        NoReferrerWhenDowngrade(2),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>Never</code></p>
         */
        Never(3),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>Origin</code></p>
         */
        Origin(4),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>OriginWhenCrossOrigin</code></p>
         */
        OriginWhenCrossOrigin(5),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>NoReferrerWhenDowngradeOriginWhenCrossOrigin</code></p>
         */
        NoReferrerWhenDowngradeOriginWhenCrossOrigin(6),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>SameOrigin</code></p>
         */
        SameOrigin(7),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>StrictOrigin</code></p>
         */
        StrictOrigin(8),
        /**
         * <p>Representing <code>QtWebEngineCore::<wbr/>ReferrerPolicy::<wbr/>Last</code></p>
         */
        Last(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ReferrerPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ReferrerPolicy resolve(int value) {
            switch (value) {
            case 0: return Always;
            case 1: return Default;
            case 2: return NoReferrerWhenDowngrade;
            case 3: return Never;
            case 4: return Origin;
            case 5: return OriginWhenCrossOrigin;
            case 6: return NoReferrerWhenDowngradeOriginWhenCrossOrigin;
            case 7: return SameOrigin;
            case 8: return StrictOrigin;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtwebenginecoreglobal-h.html#qWebEngineChromiumSecurityPatchVersion">qWebEngineChromiumSecurityPatchVersion()</a></code></p>
     */
    public native static java.lang.@Nullable String qWebEngineChromiumSecurityPatchVersion();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtwebenginecoreglobal-h.html#qWebEngineChromiumVersion">qWebEngineChromiumVersion()</a></code></p>
     */
    public native static java.lang.@Nullable String qWebEngineChromiumVersion();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtwebenginecoreglobal-h.html#qWebEngineGetDomainAndRegistry">qWebEngineGetDomainAndRegistry(QUrl)</a></code></p>
     */
    public static java.lang.@NonNull String qWebEngineGetDomainAndRegistry(io.qt.core.@NonNull QUrl url){
        return qWebEngineGetDomainAndRegistry_native_cref_QUrl(QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native static java.lang.String qWebEngineGetDomainAndRegistry_native_cref_QUrl(long url);
    
    /**
     * <p>See <code>qWebEngineProcessName()</code></p>
     */
    public native static java.lang.@Nullable String qWebEngineProcessName();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qtwebenginecoreglobal-h.html#qWebEngineVersion">qWebEngineVersion()</a></code></p>
     */
    public native static java.lang.@Nullable String qWebEngineVersion();
    
    
    /**
     * <p>Overloaded function for {@link #qWebEngineGetDomainAndRegistry(io.qt.core.QUrl)}.</p>
     */
    public static java.lang.@NonNull String qWebEngineGetDomainAndRegistry(java.lang.@NonNull String url) {
        return qWebEngineGetDomainAndRegistry(new io.qt.core.QUrl(url));
    }
}
