package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Represents a custom URL request</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html">QWebEngineUrlRequestJob</a></code></p>
 */
public final class QWebEngineUrlRequestJob extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineUrlRequestJob.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::<wbr/>UrlNotFound</a></code></p>
         */
        UrlNotFound(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::<wbr/>UrlInvalid</a></code></p>
         */
        UrlInvalid(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::<wbr/>RequestAborted</a></code></p>
         */
        RequestAborted(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::<wbr/>RequestDenied</a></code></p>
         */
        RequestDenied(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::<wbr/>RequestFailed</a></code></p>
         */
        RequestFailed(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return UrlNotFound;
            case 2: return UrlInvalid;
            case 3: return RequestAborted;
            case 4: return RequestDenied;
            case 5: return RequestFailed;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#fail">QWebEngineUrlRequestJob::<wbr/>fail(QWebEngineUrlRequestJob::Error)</a></code></p>
     */
    @QtUninvokable
    public final void fail(io.qt.webengine.core.QWebEngineUrlRequestJob.@NonNull Error error){
        fail_native_QWebEngineUrlRequestJob_Error(QtJambi_LibraryUtilities.internal.nativeId(this), error.value());
    }
    
    @QtUninvokable
    private native void fail_native_QWebEngineUrlRequestJob_Error(long __this__nativeId, int error);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#initiator">QWebEngineUrlRequestJob::<wbr/>initiator()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl initiator(){
        return initiator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl initiator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#redirect">QWebEngineUrlRequestJob::<wbr/>redirect(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void redirect(io.qt.core.@NonNull QUrl url){
        redirect_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void redirect_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#reply">QWebEngineUrlRequestJob::<wbr/>reply(QByteArray,<wbr/>QIODevice*)</a></code></p>
     */
    @QtUninvokable
    public final void reply(io.qt.core.@NonNull QByteArray contentType, io.qt.core.@Nullable QIODevice device){
        reply_native_cref_QByteArray_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contentType), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @QtUninvokable
    private native void reply_native_cref_QByteArray_QIODevice_ptr(long __this__nativeId, long contentType, long device);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#requestHeaders">QWebEngineUrlRequestJob::<wbr/>requestHeaders()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<io.qt.core.@NonNull QByteArray, io.qt.core.@NonNull QByteArray> requestHeaders(){
        return requestHeaders_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<io.qt.core.QByteArray, io.qt.core.QByteArray> requestHeaders_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#requestMethod">QWebEngineUrlRequestJob::<wbr/>requestMethod()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray requestMethod(){
        return requestMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray requestMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#requestUrl">QWebEngineUrlRequestJob::<wbr/>requestUrl()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#setAdditionalResponseHeaders">QWebEngineUrlRequestJob::<wbr/>setAdditionalResponseHeaders(QMultiMap&lt;QByteArray,<wbr/>QByteArray&gt;)const</a></code></p>
     */
    @QtUninvokable
    public final void setAdditionalResponseHeaders(java.util.@NonNull Map<? extends io.qt.core.@NonNull QByteArray, ? extends java.util.List<? extends io.qt.core.@NonNull QByteArray>> additionalResponseHeaders){
        setAdditionalResponseHeaders_native_cref_QMultiMap_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), additionalResponseHeaders);
    }
    
    @QtUninvokable
    private native void setAdditionalResponseHeaders_native_cref_QMultiMap_constfct(long __this__nativeId, java.util.Map<? extends io.qt.core.QByteArray, ? extends java.util.List<? extends io.qt.core.QByteArray>> additionalResponseHeaders);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineUrlRequestJob(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #redirect(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void redirect(java.lang.@NonNull String url) {
        redirect(new io.qt.core.QUrl(url));
    }
    
    /**
     * <p>Overloaded function for {@link #reply(io.qt.core.QByteArray, io.qt.core.QIODevice)}.</p>
     */
    @QtUninvokable
    public final void reply(byte @NonNull[] contentType, io.qt.core.@Nullable QIODevice device) {
        reply(new io.qt.core.QByteArray(contentType), device);
    }
}
