package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>A utility type for the QWebEnginePage::navigationRequested signal</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginenavigationrequest.html">QWebEngineNavigationRequest</a></code></p>
 */
public final class QWebEngineNavigationRequest extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineNavigationRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>QWebEngineNavigationRequest::NavigationType</code></p>
     */
    public enum NavigationType implements QtEnumerator {
        /**
         * <p>Representing <code>QWebEngineNavigationRequest::<wbr/>LinkClickedNavigation</code></p>
         */
        LinkClickedNavigation(0),
        /**
         * <p>Representing <code>QWebEngineNavigationRequest::<wbr/>TypedNavigation</code></p>
         */
        TypedNavigation(1),
        /**
         * <p>Representing <code>QWebEngineNavigationRequest::<wbr/>FormSubmittedNavigation</code></p>
         */
        FormSubmittedNavigation(2),
        /**
         * <p>Representing <code>QWebEngineNavigationRequest::<wbr/>BackForwardNavigation</code></p>
         */
        BackForwardNavigation(3),
        /**
         * <p>Representing <code>QWebEngineNavigationRequest::<wbr/>ReloadNavigation</code></p>
         */
        ReloadNavigation(4),
        /**
         * <p>Representing <code>QWebEngineNavigationRequest::<wbr/>OtherNavigation</code></p>
         */
        OtherNavigation(5),
        /**
         * <p>Representing <code>QWebEngineNavigationRequest::<wbr/>RedirectNavigation</code></p>
         */
        RedirectNavigation(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NavigationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NavigationType resolve(int value) {
            switch (value) {
            case 0: return LinkClickedNavigation;
            case 1: return TypedNavigation;
            case 2: return FormSubmittedNavigation;
            case 3: return BackForwardNavigation;
            case 4: return ReloadNavigation;
            case 5: return OtherNavigation;
            case 6: return RedirectNavigation;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginenavigationrequest.html#action-prop">QWebEngineNavigationRequest::<wbr/>actionChanged()</a></code></p>
     */
    @QtPropertyNotify(name="action")
    public final @NonNull Signal0 actionChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginenavigationrequest.html#accept">QWebEngineNavigationRequest::<wbr/>accept()</a></code></p>
     */
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginenavigationrequest.html#isMainFrame-prop">QWebEngineNavigationRequest::<wbr/>isMainFrame()const</a></code></p>
     */
    @QtPropertyReader(name="isMainFrame")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isMainFrame(){
        return isMainFrame_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMainFrame_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginenavigationrequest.html#navigationType-prop">QWebEngineNavigationRequest::<wbr/>navigationType()const</a></code></p>
     */
    @QtPropertyReader(name="navigationType")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineNavigationRequest.@NonNull NavigationType navigationType(){
        return io.qt.webengine.core.QWebEngineNavigationRequest.NavigationType.resolve(navigationType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int navigationType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginenavigationrequest.html#reject">QWebEngineNavigationRequest::<wbr/>reject()</a></code></p>
     */
    public final void reject(){
        reject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reject_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginenavigationrequest.html#url-prop">QWebEngineNavigationRequest::<wbr/>url()const</a></code></p>
     */
    @QtPropertyReader(name="url")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineNavigationRequest(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #navigationType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineNavigationRequest.@NonNull NavigationType getNavigationType() {
        return navigationType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
}
