package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>In-memory store for client certificates</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebengineclientcertificatestore.html">QWebEngineClientCertificateStore</a></code></p>
 */
public final class QWebEngineClientCertificateStore extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineclientcertificatestore.html#add">QWebEngineClientCertificateStore::<wbr/>add(QSslCertificate,<wbr/>QSslKey)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void add(io.qt.network.@NonNull QSslCertificate certificate, io.qt.network.@NonNull QSslKey privateKey){
        add_native_cref_QSslCertificate_cref_QSslKey(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(certificate), QtJambi_LibraryUtilities.internal.checkedNativeId(privateKey));
    }
    
    @QtUninvokable
    private native void add_native_cref_QSslCertificate_cref_QSslKey(long __this__nativeId, long certificate, long privateKey);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineclientcertificatestore.html#certificates">QWebEngineClientCertificateStore::<wbr/>certificates()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.network.@NonNull QSslCertificate> certificates(){
        return certificates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.network.QSslCertificate> certificates_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineclientcertificatestore.html#clear">QWebEngineClientCertificateStore::<wbr/>clear()</a></code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineclientcertificatestore.html#remove">QWebEngineClientCertificateStore::<wbr/>remove(QSslCertificate)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void remove(io.qt.network.@NonNull QSslCertificate certificate){
        remove_native_cref_QSslCertificate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(certificate));
    }
    
    @QtUninvokable
    private native void remove_native_cref_QSslCertificate(long __this__nativeId, long certificate);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineClientCertificateStore(QPrivateConstructor p) { super(p); } 
    
}
