package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Holds a request to be sent with WebEngine</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html">QWebEngineHttpRequest</a></code></p>
 */
public class QWebEngineHttpRequest extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#Method-enum">QWebEngineHttpRequest::Method</a></code></p>
     */
    public enum Method implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#Method-enum">QWebEngineHttpRequest::<wbr>Get</a></code></p>
         */
        Get(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#Method-enum">QWebEngineHttpRequest::<wbr>Post</a></code></p>
         */
        Post(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Method(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Method resolve(int value) {
            switch (value) {
            case 0: return Get;
            case 1: return Post;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#QWebEngineHttpRequest">QWebEngineHttpRequest::<wbr>QWebEngineHttpRequest(QUrl,<wbr>QWebEngineHttpRequest::Method)</a></code></p>
     */
    public QWebEngineHttpRequest(io.qt.core.@NonNull QUrl url, io.qt.webengine.core.QWebEngineHttpRequest.@NonNull Method method){
        super((QPrivateConstructor)null);
        initialize_native(this, url, method);
    }
    
    private native static void initialize_native(QWebEngineHttpRequest instance, io.qt.core.QUrl url, io.qt.webengine.core.QWebEngineHttpRequest.Method method);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#QWebEngineHttpRequest-1">QWebEngineHttpRequest::<wbr>QWebEngineHttpRequest(QWebEngineHttpRequest)</a></code></p>
     */
    public QWebEngineHttpRequest(io.qt.webengine.core.@NonNull QWebEngineHttpRequest other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineHttpRequest instance, io.qt.webengine.core.QWebEngineHttpRequest other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#hasHeader">QWebEngineHttpRequest::<wbr>hasHeader(QByteArray)const</a></code></p>
     */
    @QtUninvokable
    public final boolean hasHeader(io.qt.core.@NonNull QByteArray headerName){
        return hasHeader_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName));
    }
    
    @QtUninvokable
    private native boolean hasHeader_native_cref_QByteArray_constfct(long __this__nativeId, long headerName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#header">QWebEngineHttpRequest::<wbr>header(QByteArray)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray header(io.qt.core.@NonNull QByteArray headerName){
        return header_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray header_native_cref_QByteArray_constfct(long __this__nativeId, long headerName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#headers">QWebEngineHttpRequest::<wbr>headers()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.core.@NonNull QByteArray> headers(){
        return headers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.core.QByteArray> headers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#method">QWebEngineHttpRequest::<wbr>method()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineHttpRequest.@NonNull Method method(){
        return io.qt.webengine.core.QWebEngineHttpRequest.Method.resolve(method_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int method_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#operator-eq-1">QWebEngineHttpRequest::<wbr>operator=(QWebEngineHttpRequest)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@NonNull QWebEngineHttpRequest other){
        assign_native_cref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineHttpRequest(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#operator-eq-eq">QWebEngineHttpRequest::<wbr>operator==(QWebEngineHttpRequest)const</a></code></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.@NonNull QWebEngineHttpRequest other){
        return operator_equal_native_cref_QWebEngineHttpRequest_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineHttpRequest_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#postData">QWebEngineHttpRequest::<wbr>postData()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray postData(){
        return postData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray postData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#setHeader">QWebEngineHttpRequest::<wbr>setHeader(QByteArray,<wbr>QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setHeader(io.qt.core.@NonNull QByteArray headerName, io.qt.core.@NonNull QByteArray value){
        setHeader_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setHeader_native_cref_QByteArray_cref_QByteArray(long __this__nativeId, long headerName, long value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#setMethod">QWebEngineHttpRequest::<wbr>setMethod(QWebEngineHttpRequest::Method)</a></code></p>
     */
    @QtUninvokable
    public final void setMethod(io.qt.webengine.core.QWebEngineHttpRequest.@NonNull Method method){
        setMethod_native_QWebEngineHttpRequest_Method(QtJambi_LibraryUtilities.internal.nativeId(this), method.value());
    }
    
    @QtUninvokable
    private native void setMethod_native_QWebEngineHttpRequest_Method(long __this__nativeId, int method);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#setPostData">QWebEngineHttpRequest::<wbr>setPostData(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setPostData(io.qt.core.@NonNull QByteArray postData){
        setPostData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(postData));
    }
    
    @QtUninvokable
    private native void setPostData_native_cref_QByteArray(long __this__nativeId, long postData);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#setUrl">QWebEngineHttpRequest::<wbr>setUrl(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setUrl(io.qt.core.@NonNull QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#swap">QWebEngineHttpRequest::<wbr>swap(QWebEngineHttpRequest&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.webengine.core.@StrictNonNull QWebEngineHttpRequest other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QWebEngineHttpRequest(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#unsetHeader">QWebEngineHttpRequest::<wbr>unsetHeader(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void unsetHeader(io.qt.core.@NonNull QByteArray headerName){
        unsetHeader_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName));
    }
    
    @QtUninvokable
    private native void unsetHeader_native_cref_QByteArray(long __this__nativeId, long headerName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#url">QWebEngineHttpRequest::<wbr>url()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#postRequest">QWebEngineHttpRequest::<wbr>postRequest(QUrl,<wbr>QMap&lt;QString,<wbr>QString&gt;)</a></code></p>
     */
    public static io.qt.webengine.core.@NonNull QWebEngineHttpRequest postRequest(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, java.lang.@NonNull String> postData){
        return postRequest_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.checkedNativeId(url), postData);
    }
    
    private native static io.qt.webengine.core.QWebEngineHttpRequest postRequest_native_cref_QUrl_cref_QMap(long url, java.util.Map<java.lang.String, java.lang.String> postData);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineHttpRequest(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehttprequest.html#operator-eq-eq">QWebEngineHttpRequest::<wbr>operator==(QWebEngineHttpRequest)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineHttpRequest) {
            return operator_equal((io.qt.webengine.core.QWebEngineHttpRequest) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QWebEngineHttpRequest)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QWebEngineHttpRequest clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineHttpRequest clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineHttpRequest(io.qt.core.QUrl, io.qt.webengine.core.QWebEngineHttpRequest.Method)}
     *  with <code>method = io.qt.webengine.core.QWebEngineHttpRequest.Method.Get</code>.</p>
     */
    public QWebEngineHttpRequest(io.qt.core.@NonNull QUrl url) {
        this(url, io.qt.webengine.core.QWebEngineHttpRequest.Method.Get);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineHttpRequest(io.qt.core.QUrl, io.qt.webengine.core.QWebEngineHttpRequest.Method)}</p>
     * <p>with: </p><ul>
     * <li><code>url = new io.qt.core.QUrl()</code></li>
     * <li><code>method = io.qt.webengine.core.QWebEngineHttpRequest.Method.Get</code></li>
     * </ul>
     */
    public QWebEngineHttpRequest() {
        this(new io.qt.core.QUrl(), io.qt.webengine.core.QWebEngineHttpRequest.Method.Get);
    }
    
    /**
     * @deprecated Use {@link #assign(io.qt.webengine.core.QWebEngineHttpRequest)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.webengine.core.@NonNull QWebEngineHttpRequest other) {
        assign(other);
    }
}
