package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Information about a download</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html">QWebEngineDownloadRequest</a></code></p>
 */
public final class QWebEngineDownloadRequest extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineDownloadRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::DownloadInterruptReason</a></code></p>
     */
    public enum DownloadInterruptReason implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>NoReason</a></code></p>
         */
        NoReason(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileFailed</a></code></p>
         */
        FileFailed(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileAccessDenied</a></code></p>
         */
        FileAccessDenied(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileNoSpace</a></code></p>
         */
        FileNoSpace(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileNameTooLong</a></code></p>
         */
        FileNameTooLong(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileTooLarge</a></code></p>
         */
        FileTooLarge(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileVirusInfected</a></code></p>
         */
        FileVirusInfected(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileTransientError</a></code></p>
         */
        FileTransientError(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileBlocked</a></code></p>
         */
        FileBlocked(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileSecurityCheckFailed</a></code></p>
         */
        FileSecurityCheckFailed(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileTooShort</a></code></p>
         */
        FileTooShort(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>FileHashMismatch</a></code></p>
         */
        FileHashMismatch(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>NetworkFailed</a></code></p>
         */
        NetworkFailed(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>NetworkTimeout</a></code></p>
         */
        NetworkTimeout(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>NetworkDisconnected</a></code></p>
         */
        NetworkDisconnected(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>NetworkServerDown</a></code></p>
         */
        NetworkServerDown(23),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>NetworkInvalidRequest</a></code></p>
         */
        NetworkInvalidRequest(24),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>ServerFailed</a></code></p>
         */
        ServerFailed(30),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>ServerBadContent</a></code></p>
         */
        ServerBadContent(33),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>ServerUnauthorized</a></code></p>
         */
        ServerUnauthorized(34),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>ServerCertProblem</a></code></p>
         */
        ServerCertProblem(35),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>ServerForbidden</a></code></p>
         */
        ServerForbidden(36),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>ServerUnreachable</a></code></p>
         */
        ServerUnreachable(37),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::<wbr>UserCanceled</a></code></p>
         */
        UserCanceled(40);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadInterruptReason(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadInterruptReason resolve(int value) {
            switch (value) {
            case 0: return NoReason;
            case 1: return FileFailed;
            case 2: return FileAccessDenied;
            case 3: return FileNoSpace;
            case 5: return FileNameTooLong;
            case 6: return FileTooLarge;
            case 7: return FileVirusInfected;
            case 10: return FileTransientError;
            case 11: return FileBlocked;
            case 12: return FileSecurityCheckFailed;
            case 13: return FileTooShort;
            case 14: return FileHashMismatch;
            case 20: return NetworkFailed;
            case 21: return NetworkTimeout;
            case 22: return NetworkDisconnected;
            case 23: return NetworkServerDown;
            case 24: return NetworkInvalidRequest;
            case 30: return ServerFailed;
            case 33: return ServerBadContent;
            case 34: return ServerUnauthorized;
            case 35: return ServerCertProblem;
            case 36: return ServerForbidden;
            case 37: return ServerUnreachable;
            case 40: return UserCanceled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadState-enum">QWebEngineDownloadRequest::DownloadState</a></code></p>
     */
    public enum DownloadState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadState-enum">QWebEngineDownloadRequest::<wbr>DownloadRequested</a></code></p>
         */
        DownloadRequested(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadState-enum">QWebEngineDownloadRequest::<wbr>DownloadInProgress</a></code></p>
         */
        DownloadInProgress(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadState-enum">QWebEngineDownloadRequest::<wbr>DownloadCompleted</a></code></p>
         */
        DownloadCompleted(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadState-enum">QWebEngineDownloadRequest::<wbr>DownloadCancelled</a></code></p>
         */
        DownloadCancelled(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadState-enum">QWebEngineDownloadRequest::<wbr>DownloadInterrupted</a></code></p>
         */
        DownloadInterrupted(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DownloadState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DownloadState resolve(int value) {
            switch (value) {
            case 0: return DownloadRequested;
            case 1: return DownloadInProgress;
            case 2: return DownloadCompleted;
            case 3: return DownloadCancelled;
            case 4: return DownloadInterrupted;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#SavePageFormat-enum">QWebEngineDownloadRequest::SavePageFormat</a></code></p>
     */
    public enum SavePageFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#SavePageFormat-enum">QWebEngineDownloadRequest::<wbr>UnknownSaveFormat</a></code></p>
         */
        UnknownSaveFormat(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#SavePageFormat-enum">QWebEngineDownloadRequest::<wbr>SingleHtmlSaveFormat</a></code></p>
         */
        SingleHtmlSaveFormat(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#SavePageFormat-enum">QWebEngineDownloadRequest::<wbr>CompleteHtmlSaveFormat</a></code></p>
         */
        CompleteHtmlSaveFormat(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#SavePageFormat-enum">QWebEngineDownloadRequest::<wbr>MimeHtmlSaveFormat</a></code></p>
         */
        MimeHtmlSaveFormat(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SavePageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SavePageFormat resolve(int value) {
            switch (value) {
            case -1: return UnknownSaveFormat;
            case 0: return SingleHtmlSaveFormat;
            case 1: return CompleteHtmlSaveFormat;
            case 2: return MimeHtmlSaveFormat;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadDirectory-prop">QWebEngineDownloadRequest::<wbr>downloadDirectoryChanged()</a></code></p>
     */
    @QtPropertyNotify(name="downloadDirectory")
    public final @NonNull Signal0 downloadDirectoryChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadFileName-prop">QWebEngineDownloadRequest::<wbr>downloadFileNameChanged()</a></code></p>
     */
    @QtPropertyNotify(name="downloadFileName")
    public final @NonNull Signal0 downloadFileNameChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#interruptReasonChanged">QWebEngineDownloadRequest::<wbr>interruptReasonChanged()</a></code></p>
     */
    @QtPropertyNotify(name="interruptReason")
    public final @NonNull Signal0 interruptReasonChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isFinished-prop">QWebEngineDownloadRequest::<wbr>isFinishedChanged()</a></code></p>
     */
    @QtPropertyNotify(name="isFinished")
    public final @NonNull Signal0 isFinishedChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isPausedChanged">QWebEngineDownloadRequest::<wbr>isPausedChanged()</a></code></p>
     */
    @QtPropertyNotify(name="isPaused")
    public final @NonNull Signal0 isPausedChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#receivedBytes-prop">QWebEngineDownloadRequest::<wbr>receivedBytesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="receivedBytes")
    public final @NonNull Signal0 receivedBytesChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#savePageFormat-prop">QWebEngineDownloadRequest::<wbr>savePageFormatChanged()</a></code></p>
     */
    @QtPropertyNotify(name="savePageFormat")
    public final @NonNull Signal0 savePageFormatChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#stateChanged">QWebEngineDownloadRequest::<wbr>stateChanged(QWebEngineDownloadRequest::DownloadState)</a></code></p>
     */
    @QtPropertyNotify(name="state")
    public final @NonNull Signal1<io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull DownloadState> stateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#totalBytes-prop">QWebEngineDownloadRequest::<wbr>totalBytesChanged()</a></code></p>
     */
    @QtPropertyNotify(name="totalBytes")
    public final @NonNull Signal0 totalBytesChanged = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#accept">QWebEngineDownloadRequest::<wbr>accept()</a></code></p>
     */
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#cancel">QWebEngineDownloadRequest::<wbr>cancel()</a></code></p>
     */
    public final void cancel(){
        cancel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancel_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadDirectory">QWebEngineDownloadRequest::<wbr>downloadDirectory()const</a></code></p>
     */
    @QtPropertyReader(name="downloadDirectory")
    @QtUninvokable
    public final java.lang.@NonNull String downloadDirectory(){
        return downloadDirectory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadDirectory_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadFileName">QWebEngineDownloadRequest::<wbr>downloadFileName()const</a></code></p>
     */
    @QtPropertyReader(name="downloadFileName")
    @QtUninvokable
    public final java.lang.@NonNull String downloadFileName(){
        return downloadFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#id">QWebEngineDownloadRequest::<wbr>id()const</a></code></p>
     */
    @QtPropertyReader(name="id")
    @QtPropertyConstant
    @QtUninvokable
    public final int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#interruptReason">QWebEngineDownloadRequest::<wbr>interruptReason()const</a></code></p>
     */
    @QtPropertyReader(name="interruptReason")
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull DownloadInterruptReason interruptReason(){
        return io.qt.webengine.core.QWebEngineDownloadRequest.DownloadInterruptReason.resolve(interruptReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int interruptReason_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#interruptReasonString">QWebEngineDownloadRequest::<wbr>interruptReasonString()const</a></code></p>
     */
    @QtPropertyReader(name="interruptReasonString")
    @QtUninvokable
    public final java.lang.@NonNull String interruptReasonString(){
        return interruptReasonString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String interruptReasonString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isFinished-prop">QWebEngineDownloadRequest::<wbr>isFinished()const</a></code></p>
     */
    @QtPropertyReader(name="isFinished")
    @QtUninvokable
    public final boolean isFinished(){
        return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isFinished_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isPaused-prop">QWebEngineDownloadRequest::<wbr>isPaused()const</a></code></p>
     */
    @QtPropertyReader(name="isPaused")
    @QtUninvokable
    public final boolean isPaused(){
        return isPaused_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPaused_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isSavePageDownload">QWebEngineDownloadRequest::<wbr>isSavePageDownload()const</a></code></p>
     */
    @QtPropertyReader(name="isSavePageDownload")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isSavePageDownload(){
        return isSavePageDownload_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSavePageDownload_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#mimeType">QWebEngineDownloadRequest::<wbr>mimeType()const</a></code></p>
     */
    @QtPropertyReader(name="mimeType")
    @QtUninvokable
    public final java.lang.@NonNull String mimeType(){
        return mimeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String mimeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#page">QWebEngineDownloadRequest::<wbr>page()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEnginePage page(){
        return page_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEnginePage page_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#pause">QWebEngineDownloadRequest::<wbr>pause()</a></code></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#receivedBytes">QWebEngineDownloadRequest::<wbr>receivedBytes()const</a></code></p>
     */
    @QtPropertyReader(name="receivedBytes")
    @QtUninvokable
    public final long receivedBytes(){
        return receivedBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long receivedBytes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#resume">QWebEngineDownloadRequest::<wbr>resume()</a></code></p>
     */
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#savePageFormat">QWebEngineDownloadRequest::<wbr>savePageFormat()const</a></code></p>
     */
    @QtPropertyReader(name="savePageFormat")
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull SavePageFormat savePageFormat(){
        return io.qt.webengine.core.QWebEngineDownloadRequest.SavePageFormat.resolve(savePageFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int savePageFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#setDownloadDirectory">QWebEngineDownloadRequest::<wbr>setDownloadDirectory(QString)</a></code></p>
     */
    @QtPropertyWriter(name="downloadDirectory")
    @QtUninvokable
    public final void setDownloadDirectory(java.lang.@NonNull String directory){
        setDownloadDirectory_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), directory);
    }
    
    @QtUninvokable
    private native void setDownloadDirectory_native_cref_QString(long __this__nativeId, java.lang.String directory);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#setDownloadFileName">QWebEngineDownloadRequest::<wbr>setDownloadFileName(QString)</a></code></p>
     */
    @QtPropertyWriter(name="downloadFileName")
    @QtUninvokable
    public final void setDownloadFileName(java.lang.@NonNull String fileName){
        setDownloadFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native void setDownloadFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#setSavePageFormat">QWebEngineDownloadRequest::<wbr>setSavePageFormat(QWebEngineDownloadRequest::SavePageFormat)</a></code></p>
     */
    @QtPropertyWriter(name="savePageFormat")
    @QtUninvokable
    public final void setSavePageFormat(io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull SavePageFormat format){
        setSavePageFormat_native_QWebEngineDownloadRequest_SavePageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setSavePageFormat_native_QWebEngineDownloadRequest_SavePageFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#state">QWebEngineDownloadRequest::<wbr>state()const</a></code></p>
     */
    @QtPropertyReader(name="state")
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull DownloadState state(){
        return io.qt.webengine.core.QWebEngineDownloadRequest.DownloadState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#suggestedFileName">QWebEngineDownloadRequest::<wbr>suggestedFileName()const</a></code></p>
     */
    @QtPropertyReader(name="suggestedFileName")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String suggestedFileName(){
        return suggestedFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String suggestedFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#totalBytes">QWebEngineDownloadRequest::<wbr>totalBytes()const</a></code></p>
     */
    @QtPropertyReader(name="totalBytes")
    @QtUninvokable
    public final long totalBytes(){
        return totalBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long totalBytes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#url">QWebEngineDownloadRequest::<wbr>url()const</a></code></p>
     */
    @QtPropertyReader(name="url")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineDownloadRequest(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #downloadDirectory()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDownloadDirectory() {
        return downloadDirectory();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #downloadFileName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDownloadFileName() {
        return downloadFileName();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #id()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getId() {
        return id();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #interruptReason()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull DownloadInterruptReason getInterruptReason() {
        return interruptReason();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #interruptReasonString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getInterruptReasonString() {
        return interruptReasonString();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mimeType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getMimeType() {
        return mimeType();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #receivedBytes()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getReceivedBytes() {
        return receivedBytes();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #savePageFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull SavePageFormat getSavePageFormat() {
        return savePageFormat();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #state()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull DownloadState getState() {
        return state();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #suggestedFileName()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSuggestedFileName() {
        return suggestedFileName();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #totalBytes()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getTotalBytes() {
        return totalBytes();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
}
