package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Object to store the settings used by QWebEnginePage</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginesettings.html">QWebEngineSettings</a></code></p>
 */
public final class QWebEngineSettings extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::FontFamily</a></code></p>
     */
    public enum FontFamily implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::<wbr/>StandardFont</a></code></p>
         */
        StandardFont(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::<wbr/>FixedFont</a></code></p>
         */
        FixedFont(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::<wbr/>SerifFont</a></code></p>
         */
        SerifFont(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::<wbr/>SansSerifFont</a></code></p>
         */
        SansSerifFont(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::<wbr/>CursiveFont</a></code></p>
         */
        CursiveFont(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::<wbr/>FantasyFont</a></code></p>
         */
        FantasyFont(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::<wbr/>PictographFont</a></code></p>
         */
        PictographFont(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FontFamily(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FontFamily resolve(int value) {
            switch (value) {
            case 0: return StandardFont;
            case 1: return FixedFont;
            case 2: return SerifFont;
            case 3: return SansSerifFont;
            case 4: return CursiveFont;
            case 5: return FantasyFont;
            case 6: return PictographFont;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::FontSize</a></code></p>
     */
    public enum FontSize implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::<wbr/>MinimumFontSize</a></code></p>
         */
        MinimumFontSize(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::<wbr/>MinimumLogicalFontSize</a></code></p>
         */
        MinimumLogicalFontSize(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::<wbr/>DefaultFontSize</a></code></p>
         */
        DefaultFontSize(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::<wbr/>DefaultFixedFontSize</a></code></p>
         */
        DefaultFixedFontSize(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FontSize(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FontSize resolve(int value) {
            switch (value) {
            case 0: return MinimumFontSize;
            case 1: return MinimumLogicalFontSize;
            case 2: return DefaultFontSize;
            case 3: return DefaultFixedFontSize;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::UnknownUrlSchemePolicy</a></code></p>
     * <p>This enum was introduced in Qt Qt 5.11.</p>
     */
    public enum UnknownUrlSchemePolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::<wbr/>InheritedUnknownUrlSchemePolicy</a></code></p>
         */
        InheritedUnknownUrlSchemePolicy(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::<wbr/>DisallowUnknownUrlSchemes</a></code></p>
         */
        DisallowUnknownUrlSchemes(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::<wbr/>AllowUnknownUrlSchemesFromUserInteraction</a></code></p>
         */
        AllowUnknownUrlSchemesFromUserInteraction(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::<wbr/>AllowAllUnknownUrlSchemes</a></code></p>
         */
        AllowAllUnknownUrlSchemes(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UnknownUrlSchemePolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull UnknownUrlSchemePolicy resolve(int value) {
            switch (value) {
            case 0: return InheritedUnknownUrlSchemePolicy;
            case 1: return DisallowUnknownUrlSchemes;
            case 2: return AllowUnknownUrlSchemesFromUserInteraction;
            case 3: return AllowAllUnknownUrlSchemes;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::WebAttribute</a></code></p>
     */
    public enum WebAttribute implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>AutoLoadImages</a></code></p>
         */
        AutoLoadImages(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>JavascriptEnabled</a></code></p>
         */
        JavascriptEnabled(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>JavascriptCanOpenWindows</a></code></p>
         */
        JavascriptCanOpenWindows(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>JavascriptCanAccessClipboard</a></code></p>
         */
        JavascriptCanAccessClipboard(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>LinksIncludedInFocusChain</a></code></p>
         */
        LinksIncludedInFocusChain(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>LocalStorageEnabled</a></code></p>
         */
        LocalStorageEnabled(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>LocalContentCanAccessRemoteUrls</a></code></p>
         */
        LocalContentCanAccessRemoteUrls(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>XSSAuditingEnabled</a></code></p>
         */
        XSSAuditingEnabled(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>SpatialNavigationEnabled</a></code></p>
         */
        SpatialNavigationEnabled(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>LocalContentCanAccessFileUrls</a></code></p>
         */
        LocalContentCanAccessFileUrls(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>HyperlinkAuditingEnabled</a></code></p>
         */
        HyperlinkAuditingEnabled(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>ScrollAnimatorEnabled</a></code></p>
         */
        ScrollAnimatorEnabled(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>ErrorPageEnabled</a></code></p>
         */
        ErrorPageEnabled(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>PluginsEnabled</a></code></p>
         */
        PluginsEnabled(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>FullScreenSupportEnabled</a></code></p>
         */
        FullScreenSupportEnabled(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>ScreenCaptureEnabled</a></code></p>
         */
        ScreenCaptureEnabled(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>WebGLEnabled</a></code></p>
         */
        WebGLEnabled(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>Accelerated2dCanvasEnabled</a></code></p>
         */
        Accelerated2dCanvasEnabled(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>AutoLoadIconsForPage</a></code></p>
         */
        AutoLoadIconsForPage(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>TouchIconsEnabled</a></code></p>
         */
        TouchIconsEnabled(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>FocusOnNavigationEnabled</a></code></p>
         */
        FocusOnNavigationEnabled(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>PrintElementBackgrounds</a></code></p>
         */
        PrintElementBackgrounds(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>AllowRunningInsecureContent</a></code></p>
         */
        AllowRunningInsecureContent(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>AllowGeolocationOnInsecureOrigins</a></code></p>
         */
        AllowGeolocationOnInsecureOrigins(23),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>AllowWindowActivationFromJavaScript</a></code></p>
         */
        AllowWindowActivationFromJavaScript(24),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>ShowScrollBars</a></code></p>
         */
        ShowScrollBars(25),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>PlaybackRequiresUserGesture</a></code></p>
         */
        PlaybackRequiresUserGesture(26),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>WebRTCPublicInterfacesOnly</a></code></p>
         */
        WebRTCPublicInterfacesOnly(27),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>JavascriptCanPaste</a></code></p>
         */
        JavascriptCanPaste(28),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>DnsPrefetchEnabled</a></code></p>
         */
        DnsPrefetchEnabled(29),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>PdfViewerEnabled</a></code></p>
         */
        PdfViewerEnabled(30),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::<wbr/>NavigateOnDropEnabled</a></code></p>
         */
        NavigateOnDropEnabled(31);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebAttribute(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WebAttribute resolve(int value) {
            switch (value) {
            case 0: return AutoLoadImages;
            case 1: return JavascriptEnabled;
            case 2: return JavascriptCanOpenWindows;
            case 3: return JavascriptCanAccessClipboard;
            case 4: return LinksIncludedInFocusChain;
            case 5: return LocalStorageEnabled;
            case 6: return LocalContentCanAccessRemoteUrls;
            case 7: return XSSAuditingEnabled;
            case 8: return SpatialNavigationEnabled;
            case 9: return LocalContentCanAccessFileUrls;
            case 10: return HyperlinkAuditingEnabled;
            case 11: return ScrollAnimatorEnabled;
            case 12: return ErrorPageEnabled;
            case 13: return PluginsEnabled;
            case 14: return FullScreenSupportEnabled;
            case 15: return ScreenCaptureEnabled;
            case 16: return WebGLEnabled;
            case 17: return Accelerated2dCanvasEnabled;
            case 18: return AutoLoadIconsForPage;
            case 19: return TouchIconsEnabled;
            case 20: return FocusOnNavigationEnabled;
            case 21: return PrintElementBackgrounds;
            case 22: return AllowRunningInsecureContent;
            case 23: return AllowGeolocationOnInsecureOrigins;
            case 24: return AllowWindowActivationFromJavaScript;
            case 25: return ShowScrollBars;
            case 26: return PlaybackRequiresUserGesture;
            case 27: return WebRTCPublicInterfacesOnly;
            case 28: return JavascriptCanPaste;
            case 29: return DnsPrefetchEnabled;
            case 30: return PdfViewerEnabled;
            case 31: return NavigateOnDropEnabled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#defaultTextEncoding">QWebEngineSettings::<wbr/>defaultTextEncoding()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String defaultTextEncoding(){
        return defaultTextEncoding_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String defaultTextEncoding_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#fontFamily">QWebEngineSettings::<wbr/>fontFamily(QWebEngineSettings::FontFamily)const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which){
        return fontFamily_native_QWebEngineSettings_FontFamily_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), which.value());
    }
    
    @QtUninvokable
    private native java.lang.String fontFamily_native_QWebEngineSettings_FontFamily_constfct(long __this__nativeId, int which);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#fontSize">QWebEngineSettings::<wbr/>fontSize(QWebEngineSettings::FontSize)const</a></code></p>
     */
    @QtUninvokable
    public final int fontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type){
        return fontSize_native_QWebEngineSettings_FontSize_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native int fontSize_native_QWebEngineSettings_FontSize_constfct(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#resetAttribute">QWebEngineSettings::<wbr/>resetAttribute(QWebEngineSettings::WebAttribute)</a></code></p>
     */
    @QtUninvokable
    public final void resetAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr){
        resetAttribute_native_QWebEngineSettings_WebAttribute(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value());
    }
    
    @QtUninvokable
    private native void resetAttribute_native_QWebEngineSettings_WebAttribute(long __this__nativeId, int attr);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#resetFontFamily">QWebEngineSettings::<wbr/>resetFontFamily(QWebEngineSettings::FontFamily)</a></code></p>
     */
    @QtUninvokable
    public final void resetFontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which){
        resetFontFamily_native_QWebEngineSettings_FontFamily(QtJambi_LibraryUtilities.internal.nativeId(this), which.value());
    }
    
    @QtUninvokable
    private native void resetFontFamily_native_QWebEngineSettings_FontFamily(long __this__nativeId, int which);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#resetFontSize">QWebEngineSettings::<wbr/>resetFontSize(QWebEngineSettings::FontSize)</a></code></p>
     */
    @QtUninvokable
    public final void resetFontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type){
        resetFontSize_native_QWebEngineSettings_FontSize(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void resetFontSize_native_QWebEngineSettings_FontSize(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#resetUnknownUrlSchemePolicy">QWebEngineSettings::<wbr/>resetUnknownUrlSchemePolicy()</a></code></p>
     * <p>This function was introduced in Qt Qt 5.11.</p>
     */
    @QtUninvokable
    public final void resetUnknownUrlSchemePolicy(){
        resetUnknownUrlSchemePolicy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resetUnknownUrlSchemePolicy_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#setAttribute">QWebEngineSettings::<wbr/>setAttribute(QWebEngineSettings::WebAttribute,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr, boolean on){
        setAttribute_native_QWebEngineSettings_WebAttribute_bool(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value(), on);
    }
    
    @QtUninvokable
    private native void setAttribute_native_QWebEngineSettings_WebAttribute_bool(long __this__nativeId, int attr, boolean on);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#setDefaultTextEncoding">QWebEngineSettings::<wbr/>setDefaultTextEncoding(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setDefaultTextEncoding(java.lang.@NonNull String encoding){
        setDefaultTextEncoding_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), encoding);
    }
    
    @QtUninvokable
    private native void setDefaultTextEncoding_native_cref_QString(long __this__nativeId, java.lang.String encoding);
    
    /**
     * <p>See <code>QWebEngineSettings::<wbr/>setFontFamily(QWebEngineSettings::FontFamily,<wbr/>QString)</code></p>
     */
    @QtUninvokable
    public final void setFontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which, java.lang.@NonNull String family){
        setFontFamily_native_QWebEngineSettings_FontFamily_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), which.value(), family);
    }
    
    @QtUninvokable
    private native void setFontFamily_native_QWebEngineSettings_FontFamily_cref_QString(long __this__nativeId, int which, java.lang.String family);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#setFontSize">QWebEngineSettings::<wbr/>setFontSize(QWebEngineSettings::FontSize,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setFontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type, int size){
        setFontSize_native_QWebEngineSettings_FontSize_int(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), size);
    }
    
    @QtUninvokable
    private native void setFontSize_native_QWebEngineSettings_FontSize_int(long __this__nativeId, int type, int size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#setUnknownUrlSchemePolicy">QWebEngineSettings::<wbr/>setUnknownUrlSchemePolicy(QWebEngineSettings::UnknownUrlSchemePolicy)</a></code></p>
     * <p>This function was introduced in Qt Qt 5.11.</p>
     */
    @QtUninvokable
    public final void setUnknownUrlSchemePolicy(io.qt.webengine.core.QWebEngineSettings.@NonNull UnknownUrlSchemePolicy policy){
        setUnknownUrlSchemePolicy_native_QWebEngineSettings_UnknownUrlSchemePolicy(QtJambi_LibraryUtilities.internal.nativeId(this), policy.value());
    }
    
    @QtUninvokable
    private native void setUnknownUrlSchemePolicy_native_QWebEngineSettings_UnknownUrlSchemePolicy(long __this__nativeId, int policy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#testAttribute">QWebEngineSettings::<wbr/>testAttribute(QWebEngineSettings::WebAttribute)const</a></code></p>
     */
    @QtUninvokable
    public final boolean testAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr){
        return testAttribute_native_QWebEngineSettings_WebAttribute_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value());
    }
    
    @QtUninvokable
    private native boolean testAttribute_native_QWebEngineSettings_WebAttribute_constfct(long __this__nativeId, int attr);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginesettings.html#unknownUrlSchemePolicy">QWebEngineSettings::<wbr/>unknownUrlSchemePolicy()const</a></code></p>
     * <p>This function was introduced in Qt Qt 5.11.</p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineSettings.@NonNull UnknownUrlSchemePolicy unknownUrlSchemePolicy(){
        return io.qt.webengine.core.QWebEngineSettings.UnknownUrlSchemePolicy.resolve(unknownUrlSchemePolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int unknownUrlSchemePolicy_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    private QWebEngineSettings(QPrivateConstructor p) { super(p); } 
    
}
