package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>A data model that represents the history of a web engine page</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginehistorymodel.html">QWebEngineHistoryModel</a></code></p>
 * <p>This class was introduced in Qt 6.2.</p>
 */
public final class QWebEngineHistoryModel extends io.qt.core.QAbstractListModel
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineHistoryModel.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::Roles</a></code></p>
     */
    @QtUnlistedEnum
    public enum Roles implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::<wbr/>UrlRole</a></code></p>
         */
        UrlRole(256),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::<wbr/>TitleRole</a></code></p>
         */
        TitleRole(257),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::<wbr/>OffsetRole</a></code></p>
         */
        OffsetRole(258),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::<wbr/>IconUrlRole</a></code></p>
         */
        IconUrlRole(259);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Roles(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Roles resolve(int value) {
            switch (value) {
            case 256: return UrlRole;
            case 257: return TitleRole;
            case 258: return OffsetRole;
            case 259: return IconUrlRole;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QWebEngineHistoryModel::<wbr/>reset()</code></p>
     */
    @QtUninvokable
    public final void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::<wbr/>data(QModelIndex,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    @Override
    public java.lang.Object data(io.qt.core.@NonNull QModelIndex index, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), role);
    }
    
    @QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long index, int role);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#roleNames">QAbstractItemModel::<wbr/>roleNames()const</a></code></p>
     */
    @QtUninvokable
    @Override
    public java.util.@NonNull Map<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.core.@NonNull QByteArray> roleNames(){
        return roleNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.Map<java.lang.@QtPrimitiveType Integer, io.qt.core.QByteArray> roleNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::<wbr/>rowCount(QModelIndex)const</a></code></p>
     */
    @QtUninvokable
    @Override
    public int rowCount(io.qt.core.@NonNull QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    private QWebEngineHistoryModel(QPrivateConstructor p) { super(p); } 
    
}
