package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Web engine profile shared by multiple pages</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebengineprofile.html">QWebEngineProfile</a></code></p>
 */
public class QWebEngineProfile extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcUrlRequestInterceptor = null;
    @QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcUrlSchemeHandler;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineProfile.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#HttpCacheType-enum">QWebEngineProfile::HttpCacheType</a></code></p>
     */
    public enum HttpCacheType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#HttpCacheType-enum">QWebEngineProfile::<wbr/>MemoryHttpCache</a></code></p>
         */
        MemoryHttpCache(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#HttpCacheType-enum">QWebEngineProfile::<wbr/>DiskHttpCache</a></code></p>
         */
        DiskHttpCache(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#HttpCacheType-enum">QWebEngineProfile::<wbr/>NoCache</a></code></p>
         */
        NoCache(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HttpCacheType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HttpCacheType resolve(int value) {
            switch (value) {
            case 0: return MemoryHttpCache;
            case 1: return DiskHttpCache;
            case 2: return NoCache;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#PersistentCookiesPolicy-enum">QWebEngineProfile::PersistentCookiesPolicy</a></code></p>
     */
    public enum PersistentCookiesPolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#PersistentCookiesPolicy-enum">QWebEngineProfile::<wbr/>NoPersistentCookies</a></code></p>
         */
        NoPersistentCookies(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#PersistentCookiesPolicy-enum">QWebEngineProfile::<wbr/>AllowPersistentCookies</a></code></p>
         */
        AllowPersistentCookies(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#PersistentCookiesPolicy-enum">QWebEngineProfile::<wbr/>ForcePersistentCookies</a></code></p>
         */
        ForcePersistentCookies(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PersistentCookiesPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PersistentCookiesPolicy resolve(int value) {
            switch (value) {
            case 0: return NoPersistentCookies;
            case 1: return AllowPersistentCookies;
            case 2: return ForcePersistentCookies;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#downloadRequested">QWebEngineProfile::<wbr/>downloadRequested(QWebEngineDownloadRequest*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@Nullable QWebEngineDownloadRequest> downloadRequested = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#QWebEngineProfile">QWebEngineProfile::<wbr/>QWebEngineProfile(QObject*)</a></code></p>
     */
    public QWebEngineProfile(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWebEngineProfile instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#QWebEngineProfile-1">QWebEngineProfile::<wbr/>QWebEngineProfile(QString,<wbr/>QObject*)</a></code></p>
     */
    public QWebEngineProfile(java.lang.@NonNull String name, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, name, parent);
    }
    
    private native static void initialize_native(QWebEngineProfile instance, java.lang.String name, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#cachePath">QWebEngineProfile::<wbr/>cachePath()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String cachePath(){
        return cachePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String cachePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#clearAllVisitedLinks">QWebEngineProfile::<wbr/>clearAllVisitedLinks()</a></code></p>
     */
    @QtUninvokable
    public final void clearAllVisitedLinks(){
        clearAllVisitedLinks_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearAllVisitedLinks_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#clearHttpCache">QWebEngineProfile::<wbr/>clearHttpCache()</a></code></p>
     */
    @QtUninvokable
    public final void clearHttpCache(){
        clearHttpCache_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearHttpCache_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#clearVisitedLinks">QWebEngineProfile::<wbr/>clearVisitedLinks(QList&lt;QUrl&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void clearVisitedLinks(java.util.@NonNull Collection<? extends io.qt.core.@NonNull QUrl> urls){
        clearVisitedLinks_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), urls);
    }
    
    @QtUninvokable
    private native void clearVisitedLinks_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.core.QUrl> urls);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#clientCertificateStore">QWebEngineProfile::<wbr/>clientCertificateStore()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineClientCertificateStore clientCertificateStore(){
        return clientCertificateStore_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineClientCertificateStore clientCertificateStore_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#cookieStore">QWebEngineProfile::<wbr/>cookieStore()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineCookieStore cookieStore(){
        return cookieStore_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineCookieStore cookieStore_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#downloadPath">QWebEngineProfile::<wbr/>downloadPath()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String downloadPath(){
        return downloadPath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String downloadPath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#httpAcceptLanguage">QWebEngineProfile::<wbr/>httpAcceptLanguage()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String httpAcceptLanguage(){
        return httpAcceptLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String httpAcceptLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#httpCacheMaximumSize">QWebEngineProfile::<wbr/>httpCacheMaximumSize()const</a></code></p>
     */
    @QtUninvokable
    public final int httpCacheMaximumSize(){
        return httpCacheMaximumSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int httpCacheMaximumSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#httpCacheType">QWebEngineProfile::<wbr/>httpCacheType()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineProfile.@NonNull HttpCacheType httpCacheType(){
        return io.qt.webengine.core.QWebEngineProfile.HttpCacheType.resolve(httpCacheType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int httpCacheType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#httpUserAgent">QWebEngineProfile::<wbr/>httpUserAgent()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String httpUserAgent(){
        return httpUserAgent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String httpUserAgent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#installUrlSchemeHandler">QWebEngineProfile::<wbr/>installUrlSchemeHandler(QByteArray,<wbr/>QWebEngineUrlSchemeHandler*)</a></code></p>
     */
    @QtUninvokable
    public final void installUrlSchemeHandler(io.qt.core.@NonNull QByteArray scheme, io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler arg__2){
        installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
        if (arg__2 != null) {
            if(__rcUrlSchemeHandler==null)
                __rcUrlSchemeHandler = QtJambi_LibraryUtilities.internal.newRCList();
            __rcUrlSchemeHandler.add(arg__2);
        }
    }
    
    @QtUninvokable
    private native void installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long scheme, long arg__2);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#isOffTheRecord">QWebEngineProfile::<wbr/>isOffTheRecord()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isOffTheRecord(){
        return isOffTheRecord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOffTheRecord_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#isPushServiceEnabled">QWebEngineProfile::<wbr/>isPushServiceEnabled()const</a></code></p>
     * <p>This function was introduced in Qt 6.5.</p>
     */
    @QtUninvokable
    public final boolean isPushServiceEnabled(){
        return isPushServiceEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isPushServiceEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#isSpellCheckEnabled">QWebEngineProfile::<wbr/>isSpellCheckEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isSpellCheckEnabled(){
        return isSpellCheckEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSpellCheckEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#persistentCookiesPolicy">QWebEngineProfile::<wbr/>persistentCookiesPolicy()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineProfile.@NonNull PersistentCookiesPolicy persistentCookiesPolicy(){
        return io.qt.webengine.core.QWebEngineProfile.PersistentCookiesPolicy.resolve(persistentCookiesPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int persistentCookiesPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#persistentStoragePath">QWebEngineProfile::<wbr/>persistentStoragePath()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String persistentStoragePath(){
        return persistentStoragePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String persistentStoragePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#removeAllUrlSchemeHandlers">QWebEngineProfile::<wbr/>removeAllUrlSchemeHandlers()</a></code></p>
     */
    @QtUninvokable
    public final void removeAllUrlSchemeHandlers(){
        removeAllUrlSchemeHandlers_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void removeAllUrlSchemeHandlers_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#removeUrlScheme">QWebEngineProfile::<wbr/>removeUrlScheme(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void removeUrlScheme(io.qt.core.@NonNull QByteArray scheme){
        removeUrlScheme_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme));
    }
    
    @QtUninvokable
    private native void removeUrlScheme_native_cref_QByteArray(long __this__nativeId, long scheme);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#removeUrlSchemeHandler">QWebEngineProfile::<wbr/>removeUrlSchemeHandler(QWebEngineUrlSchemeHandler*)</a></code></p>
     */
    @QtUninvokable
    public final void removeUrlSchemeHandler(io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler arg__1){
        removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        if (arg__1 != null) {
            while (__rcUrlSchemeHandler != null && __rcUrlSchemeHandler.remove(arg__1)) ;
        }
    }
    
    @QtUninvokable
    private native void removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#requestIconForIconURL">QWebEngineProfile::<wbr/>requestIconForIconURL(const QUrl&amp;,<wbr/>int,<wbr/>std::function&lt;void(const QIcon&amp;,<wbr/>const QUrl&amp;)&gt;)const</a></code></p>
     * <p>This function was introduced in Qt 6.2.</p>
     */
    @QtUninvokable
    public final void requestIconForIconURL(io.qt.core.@NonNull QUrl url, int desiredSizeInPixel, java.util.function.@Nullable BiConsumer<io.qt.gui.@NonNull QIcon, io.qt.core.@NonNull QUrl> iconAvailableCallback){
        requestIconForIconURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback2_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), desiredSizeInPixel, iconAvailableCallback);
    }
    
    @QtUninvokable
    private native void requestIconForIconURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback2_constfct(long __this__nativeId, long url, int desiredSizeInPixel, java.util.function.BiConsumer<io.qt.gui.@NonNull QIcon, io.qt.core.@NonNull QUrl> iconAvailableCallback);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#requestIconForPageURL">QWebEngineProfile::<wbr/>requestIconForPageURL(const QUrl&amp;,<wbr/>int,<wbr/>std::function&lt;void(const QIcon&amp;,<wbr/>const QUrl&amp;,<wbr/>const QUrl&amp;)&gt;)const</a></code></p>
     * <p>This function was introduced in Qt 6.2.</p>
     */
    @QtUninvokable
    public final void requestIconForPageURL(io.qt.core.@NonNull QUrl url, int desiredSizeInPixel, io.qt.webengine.core.QWebEngineProfile.@Nullable IconAvailableCallback iconAvailableCallback){
        requestIconForPageURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), desiredSizeInPixel, iconAvailableCallback);
    }
    
    @QtUninvokable
    private native void requestIconForPageURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback_constfct(long __this__nativeId, long url, int desiredSizeInPixel, io.qt.webengine.core.QWebEngineProfile.IconAvailableCallback iconAvailableCallback);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#scripts">QWebEngineProfile::<wbr/>scripts()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineScriptCollection scripts(){
        return scripts_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineScriptCollection scripts_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setCachePath">QWebEngineProfile::<wbr/>setCachePath(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setCachePath(java.lang.@NonNull String path){
        setCachePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setCachePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setDownloadPath">QWebEngineProfile::<wbr/>setDownloadPath(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setDownloadPath(java.lang.@NonNull String path){
        setDownloadPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setDownloadPath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpAcceptLanguage">QWebEngineProfile::<wbr/>setHttpAcceptLanguage(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setHttpAcceptLanguage(java.lang.@NonNull String httpAcceptLanguage){
        setHttpAcceptLanguage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), httpAcceptLanguage);
    }
    
    @QtUninvokable
    private native void setHttpAcceptLanguage_native_cref_QString(long __this__nativeId, java.lang.String httpAcceptLanguage);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpCacheMaximumSize">QWebEngineProfile::<wbr/>setHttpCacheMaximumSize(int)</a></code></p>
     */
    @QtUninvokable
    public final void setHttpCacheMaximumSize(int maxSize){
        setHttpCacheMaximumSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), maxSize);
    }
    
    @QtUninvokable
    private native void setHttpCacheMaximumSize_native_int(long __this__nativeId, int maxSize);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpCacheType">QWebEngineProfile::<wbr/>setHttpCacheType(QWebEngineProfile::HttpCacheType)</a></code></p>
     */
    @QtUninvokable
    public final void setHttpCacheType(io.qt.webengine.core.QWebEngineProfile.@NonNull HttpCacheType arg__1){
        setHttpCacheType_native_QWebEngineProfile_HttpCacheType(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setHttpCacheType_native_QWebEngineProfile_HttpCacheType(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpUserAgent">QWebEngineProfile::<wbr/>setHttpUserAgent(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setHttpUserAgent(java.lang.@NonNull String userAgent){
        setHttpUserAgent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), userAgent);
    }
    
    @QtUninvokable
    private native void setHttpUserAgent_native_cref_QString(long __this__nativeId, java.lang.String userAgent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setNotificationPresenter">QWebEngineProfile::<wbr/>setNotificationPresenter(std::function&lt;void(std::unique_ptr&lt;QWebEngineNotification&gt;)&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setNotificationPresenter(java.util.function.@Nullable Consumer<@NonNull QWebEngineNotification> notificationPresenter){
        setNotificationPresenter_native_std_function_void_std_unique_ptr_QWebEngineNotification___(QtJambi_LibraryUtilities.internal.nativeId(this), notificationPresenter);
    }
    
    @QtUninvokable
    private native void setNotificationPresenter_native_std_function_void_std_unique_ptr_QWebEngineNotification___(long __this__nativeId, java.util.function.Consumer<@NonNull QWebEngineNotification> notificationPresenter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setPersistentCookiesPolicy">QWebEngineProfile::<wbr/>setPersistentCookiesPolicy(QWebEngineProfile::PersistentCookiesPolicy)</a></code></p>
     */
    @QtUninvokable
    public final void setPersistentCookiesPolicy(io.qt.webengine.core.QWebEngineProfile.@NonNull PersistentCookiesPolicy arg__1){
        setPersistentCookiesPolicy_native_QWebEngineProfile_PersistentCookiesPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setPersistentCookiesPolicy_native_QWebEngineProfile_PersistentCookiesPolicy(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setPersistentStoragePath">QWebEngineProfile::<wbr/>setPersistentStoragePath(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setPersistentStoragePath(java.lang.@NonNull String path){
        setPersistentStoragePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @QtUninvokable
    private native void setPersistentStoragePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setPushServiceEnabled">QWebEngineProfile::<wbr/>setPushServiceEnabled(bool)</a></code></p>
     * <p>This function was introduced in Qt 6.5.</p>
     */
    @QtUninvokable
    public final void setPushServiceEnabled(boolean enabled){
        setPushServiceEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setPushServiceEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setSpellCheckEnabled">QWebEngineProfile::<wbr/>setSpellCheckEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setSpellCheckEnabled(boolean enabled){
        setSpellCheckEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setSpellCheckEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setSpellCheckLanguages">QWebEngineProfile::<wbr/>setSpellCheckLanguages(QStringList)</a></code></p>
     */
    @QtUninvokable
    public final void setSpellCheckLanguages(java.util.@NonNull Collection<java.lang.@NonNull String> languages){
        setSpellCheckLanguages_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), languages);
    }
    
    @QtUninvokable
    private native void setSpellCheckLanguages_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> languages);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#setUrlRequestInterceptor">QWebEngineProfile::<wbr/>setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)</a></code></p>
     */
    @QtUninvokable
    public final void setUrlRequestInterceptor(io.qt.webengine.core.@Nullable QWebEngineUrlRequestInterceptor interceptor){
        setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @QtUninvokable
    private native void setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#settings">QWebEngineProfile::<wbr/>settings()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineSettings settings(){
        return settings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineSettings settings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#spellCheckLanguages">QWebEngineProfile::<wbr/>spellCheckLanguages()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList spellCheckLanguages(){
        return spellCheckLanguages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList spellCheckLanguages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#storageName">QWebEngineProfile::<wbr/>storageName()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String storageName(){
        return storageName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String storageName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#urlSchemeHandler">QWebEngineProfile::<wbr/>urlSchemeHandler(QByteArray)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler urlSchemeHandler(io.qt.core.@NonNull QByteArray arg__1){
        return urlSchemeHandler_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineUrlSchemeHandler urlSchemeHandler_native_cref_QByteArray_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#visitedLinksContainsUrl">QWebEngineProfile::<wbr/>visitedLinksContainsUrl(QUrl)const</a></code></p>
     */
    @QtUninvokable
    public final boolean visitedLinksContainsUrl(io.qt.core.@NonNull QUrl url){
        return visitedLinksContainsUrl_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native boolean visitedLinksContainsUrl_native_cref_QUrl_constfct(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineprofile.html#defaultProfile">QWebEngineProfile::<wbr/>defaultProfile()</a></code></p>
     */
    public native static io.qt.webengine.core.@Nullable QWebEngineProfile defaultProfile();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineProfile(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineProfile(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWebEngineProfile instance, QDeclarativeConstructor constructor);
    
    /**
     * <p>Java wrapper for Qt callable <code>std::function&lt;void(const QIcon&amp;,const QUrl&amp;,const QUrl&amp;)&gt;</code></p>
     */
    @FunctionalInterface
    public interface IconAvailableCallback {
        public void accept(io.qt.gui.@NonNull QIcon icon, io.qt.core.@NonNull QUrl url1, io.qt.core.@NonNull QUrl url2);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineProfile(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEngineProfile() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineProfile(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEngineProfile(java.lang.@NonNull String name) {
        this(name, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #installUrlSchemeHandler(io.qt.core.QByteArray, io.qt.webengine.core.QWebEngineUrlSchemeHandler)}.</p>
     */
    @QtUninvokable
    public final void installUrlSchemeHandler(byte @NonNull[] scheme, io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler arg__2) {
        installUrlSchemeHandler(new io.qt.core.QByteArray(scheme), arg__2);
    }
    
    /**
     * <p>Overloaded function for {@link #removeUrlScheme(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void removeUrlScheme(byte @NonNull[] scheme) {
        removeUrlScheme(new io.qt.core.QByteArray(scheme));
    }
    
    /**
     * <p>Overloaded function for {@link #requestIconForIconURL(io.qt.core.QUrl, int, java.util.function.BiConsumer)}.</p>
     */
    @QtUninvokable
    public final void requestIconForIconURL(java.lang.@NonNull String url, int desiredSizeInPixel, java.util.function.@Nullable BiConsumer<io.qt.gui.@NonNull QIcon, io.qt.core.@NonNull QUrl> iconAvailableCallback) {
        requestIconForIconURL(new io.qt.core.QUrl(url), desiredSizeInPixel, iconAvailableCallback);
    }
    
    /**
     * <p>Overloaded function for {@link #requestIconForPageURL(io.qt.core.QUrl, int, io.qt.webengine.core.QWebEngineProfile.IconAvailableCallback)}.</p>
     */
    @QtUninvokable
    public final void requestIconForPageURL(java.lang.@NonNull String url, int desiredSizeInPixel, io.qt.webengine.core.QWebEngineProfile.@Nullable IconAvailableCallback iconAvailableCallback) {
        requestIconForPageURL(new io.qt.core.QUrl(url), desiredSizeInPixel, iconAvailableCallback);
    }
    
    /**
     * <p>Overloaded function for {@link #urlSchemeHandler(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineUrlSchemeHandler urlSchemeHandler(byte @NonNull[] arg__1) {
        return urlSchemeHandler(new io.qt.core.QByteArray(arg__1));
    }
    
    /**
     * <p>Overloaded function for {@link #visitedLinksContainsUrl(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final boolean visitedLinksContainsUrl(java.lang.@NonNull String url) {
        return visitedLinksContainsUrl(new io.qt.core.QUrl(url));
    }
}
