package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Object to view and edit web documents</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginepage.html">QWebEnginePage</a></code></p>
 */
public class QWebEnginePage extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcDevToolsPage = null;
    @QtPropertyMember(enabled=false)
    private Object __rcInspectedPage = null;
    @QtPropertyMember(enabled=false)
    private Object __rcUrlRequestInterceptor = null;
    @QtPropertyMember(enabled=false)
    private Object __rcWebChannel = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEnginePage.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::Feature</a></code></p>
     */
    public enum Feature implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>Notifications</a></code></p>
         */
        Notifications(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>Geolocation</a></code></p>
         */
        Geolocation(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>MediaAudioCapture</a></code></p>
         */
        MediaAudioCapture(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>MediaVideoCapture</a></code></p>
         */
        MediaVideoCapture(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>MediaAudioVideoCapture</a></code></p>
         */
        MediaAudioVideoCapture(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>MouseLock</a></code></p>
         */
        MouseLock(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>DesktopVideoCapture</a></code></p>
         */
        DesktopVideoCapture(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#Feature-enum">QWebEnginePage::<wbr/>DesktopAudioVideoCapture</a></code></p>
         */
        DesktopAudioVideoCapture(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Feature(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Feature resolve(int value) {
            switch (value) {
            case 0: return Notifications;
            case 1: return Geolocation;
            case 2: return MediaAudioCapture;
            case 3: return MediaVideoCapture;
            case 4: return MediaAudioVideoCapture;
            case 5: return MouseLock;
            case 6: return DesktopVideoCapture;
            case 7: return DesktopAudioVideoCapture;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::FileSelectionMode</a></code></p>
     */
    public enum FileSelectionMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::<wbr/>FileSelectOpen</a></code></p>
         */
        FileSelectOpen(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::<wbr/>FileSelectOpenMultiple</a></code></p>
         */
        FileSelectOpenMultiple(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::<wbr/>FileSelectUploadFolder</a></code></p>
         */
        FileSelectUploadFolder(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FileSelectionMode-enum">QWebEnginePage::<wbr/>FileSelectSave</a></code></p>
         */
        FileSelectSave(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FileSelectionMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FileSelectionMode resolve(int value) {
            switch (value) {
            case 0: return FileSelectOpen;
            case 1: return FileSelectOpenMultiple;
            case 2: return FileSelectUploadFolder;
            case 3: return FileSelectSave;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FindFlag-enum">QWebEnginePage::FindFlag</a></code></p>
     * 
     * @see FindFlags
     */
    public enum FindFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FindFlag-enum">QWebEnginePage::<wbr/>FindBackward</a></code></p>
         */
        FindBackward(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#FindFlag-enum">QWebEnginePage::<wbr/>FindCaseSensitively</a></code></p>
         */
        FindCaseSensitively(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FindFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        @Override
        public @NonNull FindFlags asFlags() {
            return new FindFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull FindFlags combined(@NonNull FindFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull FindFlags cleared(@NonNull FindFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link FindFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull FindFlags flags(@Nullable FindFlag @NonNull... values) {
            return new FindFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FindFlag resolve(int value) {
            switch (value) {
            case 1: return FindBackward;
            case 2: return FindCaseSensitively;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link FindFlag}
     */
    public static final class FindFlags extends QFlags<FindFlag> implements Comparable<FindFlags> {
        private static final long serialVersionUID = 0xd99302055005fdf3L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new FindFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public FindFlags(@Nullable FindFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new FindFlags with given <code>value</code>.
         * @param value
         */
        public FindFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new FindFlags
         */
        @Override
        public final @NonNull FindFlags combined(@StrictNonNull FindFlag e){
            return new FindFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        @Override
        public final @NonNull FindFlags setFlag(@Nullable FindFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        @Override
        public final @NonNull FindFlags setFlag(@Nullable FindFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this FindFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull FindFlag @NonNull[] flags(){
            return super.flags(FindFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull FindFlags clone(){
            return new FindFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull FindFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::JavaScriptConsoleMessageLevel</a></code></p>
     */
    public enum JavaScriptConsoleMessageLevel implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::<wbr/>InfoMessageLevel</a></code></p>
         */
        InfoMessageLevel(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::<wbr/>WarningMessageLevel</a></code></p>
         */
        WarningMessageLevel(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#JavaScriptConsoleMessageLevel-enum">QWebEnginePage::<wbr/>ErrorMessageLevel</a></code></p>
         */
        ErrorMessageLevel(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private JavaScriptConsoleMessageLevel(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull JavaScriptConsoleMessageLevel resolve(int value) {
            switch (value) {
            case 0: return InfoMessageLevel;
            case 1: return WarningMessageLevel;
            case 2: return ErrorMessageLevel;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#LifecycleState-enum">QWebEnginePage::LifecycleState</a></code></p>
     */
    public enum LifecycleState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#LifecycleState-enum">QWebEnginePage::<wbr/>LifecycleState::<wbr/>Active</a></code></p>
         */
        Active(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#LifecycleState-enum">QWebEnginePage::<wbr/>LifecycleState::<wbr/>Frozen</a></code></p>
         */
        Frozen(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#LifecycleState-enum">QWebEnginePage::<wbr/>LifecycleState::<wbr/>Discarded</a></code></p>
         */
        Discarded(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private LifecycleState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull LifecycleState resolve(int value) {
            switch (value) {
            case 0: return Active;
            case 1: return Frozen;
            case 2: return Discarded;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::NavigationType</a></code></p>
     */
    public enum NavigationType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::<wbr/>NavigationTypeLinkClicked</a></code></p>
         */
        NavigationTypeLinkClicked(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::<wbr/>NavigationTypeTyped</a></code></p>
         */
        NavigationTypeTyped(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::<wbr/>NavigationTypeFormSubmitted</a></code></p>
         */
        NavigationTypeFormSubmitted(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::<wbr/>NavigationTypeBackForward</a></code></p>
         */
        NavigationTypeBackForward(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::<wbr/>NavigationTypeReload</a></code></p>
         */
        NavigationTypeReload(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::<wbr/>NavigationTypeOther</a></code></p>
         */
        NavigationTypeOther(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#NavigationType-enum">QWebEnginePage::<wbr/>NavigationTypeRedirect</a></code></p>
         */
        NavigationTypeRedirect(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NavigationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NavigationType resolve(int value) {
            switch (value) {
            case 0: return NavigationTypeLinkClicked;
            case 1: return NavigationTypeTyped;
            case 2: return NavigationTypeFormSubmitted;
            case 3: return NavigationTypeBackForward;
            case 4: return NavigationTypeReload;
            case 5: return NavigationTypeOther;
            case 6: return NavigationTypeRedirect;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::PermissionPolicy</a></code></p>
     */
    public enum PermissionPolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::<wbr/>PermissionUnknown</a></code></p>
         */
        PermissionUnknown(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::<wbr/>PermissionGrantedByUser</a></code></p>
         */
        PermissionGrantedByUser(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#PermissionPolicy-enum">QWebEnginePage::<wbr/>PermissionDeniedByUser</a></code></p>
         */
        PermissionDeniedByUser(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PermissionPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PermissionPolicy resolve(int value) {
            switch (value) {
            case 0: return PermissionUnknown;
            case 1: return PermissionGrantedByUser;
            case 2: return PermissionDeniedByUser;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#RenderProcessTerminationStatus-enum">QWebEnginePage::RenderProcessTerminationStatus</a></code></p>
     */
    public enum RenderProcessTerminationStatus implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#RenderProcessTerminationStatus-enum">QWebEnginePage::<wbr/>NormalTerminationStatus</a></code></p>
         */
        NormalTerminationStatus(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#RenderProcessTerminationStatus-enum">QWebEnginePage::<wbr/>AbnormalTerminationStatus</a></code></p>
         */
        AbnormalTerminationStatus(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#RenderProcessTerminationStatus-enum">QWebEnginePage::<wbr/>CrashedTerminationStatus</a></code></p>
         */
        CrashedTerminationStatus(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#RenderProcessTerminationStatus-enum">QWebEnginePage::<wbr/>KilledTerminationStatus</a></code></p>
         */
        KilledTerminationStatus(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderProcessTerminationStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RenderProcessTerminationStatus resolve(int value) {
            switch (value) {
            case 0: return NormalTerminationStatus;
            case 1: return AbnormalTerminationStatus;
            case 2: return CrashedTerminationStatus;
            case 3: return KilledTerminationStatus;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::WebAction</a></code></p>
     */
    public enum WebAction implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>NoWebAction</a></code></p>
         */
        NoWebAction(-1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Back</a></code></p>
         */
        Back(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Forward</a></code></p>
         */
        Forward(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Stop</a></code></p>
         */
        Stop(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Reload</a></code></p>
         */
        Reload(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Cut</a></code></p>
         */
        Cut(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Copy</a></code></p>
         */
        Copy(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Paste</a></code></p>
         */
        Paste(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Undo</a></code></p>
         */
        Undo(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Redo</a></code></p>
         */
        Redo(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>SelectAll</a></code></p>
         */
        SelectAll(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ReloadAndBypassCache</a></code></p>
         */
        ReloadAndBypassCache(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>PasteAndMatchStyle</a></code></p>
         */
        PasteAndMatchStyle(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>OpenLinkInThisWindow</a></code></p>
         */
        OpenLinkInThisWindow(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>OpenLinkInNewWindow</a></code></p>
         */
        OpenLinkInNewWindow(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>OpenLinkInNewTab</a></code></p>
         */
        OpenLinkInNewTab(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>CopyLinkToClipboard</a></code></p>
         */
        CopyLinkToClipboard(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>DownloadLinkToDisk</a></code></p>
         */
        DownloadLinkToDisk(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>CopyImageToClipboard</a></code></p>
         */
        CopyImageToClipboard(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>CopyImageUrlToClipboard</a></code></p>
         */
        CopyImageUrlToClipboard(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>DownloadImageToDisk</a></code></p>
         */
        DownloadImageToDisk(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>CopyMediaUrlToClipboard</a></code></p>
         */
        CopyMediaUrlToClipboard(20),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleMediaControls</a></code></p>
         */
        ToggleMediaControls(21),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleMediaLoop</a></code></p>
         */
        ToggleMediaLoop(22),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleMediaPlayPause</a></code></p>
         */
        ToggleMediaPlayPause(23),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleMediaMute</a></code></p>
         */
        ToggleMediaMute(24),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>DownloadMediaToDisk</a></code></p>
         */
        DownloadMediaToDisk(25),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>InspectElement</a></code></p>
         */
        InspectElement(26),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ExitFullScreen</a></code></p>
         */
        ExitFullScreen(27),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>RequestClose</a></code></p>
         */
        RequestClose(28),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Unselect</a></code></p>
         */
        Unselect(29),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>SavePage</a></code></p>
         */
        SavePage(30),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>OpenLinkInNewBackgroundTab</a></code></p>
         */
        OpenLinkInNewBackgroundTab(31),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ViewSource</a></code></p>
         */
        ViewSource(32),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleBold</a></code></p>
         */
        ToggleBold(33),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleItalic</a></code></p>
         */
        ToggleItalic(34),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleUnderline</a></code></p>
         */
        ToggleUnderline(35),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>ToggleStrikethrough</a></code></p>
         */
        ToggleStrikethrough(36),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>AlignLeft</a></code></p>
         */
        AlignLeft(37),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>AlignCenter</a></code></p>
         */
        AlignCenter(38),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>AlignRight</a></code></p>
         */
        AlignRight(39),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>AlignJustified</a></code></p>
         */
        AlignJustified(40),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Indent</a></code></p>
         */
        Indent(41),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>Outdent</a></code></p>
         */
        Outdent(42),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>InsertOrderedList</a></code></p>
         */
        InsertOrderedList(43),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>InsertUnorderedList</a></code></p>
         */
        InsertUnorderedList(44),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebAction-enum">QWebEnginePage::<wbr/>WebActionCount</a></code></p>
         */
        WebActionCount(45);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WebAction resolve(int value) {
            switch (value) {
            case -1: return NoWebAction;
            case 0: return Back;
            case 1: return Forward;
            case 2: return Stop;
            case 3: return Reload;
            case 4: return Cut;
            case 5: return Copy;
            case 6: return Paste;
            case 7: return Undo;
            case 8: return Redo;
            case 9: return SelectAll;
            case 10: return ReloadAndBypassCache;
            case 11: return PasteAndMatchStyle;
            case 12: return OpenLinkInThisWindow;
            case 13: return OpenLinkInNewWindow;
            case 14: return OpenLinkInNewTab;
            case 15: return CopyLinkToClipboard;
            case 16: return DownloadLinkToDisk;
            case 17: return CopyImageToClipboard;
            case 18: return CopyImageUrlToClipboard;
            case 19: return DownloadImageToDisk;
            case 20: return CopyMediaUrlToClipboard;
            case 21: return ToggleMediaControls;
            case 22: return ToggleMediaLoop;
            case 23: return ToggleMediaPlayPause;
            case 24: return ToggleMediaMute;
            case 25: return DownloadMediaToDisk;
            case 26: return InspectElement;
            case 27: return ExitFullScreen;
            case 28: return RequestClose;
            case 29: return Unselect;
            case 30: return SavePage;
            case 31: return OpenLinkInNewBackgroundTab;
            case 32: return ViewSource;
            case 33: return ToggleBold;
            case 34: return ToggleItalic;
            case 35: return ToggleUnderline;
            case 36: return ToggleStrikethrough;
            case 37: return AlignLeft;
            case 38: return AlignCenter;
            case 39: return AlignRight;
            case 40: return AlignJustified;
            case 41: return Indent;
            case 42: return Outdent;
            case 43: return InsertOrderedList;
            case 44: return InsertUnorderedList;
            case 45: return WebActionCount;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::WebWindowType</a></code></p>
     */
    public enum WebWindowType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::<wbr/>WebBrowserWindow</a></code></p>
         */
        WebBrowserWindow(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::<wbr/>WebBrowserTab</a></code></p>
         */
        WebBrowserTab(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::<wbr/>WebDialog</a></code></p>
         */
        WebDialog(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginepage.html#WebWindowType-enum">QWebEnginePage::<wbr/>WebBrowserBackgroundTab</a></code></p>
         */
        WebBrowserBackgroundTab(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebWindowType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WebWindowType resolve(int value) {
            switch (value) {
            case 0: return WebBrowserWindow;
            case 1: return WebBrowserTab;
            case 2: return WebDialog;
            case 3: return WebBrowserBackgroundTab;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code>QWebEnginePage::<wbr/>_q_aboutToDelete()</code></p>
     */
    public final @NonNull Signal0 _q_aboutToDelete = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#audioMutedChanged">QWebEnginePage::<wbr/>audioMutedChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="audioMuted")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> audioMutedChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#authenticationRequired">QWebEnginePage::<wbr/>authenticationRequired(QUrl,<wbr/>QAuthenticator*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal2<io.qt.core.@NonNull QUrl, io.qt.network.@Nullable QAuthenticator> authenticationRequired = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#certificateError">QWebEnginePage::<wbr/>certificateError(QWebEngineCertificateError)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineCertificateError> certificateError = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#contentsSize-prop">QWebEnginePage::<wbr/>contentsSizeChanged(QSizeF)</a></code></p>
     */
    @QtPropertyNotify(name="contentsSize")
    public final @NonNull Signal1<io.qt.core.@NonNull QSizeF> contentsSizeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#featurePermissionRequestCanceled">QWebEnginePage::<wbr/>featurePermissionRequestCanceled(QUrl,<wbr/>QWebEnginePage::Feature)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.core.@NonNull QUrl, io.qt.webengine.core.QWebEnginePage.@NonNull Feature> featurePermissionRequestCanceled = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#featurePermissionRequested">QWebEnginePage::<wbr/>featurePermissionRequested(QUrl,<wbr/>QWebEnginePage::Feature)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.core.@NonNull QUrl, io.qt.webengine.core.QWebEnginePage.@NonNull Feature> featurePermissionRequested = new Signal2<>();

    /**
     * <p>See <code>QWebEnginePage::<wbr/>fileSystemAccessRequested(QWebEngineFileSystemAccessRequest)</code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineFileSystemAccessRequest> fileSystemAccessRequested = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#findTextFinished">QWebEnginePage::<wbr/>findTextFinished(QWebEngineFindTextResult)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineFindTextResult> findTextFinished = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#fullScreenRequested">QWebEnginePage::<wbr/>fullScreenRequested(QWebEngineFullScreenRequest)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineFullScreenRequest> fullScreenRequested = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#geometryChangeRequested">QWebEnginePage::<wbr/>geometryChangeRequested(QRect)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QRect> geometryChangeRequested = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#iconChanged">QWebEnginePage::<wbr/>iconChanged(QIcon)</a></code></p>
     */
    @QtPropertyNotify(name="icon")
    public final @NonNull Signal1<io.qt.gui.@NonNull QIcon> iconChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#iconUrlChanged">QWebEnginePage::<wbr/>iconUrlChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="iconUrl")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> iconUrlChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::<wbr/>lifecycleStateChanged(QWebEnginePage::LifecycleState)</a></code></p>
     */
    @QtPropertyNotify(name="lifecycleState")
    public final @NonNull Signal1<io.qt.webengine.core.QWebEnginePage.@NonNull LifecycleState> lifecycleStateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#linkHovered">QWebEnginePage::<wbr/>linkHovered(QString)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> linkHovered = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#loadFinished">QWebEnginePage::<wbr/>loadFinished(bool)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> loadFinished = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#loadProgress">QWebEnginePage::<wbr/>loadProgress(int)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> loadProgress = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#loadStarted">QWebEnginePage::<wbr/>loadStarted()</a></code></p>
     */
    public final @NonNull Signal0 loadStarted = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#loadingChanged">QWebEnginePage::<wbr/>loadingChanged(QWebEngineLoadingInfo)</a></code></p>
     * <p>This signal was introduced in Qt 6.2.</p>
     */
    @QtPropertyNotify(name="loading")
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineLoadingInfo> loadingChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#navigationRequested">QWebEnginePage::<wbr/>navigationRequested(QWebEngineNavigationRequest&amp;)</a></code></p>
     * <p>This signal was introduced in Qt 6.2.</p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineNavigationRequest> navigationRequested = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#newWindowRequested">QWebEnginePage::<wbr/>newWindowRequested(QWebEngineNewWindowRequest&amp;)</a></code></p>
     * <p>This signal was introduced in Qt 6.2.</p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineNewWindowRequest> newWindowRequested = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#pdfPrintingFinished">QWebEnginePage::<wbr/>pdfPrintingFinished(QString,<wbr/>bool)</a></code></p>
     */
    public final @NonNull Signal2<java.lang.@NonNull String, java.lang.@QtPrimitiveType@NonNull Boolean> pdfPrintingFinished = new Signal2<>();

    /**
     * <p>See <code>QWebEnginePage::<wbr/>printRequested()</code></p>
     */
    public final @NonNull Signal0 printRequested = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#proxyAuthenticationRequired">QWebEnginePage::<wbr/>proxyAuthenticationRequired(QUrl,<wbr/>QAuthenticator*,<wbr/>QString)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal3<io.qt.core.@NonNull QUrl, io.qt.network.@Nullable QAuthenticator, java.lang.@NonNull String> proxyAuthenticationRequired = new Signal3<>();

    /**
     * <p>See <code>QWebEnginePage::<wbr/>quotaRequested(QWebEngineQuotaRequest)</code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineQuotaRequest> quotaRequested = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#recentlyAudibleChanged">QWebEnginePage::<wbr/>recentlyAudibleChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="recentlyAudible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> recentlyAudibleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#recommendedState-prop">QWebEnginePage::<wbr/>recommendedStateChanged(QWebEnginePage::LifecycleState)</a></code></p>
     */
    @QtPropertyNotify(name="recommendedState")
    public final @NonNull Signal1<io.qt.webengine.core.QWebEnginePage.@NonNull LifecycleState> recommendedStateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#registerProtocolHandlerRequested">QWebEnginePage::<wbr/>registerProtocolHandlerRequested(QWebEngineRegisterProtocolHandlerRequest)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineRegisterProtocolHandlerRequest> registerProtocolHandlerRequested = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#renderProcessPidChanged">QWebEnginePage::<wbr/>renderProcessPidChanged(qint64)</a></code></p>
     */
    @QtPropertyNotify(name="renderProcessPid")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> renderProcessPidChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#renderProcessTerminated">QWebEnginePage::<wbr/>renderProcessTerminated(QWebEnginePage::RenderProcessTerminationStatus,<wbr/>int)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.webengine.core.QWebEnginePage.@NonNull RenderProcessTerminationStatus, java.lang.@QtPrimitiveType@NonNull Integer> renderProcessTerminated = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#scrollPosition-prop">QWebEnginePage::<wbr/>scrollPositionChanged(QPointF)</a></code></p>
     */
    @QtPropertyNotify(name="scrollPosition")
    public final @NonNull Signal1<io.qt.core.@NonNull QPointF> scrollPositionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#selectClientCertificate">QWebEnginePage::<wbr/>selectClientCertificate(QWebEngineClientCertificateSelection)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.webengine.core.@NonNull QWebEngineClientCertificateSelection> selectClientCertificate = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#selectionChanged">QWebEnginePage::<wbr/>selectionChanged()</a></code></p>
     */
    public final @NonNull Signal0 selectionChanged = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#titleChanged">QWebEnginePage::<wbr/>titleChanged(QString)</a></code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> titleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#urlChanged">QWebEnginePage::<wbr/>urlChanged(QUrl)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> urlChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#visible-prop">QWebEnginePage::<wbr/>visibleChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="visible")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> visibleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#windowCloseRequested">QWebEnginePage::<wbr/>windowCloseRequested()</a></code></p>
     */
    public final @NonNull Signal0 windowCloseRequested = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#QWebEnginePage">QWebEnginePage::<wbr/>QWebEnginePage(QObject*)</a></code></p>
     */
    public QWebEnginePage(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWebEnginePage instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#QWebEnginePage-1">QWebEnginePage::<wbr/>QWebEnginePage(QWebEngineProfile*,<wbr/>QObject*)</a></code></p>
     */
    public QWebEnginePage(io.qt.webengine.core.@Nullable QWebEngineProfile profile, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, profile, parent);
    }
    
    private native static void initialize_native(QWebEnginePage instance, io.qt.webengine.core.QWebEngineProfile profile, io.qt.core.QObject parent);
    
    /**
     * <p>See <code>QWebEnginePage::<wbr/>acceptAsNewWindow(QWebEngineNewWindowRequest&amp;)</code></p>
     */
    @QtUninvokable
    public final void acceptAsNewWindow(io.qt.webengine.core.@StrictNonNull QWebEngineNewWindowRequest request){
        java.util.Objects.requireNonNull(request, "Argument 'request': null not expected.");
        acceptAsNewWindow_native_ref_QWebEngineNewWindowRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    @QtUninvokable
    private native void acceptAsNewWindow_native_ref_QWebEngineNewWindowRequest(long __this__nativeId, long request);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#action">QWebEnginePage::<wbr/>action(QWebEnginePage::WebAction)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.gui.@Nullable QAction action(io.qt.webengine.core.QWebEnginePage.@NonNull WebAction action){
        return action_native_QWebEnginePage_WebAction_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), action.value());
    }
    
    @QtUninvokable
    private native io.qt.gui.QAction action_native_QWebEnginePage_WebAction_constfct(long __this__nativeId, int action);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#backgroundColor-prop">QWebEnginePage::<wbr/>backgroundColor()const</a></code></p>
     */
    @QtPropertyReader(name="backgroundColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor backgroundColor(){
        return backgroundColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor backgroundColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#contentsSize-prop">QWebEnginePage::<wbr/>contentsSize()const</a></code></p>
     */
    @QtPropertyReader(name="contentsSize")
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF contentsSize(){
        return contentsSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSizeF contentsSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#devToolsPage">QWebEnginePage::<wbr/>devToolsPage()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEnginePage devToolsPage(){
        return devToolsPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEnginePage devToolsPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#download">QWebEnginePage::<wbr/>download(QUrl,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void download(io.qt.core.@NonNull QUrl url, java.lang.@NonNull String filename){
        download_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), filename);
    }
    
    @QtUninvokable
    private native void download_native_cref_QUrl_cref_QString(long __this__nativeId, long url, java.lang.String filename);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#findText">QWebEnginePage::<wbr/>findText(const QString&amp;,<wbr/>QWebEnginePage::FindFlags,<wbr/>const std::function&lt;void(const QWebEngineFindTextResult&amp;)&gt;&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString, io.qt.webengine.core.QWebEnginePage.@NonNull FindFlags options, java.util.function.@Nullable Consumer<@NonNull QWebEngineFindTextResult> resultCallback){
        findText_native_cref_QString_QWebEnginePage_FindFlags_cref_std_function_void_const_QWebEngineFindTextResult_ref__(QtJambi_LibraryUtilities.internal.nativeId(this), subString, options.value(), resultCallback);
    }
    
    @QtUninvokable
    private native void findText_native_cref_QString_QWebEnginePage_FindFlags_cref_std_function_void_const_QWebEngineFindTextResult_ref__(long __this__nativeId, java.lang.String subString, int options, java.util.function.Consumer<@NonNull QWebEngineFindTextResult> resultCallback);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#hasSelection-prop">QWebEnginePage::<wbr/>hasSelection()const</a></code></p>
     */
    @QtPropertyReader(name="hasSelection")
    @QtUninvokable
    public final boolean hasSelection(){
        return hasSelection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasSelection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#history">QWebEnginePage::<wbr/>history()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistory history(){
        return history_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistory history_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#icon-prop">QWebEnginePage::<wbr/>icon()const</a></code></p>
     */
    @QtPropertyReader(name="icon")
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon icon(){
        return icon_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QIcon icon_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#iconUrl-prop">QWebEnginePage::<wbr/>iconUrl()const</a></code></p>
     */
    @QtPropertyReader(name="iconUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl iconUrl(){
        return iconUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl iconUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#inspectedPage">QWebEnginePage::<wbr/>inspectedPage()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEnginePage inspectedPage(){
        return inspectedPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEnginePage inspectedPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#audioMuted-prop">QWebEnginePage::<wbr/>isAudioMuted()const</a></code></p>
     */
    @QtPropertyReader(name="audioMuted")
    @QtUninvokable
    public final boolean isAudioMuted(){
        return isAudioMuted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAudioMuted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#loading-prop">QWebEnginePage::<wbr/>isLoading()const</a></code></p>
     */
    @QtPropertyReader(name="loading")
    @QtUninvokable
    public final boolean isLoading(){
        return isLoading_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isLoading_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#visible-prop">QWebEnginePage::<wbr/>isVisible()const</a></code></p>
     */
    @QtPropertyReader(name="visible")
    @QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::<wbr/>lifecycleState()const</a></code></p>
     */
    @QtPropertyReader(name="lifecycleState")
    @QtUninvokable
    public final io.qt.webengine.core.QWebEnginePage.@NonNull LifecycleState lifecycleState(){
        return io.qt.webengine.core.QWebEnginePage.LifecycleState.resolve(lifecycleState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int lifecycleState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#load">QWebEnginePage::<wbr/>load(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void load(io.qt.core.@NonNull QUrl url){
        load_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void load_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#load-1">QWebEnginePage::<wbr/>load(QWebEngineHttpRequest)</a></code></p>
     */
    @QtUninvokable
    public final void load(io.qt.webengine.core.@NonNull QWebEngineHttpRequest request){
        load_native_cref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request));
    }
    
    @QtUninvokable
    private native void load_native_cref_QWebEngineHttpRequest(long __this__nativeId, long request);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#printToPdf">QWebEnginePage::<wbr/>printToPdf(QString,<wbr/>QPageLayout,<wbr/>QPageRanges)</a></code></p>
     */
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath, io.qt.gui.@NonNull QPageLayout layout, io.qt.gui.@NonNull QPageRanges ranges){
        printToPdf_native_cref_QString_cref_QPageLayout_cref_QPageRanges(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, QtJambi_LibraryUtilities.internal.checkedNativeId(layout), QtJambi_LibraryUtilities.internal.checkedNativeId(ranges));
    }
    
    @QtUninvokable
    private native void printToPdf_native_cref_QString_cref_QPageLayout_cref_QPageRanges(long __this__nativeId, java.lang.String filePath, long layout, long ranges);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#printToPdf-1">QWebEnginePage::<wbr/>printToPdf(const std::function&lt;void(const QByteArray&amp;)&gt;&amp;,<wbr/>const QPageLayout&amp;,<wbr/>const QPageRanges&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void printToPdf(java.util.function.@StrictNonNull @Nullable Consumer<io.qt.core.@NonNull QByteArray> resultCallback, io.qt.gui.@NonNull QPageLayout layout, io.qt.gui.@NonNull QPageRanges ranges){
        java.util.Objects.requireNonNull(resultCallback, "Argument 'resultCallback': null not expected.");
        printToPdf_native_cref_std_function_void_const_QByteArray_ref___cref_QPageLayout_cref_QPageRanges(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback, QtJambi_LibraryUtilities.internal.checkedNativeId(layout), QtJambi_LibraryUtilities.internal.checkedNativeId(ranges));
    }
    
    @QtUninvokable
    private native void printToPdf_native_cref_std_function_void_const_QByteArray_ref___cref_QPageLayout_cref_QPageRanges(long __this__nativeId, java.util.function.Consumer<io.qt.core.@NonNull QByteArray> resultCallback, long layout, long ranges);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#profile">QWebEnginePage::<wbr/>profile()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineProfile profile(){
        return profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineProfile profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#recentlyAudible-prop">QWebEnginePage::<wbr/>recentlyAudible()const</a></code></p>
     */
    @QtPropertyReader(name="recentlyAudible")
    @QtUninvokable
    public final boolean recentlyAudible(){
        return recentlyAudible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean recentlyAudible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#recommendedState-prop">QWebEnginePage::<wbr/>recommendedState()const</a></code></p>
     */
    @QtPropertyReader(name="recommendedState")
    @QtUninvokable
    public final io.qt.webengine.core.QWebEnginePage.@NonNull LifecycleState recommendedState(){
        return io.qt.webengine.core.QWebEnginePage.LifecycleState.resolve(recommendedState_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int recommendedState_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#renderProcessPid-prop">QWebEnginePage::<wbr/>renderProcessPid()const</a></code></p>
     */
    @QtPropertyReader(name="renderProcessPid")
    @QtUninvokable
    public final long renderProcessPid(){
        return renderProcessPid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long renderProcessPid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#replaceMisspelledWord">QWebEnginePage::<wbr/>replaceMisspelledWord(QString)</a></code></p>
     */
    @QtUninvokable
    public final void replaceMisspelledWord(java.lang.@NonNull String replacement){
        replaceMisspelledWord_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), replacement);
    }
    
    @QtUninvokable
    private native void replaceMisspelledWord_native_cref_QString(long __this__nativeId, java.lang.String replacement);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#requestedUrl-prop">QWebEnginePage::<wbr/>requestedUrl()const</a></code></p>
     */
    @QtPropertyReader(name="requestedUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestedUrl(){
        return requestedUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestedUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#runJavaScript-1">QWebEnginePage::<wbr/>runJavaScript(const QString&amp;,<wbr/>quint32,<wbr/>const std::function&lt;void(const QVariant&amp;)&gt;&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource, int worldId, java.util.function.@Nullable Consumer<@Nullable Object> resultCallback){
        runJavaScript_native_cref_QString_quint32_cref_std_function_void_const_QVariant_ref__(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, worldId, resultCallback);
    }
    
    @QtUninvokable
    private native void runJavaScript_native_cref_QString_quint32_cref_std_function_void_const_QVariant_ref__(long __this__nativeId, java.lang.String scriptSource, int worldId, java.util.function.Consumer<@Nullable Object> resultCallback);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#runJavaScript">QWebEnginePage::<wbr/>runJavaScript(const QString&amp;,<wbr/>const std::function&lt;void(const QVariant&amp;)&gt;&amp;)</a></code></p>
     */
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource, java.util.function.@Nullable Consumer<@Nullable Object> resultCallback){
        runJavaScript_native_cref_QString_cref_std_function_void_const_QVariant_ref__(QtJambi_LibraryUtilities.internal.nativeId(this), scriptSource, resultCallback);
    }
    
    @QtUninvokable
    private native void runJavaScript_native_cref_QString_cref_std_function_void_const_QVariant_ref__(long __this__nativeId, java.lang.String scriptSource, java.util.function.Consumer<@Nullable Object> resultCallback);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#save">QWebEnginePage::<wbr/>save(QString,<wbr/>QWebEngineDownloadRequest::SavePageFormat)const</a></code></p>
     */
    @QtUninvokable
    public final void save(java.lang.@NonNull String filePath, io.qt.webengine.core.QWebEngineDownloadRequest.@NonNull SavePageFormat format){
        save_native_cref_QString_QWebEngineDownloadRequest_SavePageFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), filePath, format.value());
    }
    
    @QtUninvokable
    private native void save_native_cref_QString_QWebEngineDownloadRequest_SavePageFormat_constfct(long __this__nativeId, java.lang.String filePath, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#scripts">QWebEnginePage::<wbr/>scripts()</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@NonNull QWebEngineScriptCollection scripts(){
        return scripts_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineScriptCollection scripts_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#scrollPosition-prop">QWebEnginePage::<wbr/>scrollPosition()const</a></code></p>
     */
    @QtPropertyReader(name="scrollPosition")
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF scrollPosition(){
        return scrollPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPointF scrollPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#selectedText-prop">QWebEnginePage::<wbr/>selectedText()const</a></code></p>
     */
    @QtPropertyReader(name="selectedText")
    @QtUninvokable
    public final java.lang.@NonNull String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#audioMuted-prop">QWebEnginePage::<wbr/>setAudioMuted(bool)</a></code></p>
     */
    @QtPropertyWriter(name="audioMuted")
    @QtUninvokable
    public final void setAudioMuted(boolean muted){
        setAudioMuted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), muted);
    }
    
    @QtUninvokable
    private native void setAudioMuted_native_bool(long __this__nativeId, boolean muted);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#backgroundColor-prop">QWebEnginePage::<wbr/>setBackgroundColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="backgroundColor")
    @QtUninvokable
    public final void setBackgroundColor(io.qt.gui.@NonNull QColor color){
        setBackgroundColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @QtUninvokable
    private native void setBackgroundColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#setContent">QWebEnginePage::<wbr/>setContent(QByteArray,<wbr/>QString,<wbr/>QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String mimeType, io.qt.core.@NonNull QUrl baseUrl){
        setContent_native_cref_QByteArray_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), mimeType, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @QtUninvokable
    private native void setContent_native_cref_QByteArray_cref_QString_cref_QUrl(long __this__nativeId, long data, java.lang.String mimeType, long baseUrl);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#setDevToolsPage">QWebEnginePage::<wbr/>setDevToolsPage(QWebEnginePage*)</a></code></p>
     */
    @QtUninvokable
    public final void setDevToolsPage(io.qt.webengine.core.@Nullable QWebEnginePage page){
        setDevToolsPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
        __rcDevToolsPage = page;
    }
    
    @QtUninvokable
    private native void setDevToolsPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#setFeaturePermission">QWebEnginePage::<wbr/>setFeaturePermission(QUrl,<wbr/>QWebEnginePage::Feature,<wbr/>QWebEnginePage::PermissionPolicy)</a></code></p>
     */
    @QtUninvokable
    public final void setFeaturePermission(io.qt.core.@NonNull QUrl securityOrigin, io.qt.webengine.core.QWebEnginePage.@NonNull Feature feature, io.qt.webengine.core.QWebEnginePage.@NonNull PermissionPolicy policy){
        setFeaturePermission_native_cref_QUrl_QWebEnginePage_Feature_QWebEnginePage_PermissionPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), feature.value(), policy.value());
    }
    
    @QtUninvokable
    private native void setFeaturePermission_native_cref_QUrl_QWebEnginePage_Feature_QWebEnginePage_PermissionPolicy(long __this__nativeId, long securityOrigin, int feature, int policy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#setHtml">QWebEnginePage::<wbr/>setHtml(QString,<wbr/>QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setHtml(java.lang.@NonNull String html, io.qt.core.@NonNull QUrl baseUrl){
        setHtml_native_cref_QString_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), html, QtJambi_LibraryUtilities.internal.checkedNativeId(baseUrl));
    }
    
    @QtUninvokable
    private native void setHtml_native_cref_QString_cref_QUrl(long __this__nativeId, java.lang.String html, long baseUrl);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#setInspectedPage">QWebEnginePage::<wbr/>setInspectedPage(QWebEnginePage*)</a></code></p>
     */
    @QtUninvokable
    public final void setInspectedPage(io.qt.webengine.core.@Nullable QWebEnginePage page){
        setInspectedPage_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(page));
        __rcInspectedPage = page;
    }
    
    @QtUninvokable
    private native void setInspectedPage_native_QWebEnginePage_ptr(long __this__nativeId, long page);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#lifecycleState-prop">QWebEnginePage::<wbr/>setLifecycleState(QWebEnginePage::LifecycleState)</a></code></p>
     */
    @QtPropertyWriter(name="lifecycleState")
    @QtUninvokable
    public final void setLifecycleState(io.qt.webengine.core.QWebEnginePage.@NonNull LifecycleState state){
        setLifecycleState_native_QWebEnginePage_LifecycleState(QtJambi_LibraryUtilities.internal.nativeId(this), state.value());
    }
    
    @QtUninvokable
    private native void setLifecycleState_native_QWebEnginePage_LifecycleState(long __this__nativeId, int state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#url-prop">QWebEnginePage::<wbr/>setUrl(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="url")
    @QtUninvokable
    public final void setUrl(io.qt.core.@NonNull QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#setUrlRequestInterceptor">QWebEnginePage::<wbr/>setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)</a></code></p>
     */
    @QtUninvokable
    public final void setUrlRequestInterceptor(io.qt.webengine.core.@Nullable QWebEngineUrlRequestInterceptor interceptor){
        setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @QtUninvokable
    private native void setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#visible-prop">QWebEnginePage::<wbr/>setVisible(bool)</a></code></p>
     */
    @QtPropertyWriter(name="visible")
    @QtUninvokable
    public final void setVisible(boolean visible){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), visible);
    }
    
    @QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean visible);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#setWebChannel">QWebEnginePage::<wbr/>setWebChannel(QWebChannel*,<wbr/>quint32)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setWebChannel(io.qt.webchannel.@Nullable QWebChannel arg__1, int worldId){
        setWebChannel_native_QWebChannel_ptr_quint32(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), worldId);
        __rcWebChannel = arg__1;
    }
    
    @QtUninvokable
    private native void setWebChannel_native_QWebChannel_ptr_quint32(long __this__nativeId, long arg__1, int worldId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#zoomFactor-prop">QWebEnginePage::<wbr/>setZoomFactor(qreal)</a></code></p>
     */
    @QtPropertyWriter(name="zoomFactor")
    @QtUninvokable
    public final void setZoomFactor(double factor){
        setZoomFactor_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), factor);
    }
    
    @QtUninvokable
    private native void setZoomFactor_native_qreal(long __this__nativeId, double factor);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#settings">QWebEnginePage::<wbr/>settings()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineSettings settings(){
        return settings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineSettings settings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#title-prop">QWebEnginePage::<wbr/>title()const</a></code></p>
     */
    @QtPropertyReader(name="title")
    @QtUninvokable
    public final java.lang.@NonNull String title(){
        return title_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String title_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#toHtml">QWebEnginePage::<wbr/>toHtml(const std::function&lt;void(const QString&amp;)&gt;&amp;)const</a></code></p>
     */
    @QtUninvokable
    public final void toHtml(java.util.function.@Nullable Consumer<@NonNull String> resultCallback){
        toHtml_native_cref_std_function_void_const_QString_ref___constfct(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback);
    }
    
    @QtUninvokable
    private native void toHtml_native_cref_std_function_void_const_QString_ref___constfct(long __this__nativeId, java.util.function.Consumer<@NonNull String> resultCallback);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#toPlainText">QWebEnginePage::<wbr/>toPlainText(const std::function&lt;void(const QString&amp;)&gt;&amp;)const</a></code></p>
     */
    @QtUninvokable
    public final void toPlainText(java.util.function.@Nullable Consumer<@NonNull String> resultCallback){
        toPlainText_native_cref_std_function_void_const_QString_ref___constfct(QtJambi_LibraryUtilities.internal.nativeId(this), resultCallback);
    }
    
    @QtUninvokable
    private native void toPlainText_native_cref_std_function_void_const_QString_ref___constfct(long __this__nativeId, java.util.function.Consumer<@NonNull String> resultCallback);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#url-prop">QWebEnginePage::<wbr/>url()const</a></code></p>
     */
    @QtPropertyReader(name="url")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#webChannel">QWebEnginePage::<wbr/>webChannel()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.webchannel.@Nullable QWebChannel webChannel(){
        return webChannel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webchannel.QWebChannel webChannel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#zoomFactor-prop">QWebEnginePage::<wbr/>zoomFactor()const</a></code></p>
     */
    @QtPropertyReader(name="zoomFactor")
    @QtUninvokable
    public final double zoomFactor(){
        return zoomFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native double zoomFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#acceptNavigationRequest">QWebEnginePage::<wbr/>acceptNavigationRequest(QUrl,<wbr/>QWebEnginePage::NavigationType,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    protected boolean acceptNavigationRequest(io.qt.core.@NonNull QUrl url, io.qt.webengine.core.QWebEnginePage.@NonNull NavigationType type, boolean isMainFrame){
        return acceptNavigationRequest_native_cref_QUrl_QWebEnginePage_NavigationType_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), type.value(), isMainFrame);
    }
    
    @QtUninvokable
    private native boolean acceptNavigationRequest_native_cref_QUrl_QWebEnginePage_NavigationType_bool(long __this__nativeId, long url, int type, boolean isMainFrame);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#chooseFiles">QWebEnginePage::<wbr/>chooseFiles(QWebEnginePage::FileSelectionMode,<wbr/>QStringList,<wbr/>QStringList)</a></code></p>
     */
    @QtUninvokable
    protected java.util.@NonNull List<java.lang.@NonNull String> chooseFiles(io.qt.webengine.core.QWebEnginePage.@NonNull FileSelectionMode mode, java.util.@NonNull Collection<java.lang.@NonNull String> oldFiles, java.util.@NonNull Collection<java.lang.@NonNull String> acceptedMimeTypes){
        return chooseFiles_native_QWebEnginePage_FileSelectionMode_cref_QStringList_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value(), oldFiles, acceptedMimeTypes);
    }
    
    @QtUninvokable
    private native java.util.List<java.lang.String> chooseFiles_native_QWebEnginePage_FileSelectionMode_cref_QStringList_cref_QStringList(long __this__nativeId, int mode, java.util.Collection<java.lang.String> oldFiles, java.util.Collection<java.lang.String> acceptedMimeTypes);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#createWindow">QWebEnginePage::<wbr/>createWindow(QWebEnginePage::WebWindowType)</a></code></p>
     */
    @QtUninvokable
    protected io.qt.webengine.core.@Nullable QWebEnginePage createWindow(io.qt.webengine.core.QWebEnginePage.@NonNull WebWindowType type){
        return createWindow_native_QWebEnginePage_WebWindowType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEnginePage createWindow_native_QWebEnginePage_WebWindowType(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qobject.html#event">QObject::<wbr/>event(QEvent*)</a></code></p>
     */
    @QtUninvokable
    @Override
    public boolean event(io.qt.core.@Nullable QEvent arg__1){
        java.util.Objects.requireNonNull(arg__1, "Argument 'arg__1': null not expected.");
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#javaScriptAlert">QWebEnginePage::<wbr/>javaScriptAlert(QUrl,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    protected void javaScriptAlert(io.qt.core.@NonNull QUrl securityOrigin, java.lang.@NonNull String msg){
        javaScriptAlert_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg);
    }
    
    @QtUninvokable
    private native void javaScriptAlert_native_cref_QUrl_cref_QString(long __this__nativeId, long securityOrigin, java.lang.String msg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#javaScriptConfirm">QWebEnginePage::<wbr/>javaScriptConfirm(QUrl,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    protected boolean javaScriptConfirm(io.qt.core.@NonNull QUrl securityOrigin, java.lang.@NonNull String msg){
        return javaScriptConfirm_native_cref_QUrl_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg);
    }
    
    @QtUninvokable
    private native boolean javaScriptConfirm_native_cref_QUrl_cref_QString(long __this__nativeId, long securityOrigin, java.lang.String msg);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#javaScriptConsoleMessage">QWebEnginePage::<wbr/>javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,<wbr/>QString,<wbr/>int,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    protected void javaScriptConsoleMessage(io.qt.webengine.core.QWebEnginePage.@NonNull JavaScriptConsoleMessageLevel level, java.lang.@NonNull String message, int lineNumber, java.lang.@NonNull String sourceID){
        javaScriptConsoleMessage_native_QWebEnginePage_JavaScriptConsoleMessageLevel_cref_QString_int_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), level.value(), message, lineNumber, sourceID);
    }
    
    @QtUninvokable
    private native void javaScriptConsoleMessage_native_QWebEnginePage_JavaScriptConsoleMessageLevel_cref_QString_int_cref_QString(long __this__nativeId, int level, java.lang.String message, int lineNumber, java.lang.String sourceID);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#javaScriptPrompt">QWebEnginePage::<wbr/>javaScriptPrompt(QUrl,<wbr/>QString,<wbr/>QString,<wbr/>QString*)</a></code></p>
     */
    @QtUninvokable
    protected java.lang.@Nullable String javaScriptPrompt(io.qt.core.@NonNull QUrl securityOrigin, java.lang.@NonNull String msg, java.lang.@NonNull String defaultValue){
        return javaScriptPrompt_native_cref_QUrl_cref_QString_cref_QString_QString_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(securityOrigin), msg, defaultValue);
    }
    
    @QtUninvokable
    private native java.lang.@Nullable String javaScriptPrompt_native_cref_QUrl_cref_QString_cref_QString_QString_ptr(long __this__nativeId, long securityOrigin, java.lang.String msg, java.lang.String defaultValue);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginepage.html#triggerAction">QWebEnginePage::<wbr/>triggerAction(QWebEnginePage::WebAction,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public void triggerAction(io.qt.webengine.core.QWebEnginePage.@NonNull WebAction action, boolean checked){
        triggerAction_native_QWebEnginePage_WebAction_bool(QtJambi_LibraryUtilities.internal.nativeId(this), action.value(), checked);
    }
    
    @QtUninvokable
    private native void triggerAction_native_QWebEnginePage_WebAction_bool(long __this__nativeId, int action, boolean checked);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEnginePage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QWebEnginePage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWebEnginePage instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QWebEnginePage(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEnginePage() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebEnginePage(io.qt.webengine.core.QWebEngineProfile, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEnginePage(io.qt.webengine.core.@Nullable QWebEngineProfile profile) {
        this(profile, (io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #backgroundColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getBackgroundColor() {
        return backgroundColor();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #contentsSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSizeF getContentsSize() {
        return contentsSize();
    }
    
    /**
     * <p>Overloaded function for {@link #download(io.qt.core.QUrl, java.lang.String)}
     *  with <code>filename = (String)null</code>.</p>
     */
    @QtUninvokable
    public final void download(io.qt.core.@NonNull QUrl url) {
        download(url, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #download(java.lang.String, java.lang.String)}
     *  with <code>filename = (String)null</code>.</p>
     */
    @QtUninvokable
    public final void download(java.lang.@NonNull String url) {
        download(url, (String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #download(io.qt.core.QUrl, java.lang.String)}.</p>
     */
    @QtUninvokable
    public final void download(java.lang.@NonNull String url, java.lang.@NonNull String filename) {
        download(new io.qt.core.QUrl(url), filename);
    }
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.core.QWebEnginePage.FindFlags, java.util.function.Consumer)}
     *  with <code>resultCallback = null</code>.</p>
     */
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString, io.qt.webengine.core.QWebEnginePage.@NonNull FindFlags options) {
        findText(subString, options, (java.util.function.Consumer<QWebEngineFindTextResult>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #findText(java.lang.String, io.qt.webengine.core.QWebEnginePage.FindFlags, java.util.function.Consumer)}</p>
     * <p>with: </p><ul>
     * <li><code>options = new io.qt.webengine.core.QWebEnginePage.FindFlags(0)</code></li>
     * <li><code>resultCallback = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void findText(java.lang.@NonNull String subString) {
        findText(subString, new io.qt.webengine.core.QWebEnginePage.FindFlags(0), (java.util.function.Consumer<QWebEngineFindTextResult>)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #hasSelection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getHasSelection() {
        return hasSelection();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #icon()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QIcon getIcon() {
        return icon();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #iconUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getIconUrl() {
        return iconUrl();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isAudioMuted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAudioMuted() {
        return isAudioMuted();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isLoading()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getLoading() {
        return isLoading();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isVisible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getVisible() {
        return isVisible();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #lifecycleState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEnginePage.@NonNull LifecycleState getLifecycleState() {
        return lifecycleState();
    }
    
    /**
     * <p>Overloaded function for {@link #load(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void load(java.lang.@NonNull String url) {
        load(new io.qt.core.QUrl(url));
    }
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.lang.String, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}
     *  with <code>ranges = new io.qt.gui.QPageRanges()</code>.</p>
     */
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath, io.qt.gui.@NonNull QPageLayout layout) {
        printToPdf(filePath, layout, new io.qt.gui.QPageRanges());
    }
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.lang.String, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}</p>
     * <p>with: </p><ul>
     * <li><code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code></li>
     * <li><code>ranges = new io.qt.gui.QPageRanges()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void printToPdf(java.lang.@NonNull String filePath) {
        printToPdf(filePath, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()), new io.qt.gui.QPageRanges());
    }
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.util.function.Consumer, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}
     *  with <code>ranges = new io.qt.gui.QPageRanges()</code>.</p>
     */
    @QtUninvokable
    public final void printToPdf(java.util.function.@StrictNonNull @Nullable Consumer<io.qt.core.@NonNull QByteArray> resultCallback, io.qt.gui.@NonNull QPageLayout layout) {
        printToPdf(resultCallback, layout, new io.qt.gui.QPageRanges());
    }
    
    /**
     * <p>Overloaded function for {@link #printToPdf(java.util.function.Consumer, io.qt.gui.QPageLayout, io.qt.gui.QPageRanges)}</p>
     * <p>with: </p><ul>
     * <li><code>layout = new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF())</code></li>
     * <li><code>ranges = new io.qt.gui.QPageRanges()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void printToPdf(java.util.function.@StrictNonNull @Nullable Consumer<io.qt.core.@NonNull QByteArray> resultCallback) {
        printToPdf(resultCallback, new io.qt.gui.QPageLayout(new io.qt.gui.QPageSize(io.qt.gui.QPageSize.PageSizeId.A4), io.qt.gui.QPageLayout.Orientation.Portrait, new io.qt.core.QMarginsF()), new io.qt.gui.QPageRanges());
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #recentlyAudible()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRecentlyAudible() {
        return recentlyAudible();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #recommendedState()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEnginePage.@NonNull LifecycleState getRecommendedState() {
        return recommendedState();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #renderProcessPid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getRenderProcessPid() {
        return renderProcessPid();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #requestedUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getRequestedUrl() {
        return requestedUrl();
    }
    
    /**
     * <p>Overloaded function for {@link #runJavaScript(java.lang.String, int, java.util.function.Consumer)}
     *  with <code>resultCallback = null</code>.</p>
     */
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource, int worldId) {
        runJavaScript(scriptSource, worldId, (java.util.function.Consumer<Object>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #runJavaScript(java.lang.String, int, java.util.function.Consumer)}</p>
     * <p>with: </p><ul>
     * <li><code>worldId = 0</code></li>
     * <li><code>resultCallback = null</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void runJavaScript(java.lang.@NonNull String scriptSource) {
        runJavaScript(scriptSource, (int)0, (java.util.function.Consumer<Object>)null);
    }
    
    /**
     * <p>Overloaded function for {@link #save(java.lang.String, io.qt.webengine.core.QWebEngineDownloadRequest.SavePageFormat)}
     *  with <code>format = io.qt.webengine.core.QWebEngineDownloadRequest.SavePageFormat.MimeHtmlSaveFormat</code>.</p>
     */
    @QtUninvokable
    public final void save(java.lang.@NonNull String filePath) {
        save(filePath, io.qt.webengine.core.QWebEngineDownloadRequest.SavePageFormat.MimeHtmlSaveFormat);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scrollPosition()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPointF getScrollPosition() {
        return scrollPosition();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #selectedText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSelectedText() {
        return selectedText();
    }
    
    /**
     * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setBackgroundColor(io.qt.core.Qt.@NonNull GlobalColor color) {
        setBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setBackgroundColor(io.qt.gui.@NonNull QRgba64 color) {
        setBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setBackgroundColor(io.qt.gui.QColor)}.</p>
     */
    @QtUninvokable
    public final void setBackgroundColor(java.lang.@NonNull String color) {
        setBackgroundColor(new io.qt.gui.QColor(color));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String mimeType) {
        setContent(data, mimeType, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}</p>
     * <p>with: </p><ul>
     * <li><code>mimeType = (String)null</code></li>
     * <li><code>baseUrl = new io.qt.core.QUrl()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data) {
        setContent(data, (String)null, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(byte[], java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setContent(byte @NonNull[] data, java.lang.@NonNull String mimeType) {
        setContent(data, mimeType, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(byte[], java.lang.String, io.qt.core.QUrl)}</p>
     * <p>with: </p><ul>
     * <li><code>mimeType = (String)null</code></li>
     * <li><code>baseUrl = new io.qt.core.QUrl()</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void setContent(byte @NonNull[] data) {
        setContent(data, (String)null, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setContent(byte @NonNull[] data, java.lang.@NonNull String mimeType, io.qt.core.@NonNull QUrl baseUrl) {
        setContent(new io.qt.core.QByteArray(data), mimeType, baseUrl);
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setContent(io.qt.core.@NonNull QByteArray data, java.lang.@NonNull String mimeType, java.lang.@NonNull String baseUrl) {
        setContent(data, mimeType, new io.qt.core.QUrl(baseUrl));
    }
    
    /**
     * <p>Overloaded function for {@link #setContent(io.qt.core.QByteArray, java.lang.String, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setContent(byte @NonNull[] data, java.lang.@NonNull String mimeType, java.lang.@NonNull String baseUrl) {
        setContent(new io.qt.core.QByteArray(data), mimeType, new io.qt.core.QUrl(baseUrl));
    }
    
    /**
     * <p>Overloaded function for {@link #setFeaturePermission(io.qt.core.QUrl, io.qt.webengine.core.QWebEnginePage.Feature, io.qt.webengine.core.QWebEnginePage.PermissionPolicy)}.</p>
     */
    @QtUninvokable
    public final void setFeaturePermission(java.lang.@NonNull String securityOrigin, io.qt.webengine.core.QWebEnginePage.@NonNull Feature feature, io.qt.webengine.core.QWebEnginePage.@NonNull PermissionPolicy policy) {
        setFeaturePermission(new io.qt.core.QUrl(securityOrigin), feature, policy);
    }
    
    /**
     * <p>Overloaded function for {@link #setHtml(java.lang.String, io.qt.core.QUrl)}
     *  with <code>baseUrl = new io.qt.core.QUrl()</code>.</p>
     */
    @QtUninvokable
    public final void setHtml(java.lang.@NonNull String html) {
        setHtml(html, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setHtml(java.lang.String, io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setHtml(java.lang.@NonNull String html, java.lang.@NonNull String baseUrl) {
        setHtml(html, new io.qt.core.QUrl(baseUrl));
    }
    
    /**
     * <p>Overloaded function for {@link #setUrl(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setUrl(java.lang.@NonNull String url) {
        setUrl(new io.qt.core.QUrl(url));
    }
    
    /**
     * <p>Overloaded function for {@link #setWebChannel(io.qt.webchannel.QWebChannel, int)}
     *  with <code>worldId = 0</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setWebChannel(io.qt.webchannel.@Nullable QWebChannel arg__1) {
        setWebChannel(arg__1, (int)0);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #title()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getTitle() {
        return title();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #zoomFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final double getZoomFactor() {
        return zoomFactor();
    }
    
    /**
     * <p>Overloaded function for {@link #acceptNavigationRequest(io.qt.core.QUrl, io.qt.webengine.core.QWebEnginePage.NavigationType, boolean)}.</p>
     */
    @QtUninvokable
    protected final boolean acceptNavigationRequest(java.lang.@NonNull String url, io.qt.webengine.core.QWebEnginePage.@NonNull NavigationType type, boolean isMainFrame) {
        return acceptNavigationRequest(new io.qt.core.QUrl(url), type, isMainFrame);
    }
    
    /**
     * <p>Overloaded function for {@link #javaScriptAlert(io.qt.core.QUrl, java.lang.String)}.</p>
     */
    @QtUninvokable
    protected final void javaScriptAlert(java.lang.@NonNull String securityOrigin, java.lang.@NonNull String msg) {
        javaScriptAlert(new io.qt.core.QUrl(securityOrigin), msg);
    }
    
    /**
     * <p>Overloaded function for {@link #javaScriptConfirm(io.qt.core.QUrl, java.lang.String)}.</p>
     */
    @QtUninvokable
    protected final boolean javaScriptConfirm(java.lang.@NonNull String securityOrigin, java.lang.@NonNull String msg) {
        return javaScriptConfirm(new io.qt.core.QUrl(securityOrigin), msg);
    }
    
    /**
     * <p>Overloaded function for {@link #javaScriptPrompt(io.qt.core.QUrl, java.lang.String, java.lang.String)}.</p>
     */
    @QtUninvokable
    protected final java.lang.@Nullable String javaScriptPrompt(java.lang.@NonNull String securityOrigin, java.lang.@NonNull String msg, java.lang.@NonNull String defaultValue) {
        return javaScriptPrompt(new io.qt.core.QUrl(securityOrigin), msg, defaultValue);
    }
    
    /**
     * <p>Overloaded function for {@link #triggerAction(io.qt.webengine.core.QWebEnginePage.WebAction, boolean)}
     *  with <code>checked = false</code>.</p>
     */
    @QtUninvokable
    public final void triggerAction(io.qt.webengine.core.QWebEnginePage.@NonNull WebAction action) {
        triggerAction(action, (boolean)false);
    }
}
