package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Enables accepting or rejecting requests for local file system access from JavaScript applications</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html">QWebEngineFileSystemAccessRequest</a></code></p>
 * <p>This class was introduced in Qt 6.4.</p>
 */
public class QWebEngineFileSystemAccessRequest extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineFileSystemAccessRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>QWebEngineFileSystemAccessRequest::AccessFlag</code></p>
     * 
     * @see AccessFlags
     */
    public enum AccessFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code>QWebEngineFileSystemAccessRequest::<wbr/>Read</code></p>
         */
        Read(1),
        /**
         * <p>Representing <code>QWebEngineFileSystemAccessRequest::<wbr/>Write</code></p>
         */
        Write(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AccessFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        @Override
        public @NonNull AccessFlags asFlags() {
            return new AccessFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull AccessFlags combined(@NonNull AccessFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull AccessFlags cleared(@NonNull AccessFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link AccessFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull AccessFlags flags(@Nullable AccessFlag @NonNull... values) {
            return new AccessFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AccessFlag resolve(int value) {
            switch (value) {
            case 1: return Read;
            case 2: return Write;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link AccessFlag}
     */
    public static final class AccessFlags extends QFlags<AccessFlag> implements Comparable<AccessFlags> {
        private static final long serialVersionUID = 0x354c56a0ae87271cL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new AccessFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public AccessFlags(@Nullable AccessFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new AccessFlags with given <code>value</code>.
         * @param value
         */
        public AccessFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new AccessFlags
         */
        @Override
        public final @NonNull AccessFlags combined(@StrictNonNull AccessFlag e){
            return new AccessFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        @Override
        public final @NonNull AccessFlags setFlag(@Nullable AccessFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        @Override
        public final @NonNull AccessFlags setFlag(@Nullable AccessFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this AccessFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull AccessFlag @NonNull[] flags(){
            return super.flags(AccessFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull AccessFlags clone(){
            return new AccessFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull AccessFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>QWebEngineFileSystemAccessRequest::HandleType</code></p>
     */
    public enum HandleType implements QtEnumerator {
        /**
         * <p>Representing <code>QWebEngineFileSystemAccessRequest::<wbr/>File</code></p>
         */
        File(0),
        /**
         * <p>Representing <code>QWebEngineFileSystemAccessRequest::<wbr/>Directory</code></p>
         */
        Directory(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HandleType resolve(int value) {
            switch (value) {
            case 0: return File;
            case 1: return Directory;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QWebEngineFileSystemAccessRequest::<wbr/>QWebEngineFileSystemAccessRequest(QWebEngineFileSystemAccessRequest)</code></p>
     */
    public QWebEngineFileSystemAccessRequest(io.qt.webengine.core.@NonNull QWebEngineFileSystemAccessRequest other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineFileSystemAccessRequest instance, io.qt.webengine.core.QWebEngineFileSystemAccessRequest other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#accept">QWebEngineFileSystemAccessRequest::<wbr/>accept()</a></code></p>
     */
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#accessFlags-prop">QWebEngineFileSystemAccessRequest::<wbr/>accessFlags()const</a></code></p>
     */
    @QtPropertyReader(name="accessFlags")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineFileSystemAccessRequest.@NonNull AccessFlags accessFlags(){
        return new io.qt.webengine.core.QWebEngineFileSystemAccessRequest.AccessFlags(accessFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int accessFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#filePath-prop">QWebEngineFileSystemAccessRequest::<wbr/>filePath()const</a></code></p>
     */
    @QtPropertyReader(name="filePath")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl filePath(){
        return filePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl filePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#handleType-prop">QWebEngineFileSystemAccessRequest::<wbr/>handleType()const</a></code></p>
     */
    @QtPropertyReader(name="handleType")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineFileSystemAccessRequest.@NonNull HandleType handleType(){
        return io.qt.webengine.core.QWebEngineFileSystemAccessRequest.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineFileSystemAccessRequest::<wbr/>operator=(QWebEngineFileSystemAccessRequest)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@NonNull QWebEngineFileSystemAccessRequest other){
        assign_native_cref_QWebEngineFileSystemAccessRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineFileSystemAccessRequest(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#operator-eq-eq">operator==(QWebEngineFileSystemAccessRequest,<wbr/>QWebEngineFileSystemAccessRequest)</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.webengine.core.@NonNull QWebEngineFileSystemAccessRequest rhs){
        return equals_native_cref_QWebEngineFileSystemAccessRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QWebEngineFileSystemAccessRequest(long __this__nativeId, long rhs);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#origin-prop">QWebEngineFileSystemAccessRequest::<wbr/>origin()const</a></code></p>
     */
    @QtPropertyReader(name="origin")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#reject">QWebEngineFileSystemAccessRequest::<wbr/>reject()</a></code></p>
     */
    public final void reject(){
        reject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reject_native(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineFileSystemAccessRequest::<wbr/>swap(QWebEngineFileSystemAccessRequest&amp;)</code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.webengine.core.@StrictNonNull QWebEngineFileSystemAccessRequest other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebEngineFileSystemAccessRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QWebEngineFileSystemAccessRequest(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineFileSystemAccessRequest(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#operator-eq-eq">operator==(QWebEngineFileSystemAccessRequest,<wbr/>QWebEngineFileSystemAccessRequest)</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other==null || other instanceof io.qt.webengine.core.QWebEngineFileSystemAccessRequest) {
            return equals((io.qt.webengine.core.QWebEngineFileSystemAccessRequest) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QWebEngineFileSystemAccessRequest)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QWebEngineFileSystemAccessRequest::<wbr/>QWebEngineFileSystemAccessRequest(QWebEngineFileSystemAccessRequest)</code></p>
     */
    @QtUninvokable
    @Override
    public QWebEngineFileSystemAccessRequest clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineFileSystemAccessRequest clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #accessFlags()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineFileSystemAccessRequest.@NonNull AccessFlags getAccessFlags() {
        return accessFlags();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #filePath()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getFilePath() {
        return filePath();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #handleType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineFileSystemAccessRequest.@NonNull HandleType getHandleType() {
        return handleType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #origin()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getOrigin() {
        return origin();
    }
}
