package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>A utility type for the WebEngineView::loadingChanged signal</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html">QWebEngineLoadingInfo</a></code></p>
 */
public class QWebEngineLoadingInfo extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineLoadingInfo.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::ErrorDomain</a></code></p>
     */
    public enum ErrorDomain implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>NoErrorDomain</a></code></p>
         */
        NoErrorDomain(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>InternalErrorDomain</a></code></p>
         */
        InternalErrorDomain(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>ConnectionErrorDomain</a></code></p>
         */
        ConnectionErrorDomain(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>CertificateErrorDomain</a></code></p>
         */
        CertificateErrorDomain(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>HttpErrorDomain</a></code></p>
         */
        HttpErrorDomain(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>FtpErrorDomain</a></code></p>
         */
        FtpErrorDomain(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>DnsErrorDomain</a></code></p>
         */
        DnsErrorDomain(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::<wbr/>HttpStatusCodeDomain</a></code></p>
         */
        HttpStatusCodeDomain(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorDomain(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ErrorDomain resolve(int value) {
            switch (value) {
            case 0: return NoErrorDomain;
            case 1: return InternalErrorDomain;
            case 2: return ConnectionErrorDomain;
            case 3: return CertificateErrorDomain;
            case 4: return HttpErrorDomain;
            case 5: return FtpErrorDomain;
            case 6: return DnsErrorDomain;
            case 7: return HttpStatusCodeDomain;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::LoadStatus</a></code></p>
     */
    public enum LoadStatus implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::<wbr/>LoadStartedStatus</a></code></p>
         */
        LoadStartedStatus(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::<wbr/>LoadStoppedStatus</a></code></p>
         */
        LoadStoppedStatus(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::<wbr/>LoadSucceededStatus</a></code></p>
         */
        LoadSucceededStatus(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::<wbr/>LoadFailedStatus</a></code></p>
         */
        LoadFailedStatus(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private LoadStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull LoadStatus resolve(int value) {
            switch (value) {
            case 0: return LoadStartedStatus;
            case 1: return LoadStoppedStatus;
            case 2: return LoadSucceededStatus;
            case 3: return LoadFailedStatus;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>QWebEngineLoadingInfo::<wbr/>QWebEngineLoadingInfo(QWebEngineLoadingInfo)</code></p>
     */
    public QWebEngineLoadingInfo(io.qt.webengine.core.@StrictNonNull QWebEngineLoadingInfo other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineLoadingInfo instance, io.qt.webengine.core.QWebEngineLoadingInfo other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorCode-prop">QWebEngineLoadingInfo::<wbr/>errorCode()const</a></code></p>
     */
    @QtPropertyReader(name="errorCode")
    @QtPropertyConstant
    @QtUninvokable
    public final int errorCode(){
        return errorCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int errorCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorDomain-prop">QWebEngineLoadingInfo::<wbr/>errorDomain()const</a></code></p>
     */
    @QtPropertyReader(name="errorDomain")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull ErrorDomain errorDomain(){
        return io.qt.webengine.core.QWebEngineLoadingInfo.ErrorDomain.resolve(errorDomain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int errorDomain_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorString-prop">QWebEngineLoadingInfo::<wbr/>errorString()const</a></code></p>
     */
    @QtPropertyReader(name="errorString")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#isErrorPage-prop">QWebEngineLoadingInfo::<wbr/>isErrorPage()const</a></code></p>
     */
    @QtPropertyReader(name="isErrorPage")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isErrorPage(){
        return isErrorPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isErrorPage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QWebEngineLoadingInfo::<wbr/>operator=(QWebEngineLoadingInfo)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@StrictNonNull QWebEngineLoadingInfo other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        assign_native_cref_QWebEngineLoadingInfo(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineLoadingInfo(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#status-prop">QWebEngineLoadingInfo::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull LoadStatus status(){
        return io.qt.webengine.core.QWebEngineLoadingInfo.LoadStatus.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#url">QWebEngineLoadingInfo::<wbr/>url()const</a></code></p>
     */
    @QtPropertyReader(name="url")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineLoadingInfo(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code>QWebEngineLoadingInfo::<wbr/>QWebEngineLoadingInfo(QWebEngineLoadingInfo)</code></p>
     */
    @QtUninvokable
    @Override
    public QWebEngineLoadingInfo clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineLoadingInfo clone_native(long __this_nativeId);
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getErrorCode() {
        return errorCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorDomain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull ErrorDomain getErrorDomain() {
        return errorDomain();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * @deprecated Use {@link #assign(io.qt.webengine.core.QWebEngineLoadingInfo)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.webengine.core.@StrictNonNull QWebEngineLoadingInfo other) {
        assign(other);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull LoadStatus getStatus() {
        return status();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
}
