package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Access to Chromium's cookies</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html">QWebEngineCookieStore</a></code></p>
 */
public final class QWebEngineCookieStore extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineCookieStore.class);
    
    /**
     * <p>QWebEngineCookieStore::FilterRequest struct is used in conjunction with QWebEngineCookieStore::setCookieFilter() and is the type filterCallback operates on</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html">QWebEngineCookieStore::FilterRequest</a></code></p>
     */
    public static class FilterRequest extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>FilterRequest()</code></p>
         */
        public FilterRequest(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(FilterRequest instance);
        
        /**
         * <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>FilterRequest(QWebEngineCookieStore::FilterRequest)</code></p>
         */
        public FilterRequest(io.qt.webengine.core.QWebEngineCookieStore.@NonNull FilterRequest other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(FilterRequest instance, io.qt.webengine.core.QWebEngineCookieStore.FilterRequest other);
        
        /**
         * <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>FilterRequest{QUrl,<wbr/>QUrl,<wbr/>bool,<wbr/>bool,<wbr/>ushort}</code></p>
         */
        public FilterRequest(io.qt.core.@NonNull QUrl firstPartyUrl, io.qt.core.@NonNull QUrl origin, boolean thirdParty, boolean _reservedFlag, short _reservedType){
            super((QPrivateConstructor)null);
            initialize_native(this, firstPartyUrl, origin, thirdParty, _reservedFlag, _reservedType);
        }
        
        private native static void initialize_native(FilterRequest instance, io.qt.core.QUrl firstPartyUrl, io.qt.core.QUrl origin, boolean thirdParty, boolean _reservedFlag, short _reservedType);
        
        /**
         * <p>See <code>operator==(QWebEngineCookieStore::FilterRequest,<wbr/>QWebEngineCookieStore::FilterRequest)</code></p>
         */
        @QtUninvokable
        public final boolean equals(io.qt.webengine.core.QWebEngineCookieStore.@NonNull FilterRequest arg2){
            return equals_native_cref_QWebEngineCookieStore_FilterRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg2));
        }
        
        @QtUninvokable
        private native boolean equals_native_cref_QWebEngineCookieStore_FilterRequest(long __this__nativeId, long arg2);
        
        /**
         * <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>_reservedFlag</code></p>
         */
        @QtUninvokable
        public final void set_reservedFlag(boolean _reservedFlag){
            set_reservedFlag_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), _reservedFlag);
        }
        
        @QtUninvokable
        private native void set_reservedFlag_native_bool(long __this__nativeId, boolean _reservedFlag);
        
        /**
         * <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>_reservedFlag</code></p>
         */
        @QtUninvokable
        public final boolean _reservedFlag(){
            return _reservedFlag_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean _reservedFlag_native(long __this__nativeId);
        
        /**
         * <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>_reservedType</code></p>
         */
        @QtUninvokable
        public final void set_reservedType(short _reservedType){
            set_reservedType_native_ushort(QtJambi_LibraryUtilities.internal.nativeId(this), _reservedType);
        }
        
        @QtUninvokable
        private native void set_reservedType_native_ushort(long __this__nativeId, short _reservedType);
        
        /**
         * <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>_reservedType</code></p>
         */
        @QtUninvokable
        public final short _reservedType(){
            return _reservedType_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native short _reservedType_native(long __this__nativeId);
        
        /**
         * <p>URL that was navigated to</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#firstPartyUrl-var">QWebEngineCookieStore::FilterRequest::<wbr/>firstPartyUrl</a></code></p>
         */
        @QtUninvokable
        public final void setFirstPartyUrl(io.qt.core.@NonNull QUrl firstPartyUrl){
            setFirstPartyUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(firstPartyUrl));
        }
        
        @QtUninvokable
        private native void setFirstPartyUrl_native_cref_QUrl(long __this__nativeId, long firstPartyUrl);
        
        /**
         * <p>URL that was navigated to</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#firstPartyUrl-var">QWebEngineCookieStore::FilterRequest::<wbr/>firstPartyUrl</a></code></p>
         */
        @QtUninvokable
        public final io.qt.core.@NonNull QUrl firstPartyUrl(){
            return firstPartyUrl_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.core.QUrl firstPartyUrl_native(long __this__nativeId);
        
        /**
         * <p>URL of the script or content accessing a cookie</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#origin-var">QWebEngineCookieStore::FilterRequest::<wbr/>origin</a></code></p>
         */
        @QtUninvokable
        public final void setOrigin(io.qt.core.@NonNull QUrl origin){
            setOrigin_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
        }
        
        @QtUninvokable
        private native void setOrigin_native_cref_QUrl(long __this__nativeId, long origin);
        
        /**
         * <p>URL of the script or content accessing a cookie</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#origin-var">QWebEngineCookieStore::FilterRequest::<wbr/>origin</a></code></p>
         */
        @QtUninvokable
        public final io.qt.core.@NonNull QUrl origin(){
            return origin_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.core.QUrl origin_native(long __this__nativeId);
        
        /**
         * <p>Whether this is considered a third-party access</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#thirdParty-var">QWebEngineCookieStore::FilterRequest::<wbr/>thirdParty</a></code></p>
         */
        @QtUninvokable
        public final void setThirdParty(boolean thirdParty){
            setThirdParty_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), thirdParty);
        }
        
        @QtUninvokable
        private native void setThirdParty_native_bool(long __this__nativeId, boolean thirdParty);
        
        /**
         * <p>Whether this is considered a third-party access</p>
         * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#thirdParty-var">QWebEngineCookieStore::FilterRequest::<wbr/>thirdParty</a></code></p>
         */
        @QtUninvokable
        public final boolean thirdParty(){
            return thirdParty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean thirdParty_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected FilterRequest(QPrivateConstructor p) { super(p); } 
        

        /**
         * <p>See <code>operator==(QWebEngineCookieStore::FilterRequest,<wbr/>QWebEngineCookieStore::FilterRequest)</code></p>
         */
        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.webengine.core.QWebEngineCookieStore.FilterRequest) {
                return equals((io.qt.webengine.core.QWebEngineCookieStore.FilterRequest) other);
            }

            return false;
        }


        /**
         * Returns the objects's hash code computed by <code>qHash(QWebEngineCookieStore::FilterRequest)</code>.
         */
        @QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QWebEngineCookieStore::FilterRequest::<wbr/>FilterRequest(QWebEngineCookieStore::FilterRequest)</code></p>
         */
        @QtUninvokable
        @Override
        public FilterRequest clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native FilterRequest clone_native(long __this_nativeId);
        
        /**
         * <p>Overloaded constructor for {@link #FilterRequest(io.qt.core.QUrl, io.qt.core.QUrl, boolean, boolean, short)}.</p>
         */
        public FilterRequest(java.lang.@NonNull String firstPartyUrl, io.qt.core.@NonNull QUrl origin, boolean thirdParty, boolean _reservedFlag, short _reservedType) {
            this(new io.qt.core.QUrl(firstPartyUrl), origin, thirdParty, _reservedFlag, _reservedType);
        }
        
        /**
         * <p>Overloaded constructor for {@link #FilterRequest(io.qt.core.QUrl, io.qt.core.QUrl, boolean, boolean, short)}.</p>
         */
        public FilterRequest(io.qt.core.@NonNull QUrl firstPartyUrl, java.lang.@NonNull String origin, boolean thirdParty, boolean _reservedFlag, short _reservedType) {
            this(firstPartyUrl, new io.qt.core.QUrl(origin), thirdParty, _reservedFlag, _reservedType);
        }
        
        /**
         * <p>Overloaded constructor for {@link #FilterRequest(io.qt.core.QUrl, io.qt.core.QUrl, boolean, boolean, short)}.</p>
         */
        public FilterRequest(java.lang.@NonNull String firstPartyUrl, java.lang.@NonNull String origin, boolean thirdParty, boolean _reservedFlag, short _reservedType) {
            this(new io.qt.core.QUrl(firstPartyUrl), new io.qt.core.QUrl(origin), thirdParty, _reservedFlag, _reservedType);
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #_reservedFlag()} instead.</p>
         */
        @QtUninvokable
        public final boolean get_reservedFlag() {
            return _reservedFlag();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #_reservedType()} instead.</p>
         */
        @QtUninvokable
        public final short get_reservedType() {
            return _reservedType();
        }
        
        /**
         * <p>Overloaded function for {@link #setFirstPartyUrl(io.qt.core.QUrl)}.</p>
         */
        @QtUninvokable
        public final void setFirstPartyUrl(java.lang.@NonNull String firstPartyUrl) {
            setFirstPartyUrl(new io.qt.core.QUrl(firstPartyUrl));
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #firstPartyUrl()} instead.</p>
         */
        @QtUninvokable
        public final io.qt.core.@NonNull QUrl getFirstPartyUrl() {
            return firstPartyUrl();
        }
        
        /**
         * <p>Overloaded function for {@link #setOrigin(io.qt.core.QUrl)}.</p>
         */
        @QtUninvokable
        public final void setOrigin(java.lang.@NonNull String origin) {
            setOrigin(new io.qt.core.QUrl(origin));
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #origin()} instead.</p>
         */
        @QtUninvokable
        public final io.qt.core.@NonNull QUrl getOrigin() {
            return origin();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #thirdParty()} instead.</p>
         */
        @QtUninvokable
        public final boolean getThirdParty() {
            return thirdParty();
        }
    }


    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html#cookieAdded">QWebEngineCookieStore::<wbr/>cookieAdded(QNetworkCookie)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QNetworkCookie> cookieAdded = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html#cookieRemoved">QWebEngineCookieStore::<wbr/>cookieRemoved(QNetworkCookie)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QNetworkCookie> cookieRemoved = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html#deleteAllCookies">QWebEngineCookieStore::<wbr/>deleteAllCookies()</a></code></p>
     */
    @QtUninvokable
    public final void deleteAllCookies(){
        deleteAllCookies_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void deleteAllCookies_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html#deleteCookie">QWebEngineCookieStore::<wbr/>deleteCookie(QNetworkCookie,<wbr/>QUrl)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void deleteCookie(io.qt.network.@NonNull QNetworkCookie cookie, io.qt.core.@NonNull QUrl origin){
        deleteCookie_native_cref_QNetworkCookie_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cookie), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
    }
    
    @QtUninvokable
    private native void deleteCookie_native_cref_QNetworkCookie_cref_QUrl(long __this__nativeId, long cookie, long origin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html#deleteSessionCookies">QWebEngineCookieStore::<wbr/>deleteSessionCookies()</a></code></p>
     */
    @QtUninvokable
    public final void deleteSessionCookies(){
        deleteSessionCookies_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void deleteSessionCookies_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html#loadAllCookies">QWebEngineCookieStore::<wbr/>loadAllCookies()</a></code></p>
     */
    @QtUninvokable
    public final void loadAllCookies(){
        loadAllCookies_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void loadAllCookies_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecookiestore.html#setCookie">QWebEngineCookieStore::<wbr/>setCookie(QNetworkCookie,<wbr/>QUrl)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setCookie(io.qt.network.@NonNull QNetworkCookie cookie, io.qt.core.@NonNull QUrl origin){
        setCookie_native_cref_QNetworkCookie_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cookie), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
    }
    
    @QtUninvokable
    private native void setCookie_native_cref_QNetworkCookie_cref_QUrl(long __this__nativeId, long cookie, long origin);
    
    /**
     * <p>See <code>QWebEngineCookieStore::<wbr/>setCookieFilter(const std::function&lt;bool(const QWebEngineCookieStore::FilterRequest&amp;)&gt;&amp;)</code></p>
     */
    @QtUninvokable
    public final void setCookieFilter(java.util.function.@Nullable Predicate<@NonNull FilterRequest> filterCallback){
        setCookieFilter_native_cref_std_function_bool_const_QWebEngineCookieStore_FilterRequest_ref__(QtJambi_LibraryUtilities.internal.nativeId(this), filterCallback);
    }
    
    @QtUninvokable
    private native void setCookieFilter_native_cref_std_function_bool_const_QWebEngineCookieStore_FilterRequest_ref__(long __this__nativeId, java.util.function.Predicate<@NonNull FilterRequest> filterCallback);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineCookieStore(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #deleteCookie(io.qt.network.QNetworkCookie, io.qt.core.QUrl)}
     *  with <code>origin = new io.qt.core.QUrl()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void deleteCookie(io.qt.network.@NonNull QNetworkCookie cookie) {
        deleteCookie(cookie, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #deleteCookie(io.qt.network.QNetworkCookie, io.qt.core.QUrl)}.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void deleteCookie(io.qt.network.@NonNull QNetworkCookie cookie, java.lang.@NonNull String origin) {
        deleteCookie(cookie, new io.qt.core.QUrl(origin));
    }
    
    /**
     * <p>Overloaded function for {@link #setCookie(io.qt.network.QNetworkCookie, io.qt.core.QUrl)}
     *  with <code>origin = new io.qt.core.QUrl()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setCookie(io.qt.network.@NonNull QNetworkCookie cookie) {
        setCookie(cookie, new io.qt.core.QUrl());
    }
    
    /**
     * <p>Overloaded function for {@link #setCookie(io.qt.network.QNetworkCookie, io.qt.core.QUrl)}.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setCookie(io.qt.network.@NonNull QNetworkCookie cookie, java.lang.@NonNull String origin) {
        setCookie(cookie, new io.qt.core.QUrl(origin));
    }
}
