package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Represents the history of a web engine page</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginehistory.html">QWebEngineHistory</a></code></p>
 */
public final class QWebEngineHistory extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineHistory.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#back">QWebEngineHistory::<wbr/>back()</a></code></p>
     */
    @QtUninvokable
    public final void back(){
        back_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void back_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#backItem">QWebEngineHistory::<wbr/>backItem()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@NonNull QWebEngineHistoryItem backItem(){
        return backItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistoryItem backItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#backItems">QWebEngineHistory::<wbr/>backItems(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.webengine.core.@NonNull QWebEngineHistoryItem> backItems(int maxItems){
        return backItems_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), maxItems);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.webengine.core.QWebEngineHistoryItem> backItems_native_int_constfct(long __this__nativeId, int maxItems);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#backItemsModel">QWebEngineHistory::<wbr/>backItemsModel()const</a></code></p>
     */
    @QtPropertyReader(name="backItems")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistoryModel backItemsModel(){
        return backItemsModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistoryModel backItemsModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#canGoBack">QWebEngineHistory::<wbr/>canGoBack()const</a></code></p>
     */
    @QtUninvokable
    public final boolean canGoBack(){
        return canGoBack_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean canGoBack_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#canGoForward">QWebEngineHistory::<wbr/>canGoForward()const</a></code></p>
     */
    @QtUninvokable
    public final boolean canGoForward(){
        return canGoForward_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean canGoForward_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#clear">QWebEngineHistory::<wbr/>clear()</a></code></p>
     */
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#count">QWebEngineHistory::<wbr/>count()const</a></code></p>
     */
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#currentItem">QWebEngineHistory::<wbr/>currentItem()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@NonNull QWebEngineHistoryItem currentItem(){
        return currentItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistoryItem currentItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#currentItemIndex">QWebEngineHistory::<wbr/>currentItemIndex()const</a></code></p>
     */
    @QtUninvokable
    public final int currentItemIndex(){
        return currentItemIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int currentItemIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#forward">QWebEngineHistory::<wbr/>forward()</a></code></p>
     */
    @QtUninvokable
    public final void forward(){
        forward_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void forward_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#forwardItem">QWebEngineHistory::<wbr/>forwardItem()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@NonNull QWebEngineHistoryItem forwardItem(){
        return forwardItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistoryItem forwardItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#forwardItems">QWebEngineHistory::<wbr/>forwardItems(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.webengine.core.@NonNull QWebEngineHistoryItem> forwardItems(int maxItems){
        return forwardItems_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), maxItems);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.webengine.core.QWebEngineHistoryItem> forwardItems_native_int_constfct(long __this__nativeId, int maxItems);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#forwardItemsModel">QWebEngineHistory::<wbr/>forwardItemsModel()const</a></code></p>
     */
    @QtPropertyReader(name="forwardItems")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistoryModel forwardItemsModel(){
        return forwardItemsModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistoryModel forwardItemsModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#goToItem">QWebEngineHistory::<wbr/>goToItem(QWebEngineHistoryItem)</a></code></p>
     */
    @QtUninvokable
    public final void goToItem(io.qt.webengine.core.@NonNull QWebEngineHistoryItem item){
        goToItem_native_cref_QWebEngineHistoryItem(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    @QtUninvokable
    private native void goToItem_native_cref_QWebEngineHistoryItem(long __this__nativeId, long item);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#itemAt">QWebEngineHistory::<wbr/>itemAt(int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.@NonNull QWebEngineHistoryItem itemAt(int i){
        return itemAt_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistoryItem itemAt_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#items">QWebEngineHistory::<wbr/>items()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.webengine.core.@NonNull QWebEngineHistoryItem> items(){
        return items_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.webengine.core.QWebEngineHistoryItem> items_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#itemsModel">QWebEngineHistory::<wbr/>itemsModel()const</a></code></p>
     */
    @QtPropertyReader(name="items")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistoryModel itemsModel(){
        return itemsModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.webengine.core.QWebEngineHistoryModel itemsModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#operator-lt-lt-1">operator&lt;&lt;(QDataStream&amp;,<wbr/>QWebEngineHistory)</a></code></p>
     */
    @QtUninvokable
    public void writeTo(io.qt.core.@StrictNonNull QDataStream stream){
        java.util.Objects.requireNonNull(stream, "Argument 'stream': null not expected.");
        writeTo_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(stream));
    }
    
    @QtUninvokable
    private native void writeTo_native_ref_QDataStream(long __this__nativeId, long stream);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginehistory.html#operator-gt-gt-1">operator&gt;&gt;(QDataStream&amp;,<wbr/>QWebEngineHistory&amp;)</a></code></p>
     */
    @QtUninvokable
    public void readFrom(io.qt.core.@StrictNonNull QDataStream stream){
        java.util.Objects.requireNonNull(stream, "Argument 'stream': null not expected.");
        readFrom_native_ref_QDataStream(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(stream));
    }
    
    @QtUninvokable
    private native void readFrom_native_ref_QDataStream(long __this__nativeId, long stream);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineHistory(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #backItemsModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistoryModel getBackItems() {
        return backItemsModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #forwardItemsModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistoryModel getForwardItems() {
        return forwardItemsModel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #itemsModel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.@Nullable QWebEngineHistoryModel getItems() {
        return itemsModel();
    }
}
